/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.provider.SetupTaskItemProvider;
import org.eclipse.oomph.util.StringUtil;

public class PreferenceTaskItemProvider
extends SetupTaskItemProvider {
    private static final String INSTANCE_SCOPE = "/instance/";
    private static final String CONFIGURATION_SCOPE = "/configuration/";
    private boolean shortenLabelText;

    public PreferenceTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public boolean isShortenLabelText() {
        return this.shortenLabelText;
    }

    public void setShortenLabelText(boolean shortenLabelText) {
        this.shortenLabelText = shortenLabelText;
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addKeyPropertyDescriptor(object);
            this.addValuePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addKeyPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PreferenceTask_key_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PreferenceTask_key_feature", "_UI_PreferenceTask_type"), (EStructuralFeature)SetupPackage.Literals.PREFERENCE_TASK__KEY, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PreferenceTask_value_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PreferenceTask_value_feature", "_UI_PreferenceTask_type"), (EStructuralFeature)SetupPackage.Literals.PREFERENCE_TASK__VALUE, true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        String scope;
        Object imageKey = "full/obj16/PreferenceTask";
        PreferenceTask preferenceTask = (PreferenceTask)object;
        String key = preferenceTask.getKey();
        if (!StringUtil.isEmpty((String)key) && (scope = PreferenceTaskItemProvider.getScope(key)) == CONFIGURATION_SCOPE) {
            imageKey = (String)imageKey + "Configuration";
        }
        return this.overlayImage(object, this.getResourceLocator().getImage((String)imageKey));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        String parentLabel;
        String scope;
        PreferenceTask preferenceTask = (PreferenceTask)object;
        String key = preferenceTask.getKey();
        String value = preferenceTask.getValue();
        if (StringUtil.isEmpty((String)key)) {
            if (StringUtil.isEmpty((String)value)) {
                return this.getString("_UI_PreferenceTask_type");
            }
        } else if (this.shortenLabelText && (scope = PreferenceTaskItemProvider.getScope(key)) != null && (parentLabel = this.getParentLabel(preferenceTask)) != null) {
            String prefix = scope + parentLabel + "/";
            String prefixLong = prefix + parentLabel + ".";
            if (key.startsWith(prefixLong)) {
                key = key.substring(prefixLong.length());
            } else if (key.startsWith(prefix)) {
                key = key.substring(prefix.length());
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(key);
        if (value != null) {
            builder.append(" = ");
            builder.append(this.crop(value));
        }
        return builder.toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PreferenceTask.class)) {
            case 10: 
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    private String getParentLabel(PreferenceTask preferenceTask) {
        ItemProviderAdapter itemProvider;
        Object parent = this.getParent(preferenceTask);
        if (parent != null && (itemProvider = (ItemProviderAdapter)this.getRootAdapterFactory().adapt(parent, IItemLabelProvider.class)) != null) {
            return itemProvider.getText(parent);
        }
        EObject container = preferenceTask.eContainer();
        if (container instanceof CompoundTask) {
            CompoundTask compoundTask = (CompoundTask)container;
            return compoundTask.getName();
        }
        return null;
    }

    private static String getScope(String key) {
        if (key.startsWith(INSTANCE_SCOPE)) {
            return INSTANCE_SCOPE;
        }
        if (key.startsWith(CONFIGURATION_SCOPE)) {
            return CONFIGURATION_SCOPE;
        }
        return null;
    }

    private static PreferenceTaskItemProvider getItemProvider(AdapterFactory adapterFactory) {
        PreferenceTask preferenceTask = SetupFactory.eINSTANCE.createPreferenceTask();
        Adapter adapter = adapterFactory.adapt((Notifier)preferenceTask, IItemLabelProvider.class);
        if (adapter instanceof PreferenceTaskItemProvider) {
            return (PreferenceTaskItemProvider)adapter;
        }
        return null;
    }

    public static boolean isShortenLabelText(AdapterFactory adapterFactory) {
        PreferenceTaskItemProvider itemProvider = PreferenceTaskItemProvider.getItemProvider(adapterFactory);
        return itemProvider != null ? itemProvider.isShortenLabelText() : false;
    }

    public static void setShortenLabelText(AdapterFactory adapterFactory) {
        PreferenceTaskItemProvider itemProvider = PreferenceTaskItemProvider.getItemProvider(adapterFactory);
        if (itemProvider != null) {
            itemProvider.setShortenLabelText(true);
        }
    }
}

