/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.MoveResourcesOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class MoveFilesAndFoldersOperation
extends CopyFilesAndFoldersOperation {
    public MoveFilesAndFoldersOperation(Shell shell) {
        super(shell);
    }

    @Override
    protected boolean canPerformAutoRename() {
        return false;
    }

    @Override
    @Deprecated
    protected void copy(IResource[] resources, IPath destination, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)resources.length);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            SubMonitor iterationMonitor = subMonitor.split(1).setWorkRemaining(100);
            IPath destinationPath = destination.append(resource.getName());
            IWorkspace workspace = resource.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IResource existing = workspaceRoot.findMember(destinationPath);
            if (resource.getType() == 2 && existing != null) {
                if (this.homogenousResources(resource, existing)) {
                    IResource[] children = ((IContainer)resource).members();
                    this.copy(children, destinationPath, (IProgressMonitor)iterationMonitor.split(50));
                    this.delete(resource, (IProgressMonitor)iterationMonitor.split(50));
                } else {
                    this.delete(existing, (IProgressMonitor)iterationMonitor.split(50));
                    resource.move(destinationPath, 34, (IProgressMonitor)iterationMonitor.split(50));
                }
            } else if (existing != null) {
                if (this.homogenousResources(resource, existing)) {
                    this.moveExisting(resource, existing, (IProgressMonitor)iterationMonitor.split(100));
                } else {
                    this.delete(existing, (IProgressMonitor)iterationMonitor.split(50));
                    resource.move(destinationPath, 34, (IProgressMonitor)iterationMonitor.split(50));
                }
            } else {
                resource.move(destinationPath, 34, (IProgressMonitor)iterationMonitor.split(100));
            }
            ++n2;
        }
    }

    @Override
    protected String getDeepCheckQuestion(IResource source) {
        return NLS.bind((String)IDEWorkbenchMessages.CopyFilesAndFoldersOperation_deepMoveQuestion, (Object)source.getFullPath().makeRelative());
    }

    @Override
    protected String getOperationTitle() {
        return IDEWorkbenchMessages.MoveFilesAndFoldersOperation_operationTitle;
    }

    @Override
    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.MoveFilesAndFoldersOperation_problemMessage;
    }

    @Override
    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.MoveFilesAndFoldersOperation_moveFailedTitle;
    }

    @Override
    protected boolean getValidateConflictSource() {
        return true;
    }

    @Deprecated
    private void moveExisting(IResource source, IResource existing, IProgressMonitor monitor) throws CoreException {
        IFile sourceFile;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IFile existingFile = this.getFile(existing);
        if (existingFile != null && (sourceFile = this.getFile(source)) != null) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (InputStream contents = sourceFile.getContents();){
                    existingFile.setContents(contents, 2, (IProgressMonitor)subMonitor.split(1));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.delete((IResource)sourceFile, (IProgressMonitor)subMonitor.split(1));
        }
    }

    @Override
    public String validateDestination(IContainer destination, IResource[] sourceResources) {
        IPath destinationLocation = destination.getLocation();
        IResource[] iResourceArray = sourceResources;
        int n = sourceResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource sourceRessource = iResourceArray[n2];
            if (sourceRessource.getParent().equals((Object)destination)) {
                return NLS.bind((String)IDEWorkbenchMessages.MoveFilesAndFoldersOperation_sameSourceAndDest, (Object)sourceRessource.getName());
            }
            if (destinationLocation != null) {
                IPath sourceLocation = sourceRessource.getLocation();
                IPath destinationResource = destinationLocation.append(sourceRessource.getName());
                if (sourceLocation != null && sourceLocation.isPrefixOf(destinationResource)) {
                    return NLS.bind((String)IDEWorkbenchMessages.MoveFilesAndFoldersOperation_sameSourceAndDest, (Object)sourceRessource.getName());
                }
            }
            ++n2;
        }
        return super.validateDestination(destination, sourceResources);
    }

    @Override
    protected boolean isMove() {
        return true;
    }

    @Override
    protected AbstractWorkspaceOperation getUndoableCopyOrMoveOperation(IResource[] resources, IPath destinationPath) {
        return new MoveResourcesOperation(resources, destinationPath, IDEWorkbenchMessages.CopyFilesAndFoldersOperation_moveTitle);
    }
}

