/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.internal.expressions.AlwaysEnabledExpression;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;

final class ContributionRoot
implements IContributionRoot {
    private final List<IContributionItem> topLevelItems = new ArrayList<IContributionItem>();
    private final Map<IContributionItem, Expression> itemsToExpressions = new HashMap<IContributionItem, Expression>();
    private final AbstractContributionFactory factory;

    public ContributionRoot(AbstractContributionFactory factory) {
        this.factory = factory;
    }

    @Override
    public void addContributionItem(IContributionItem item, Expression visibleWhen) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        this.topLevelItems.add(item);
        if (visibleWhen == null) {
            visibleWhen = AlwaysEnabledExpression.INSTANCE;
        }
        this.itemsToExpressions.put(item, visibleWhen);
    }

    String createIdentifierId(IContributionItem item) {
        String namespace = this.factory.getNamespace();
        return namespace != null ? namespace + "/" + item.getId() : null;
    }

    public List<IContributionItem> getItems() {
        return this.topLevelItems;
    }

    public Map<IContributionItem, Expression> getVisibleWhen() {
        return this.itemsToExpressions;
    }

    public void release() {
        for (IContributionItem item : this.itemsToExpressions.keySet()) {
            item.dispose();
        }
        this.itemsToExpressions.clear();
        this.topLevelItems.clear();
    }

    @Override
    public void registerVisibilityForChild(IContributionItem item, Expression visibleWhen) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        if (visibleWhen == null) {
            visibleWhen = AlwaysEnabledExpression.INSTANCE;
        }
        this.itemsToExpressions.put(item, visibleWhen);
    }
}

