/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.Win32DPIUtils;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.HDHITTESTINFO;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.HDLAYOUT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMTREEVIEW;
import org.eclipse.swt.internal.win32.NMTTCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMTVDISPINFO;
import org.eclipse.swt.internal.win32.NMTVITEMCHANGE;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLBARINFO;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.SHDRAGIMAGE;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.TVHITTESTINFO;
import org.eclipse.swt.internal.win32.TVINSERTSTRUCT;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.internal.win32.TVSORTCB;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    TreeItem[] items;
    TreeColumn[] columns;
    int columnCount;
    ImageList imageList;
    ImageList headerImageList;
    TreeItem currentItem;
    TreeColumn sortColumn;
    RECT focusRect;
    long hwndParent;
    long hwndHeader;
    long hAnchor;
    long hInsert;
    long hSelect;
    int lastID;
    int sortDirection;
    boolean dragStarted;
    boolean gestureCompleted;
    boolean insertAfter;
    boolean shrink;
    boolean ignoreShrink;
    boolean ignoreSelect;
    boolean ignoreExpand;
    boolean ignoreDeselect;
    boolean ignoreResize;
    boolean lockSelection;
    boolean oldSelected;
    boolean newSelected;
    boolean ignoreColumnMove;
    boolean ignoreColumnResize;
    boolean linesVisible;
    boolean customDraw;
    boolean painted;
    boolean ignoreItemHeight;
    boolean ignoreCustomDraw;
    boolean ignoreDrawForeground;
    boolean ignoreDrawBackground;
    boolean ignoreDrawFocus;
    boolean ignoreDrawSelection;
    boolean ignoreDrawHot;
    boolean ignoreFullSelection;
    boolean explorerTheme;
    boolean createdAsRTL;
    boolean headerItemDragging;
    int scrollWidth;
    int selectionForeground;
    long headerToolTipHandle;
    long itemToolTipHandle;
    long lastTimerID = -1L;
    int lastTimerCount;
    int headerBackground = -1;
    int headerForeground = -1;
    int[] cachedItemOrder;
    long cachedFirstItem;
    long cachedIndexItem;
    int cachedIndex;
    int cachedItemCount;
    static final boolean ENABLE_TVS_EX_FADEINOUTEXPANDOS = System.getProperty("org.eclipse.swt.internal.win32.enableFadeInOutExpandos") != null;
    static final int TIMER_MAX_COUNT = 8;
    static final int INSET = 3;
    static final int GRID_WIDTH = 1;
    static final int HEADER_MARGIN = 12;
    static final int HEADER_EXTRA = 3;
    static final int INCREMENT = 5;
    static final int EXPLORER_EXTRA = 2;
    static final int DRAG_IMAGE_SIZE = 301;
    static final int DEFAULT_INDENT = 16;
    static final long TreeProc;
    static final TCHAR TreeClass;
    static final long HeaderProc;
    static final TCHAR HeaderClass;

    static {
        TreeClass = new TCHAR(0, "SysTreeView32", true);
        HeaderClass = new TCHAR(0, "SysHeader32", true);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, TreeClass, lpWndClass);
        TreeProc = lpWndClass.lpfnWndProc;
        OS.GetClassInfo(0L, HeaderClass, lpWndClass);
        HeaderProc = lpWndClass.lpfnWndProc;
    }

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        if ((style & 0x100) != 0 && (style & 0x200) == 0) {
            style |= 0x200;
        }
        return Tree.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    @Override
    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        switch (eventType) {
            case 29: {
                if ((this.state & 0x8000) == 0) break;
                int bits = OS.GetWindowLong(this.handle, -16);
                OS.SetWindowLong(this.handle, -16, bits &= 0xFFFFFFEF);
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                this.customDraw = true;
                this.style |= 0x20000000;
                if (this.isCustomToolTip()) {
                    this.createItemToolTips();
                }
                OS.SendMessage(this.handle, 4385, 0L, 0L);
                int bits = OS.GetWindowLong(this.handle, -16);
                if (eventType == 41) {
                    bits |= 0x8000;
                }
                if ((this.style & 0x10000) != 0 && eventType != 41 && !this.explorerTheme) {
                    bits &= 0xFFFFEFFF;
                }
                if (bits == OS.GetWindowLong(this.handle, -16)) break;
                OS.SetWindowLong(this.handle, -16, bits);
                OS.InvalidateRect(this.handle, null, true);
                int count = (int)OS.SendMessage(this.handle, 4357, 0L, 0L);
                if (count == 0 || (bits & 0x8000) == 0) break;
                OS.ShowScrollBar(this.handle, 0, false);
            }
        }
    }

    TreeItem _getItem(long hItem) {
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = hItem;
        if (OS.SendMessage(this.handle, 4414, 0L, tvItem) != 0L) {
            return this._getItem(tvItem.hItem, (int)tvItem.lParam);
        }
        return null;
    }

    TreeItem _getItem(long hItem, int id) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[id];
        }
        return id != -1 ? this.items[id] : new TreeItem(this, 0, -1L, -1L, hItem);
    }

    @Override
    void _removeListener(int eventType, Listener listener) {
        super._removeListener(eventType, listener);
        switch (eventType) {
            case 41: {
                if ((this.style & 0x100) == 0 || (this.state & 0x1000) != 0) break;
                int bits = OS.GetWindowLong(this.handle, -16);
                OS.SetWindowLong(this.handle, -16, bits &= 0xFFFF7FFF);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
    }

    void _setBackgroundPixel(int newPixel) {
        int oldPixel = (int)OS.SendMessage(this.handle, 4383, 0L, 0L);
        if (oldPixel != newPixel) {
            if (oldPixel != -1) {
                OS.SendMessage(this.handle, 4381, 0L, -1L);
            }
            OS.SendMessage(this.handle, 4381, 0L, newPixel);
            if (this.explorerTheme && ENABLE_TVS_EX_FADEINOUTEXPANDOS) {
                int bits2 = (int)OS.SendMessage(this.handle, 4397, 0L, 0L);
                bits2 = newPixel == -1 && this.findImageControl() == null ? (bits2 |= 0x40) : (bits2 &= 0xFFFFFFBF);
                OS.SendMessage(this.handle, 4396, 0L, bits2);
            }
            if ((this.style & 0x20) != 0) {
                this.setCheckboxImageList();
            }
            this.updateImageList();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    public void addTreeListener(TreeListener listener) {
        this.addTypedListener(listener, 17, 18);
    }

    @Override
    long borderHandle() {
        return this.hwndParent != 0L ? this.hwndParent : this.handle;
    }

    LRESULT CDDS_ITEMPOSTPAINT(NMTVCUSTOMDRAW nmcd, long wParam, long lParam) {
        long hItem;
        int uiState;
        int bits;
        boolean hot;
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (nmcd.left == nmcd.right) {
            return new LRESULT(0L);
        }
        long hDC = nmcd.hdc;
        OS.RestoreDC(hDC, -1);
        TreeItem item = this.getItem(nmcd);
        if (item == null) {
            return null;
        }
        if (nmcd.left >= nmcd.right || nmcd.top >= nmcd.bottom) {
            return null;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return null;
        }
        if ((this.style & 0x10000) != 0 || this.findImageControl() != null || this.ignoreDrawSelection || this.explorerTheme) {
            OS.SetBkMode(hDC, 1);
        }
        int zoom = this.getZoom();
        boolean selected = this.isItemSelected(nmcd);
        boolean bl = hot = this.explorerTheme && (nmcd.uItemState & 0x40) != 0;
        if (OS.IsWindowEnabled(this.handle) && this.explorerTheme && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x200) != 0) {
            OS.SetTextColor(hDC, this.getForegroundPixel());
        }
        int[] order = null;
        RECT clientRect = new RECT();
        OS.GetClientRect(this.scrolledHandle(), clientRect);
        if (this.hwndHeader != 0L) {
            OS.MapWindowPoints(this.hwndParent, this.handle, clientRect, 2);
            if (this.columnCount != 0) {
                order = this.getColumnOrder();
            }
        }
        int sortIndex = -1;
        int clrSortBk = -1;
        if (OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null) {
            sortIndex = this.indexOf(this.sortColumn);
            clrSortBk = this.getSortColumnPixel();
        }
        int x = 0;
        Point size = null;
        int i = 0;
        while (i < Math.max(1, this.columnCount)) {
            int index = order == null ? i : order[i];
            int width = nmcd.right - nmcd.left;
            if (this.columnCount > 0 && this.hwndHeader != 0L) {
                HDITEM hdItem = new HDITEM();
                hdItem.mask = 1;
                OS.SendMessage(this.hwndHeader, 4619, (long)index, hdItem);
                width = hdItem.cxy;
            }
            if (i == 0 && (this.style & 0x10000) != 0) {
                boolean clear;
                boolean bl2 = clear = !this.explorerTheme && !this.ignoreDrawSelection && this.findImageControl() == null;
                if (clear || selected && !this.ignoreDrawSelection || hot && !this.ignoreDrawHot) {
                    boolean draw = true;
                    RECT pClipRect = new RECT();
                    OS.SetRect(pClipRect, width, nmcd.top, nmcd.right, nmcd.bottom);
                    if (this.explorerTheme) {
                        int iStateId;
                        HDITEM hdItem;
                        if (this.hooks(40)) {
                            RECT itemRect = item.getBounds(index, true, true, false, false, true, hDC);
                            int explorerExtraInPixels = DPIUtil.pointToPixel(2, zoom);
                            itemRect.left -= explorerExtraInPixels;
                            itemRect.right += explorerExtraInPixels + 1;
                            pClipRect.left = itemRect.left;
                            pClipRect.right = itemRect.right;
                            if (this.columnCount > 0 && this.hwndHeader != 0L) {
                                hdItem = new HDITEM();
                                hdItem.mask = 1;
                                OS.SendMessage(this.hwndHeader, 4619, (long)index, hdItem);
                                pClipRect.right = Math.min(pClipRect.right, nmcd.left + hdItem.cxy);
                            }
                        }
                        RECT pRect = new RECT();
                        OS.SetRect(pRect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                        if (this.columnCount > 0 && this.hwndHeader != 0L) {
                            int totalWidth = 0;
                            hdItem = new HDITEM();
                            hdItem.mask = 1;
                            int j = 0;
                            while (j < this.columnCount) {
                                OS.SendMessage(this.hwndHeader, 4619, (long)j, hdItem);
                                totalWidth += hdItem.cxy;
                                ++j;
                            }
                            if (totalWidth > clientRect.right - clientRect.left) {
                                pRect.left = 0;
                                pRect.right = totalWidth;
                            } else {
                                pRect.left = clientRect.left;
                                pRect.right = clientRect.right;
                            }
                        }
                        draw = false;
                        long hTheme = OS.OpenThemeData(this.handle, Display.TREEVIEW, this.getZoom());
                        int n = iStateId = selected ? 3 : 2;
                        if (OS.GetFocus() != this.handle && selected && !hot) {
                            iStateId = 5;
                        }
                        OS.DrawThemeBackground(hTheme, hDC, 1, iStateId, pRect, pClipRect);
                        OS.CloseThemeData(hTheme);
                    }
                    if (draw) {
                        this.fillBackground(hDC, OS.GetBkColor(hDC), pClipRect);
                    }
                }
            }
            if (x + width > clientRect.left) {
                Event event;
                GC gc;
                GCData data;
                RECT rect = new RECT();
                RECT backgroundRect = null;
                boolean drawItem = true;
                boolean drawText = true;
                boolean drawImage = true;
                boolean drawBackground = false;
                if (i == 0) {
                    drawText = false;
                    drawImage = false;
                    drawItem = false;
                    if (this.findImageControl() != null) {
                        if (this.explorerTheme) {
                            if (OS.IsWindowEnabled(this.handle) && !this.hooks(40)) {
                                Image image = null;
                                if (index == 0) {
                                    image = item.image;
                                } else {
                                    Image[] images = item.images;
                                    if (images != null) {
                                        image = images[index];
                                    }
                                }
                                if (image != null) {
                                    if (size == null) {
                                        size = Win32DPIUtils.pixelToPointAsSize(this.getImageSize(), zoom);
                                    }
                                    if (!this.ignoreDrawForeground) {
                                        GCData data2 = new GCData();
                                        data2.device = this.display;
                                        GC gc2 = this.createNewGC(hDC, data2);
                                        RECT iconRect = item.getBounds(index, false, true, false, false, true, hDC);
                                        gc2.setClipping(Win32DPIUtils.pixelToPoint(new Rectangle(iconRect.left, iconRect.top, iconRect.right - iconRect.left, iconRect.bottom - iconRect.top), zoom));
                                        gc2.drawImage(image, DPIUtil.pixelToPoint(iconRect.left, zoom), DPIUtil.pixelToPoint(iconRect.top, zoom), size.x, size.y);
                                        OS.SelectClipRgn(hDC, 0L);
                                        gc2.dispose();
                                    }
                                }
                            }
                        } else {
                            drawBackground = true;
                            drawText = true;
                            drawItem = true;
                            rect = item.getBounds(index, true, false, false, false, true, hDC);
                            if (this.linesVisible) {
                                ++rect.right;
                                ++rect.bottom;
                            }
                        }
                    }
                    if (selected && !this.ignoreDrawSelection && !this.ignoreDrawBackground) {
                        if (!this.explorerTheme) {
                            this.fillBackground(hDC, OS.GetBkColor(hDC), rect);
                        }
                        drawBackground = false;
                    }
                    backgroundRect = rect;
                    if (this.hooks(40)) {
                        drawImage = true;
                        drawText = true;
                        drawItem = true;
                        rect = item.getBounds(index, true, true, false, false, true, hDC);
                        backgroundRect = (this.style & 0x10000) != 0 ? rect : item.getBounds(index, true, false, false, false, true, hDC);
                    }
                } else {
                    this.selectionForeground = -1;
                    this.ignoreDrawHot = false;
                    this.ignoreDrawFocus = false;
                    this.ignoreDrawSelection = false;
                    this.ignoreDrawBackground = false;
                    this.ignoreDrawForeground = false;
                    OS.SetRect(rect, x, nmcd.top, x + width, nmcd.bottom);
                    backgroundRect = rect;
                }
                int clrText = -1;
                int clrTextBk = -1;
                long hFont = item.fontHandle(index);
                if (this.selectionForeground != -1) {
                    clrText = this.selectionForeground;
                }
                if (OS.IsWindowEnabled(this.handle)) {
                    boolean drawForeground = false;
                    if (selected) {
                        if (i != 0 && (this.style & 0x10000) == 0) {
                            OS.SetTextColor(hDC, this.getForegroundPixel());
                            OS.SetBkColor(hDC, this.getBackgroundPixel());
                            drawBackground = true;
                            drawForeground = true;
                        }
                    } else {
                        drawBackground = true;
                        drawForeground = true;
                    }
                    if (drawForeground) {
                        int n = clrText = item.cellForeground != null ? item.cellForeground[index] : -1;
                        if (clrText == -1) {
                            clrText = item.foreground;
                        }
                    }
                    if (drawBackground) {
                        int n = clrTextBk = item.cellBackground != null ? item.cellBackground[index] : -1;
                        if (clrTextBk == -1) {
                            clrTextBk = item.background;
                        }
                        if (clrTextBk == -1 && index == sortIndex) {
                            clrTextBk = clrSortBk;
                        }
                    }
                } else if (clrTextBk == -1 && index == sortIndex) {
                    drawBackground = true;
                    clrTextBk = clrSortBk;
                }
                if (this.explorerTheme && (selected || (nmcd.uItemState & 0x40) != 0)) {
                    if ((this.style & 0x10000) != 0) {
                        drawBackground = false;
                    } else if (i == 0) {
                        drawBackground = false;
                        if (!this.hooks(40)) {
                            drawText = false;
                        }
                    }
                }
                if (drawItem) {
                    if (i != 0) {
                        if (this.hooks(41)) {
                            this.sendMeasureItemEvent(item, index, hDC, selected ? 2 : 0);
                            if (this.isDisposed() || item.isDisposed()) break;
                        }
                        if (this.hooks(40)) {
                            RECT cellRect = item.getBounds(index, true, true, true, true, true, hDC);
                            int nSavedDC = OS.SaveDC(hDC);
                            data = new GCData();
                            data.device = this.display;
                            data.foreground = OS.GetTextColor(hDC);
                            data.background = OS.GetBkColor(hDC);
                            if (!selected || (this.style & 0x10000) == 0) {
                                if (clrText != -1) {
                                    data.foreground = clrText;
                                }
                                if (clrTextBk != -1) {
                                    data.background = clrTextBk;
                                }
                            }
                            data.font = item.getFont(index);
                            data.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
                            gc = this.createNewGC(hDC, data);
                            event = new Event();
                            event.item = item;
                            event.index = index;
                            event.gc = gc;
                            event.detail |= 0x10;
                            if (clrTextBk != -1) {
                                event.detail |= 8;
                            }
                            if ((this.style & 0x10000) != 0) {
                                int uiState2;
                                if (hot) {
                                    event.detail |= 0x20;
                                }
                                if (selected) {
                                    event.detail |= 2;
                                }
                                if (!this.explorerTheme && OS.SendMessage(this.handle, 4362, 9L, 0L) == nmcd.dwItemSpec && this.handle == OS.GetFocus() && ((uiState2 = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) == 0) {
                                    event.detail |= 4;
                                }
                            }
                            Rectangle bounds = Win32DPIUtils.pixelToPoint(new Rectangle(cellRect.left, cellRect.top, cellRect.right - cellRect.left, cellRect.bottom - cellRect.top), this.getZoom());
                            event.setBounds(bounds);
                            gc.setClipping(bounds);
                            this.sendEvent(40, event);
                            event.gc = null;
                            int newTextClr = data.foreground;
                            gc.dispose();
                            OS.RestoreDC(hDC, nSavedDC);
                            if (this.isDisposed() || item.isDisposed()) break;
                            if (event.doit) {
                                this.ignoreDrawForeground = (event.detail & 0x10) == 0;
                                boolean bl3 = this.ignoreDrawBackground = (event.detail & 8) == 0;
                                if ((this.style & 0x10000) != 0) {
                                    this.ignoreDrawSelection = (event.detail & 2) == 0;
                                    this.ignoreDrawFocus = (event.detail & 4) == 0;
                                    this.ignoreDrawHot = (event.detail & 0x20) == 0;
                                }
                            } else {
                                this.ignoreDrawHot = true;
                                this.ignoreDrawFocus = true;
                                this.ignoreDrawSelection = true;
                                this.ignoreDrawBackground = true;
                                this.ignoreDrawForeground = true;
                            }
                            if (selected && this.ignoreDrawSelection) {
                                this.ignoreDrawHot = true;
                            }
                            if ((this.style & 0x10000) != 0) {
                                if (this.ignoreDrawSelection) {
                                    this.ignoreFullSelection = true;
                                }
                                if (!this.ignoreDrawSelection || !this.ignoreDrawHot) {
                                    if (!selected && !hot) {
                                        this.selectionForeground = OS.GetSysColor(14);
                                    } else if (!this.explorerTheme) {
                                        drawBackground = true;
                                        this.ignoreDrawBackground = false;
                                        clrTextBk = (this.handle == OS.GetFocus() || this.display.getHighContrast()) && OS.IsWindowEnabled(this.handle) ? OS.GetSysColor(13) : OS.GetSysColor(15);
                                        if (!this.ignoreFullSelection && index == this.columnCount - 1) {
                                            RECT selectionRect = new RECT();
                                            OS.SetRect(selectionRect, backgroundRect.left, backgroundRect.top, nmcd.right, backgroundRect.bottom);
                                            backgroundRect = selectionRect;
                                        }
                                    } else {
                                        int iStateId;
                                        RECT pRect = new RECT();
                                        OS.SetRect(pRect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                                        if (this.columnCount > 0 && this.hwndHeader != 0L) {
                                            int totalWidth = 0;
                                            HDITEM hdItem = new HDITEM();
                                            hdItem.mask = 1;
                                            int j = 0;
                                            while (j < this.columnCount) {
                                                OS.SendMessage(this.hwndHeader, 4619, (long)j, hdItem);
                                                totalWidth += hdItem.cxy;
                                                ++j;
                                            }
                                            if (totalWidth > clientRect.right - clientRect.left) {
                                                pRect.left = 0;
                                                pRect.right = totalWidth;
                                            } else {
                                                pRect.left = clientRect.left;
                                                pRect.right = clientRect.right;
                                            }
                                            if (index == this.columnCount - 1) {
                                                RECT selectionRect = new RECT();
                                                OS.SetRect(selectionRect, backgroundRect.left, backgroundRect.top, pRect.right, backgroundRect.bottom);
                                                backgroundRect = selectionRect;
                                            }
                                        }
                                        long hTheme = OS.OpenThemeData(this.handle, Display.TREEVIEW, this.getZoom());
                                        int n = iStateId = selected ? 3 : 2;
                                        if (OS.GetFocus() != this.handle && selected && !hot) {
                                            iStateId = 5;
                                        }
                                        OS.DrawThemeBackground(hTheme, hDC, 1, iStateId, pRect, backgroundRect);
                                        OS.CloseThemeData(hTheme);
                                    }
                                } else if (selected) {
                                    this.selectionForeground = newTextClr;
                                    if (!this.explorerTheme && clrTextBk == -1 && OS.IsWindowEnabled(this.handle)) {
                                        Control control = this.findBackgroundControl();
                                        if (control == null) {
                                            control = this;
                                        }
                                        clrTextBk = control.getBackgroundPixel();
                                    }
                                }
                            }
                        }
                        if (this.selectionForeground != -1) {
                            clrText = this.selectionForeground;
                        }
                    }
                    if (!this.ignoreDrawBackground) {
                        if (clrTextBk != -1) {
                            if (drawBackground) {
                                this.fillBackground(hDC, clrTextBk, backgroundRect);
                            }
                        } else {
                            Control control = this.findImageControl();
                            if (control != null) {
                                if (i == 0) {
                                    int right = Math.min(rect.right, width);
                                    OS.SetRect(rect, rect.left, rect.top, right, rect.bottom);
                                    if (drawBackground) {
                                        this.fillImageBackground(hDC, control, rect, 0, 0);
                                    }
                                } else if (drawBackground) {
                                    this.fillImageBackground(hDC, control, rect, 0, 0);
                                }
                            }
                        }
                    }
                    rect.left += 2;
                    if (drawImage) {
                        int offset;
                        Image image = null;
                        if (index == 0) {
                            image = item.image;
                        } else {
                            Image[] images = item.images;
                            if (images != null) {
                                image = images[index];
                            }
                        }
                        int inset = i != 0 ? 3 : 0;
                        int n = offset = i != 0 ? 3 : 5;
                        if (image != null) {
                            if (size == null) {
                                size = Win32DPIUtils.pixelToPointAsSize(this.getImageSize(), zoom);
                            }
                            if (!this.ignoreDrawForeground) {
                                int y1 = rect.top + DPIUtil.pointToPixel((this.getItemHeight() - size.y) / 2, zoom);
                                int x1 = Math.max(rect.left, rect.left - inset + 1);
                                GCData data3 = new GCData();
                                data3.device = this.display;
                                GC gc3 = this.createNewGC(hDC, data3);
                                gc3.setClipping(Win32DPIUtils.pixelToPoint(new Rectangle(x1, rect.top, rect.right - x1, rect.bottom - rect.top), zoom));
                                gc3.drawImage(image, DPIUtil.pixelToPoint(x1, zoom), DPIUtil.pixelToPoint(y1, zoom), size.x, size.y);
                                OS.SelectClipRgn(hDC, 0L);
                                gc3.dispose();
                            }
                            OS.SetRect(rect, rect.left + DPIUtil.pointToPixel(size.x, zoom) + offset, rect.top, rect.right - inset, rect.bottom);
                        } else if (i == 0) {
                            if (OS.SendMessage(this.handle, 4360, 0L, 0L) != 0L) {
                                if (size == null) {
                                    size = this.getImageSize();
                                }
                                rect.left = Math.min(rect.left + size.x + offset, rect.right);
                            }
                        } else {
                            OS.SetRect(rect, rect.left + offset, rect.top, rect.right - inset, rect.bottom);
                        }
                    }
                    if (drawText && rect.left < rect.right) {
                        Object string = null;
                        if (index == 0) {
                            string = item.text;
                        } else {
                            String[] strings = item.strings;
                            if (strings != null) {
                                string = strings[index];
                            }
                        }
                        if (string != null) {
                            TreeColumn column;
                            if (hFont != -1L) {
                                hFont = OS.SelectObject(hDC, hFont);
                            }
                            if (clrText != -1) {
                                clrText = OS.SetTextColor(hDC, clrText);
                            }
                            if (clrTextBk != -1) {
                                clrTextBk = OS.SetBkColor(hDC, clrTextBk);
                            }
                            int flags = 2084;
                            if (i != 0) {
                                flags |= 0x8000;
                            }
                            TreeColumn treeColumn = column = this.columns != null ? this.columns[index] : null;
                            if (column != null) {
                                if ((column.style & 0x1000000) != 0) {
                                    flags |= 1;
                                }
                                if ((column.style & 0x20000) != 0) {
                                    flags |= 2;
                                }
                            }
                            if (string != null && ((String)string).length() > 8192) {
                                string = ((String)string).substring(0, 8192 - "...".length()) + "...";
                            }
                            char[] buffer = ((String)string).toCharArray();
                            if (!this.ignoreDrawForeground) {
                                OS.DrawText(hDC, buffer, buffer.length, rect, flags);
                            }
                            OS.DrawText(hDC, buffer, buffer.length, rect, flags | 0x400);
                            if (hFont != -1L) {
                                hFont = OS.SelectObject(hDC, hFont);
                            }
                            if (clrText != -1) {
                                clrText = OS.SetTextColor(hDC, clrText);
                            }
                            if (clrTextBk != -1) {
                                clrTextBk = OS.SetBkColor(hDC, clrTextBk);
                            }
                        }
                    }
                }
                if (this.selectionForeground != -1) {
                    clrText = this.selectionForeground;
                }
                if (this.hooks(42)) {
                    int uiState3;
                    RECT itemRect = item.getBounds(index, true, true, false, false, false, hDC);
                    int nSavedDC = OS.SaveDC(hDC);
                    data = new GCData();
                    data.device = this.display;
                    data.font = item.getFont(index);
                    data.foreground = OS.GetTextColor(hDC);
                    data.background = OS.GetBkColor(hDC);
                    if (selected && (this.style & 0x10000) != 0) {
                        if (this.selectionForeground != -1) {
                            data.foreground = this.selectionForeground;
                        }
                    } else {
                        if (clrText != -1) {
                            data.foreground = clrText;
                        }
                        if (clrTextBk != -1) {
                            data.background = clrTextBk;
                        }
                    }
                    data.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
                    gc = this.createNewGC(hDC, data);
                    event = new Event();
                    event.item = item;
                    event.index = index;
                    event.gc = gc;
                    event.detail |= 0x10;
                    if (clrTextBk != -1) {
                        event.detail |= 8;
                    }
                    if (hot) {
                        event.detail |= 0x20;
                    }
                    if (selected && (i == 0 || (this.style & 0x10000) != 0)) {
                        event.detail |= 2;
                    }
                    if (!(this.explorerTheme || OS.SendMessage(this.handle, 4362, 9L, 0L) != nmcd.dwItemSpec || i != 0 && (this.style & 0x10000) == 0 || this.handle != OS.GetFocus() || ((uiState3 = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) != 0)) {
                        event.detail |= 4;
                    }
                    event.setBounds(Win32DPIUtils.pixelToPoint(new Rectangle(itemRect.left, itemRect.top, itemRect.right - itemRect.left, itemRect.bottom - itemRect.top), this.getZoom()));
                    RECT cellRect = item.getBounds(index, true, true, true, true, true, hDC);
                    int cellWidth = cellRect.right - cellRect.left;
                    int cellHeight = cellRect.bottom - cellRect.top;
                    gc.setClipping(Win32DPIUtils.pixelToPoint(new Rectangle(cellRect.left, cellRect.top, cellWidth, cellHeight), zoom));
                    this.sendEvent(42, event);
                    if (data.focusDrawn) {
                        this.focusRect = null;
                    }
                    event.gc = null;
                    gc.dispose();
                    OS.RestoreDC(hDC, nSavedDC);
                    if (this.isDisposed() || item.isDisposed()) break;
                }
            }
            if ((x += width) > clientRect.right) break;
            ++i;
        }
        if (this.linesVisible) {
            if ((this.style & 0x10000) != 0 && this.columnCount != 0) {
                HDITEM hdItem = new HDITEM();
                hdItem.mask = 1;
                OS.SendMessage(this.hwndHeader, 4619, 0L, hdItem);
                RECT rect = new RECT();
                OS.SetRect(rect, nmcd.left + hdItem.cxy, nmcd.top, nmcd.right, nmcd.bottom);
                OS.DrawEdge(hDC, rect, 8, 8);
            }
            RECT rect = new RECT();
            OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
            OS.DrawEdge(hDC, rect, 8, 8);
        }
        if (!this.ignoreDrawFocus && this.focusRect != null) {
            OS.DrawFocusRect(hDC, this.focusRect);
            this.focusRect = null;
        } else if (!this.explorerTheme && this.handle == OS.GetFocus() && ((uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) == 0 && (hItem = OS.SendMessage(this.handle, 4362, 9L, 0L)) == item.handle && !this.ignoreDrawFocus && this.findImageControl() != null) {
            if ((this.style & 0x10000) != 0) {
                RECT focusRect = new RECT();
                OS.SetRect(focusRect, 0, nmcd.top, clientRect.right + 1, nmcd.bottom);
                OS.DrawFocusRect(hDC, focusRect);
            } else {
                int index = this.getFirstColumnIndex();
                RECT focusRect = item.getBounds(index, true, false, false, false, false, hDC);
                RECT clipRect = item.getBounds(index, true, false, false, false, true, hDC);
                OS.IntersectClipRect(hDC, clipRect.left, clipRect.top, clipRect.right, clipRect.bottom);
                OS.DrawFocusRect(hDC, focusRect);
                OS.SelectClipRgn(hDC, 0L);
            }
        }
        return new LRESULT(0L);
    }

    int getFirstColumnIndex() {
        int index = this.getColumnIndex(0);
        return index;
    }

    private int getColumnIndex(int order) {
        if (order < 0 || order >= this.columnCount || this.columnCount == 1) {
            return 0;
        }
        return this.getColumnOrder()[order];
    }

    private int getColumnIndexFromOS(int order) {
        if (this.hwndHeader == 0L) {
            return 0;
        }
        return (int)OS.SendMessage(this.hwndHeader, 4623, (long)order, 0L);
    }

    RECT getColumnRect(int index) {
        RECT headerRectInOut = new RECT();
        if (OS.SendMessage(this.hwndHeader, 4615, (long)index, headerRectInOut) == 0L) {
            return null;
        }
        return headerRectInOut;
    }

    LRESULT CDDS_ITEMPREPAINT(NMTVCUSTOMDRAW nmcd, long wParam, long lParam) {
        HDITEM hdItem;
        boolean focused;
        TreeItem item = this.getItem(nmcd);
        if (item == null) {
            return null;
        }
        long hDC = nmcd.hdc;
        int index = this.hwndHeader != 0L ? this.getFirstColumnIndex() : 0;
        long hFont = item.fontHandle(index);
        if (hFont != -1L) {
            OS.SelectObject(hDC, hFont);
        }
        if (this.ignoreCustomDraw || nmcd.left == nmcd.right) {
            return new LRESULT(hFont == -1L ? 0 : 2);
        }
        RECT clipRect = null;
        if (this.columnCount != 0) {
            clipRect = new RECT();
            HDITEM hdItem2 = new HDITEM();
            hdItem2.mask = 1;
            OS.SendMessage(this.hwndHeader, 4619, (long)index, hdItem2);
            OS.SetRect(clipRect, nmcd.left, nmcd.top, nmcd.left + hdItem2.cxy, nmcd.bottom);
        }
        int clrText = -1;
        int clrTextBk = -1;
        if (OS.IsWindowEnabled(this.handle)) {
            int n = clrText = item.cellForeground != null ? item.cellForeground[index] : -1;
            if (clrText == -1) {
                clrText = item.foreground;
            }
            int n2 = clrTextBk = item.cellBackground != null ? item.cellBackground[index] : -1;
            if (clrTextBk == -1) {
                clrTextBk = item.background;
            }
        }
        int clrSortBk = -1;
        if (OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null && this.indexOf(this.sortColumn) == index) {
            clrSortBk = this.getSortColumnPixel();
            if (clrTextBk == -1) {
                clrTextBk = clrSortBk;
            }
        }
        boolean selected = this.isItemSelected(nmcd);
        boolean hot = this.explorerTheme && (nmcd.uItemState & 0x40) != 0;
        boolean bl = focused = this.explorerTheme && (nmcd.uItemState & 0x10) != 0;
        if (OS.IsWindowVisible(this.handle) && nmcd.left < nmcd.right && nmcd.top < nmcd.bottom) {
            int bits;
            if (hFont != -1L) {
                OS.SelectObject(hDC, hFont);
            }
            if (this.linesVisible) {
                RECT rect = new RECT();
                OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                OS.DrawEdge(hDC, rect, 8, 8);
            }
            Event measureEvent = null;
            Rectangle boundsInPixels = null;
            if (this.hooks(41)) {
                measureEvent = this.sendMeasureItemEvent(item, index, hDC, selected ? 2 : 0);
                boundsInPixels = Win32DPIUtils.pointToPixel(measureEvent.getBounds(), this.getZoom());
                if (this.isDisposed() || item.isDisposed()) {
                    return null;
                }
            }
            this.selectionForeground = -1;
            this.ignoreFullSelection = false;
            this.ignoreDrawHot = false;
            this.ignoreDrawFocus = false;
            this.ignoreDrawSelection = false;
            this.ignoreDrawBackground = false;
            this.ignoreDrawForeground = false;
            if (this.hooks(40)) {
                int uiState;
                RECT rect = new RECT();
                OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                RECT cellRect = item.getBounds(index, true, true, true, true, true, hDC);
                if (clrSortBk != -1) {
                    this.drawBackground(hDC, cellRect, clrSortBk, 0, 0);
                } else if (OS.IsWindowEnabled(this.handle) || this.findImageControl() != null) {
                    this.drawBackground(hDC, rect);
                } else {
                    this.fillBackground(hDC, OS.GetBkColor(hDC), rect);
                }
                int nSavedDC = OS.SaveDC(hDC);
                GCData data = new GCData();
                data.device = this.display;
                data.foreground = selected && this.explorerTheme ? OS.GetSysColor(8) : OS.GetTextColor(hDC);
                data.background = OS.GetBkColor(hDC);
                if (!selected) {
                    if (clrText != -1) {
                        data.foreground = clrText;
                    }
                    if (clrTextBk != -1) {
                        data.background = clrTextBk;
                    }
                }
                data.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
                data.font = item.getFont(index);
                GC gc = this.createNewGC(hDC, data);
                Event event = new Event();
                event.index = index;
                event.item = item;
                event.gc = gc;
                event.detail |= 0x10;
                if (clrTextBk != -1) {
                    event.detail |= 8;
                }
                if (hot) {
                    event.detail |= 0x20;
                }
                if (selected) {
                    event.detail |= 2;
                }
                if (!(OS.SendMessage(this.handle, 4362, 9L, 0L) != nmcd.dwItemSpec || this.handle != OS.GetFocus() || ((uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) != 0 || this.explorerTheme && selected)) {
                    focused = true;
                    event.detail |= 4;
                }
                Rectangle bounds = Win32DPIUtils.pixelToPoint(new Rectangle(cellRect.left, cellRect.top, cellRect.right - cellRect.left, cellRect.bottom - cellRect.top), this.getZoom());
                event.setBounds(bounds);
                gc.setClipping(bounds);
                this.sendEvent(40, event);
                event.gc = null;
                int newTextClr = data.foreground;
                gc.dispose();
                OS.RestoreDC(hDC, nSavedDC);
                if (this.isDisposed() || item.isDisposed()) {
                    return null;
                }
                if (event.doit) {
                    this.ignoreDrawForeground = (event.detail & 0x10) == 0;
                    this.ignoreDrawBackground = (event.detail & 8) == 0;
                    this.ignoreDrawSelection = (event.detail & 2) == 0;
                    this.ignoreDrawFocus = (event.detail & 4) == 0;
                    this.ignoreDrawHot = (event.detail & 0x20) == 0;
                } else {
                    this.ignoreDrawHot = true;
                    this.ignoreDrawFocus = true;
                    this.ignoreDrawSelection = true;
                    this.ignoreDrawBackground = true;
                    this.ignoreDrawForeground = true;
                }
                if (selected && this.ignoreDrawSelection) {
                    this.ignoreDrawHot = true;
                }
                if (!this.ignoreDrawBackground && clrTextBk != -1) {
                    boolean draw;
                    boolean bl2 = draw = !selected && !hot;
                    if (!this.explorerTheme && selected) {
                        boolean bl3 = draw = !this.ignoreDrawSelection;
                    }
                    if (draw) {
                        if (this.columnCount == 0) {
                            if ((this.style & 0x10000) != 0) {
                                this.fillBackground(hDC, clrTextBk, rect);
                            } else {
                                RECT textRect = item.getBounds(index, true, false, false, false, true, hDC);
                                if (measureEvent != null) {
                                    textRect.right = Math.min(cellRect.right, boundsInPixels.x + boundsInPixels.width);
                                }
                                this.fillBackground(hDC, clrTextBk, textRect);
                            }
                        } else {
                            this.fillBackground(hDC, clrTextBk, cellRect);
                        }
                    }
                }
                if (this.ignoreDrawSelection) {
                    this.ignoreFullSelection = true;
                }
                if (!this.ignoreDrawSelection || !this.ignoreDrawHot) {
                    if (!selected && !hot) {
                        this.selectionForeground = clrText = OS.GetSysColor(14);
                    }
                    if (this.explorerTheme) {
                        int zoom = this.getZoom();
                        if ((this.style & 0x10000) == 0) {
                            int iStateId;
                            RECT pRect = item.getBounds(index, true, true, false, false, false, hDC);
                            RECT pClipRect = item.getBounds(index, true, true, true, false, true, hDC);
                            int explorerExtraInPixels = DPIUtil.pointToPixel(2, zoom);
                            if (measureEvent != null) {
                                pRect.right = Math.min(pClipRect.right, boundsInPixels.x + boundsInPixels.width);
                            } else {
                                pRect.right += explorerExtraInPixels;
                                pClipRect.right += explorerExtraInPixels;
                            }
                            pRect.left -= explorerExtraInPixels;
                            pClipRect.left -= explorerExtraInPixels;
                            long hTheme = OS.OpenThemeData(this.handle, Display.TREEVIEW, this.getZoom());
                            int n = iStateId = selected ? 3 : 2;
                            if (OS.GetFocus() != this.handle && selected && !hot) {
                                iStateId = 5;
                            }
                            OS.DrawThemeBackground(hTheme, hDC, 1, iStateId, pRect, pClipRect);
                            OS.CloseThemeData(hTheme);
                        }
                    } else if ((this.style & 0x10000) != 0) {
                        if ((this.style & 0x10000) != 0 && this.columnCount == 0) {
                            this.fillBackground(hDC, OS.GetBkColor(hDC), rect);
                        } else {
                            this.fillBackground(hDC, OS.GetBkColor(hDC), cellRect);
                        }
                    } else {
                        RECT textRect = item.getBounds(index, true, false, false, false, true, hDC);
                        if (measureEvent != null) {
                            textRect.right = Math.min(cellRect.right, boundsInPixels.x + boundsInPixels.width);
                        }
                        this.fillBackground(hDC, OS.GetBkColor(hDC), textRect);
                    }
                } else {
                    if (selected || hot) {
                        this.selectionForeground = clrText = newTextClr;
                        this.ignoreDrawHot = true;
                        this.ignoreDrawSelection = true;
                    }
                    if (this.explorerTheme) {
                        int newColor;
                        nmcd.uItemState |= 4;
                        int n = newColor = clrText == -1 ? this.getForegroundPixel() : clrText;
                        if (nmcd.clrText == newColor) {
                            nmcd.clrText |= 0x20000000;
                            if (nmcd.clrText == newColor) {
                                nmcd.clrText &= 0xDFFFFFFF;
                            }
                        } else {
                            nmcd.clrText = newColor;
                        }
                        OS.MoveMemory(lParam, nmcd, NMTVCUSTOMDRAW.sizeof);
                    }
                }
                if (focused && !this.ignoreDrawFocus && (this.style & 0x10000) == 0) {
                    RECT textRect = item.getBounds(index, true, this.explorerTheme, false, false, true, hDC);
                    if (measureEvent != null) {
                        textRect.right = Math.min(cellRect.right, boundsInPixels.x + boundsInPixels.width);
                    }
                    nmcd.uItemState &= 0xFFFFFFEF;
                    OS.MoveMemory(lParam, nmcd, NMTVCUSTOMDRAW.sizeof);
                    this.focusRect = textRect;
                }
                if (this.explorerTheme) {
                    if (selected || hot && this.ignoreDrawHot) {
                        nmcd.uItemState &= 0xFFFFFFBF;
                    }
                    OS.MoveMemory(lParam, nmcd, NMTVCUSTOMDRAW.sizeof);
                }
                RECT itemRect = item.getBounds(index, true, true, false, false, false, hDC);
                OS.SaveDC(hDC);
                OS.SelectClipRgn(hDC, 0L);
                if (this.explorerTheme) {
                    int explorerExtraInPixels = DPIUtil.pointToPixel(2, this.getZoom());
                    itemRect.left -= explorerExtraInPixels;
                    itemRect.right += explorerExtraInPixels;
                }
                ++itemRect.right;
                if (this.linesVisible) {
                    ++itemRect.bottom;
                }
                if (clipRect != null) {
                    OS.IntersectClipRect(hDC, clipRect.left, clipRect.top, clipRect.right, clipRect.bottom);
                }
                OS.ExcludeClipRect(hDC, itemRect.left, itemRect.top, itemRect.right, itemRect.bottom);
                return new LRESULT(16L);
            }
            if ((this.style & 0x10000) != 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) == 0) {
                RECT rect = new RECT();
                OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                if (selected) {
                    this.fillBackground(hDC, OS.GetBkColor(hDC), rect);
                } else if (OS.IsWindowEnabled(this.handle)) {
                    this.drawBackground(hDC, rect);
                }
                nmcd.uItemState &= 0xFFFFFFEF;
                OS.MoveMemory(lParam, nmcd, NMTVCUSTOMDRAW.sizeof);
            }
        }
        LRESULT result = null;
        if (clrText == -1 && clrTextBk == -1 && hFont == -1L) {
            result = new LRESULT(16L);
        } else {
            result = new LRESULT(18L);
            if (hFont != -1L) {
                OS.SelectObject(hDC, hFont);
            }
            if (OS.IsWindowEnabled(this.handle) && OS.IsWindowVisible(this.handle)) {
                int bits;
                if (clrTextBk != -1 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) == 0) {
                    if (this.columnCount != 0 && this.hwndHeader != 0L) {
                        RECT itemRect;
                        RECT rect = new RECT();
                        hdItem = new HDITEM();
                        hdItem.mask = 1;
                        OS.SendMessage(this.hwndHeader, 4619, (long)index, hdItem);
                        OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.left + hdItem.cxy, nmcd.bottom);
                        if (!OS.IsAppThemed() && OS.TreeView_GetItemRect(this.handle, item.handle, itemRect = new RECT(), true)) {
                            rect.left = Math.min(itemRect.left, rect.right);
                        }
                        if ((this.style & 0x10000) != 0) {
                            if (!selected) {
                                this.fillBackground(hDC, clrTextBk, rect);
                            }
                        } else {
                            this.fillBackground(hDC, clrTextBk, rect);
                        }
                    } else if ((this.style & 0x10000) != 0) {
                        RECT rect = new RECT();
                        OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                        if (!selected) {
                            this.fillBackground(hDC, clrTextBk, rect);
                        }
                    }
                }
                if (!selected) {
                    nmcd.clrText = clrText == -1 ? this.getForegroundPixel() : clrText;
                    nmcd.clrTextBk = clrTextBk == -1 ? this.getBackgroundPixel() : clrTextBk;
                    OS.MoveMemory(lParam, nmcd, NMTVCUSTOMDRAW.sizeof);
                }
            }
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (this.explorerTheme && this.findImageControl() != null && !selected && (nmcd.uItemState & 0x41) == 0) {
                int newColor;
                nmcd.uItemState |= 4;
                int n = newColor = clrText == -1 ? this.getForegroundPixel() : clrText;
                if (nmcd.clrText == newColor) {
                    nmcd.clrText |= 0x20000000;
                    if (nmcd.clrText == newColor) {
                        nmcd.clrText &= 0xDFFFFFFF;
                    }
                } else {
                    nmcd.clrText = newColor;
                }
                OS.MoveMemory(lParam, nmcd, NMTVCUSTOMDRAW.sizeof);
                if (clrTextBk != -1) {
                    if ((this.style & 0x10000) != 0) {
                        RECT rect = new RECT();
                        if (this.columnCount != 0) {
                            hdItem = new HDITEM();
                            hdItem.mask = 1;
                            OS.SendMessage(this.hwndHeader, 4619, (long)index, hdItem);
                            OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.left + hdItem.cxy, nmcd.bottom);
                        } else {
                            OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                        }
                        this.fillBackground(hDC, clrTextBk, rect);
                    } else {
                        RECT textRect = item.getBounds(index, true, false, true, false, true, hDC);
                        this.fillBackground(hDC, clrTextBk, textRect);
                    }
                }
            }
        } else if (clrSortBk != -1) {
            RECT rect = new RECT();
            HDITEM hdItem3 = new HDITEM();
            hdItem3.mask = 1;
            OS.SendMessage(this.hwndHeader, 4619, (long)index, hdItem3);
            OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.left + hdItem3.cxy, nmcd.bottom);
            this.fillBackground(hDC, clrSortBk, rect);
        }
        OS.SaveDC(hDC);
        if (clipRect != null) {
            long hRgn = OS.CreateRectRgn(clipRect.left, clipRect.top, clipRect.right, clipRect.bottom);
            POINT lpPoint = new POINT();
            OS.GetWindowOrgEx(hDC, lpPoint);
            OS.OffsetRgn(hRgn, -lpPoint.x, -lpPoint.y);
            OS.SelectClipRgn(hDC, hRgn);
            OS.DeleteObject(hRgn);
        }
        return result;
    }

    LRESULT CDDS_POSTPAINT(NMTVCUSTOMDRAW nmcd, long wParam, long lParam) {
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (OS.IsWindowVisible(this.handle)) {
            int index;
            if (OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null && (index = this.indexOf(this.sortColumn)) != -1) {
                RECT rect;
                int top = nmcd.top;
                long hItem = this.getBottomItem();
                if (hItem != 0L && OS.TreeView_GetItemRect(this.handle, hItem, rect = new RECT(), false)) {
                    top = rect.bottom;
                }
                rect = new RECT();
                OS.SetRect(rect, nmcd.left, top, nmcd.right, nmcd.bottom);
                RECT headerRect = new RECT();
                OS.SendMessage(this.hwndHeader, 4615, (long)index, headerRect);
                rect.left = headerRect.left;
                rect.right = headerRect.right;
                this.fillBackground(nmcd.hdc, this.getSortColumnPixel(), rect);
            }
            if (this.linesVisible) {
                RECT rect;
                long hDC = nmcd.hdc;
                if (this.hwndHeader != 0L) {
                    int x = 0;
                    rect = new RECT();
                    HDITEM hdItem = new HDITEM();
                    hdItem.mask = 1;
                    int i = 0;
                    while (i < this.columnCount) {
                        int index2 = this.getColumnIndex(i);
                        OS.SendMessage(this.hwndHeader, 4619, (long)index2, hdItem);
                        OS.SetRect(rect, x, nmcd.top, x + hdItem.cxy, nmcd.bottom);
                        OS.DrawEdge(hDC, rect, 8, 4);
                        x += hdItem.cxy;
                        ++i;
                    }
                }
                int height = 0;
                rect = new RECT();
                long hItem = this.getBottomItem();
                if (hItem != 0L && OS.TreeView_GetItemRect(this.handle, hItem, rect, false)) {
                    height = rect.bottom - rect.top;
                }
                if (height == 0) {
                    height = (int)OS.SendMessage(this.handle, 4380, 0L, 0L);
                    OS.GetClientRect(this.handle, rect);
                    OS.SetRect(rect, rect.left, rect.top, rect.right, rect.top + height);
                    OS.DrawEdge(hDC, rect, 8, 8);
                }
                if (height != 0) {
                    while (rect.bottom < nmcd.bottom) {
                        int top = rect.top + height;
                        OS.SetRect(rect, rect.left, top, rect.right, top + height);
                        OS.DrawEdge(hDC, rect, 8, 8);
                    }
                }
            }
        }
        return new LRESULT(0L);
    }

    LRESULT CDDS_PREPAINT(NMTVCUSTOMDRAW nmcd, long wParam, long lParam) {
        if (this.explorerTheme && (OS.IsWindowEnabled(this.handle) && this.hooks(40) || this.hasCustomBackground() || this.findImageControl() != null)) {
            RECT rect = new RECT();
            OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
            this.drawBackground(nmcd.hdc, rect);
        }
        return new LRESULT(48L);
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        long hItem;
        if (this.handle == 0L) {
            return 0L;
        }
        if (this.hwndParent != 0L && hwnd == this.hwndParent) {
            return OS.DefWindowProc(hwnd, msg, wParam, lParam);
        }
        if (this.hwndHeader != 0L && hwnd == this.hwndHeader) {
            return OS.CallWindowProc(HeaderProc, hwnd, msg, wParam, lParam);
        }
        switch (msg) {
            case 7: {
                if ((this.style & 4) != 0 || (hItem = OS.SendMessage(this.handle, 4362, 9L, 0L)) != 0L || (hItem = OS.SendMessage(this.handle, 4362, 5L, 0L)) == 0L) break;
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 24;
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, 4414, 0L, tvItem);
                this.hSelect = hItem;
                this.lockSelection = true;
                this.ignoreSelect = true;
                this.ignoreDeselect = true;
                OS.SendMessage(this.handle, 4363, 9L, hItem);
                this.lockSelection = false;
                this.ignoreSelect = false;
                this.ignoreDeselect = false;
                this.hSelect = 0L;
                if ((tvItem.state & 2) != 0) break;
                OS.SendMessage(this.handle, 4415, 0L, tvItem);
            }
        }
        hItem = 0L;
        boolean redraw = false;
        switch (msg) {
            case 256: {
                if (wParam == 17L || wParam == 16L) break;
            }
            case 5: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                boolean bl = redraw = this.findImageControl() != null && this.getDrawing() && OS.IsWindowVisible(this.handle);
                if (redraw) {
                    OS.DefWindowProc(this.handle, 11, 0L, 0L);
                }
            }
            case 48: 
            case 275: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                if (this.findImageControl() == null) break;
                hItem = OS.SendMessage(this.handle, 4362, 5L, 0L);
            }
        }
        long code = OS.CallWindowProc(TreeProc, hwnd, msg, wParam, lParam);
        switch (msg) {
            case 256: {
                if (wParam == 17L || wParam == 16L) break;
            }
            case 5: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                if (redraw) {
                    OS.DefWindowProc(this.handle, 11, 1L, 0L);
                    OS.InvalidateRect(this.handle, null, true);
                    if (this.hwndHeader != 0L) {
                        OS.InvalidateRect(this.hwndHeader, null, true);
                    }
                }
            }
            case 48: 
            case 275: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                if (this.findImageControl() != null && hItem != OS.SendMessage(this.handle, 4362, 5L, 0L)) {
                    OS.InvalidateRect(this.handle, null, true);
                }
                this.updateScrollBar();
                break;
            }
            case 15: {
                this.painted = true;
            }
        }
        return code;
    }

    @Override
    void checkBuffered() {
        int exStyle;
        super.checkBuffered();
        if ((this.style & 0x10000000) != 0) {
            this.style |= 0x20000000;
            OS.SendMessage(this.handle, 4385, 0L, 0L);
        }
        if (OS.IsAppThemed() && ((exStyle = (int)OS.SendMessage(this.handle, 4397, 0L, 0L)) & 4) != 0) {
            this.style |= 0x20000000;
        }
    }

    boolean checkData(TreeItem item, boolean redraw) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!item.cached) {
            TreeItem parentItem = item.getParentItem();
            return this.checkData(item, parentItem == null ? this.indexOf(item) : parentItem.indexOf(item), redraw);
        }
        return true;
    }

    boolean checkData(TreeItem item, int index, boolean redraw) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!item.cached) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = index;
            TreeItem oldItem = this.currentItem;
            this.currentItem = item;
            long hTopItem = OS.SendMessage(this.handle, 4362, 5L, 0L);
            this.sendEvent(36, event);
            this.currentItem = oldItem;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw) {
                item.redraw();
            }
            if (hTopItem != OS.SendMessage(this.handle, 4362, 5L, 0L)) {
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return true;
    }

    boolean checkScroll(long hItem) {
        if (this.getDrawing()) {
            return false;
        }
        long hRoot = OS.SendMessage(this.handle, 4362, 0L, 0L);
        long hParent = OS.SendMessage(this.handle, 4362, 3L, hItem);
        while (hParent != hRoot && hParent != 0L) {
            hParent = OS.SendMessage(this.handle, 4362, 3L, hParent);
        }
        return hParent == 0L;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
        if (hItem == 0L) {
            this.error(6);
        }
        if ((hItem = this.findItem(hItem, index)) == 0L) {
            this.error(6);
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        this.clear(hItem, tvItem);
        if (all) {
            hItem = OS.SendMessage(this.handle, 4362, 4L, hItem);
            this.clearAll(hItem, tvItem, all);
        }
    }

    void clear(long hItem, TVITEM tvItem) {
        tvItem.hItem = hItem;
        TreeItem item = null;
        if (OS.SendMessage(this.handle, 4414, 0L, tvItem) != 0L) {
            TreeItem treeItem = item = tvItem.lParam != -1L ? this.items[(int)tvItem.lParam] : null;
        }
        if (item != null) {
            if ((this.style & 0x10000000) != 0 && !item.cached) {
                return;
            }
            item.clear();
            item.redraw();
        }
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
        if (hItem == 0L) {
            return;
        }
        if (all) {
            boolean redraw = false;
            TreeItem[] treeItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item != null && item != this.currentItem) {
                    item.clear();
                    redraw = true;
                }
                ++n2;
            }
            if (redraw) {
                OS.InvalidateRect(this.handle, null, true);
            }
        } else {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 20;
            this.clearAll(hItem, tvItem, all);
        }
    }

    void clearAll(long hItem, TVITEM tvItem, boolean all) {
        while (hItem != 0L) {
            this.clear(hItem, tvItem);
            if (all) {
                long hFirstItem = OS.SendMessage(this.handle, 4362, 4L, hItem);
                this.clearAll(hFirstItem, tvItem, all);
            }
            hItem = OS.SendMessage(this.handle, 4362, 1L, hItem);
        }
    }

    long CompareFunc(long lParam1, long lParam2, long lParamSort) {
        TreeItem item1 = this.items[(int)lParam1];
        TreeItem item2 = this.items[(int)lParam2];
        String text1 = item1.getText((int)lParamSort);
        String text2 = item2.getText((int)lParamSort);
        return this.sortDirection == 128 ? text1.compareTo(text2) : text2.compareTo(text1);
    }

    @Override
    Point computeSizeInPixels(Point hintInPoints, int zoom, boolean changed) {
        Point hintInPixels = Win32DPIUtils.pointToPixelAsSufficientlyLargeSize(hintInPoints, zoom);
        int width = 0;
        int height = 0;
        if (this.hwndHeader != 0L) {
            HDITEM hdItem = new HDITEM();
            hdItem.mask = 1;
            int i = 0;
            while (i < this.columnCount) {
                OS.SendMessage(this.hwndHeader, 4619, (long)i, hdItem);
                width += hdItem.cxy;
                ++i;
            }
            RECT rect = new RECT();
            OS.GetWindowRect(this.hwndHeader, rect);
            height += rect.bottom - rect.top;
        }
        RECT rect = new RECT();
        long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
        while (hItem != 0L) {
            if ((this.style & 0x10000000) == 0 && !this.painted) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 17;
                tvItem.hItem = hItem;
                tvItem.pszText = -1L;
                this.ignoreCustomDraw = true;
                OS.SendMessage(this.handle, 4415, 0L, tvItem);
                this.ignoreCustomDraw = false;
            }
            if (OS.TreeView_GetItemRect(this.handle, hItem, rect, true)) {
                width = Math.max(width, rect.right);
                height += rect.bottom - rect.top;
            }
            hItem = OS.SendMessage(this.handle, 4362, 6L, hItem);
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (hintInPoints.x != -1) {
            width = hintInPixels.x;
        }
        if (hintInPoints.y != -1) {
            height = hintInPixels.y;
        }
        int border = this.getBorderWidthInPixels();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += this.getSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            height += this.getSystemMetrics(3);
        }
        return new Point(width, height);
    }

    @Override
    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (OS.IsAppThemed()) {
            this.explorerTheme = true;
            OS.SetWindowTheme(this.handle, Display.EXPLORER, null);
            int bits = 20;
            if (ENABLE_TVS_EX_FADEINOUTEXPANDOS) {
                bits |= 0x40;
            }
            OS.SendMessage(this.handle, 4396, 0L, bits);
            this.setForegroundPixel(-1);
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        long hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0L);
        this.calculateAndApplyIndentSize();
        this.createdAsRTL = (this.style & 0x4000000) != 0;
    }

    void createHeaderToolTips() {
        if (this.headerToolTipHandle != 0L) {
            return;
        }
        int bits = 0;
        if ((this.style & 0x4000000) != 0) {
            bits |= 0x400000;
        }
        this.headerToolTipHandle = OS.CreateWindowEx(bits, new TCHAR(0, "tooltips_class32", true), null, 2, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0L, OS.GetModuleHandle(null), null);
        if (this.headerToolTipHandle == 0L) {
            this.error(2);
        }
        this.maybeEnableDarkSystemTheme(this.headerToolTipHandle);
        OS.SendMessage(this.headerToolTipHandle, 1048, 0L, 32767L);
    }

    void createItem(TreeColumn column, int index) {
        RECT rect;
        if (this.hwndHeader == 0L) {
            this.createParent();
        }
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        TreeItem[] treeItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item != null) {
                Object[] temp;
                Image[] images;
                String[] strings = item.strings;
                if (strings != null) {
                    String[] temp2 = new String[this.columnCount + 1];
                    System.arraycopy(strings, 0, temp2, 0, index);
                    System.arraycopy(strings, index, temp2, index + 1, this.columnCount - index);
                    item.strings = temp2;
                }
                if ((images = item.images) != null) {
                    Image[] temp3 = new Image[this.columnCount + 1];
                    System.arraycopy(images, 0, temp3, 0, index);
                    System.arraycopy(images, index, temp3, index + 1, this.columnCount - index);
                    item.images = temp3;
                }
                if (index == 0 && this.columnCount != 0) {
                    if (strings == null) {
                        item.strings = new String[this.columnCount + 1];
                        item.strings[1] = item.text;
                    }
                    item.text = "";
                    if (images == null) {
                        item.images = new Image[this.columnCount + 1];
                        item.images[1] = item.image;
                    }
                    item.image = null;
                }
                if (item.cellBackground != null) {
                    int[] cellBackground = item.cellBackground;
                    temp = new int[this.columnCount + 1];
                    System.arraycopy(cellBackground, 0, temp, 0, index);
                    System.arraycopy(cellBackground, index, temp, index + 1, this.columnCount - index);
                    temp[index] = -1;
                    item.cellBackground = temp;
                }
                if (item.cellForeground != null) {
                    int[] cellForeground = item.cellForeground;
                    temp = new int[this.columnCount + 1];
                    System.arraycopy(cellForeground, 0, temp, 0, index);
                    System.arraycopy(cellForeground, index, temp, index + 1, this.columnCount - index);
                    temp[index] = -1;
                    item.cellForeground = temp;
                }
                if (item.cellFont != null) {
                    Font[] cellFont = item.cellFont;
                    temp = new Font[this.columnCount + 1];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index);
                    item.cellFont = (Font[])temp;
                }
            }
            ++n2;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        this.cachedItemOrder = null;
        long hHeap = OS.GetProcessHeap();
        long pszText = OS.HeapAlloc(hHeap, 8, 2);
        HDITEM hdItem = new HDITEM();
        hdItem.mask = 6;
        hdItem.pszText = pszText;
        if ((column.style & 0x4000) == 16384) {
            hdItem.fmt = 0;
        }
        if ((column.style & 0x1000000) == 0x1000000) {
            hdItem.fmt = 2;
        }
        if ((column.style & 0x20000) == 131072) {
            hdItem.fmt = 1;
        }
        OS.SendMessage(this.hwndHeader, 4618, (long)index, hdItem);
        if (pszText != 0L) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (this.columnCount == 1) {
            int count;
            this.scrollWidth = 0;
            if ((this.style & 0x100) != 0) {
                int bits = OS.GetWindowLong(this.handle, -16);
                OS.SetWindowLong(this.handle, -16, bits |= 0x8000);
            }
            if ((count = (int)OS.SendMessage(this.handle, 4357, 0L, 0L)) != 0) {
                OS.ShowScrollBar(this.handle, 0, false);
            }
            this.createItemToolTips();
            if (this.itemToolTipHandle != 0L) {
                OS.SendMessage(this.itemToolTipHandle, 1027, 0L, -1L);
            }
        }
        this.setScrollWidth();
        this.updateImageList();
        this.updateScrollBar();
        if (this.columnCount == 1 && OS.SendMessage(this.handle, 4357, 0L, 0L) != 0L) {
            OS.InvalidateRect(this.handle, null, true);
        }
        if (this.headerToolTipHandle != 0L && OS.SendMessage(this.hwndHeader, 4615, (long)index, rect = new RECT()) != 0L) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            lpti.uFlags = 16;
            lpti.hwnd = this.hwndHeader;
            column.id = this.display.nextToolTipId++;
            lpti.uId = column.id;
            lpti.left = rect.left;
            lpti.top = rect.top;
            lpti.right = rect.right;
            lpti.bottom = rect.bottom;
            lpti.lpszText = -1L;
            OS.SendMessage(this.headerToolTipHandle, 1074, 0L, lpti);
        }
    }

    void createItem(TreeItem item, long hParent, long hInsertAfter, long hItem) {
        boolean fixParent;
        int id = -1;
        if (item != null) {
            id = this.lastID < this.items.length ? this.lastID : 0;
            while (id < this.items.length && this.items[id] != null) {
                ++id;
            }
            if (id == this.items.length) {
                int length = 0;
                if (this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                    length = this.items.length + 4;
                } else {
                    this.shrink = true;
                    length = Math.max(4, this.items.length * 3 / 2);
                }
                this.itemsGrowArray(length);
            }
            this.lastID = id + 1;
        }
        long hNewItem = 0L;
        long hFirstItem = OS.SendMessage(this.handle, 4362, 4L, hParent);
        boolean bl = fixParent = hFirstItem == 0L;
        if (hItem == 0L) {
            TVINSERTSTRUCT tvInsert = new TVINSERTSTRUCT();
            tvInsert.hParent = hParent;
            tvInsert.hInsertAfter = hInsertAfter;
            tvInsert.lParam = id;
            tvInsert.pszText = -1L;
            tvInsert.iSelectedImage = -1;
            tvInsert.iImage = -1;
            tvInsert.mask = 55;
            if ((this.style & 0x20) != 0) {
                tvInsert.mask |= 8;
                tvInsert.state = 4096;
                tvInsert.stateMask = 61440;
            }
            this.ignoreCustomDraw = true;
            hNewItem = OS.SendMessage(this.handle, 4402, 0L, tvInsert);
            this.ignoreCustomDraw = false;
            if (hNewItem == 0L) {
                this.error(14);
            }
        } else {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 20;
            tvItem.hItem = hNewItem = hItem;
            tvItem.lParam = id;
            OS.SendMessage(this.handle, 4415, 0L, tvItem);
        }
        if (item != null) {
            item.handle = hNewItem;
            this.items[id] = item;
        }
        if ((hInsertAfter == -65535L || hInsertAfter == -65534L) && hFirstItem == 0L) {
            this.cachedFirstItem = hNewItem;
            this.cachedIndexItem = hNewItem;
            this.cachedIndex = 0;
            this.cachedItemCount = 1;
        } else if (hInsertAfter == -65535L && hFirstItem == this.cachedFirstItem) {
            this.cachedFirstItem = hNewItem;
            this.cachedIndexItem = hNewItem;
            this.cachedIndex = 0;
            if (this.cachedItemCount != -1) {
                ++this.cachedItemCount;
            }
        } else if (hFirstItem == this.cachedFirstItem && this.cachedItemCount != -1) {
            ++this.cachedItemCount;
        }
        if (hItem == 0L) {
            RECT damageRect;
            boolean damaged;
            RECT rect;
            if (fixParent && hParent != -65536L && this.getDrawing() && OS.IsWindowVisible(this.handle) && OS.TreeView_GetItemRect(this.handle, hParent, rect = new RECT(), false)) {
                OS.InvalidateRect(this.handle, rect, true);
            }
            if ((this.style & 0x10000000) != 0 && this.currentItem != null && OS.TreeView_GetItemRect(this.handle, hNewItem, rect = new RECT(), false) && (damaged = OS.GetUpdateRect(this.handle, damageRect = new RECT(), true)) && damageRect.top < rect.bottom) {
                long rgn = OS.CreateRectRgn(0, 0, 0, 0);
                int result = OS.GetUpdateRgn(this.handle, rgn, true);
                if (result != 1) {
                    OS.OffsetRgn(rgn, 0, rect.bottom - rect.top);
                    OS.InvalidateRgn(this.handle, rgn, true);
                }
                OS.DeleteObject(rgn);
            }
            if (this.getDrawing()) {
                this.updateScrollBar();
            }
            if (item != null && id == 0) {
                Event event = new Event();
                event.detail = 0;
                this.sendEvent(56, event);
            }
        }
    }

    void createItemToolTips() {
        if (this.itemToolTipHandle != 0L) {
            return;
        }
        int bits1 = OS.GetWindowLong(this.handle, -16);
        OS.SetWindowLong(this.handle, -16, bits1 |= 0x80);
        int bits2 = 0;
        if ((this.style & 0x4000000) != 0) {
            bits2 |= 0x400000;
        }
        this.itemToolTipHandle = OS.CreateWindowEx(bits2 |= 0x20, new TCHAR(0, "tooltips_class32", true), null, 50, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0L, OS.GetModuleHandle(null), null);
        if (this.itemToolTipHandle == 0L) {
            this.error(2);
        }
        this.maybeEnableDarkSystemTheme(this.itemToolTipHandle);
        OS.SendMessage(this.itemToolTipHandle, 1027, 3L, 0L);
        OS.SendMessage(this.itemToolTipHandle, 1048, 0L, 32767L);
        TOOLINFO lpti = new TOOLINFO();
        lpti.cbSize = TOOLINFO.sizeof;
        lpti.hwnd = this.handle;
        lpti.uId = this.handle;
        lpti.uFlags = 272;
        lpti.lpszText = -1L;
        OS.SendMessage(this.itemToolTipHandle, 1074, 0L, lpti);
    }

    void createParent() {
        long hwndFocus;
        this.forceResize();
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        OS.MapWindowPoints(0L, this.parent.handle, rect, 2);
        int oldStyle = OS.GetWindowLong(this.handle, -16);
        int newStyle = super.widgetStyle();
        newStyle &= 0xEFFFFFFF;
        if ((oldStyle & 0x4000000) != 0) {
            newStyle |= 0x4000000;
        }
        if ((oldStyle & 0x800000) != 0) {
            int noBorderStyle = oldStyle & 0xFF7FFFFF;
            OS.SetWindowLong(this.handle, -16, noBorderStyle);
        }
        this.hwndParent = OS.CreateWindowEx(super.widgetExtStyle(), super.windowClass(), null, newStyle, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, this.parent.handle, 0L, OS.GetModuleHandle(null), null);
        if (this.hwndParent == 0L) {
            this.error(2);
        }
        OS.SetWindowLongPtr(this.hwndParent, -12, this.hwndParent);
        this.maybeEnableDarkSystemTheme(this.hwndParent);
        int bits = 0x100000;
        if ((this.style & 0x4000000) != 0) {
            bits |= 0x400000;
        }
        this.hwndHeader = OS.CreateWindowEx(bits, HeaderClass, null, 1140850890, 0, 0, 0, 0, this.hwndParent, 0L, OS.GetModuleHandle(null), null);
        if (this.hwndHeader == 0L) {
            this.error(2);
        }
        OS.SetWindowLongPtr(this.hwndHeader, -12, this.hwndHeader);
        this.maybeEnableDarkSystemTheme(this.hwndHeader);
        long hFont = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (hFont != 0L) {
            OS.SendMessage(this.hwndHeader, 48, hFont, 0L);
        }
        long hwndInsertAfter = OS.GetWindow(this.handle, 3);
        int flags = 19;
        OS.SetWindowPos(this.hwndParent, hwndInsertAfter, 0, 0, 0, 0, flags);
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = SCROLLINFO.sizeof;
        info.fMask = 3;
        OS.GetScrollInfo(this.hwndParent, 0, info);
        info.nPage = info.nMax + 1;
        OS.SetScrollInfo(this.hwndParent, 0, info, true);
        OS.GetScrollInfo(this.hwndParent, 1, info);
        info.nPage = info.nMax + 1;
        OS.SetScrollInfo(this.hwndParent, 1, info, true);
        this.customDraw = true;
        this.deregister();
        if ((oldStyle & 0x10000000) != 0) {
            OS.ShowWindow(this.hwndParent, 5);
        }
        if ((hwndFocus = OS.GetFocus()) == this.handle) {
            OS.SetFocus(this.hwndParent);
        }
        OS.SetParent(this.handle, this.hwndParent);
        if (hwndFocus == this.handle) {
            OS.SetFocus(this.handle);
        }
        this.register();
        this.subclass();
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.cachedItemCount = -1;
    }

    private boolean customHeaderDrawing() {
        return this.headerBackground != -1 || this.headerForeground != -1;
    }

    @Override
    int defaultBackground() {
        return OS.GetSysColor(5);
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.hwndParent != 0L) {
            this.display.removeControl(this.hwndParent);
        }
        if (this.hwndHeader != 0L) {
            this.display.removeControl(this.hwndHeader);
        }
    }

    void deselect(long hItem, TVITEM tvItem, long hIgnoreItem) {
        while (hItem != 0L) {
            if (hItem != hIgnoreItem) {
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, 4415, 0L, tvItem);
            }
            long hFirstItem = OS.SendMessage(this.handle, 4362, 4L, hItem);
            this.deselect(hFirstItem, tvItem, hIgnoreItem);
            hItem = OS.SendMessage(this.handle, 4362, 1L, hItem);
        }
    }

    public void deselect(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 2;
        tvItem.hItem = item.handle;
        OS.SendMessage(this.handle, 4415, 0L, tvItem);
    }

    public void deselectAll() {
        this.checkWidget();
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 2;
        if ((this.style & 4) != 0) {
            long hItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
            if (hItem != 0L) {
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, 4415, 0L, tvItem);
            }
        } else {
            long oldProc = OS.GetWindowLongPtr(this.handle, -4);
            OS.SetWindowLongPtr(this.handle, -4, TreeProc);
            if ((this.style & 0x10000000) != 0) {
                long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
                this.deselect(hItem, tvItem, 0L);
            } else {
                TreeItem[] treeItemArray = this.items;
                int n = this.items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item != null) {
                        tvItem.hItem = item.handle;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                    }
                    ++n2;
                }
            }
            OS.SetWindowLongPtr(this.handle, -4, oldProc);
        }
    }

    void destroyItem(TreeColumn column) {
        if (this.hwndHeader == 0L) {
            this.error(15);
        }
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        int[] oldOrder = this.getColumnOrder();
        int orderIndex = 0;
        while (orderIndex < this.columnCount) {
            if (oldOrder[orderIndex] == index) break;
            ++orderIndex;
        }
        RECT headerRect = new RECT();
        OS.SendMessage(this.hwndHeader, 4615, (long)index, headerRect);
        if (OS.SendMessage(this.hwndHeader, 4610, (long)index, 0L) == 0L) {
            this.error(15);
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.cachedItemOrder = null;
        this.columns[this.columnCount] = null;
        TreeItem[] treeItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item != null) {
                if (this.columnCount == 0) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[this.columnCount];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, this.columnCount - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[this.columnCount];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, this.columnCount - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        int[] cellBackground = item.cellBackground;
                        temp = new int[this.columnCount];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, this.columnCount - index);
                        item.cellBackground = (int[])temp;
                    }
                    if (item.cellForeground != null) {
                        int[] cellForeground = item.cellForeground;
                        temp = new int[this.columnCount];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, this.columnCount - index);
                        item.cellForeground = (int[])temp;
                    }
                    if (item.cellFont != null) {
                        Font[] cellFont = item.cellFont;
                        temp = new Font[this.columnCount];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - index);
                        item.cellFont = temp;
                    }
                }
            }
            ++n2;
        }
        if (this.columnCount == 0) {
            this.scrollWidth = 0;
            if (!this.hooks(41)) {
                int bits = OS.GetWindowLong(this.handle, -16);
                if ((this.style & 0x100) != 0) {
                    bits &= 0xFFFF7FFF;
                }
                OS.SetWindowLong(this.handle, -16, bits);
                OS.InvalidateRect(this.handle, null, true);
            }
            if (this.itemToolTipHandle != 0L) {
                OS.SendMessage(this.itemToolTipHandle, 1027, 3L, 0L);
            }
        } else {
            if (index == 0) {
                this.columns[0].style &= 0xFEFDBFFF;
                this.columns[0].style |= 0x4000;
                HDITEM hdItem = new HDITEM();
                hdItem.mask = 36;
                OS.SendMessage(this.hwndHeader, 4619, (long)index, hdItem);
                hdItem.fmt &= 0xFFFFFFFC;
                hdItem.fmt |= 0;
                OS.SendMessage(this.hwndHeader, 4620, (long)index, hdItem);
            }
            RECT rect = new RECT();
            OS.GetClientRect(this.handle, rect);
            rect.left = headerRect.left;
            OS.InvalidateRect(this.handle, rect, true);
        }
        this.setScrollWidth();
        this.updateImageList();
        this.updateScrollBar();
        if (this.columnCount != 0) {
            int[] newOrder = this.getColumnOrderFromOS();
            TreeColumn[] newColumns = new TreeColumn[this.columnCount - orderIndex];
            int i = orderIndex;
            while (i < newOrder.length) {
                newColumns[i - orderIndex] = this.columns[newOrder[i]];
                newColumns[i - orderIndex].updateToolTip(newOrder[i]);
                ++i;
            }
            TreeColumn[] treeColumnArray = newColumns;
            int n3 = newColumns.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeColumn newColumn = treeColumnArray[n4];
                if (!newColumn.isDisposed()) {
                    newColumn.sendEvent(10);
                }
                ++n4;
            }
        }
        if (this.headerToolTipHandle != 0L) {
            TOOLINFO lpti = new TOOLINFO();
            lpti.cbSize = TOOLINFO.sizeof;
            lpti.uId = column.id;
            lpti.hwnd = this.hwndHeader;
            OS.SendMessage(this.headerToolTipHandle, 1075, 0L, lpti);
        }
    }

    void destroyItem(TreeItem item, long hItem) {
        int count;
        this.cachedIndexItem = 0L;
        this.cachedFirstItem = 0L;
        this.cachedItemCount = -1;
        long hParent = 0L;
        boolean fixRedraw = false;
        if ((this.style & 0x20000000) == 0 && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
            RECT rect = new RECT();
            boolean bl = fixRedraw = !OS.TreeView_GetItemRect(this.handle, hItem, rect, false);
        }
        if (fixRedraw) {
            hParent = OS.SendMessage(this.handle, 4362, 3L, hItem);
            OS.UpdateWindow(this.handle);
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
        }
        this.lockSelection = true;
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        long hwndToolTip = OS.SendMessage(this.handle, 4377, 0L, 0L);
        if (hwndToolTip != 0L) {
            OS.SendMessage(hwndToolTip, 1052, 0L, 0L);
        }
        this.ignoreShrink = true;
        this.shrink = true;
        OS.SendMessage(this.handle, 4353, 0L, hItem);
        this.ignoreShrink = false;
        this.lockSelection = false;
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (fixRedraw) {
            RECT rect;
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            OS.ValidateRect(this.handle, null);
            if (OS.SendMessage(this.handle, 4362, 4L, hParent) == 0L && OS.TreeView_GetItemRect(this.handle, hParent, rect = new RECT(), false)) {
                OS.InvalidateRect(this.handle, rect, true);
            }
        }
        if ((count = (int)OS.SendMessage(this.handle, 4357, 0L, 0L)) == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4361, 0L, 0L);
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            if (!(this.hwndParent != 0L || this.linesVisible || this.hooks(41) || this.hooks(40) || this.hooks(42))) {
                this.customDraw = false;
            }
            this.items = new TreeItem[4];
            this.scrollWidth = 0;
            this.setScrollWidth();
        }
        if (this.getDrawing()) {
            this.updateScrollBar();
        }
        if (count == 0) {
            Event event = new Event();
            event.detail = 1;
            this.sendEvent(56, event);
        }
    }

    @Override
    void destroyScrollBar(int type) {
        super.destroyScrollBar(type);
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((this.style & 0x300) == 0) {
            bits &= 0xFFCFFFFF;
            bits |= 0x2000;
        } else if ((this.style & 0x100) == 0) {
            bits &= 0xFFEFFFFF;
            bits |= 0x8000;
        }
        OS.SetWindowLong(this.handle, -16, bits);
    }

    @Override
    void enableDrag(boolean enabled) {
        int bits = OS.GetWindowLong(this.handle, -16);
        bits = enabled && this.hooks(29) ? (bits &= 0xFFFFFFEF) : (bits |= 0x10);
        OS.SetWindowLong(this.handle, -16, bits);
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if (control.backgroundImage == null) {
            this._setBackgroundPixel(this.hasCustomBackground() ? control.getBackgroundPixel() : -1);
        }
        if (this.hwndParent != 0L) {
            OS.EnableWindow(this.hwndParent, enabled);
        }
        this.updateFullSelection();
    }

    boolean findCell(int x, int y, TreeItem[] item, int[] index, RECT[] cellRect, RECT[] itemRect) {
        boolean found = false;
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = x;
        lpht.y = y;
        OS.SendMessage(this.handle, 4369, 0L, lpht);
        if (lpht.hItem != 0L) {
            item[0] = this._getItem(lpht.hItem);
            POINT pt = new POINT();
            pt.x = x;
            pt.y = y;
            long hDC = OS.GetDC(this.handle);
            long oldFont = 0L;
            long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (newFont != 0L) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            RECT rect = new RECT();
            if (this.hwndParent != 0L) {
                OS.GetClientRect(this.hwndParent, rect);
                OS.MapWindowPoints(this.hwndParent, this.handle, rect, 2);
            } else {
                OS.GetClientRect(this.handle, rect);
            }
            int count = Math.max(1, this.columnCount);
            int[] order = new int[count];
            if (this.hwndHeader != 0L && this.columnCount != 0) {
                order = this.getColumnOrder();
            }
            index[0] = 0;
            boolean quit = false;
            while (index[0] < count && !quit) {
                long hFont = item[0].fontHandle(order[index[0]]);
                if (hFont != -1L) {
                    hFont = OS.SelectObject(hDC, hFont);
                }
                cellRect[0] = item[0].getBounds(order[index[0]], true, false, true, false, true, hDC);
                if (cellRect[0].left > rect.right) {
                    quit = true;
                } else {
                    cellRect[0].right = Math.min(cellRect[0].right, rect.right);
                    if (OS.PtInRect(cellRect[0], pt)) {
                        if (this.isCustomToolTip()) {
                            int state = (int)OS.SendMessage(this.handle, 4391, lpht.hItem, 2L);
                            int detail = (state & 2) != 0 ? 2 : 0;
                            Event event = this.sendMeasureItemEvent(item[0], order[index[0]], hDC, detail);
                            if (this.isDisposed() || item[0].isDisposed()) break;
                            Rectangle boundsInPixels = Win32DPIUtils.pointToPixel(event.getBounds(), this.getZoom());
                            itemRect[0] = new RECT();
                            itemRect[0].left = boundsInPixels.x;
                            itemRect[0].right = boundsInPixels.x + boundsInPixels.width;
                            itemRect[0].top = boundsInPixels.y;
                            itemRect[0].bottom = boundsInPixels.y + boundsInPixels.height;
                        } else {
                            itemRect[0] = item[0].getBounds(order[index[0]], true, true, false, false, false, hDC);
                        }
                        if (itemRect[0].right > cellRect[0].right) {
                            found = true;
                        }
                        quit = true;
                    }
                }
                if (hFont != -1L) {
                    OS.SelectObject(hDC, hFont);
                }
                if (found) continue;
                index[0] = index[0] + 1;
            }
            if (newFont != 0L) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        }
        return found;
    }

    int findIndex(long hFirstItem, long hItem) {
        if (hFirstItem == 0L) {
            return -1;
        }
        if (hFirstItem == this.cachedFirstItem) {
            if (this.cachedFirstItem == hItem) {
                this.cachedIndexItem = this.cachedFirstItem;
                this.cachedIndex = 0;
                return 0;
            }
            if (this.cachedIndexItem == hItem) {
                return this.cachedIndex;
            }
            long hPrevItem = OS.SendMessage(this.handle, 4362, 2L, this.cachedIndexItem);
            if (hPrevItem == hItem) {
                this.cachedIndexItem = hPrevItem;
                return --this.cachedIndex;
            }
            long hNextItem = OS.SendMessage(this.handle, 4362, 1L, this.cachedIndexItem);
            if (hNextItem == hItem) {
                this.cachedIndexItem = hNextItem;
                return ++this.cachedIndex;
            }
            int previousIndex = this.cachedIndex - 1;
            while (hPrevItem != 0L && hPrevItem != hItem) {
                hPrevItem = OS.SendMessage(this.handle, 4362, 2L, hPrevItem);
                --previousIndex;
            }
            if (hPrevItem == hItem) {
                this.cachedIndexItem = hPrevItem;
                this.cachedIndex = previousIndex;
                return this.cachedIndex;
            }
            int nextIndex = this.cachedIndex + 1;
            while (hNextItem != 0L && hNextItem != hItem) {
                hNextItem = OS.SendMessage(this.handle, 4362, 1L, hNextItem);
                ++nextIndex;
            }
            if (hNextItem == hItem) {
                this.cachedIndexItem = hNextItem;
                this.cachedIndex = nextIndex;
                return this.cachedIndex;
            }
            return -1;
        }
        int index = 0;
        long hNextItem = hFirstItem;
        while (hNextItem != 0L && hNextItem != hItem) {
            hNextItem = OS.SendMessage(this.handle, 4362, 1L, hNextItem);
            ++index;
        }
        if (hNextItem == hItem) {
            this.cachedItemCount = -1;
            this.cachedFirstItem = hFirstItem;
            this.cachedIndexItem = hNextItem;
            this.cachedIndex = index;
            return this.cachedIndex;
        }
        return -1;
    }

    @Override
    Widget findItem(long hItem) {
        return this._getItem(hItem);
    }

    long findItem(long hFirstItem, int index) {
        if (hFirstItem == 0L) {
            return 0L;
        }
        if (hFirstItem == this.cachedFirstItem) {
            if (index == 0) {
                this.cachedIndex = 0;
                this.cachedIndexItem = this.cachedFirstItem;
                return this.cachedIndexItem;
            }
            if (this.cachedIndex == index) {
                return this.cachedIndexItem;
            }
            if (this.cachedIndex - 1 == index) {
                --this.cachedIndex;
                this.cachedIndexItem = OS.SendMessage(this.handle, 4362, 2L, this.cachedIndexItem);
                return this.cachedIndexItem;
            }
            if (this.cachedIndex + 1 == index) {
                ++this.cachedIndex;
                this.cachedIndexItem = OS.SendMessage(this.handle, 4362, 1L, this.cachedIndexItem);
                return this.cachedIndexItem;
            }
            if (index < this.cachedIndex) {
                int previousIndex = this.cachedIndex - 1;
                long hPrevItem = OS.SendMessage(this.handle, 4362, 2L, this.cachedIndexItem);
                while (hPrevItem != 0L && index < previousIndex) {
                    hPrevItem = OS.SendMessage(this.handle, 4362, 2L, hPrevItem);
                    --previousIndex;
                }
                if (index == previousIndex) {
                    this.cachedIndex = previousIndex;
                    this.cachedIndexItem = hPrevItem;
                    return this.cachedIndexItem;
                }
            } else {
                int nextIndex = this.cachedIndex + 1;
                long hNextItem = OS.SendMessage(this.handle, 4362, 1L, this.cachedIndexItem);
                while (hNextItem != 0L && nextIndex < index) {
                    hNextItem = OS.SendMessage(this.handle, 4362, 1L, hNextItem);
                    ++nextIndex;
                }
                if (index == nextIndex) {
                    this.cachedIndex = nextIndex;
                    this.cachedIndexItem = hNextItem;
                    return this.cachedIndexItem;
                }
            }
            return 0L;
        }
        int nextIndex = 0;
        long hNextItem = hFirstItem;
        while (hNextItem != 0L && nextIndex < index) {
            hNextItem = OS.SendMessage(this.handle, 4362, 1L, hNextItem);
            ++nextIndex;
        }
        if (index == nextIndex) {
            this.cachedItemCount = -1;
            this.cachedIndex = nextIndex;
            this.cachedFirstItem = hFirstItem;
            this.cachedIndexItem = hNextItem;
            return this.cachedIndexItem;
        }
        return 0L;
    }

    TreeItem getFocusItem() {
        long hItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
        return hItem != 0L ? this._getItem(hItem) : null;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    int getGridLineWidthInPixels() {
        return DPIUtil.pointToPixel(1, this.getZoom());
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getHeaderBackgroundPixel());
    }

    private int getHeaderBackgroundPixel() {
        return this.headerBackground != -1 ? this.headerBackground : this.defaultBackground();
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getHeaderForegroundPixel());
    }

    private int getHeaderForegroundPixel() {
        return this.headerForeground != -1 ? this.headerForeground : this.defaultForeground();
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.pixelToPoint(this.getHeaderHeightInPixels(), this.getZoom());
    }

    int getHeaderHeightInPixels() {
        if (this.hwndHeader == 0L) {
            return 0;
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.hwndHeader, rect);
        return rect.bottom - rect.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        if (this.hwndHeader == 0L) {
            return false;
        }
        int bits = OS.GetWindowLong(this.hwndHeader, -16);
        return (bits & 0x10000000) != 0;
    }

    Point getImageSize() {
        if (this.imageList != null) {
            return Win32DPIUtils.pointToPixelAsSize(this.imageList.getImageSize(), this.getZoom());
        }
        return new Point(0, this.getItemHeightInPixels());
    }

    long getBottomItem() {
        long hItem = OS.SendMessage(this.handle, 4362, 5L, 0L);
        if (hItem == 0L) {
            return 0L;
        }
        int index = 0;
        int count = (int)OS.SendMessage(this.handle, 4368, 0L, 0L);
        while (index <= count) {
            long hNextItem = OS.SendMessage(this.handle, 4362, 6L, hItem);
            if (hNextItem == 0L) {
                return hItem;
            }
            hItem = hNextItem;
            ++index;
        }
        return hItem;
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.cachedItemOrder != null) {
            return (int[])this.cachedItemOrder.clone();
        }
        int[] order = this.getColumnOrderFromOS();
        return order;
    }

    private int[] getColumnOrderFromOS() {
        if (this.columnCount == 0) {
            return new int[0];
        }
        int[] order = new int[this.columnCount];
        OS.SendMessage(this.hwndHeader, 4625, (long)this.columnCount, order);
        this.cachedItemOrder = (int[])order.clone();
        return order;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    public TreeItem getItem(int index) {
        long hItem;
        long hFirstItem;
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        if ((hFirstItem = OS.SendMessage(this.handle, 4362, 0L, 0L)) == 0L) {
            this.error(6);
        }
        if ((hItem = this.findItem(hFirstItem, index)) == 0L) {
            this.error(6);
        }
        return this._getItem(hItem);
    }

    TreeItem getItem(NMTVCUSTOMDRAW nmcd) {
        int id = (int)nmcd.lItemlParam;
        if ((this.style & 0x10000000) != 0 && id == -1) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 20;
            tvItem.hItem = nmcd.dwItemSpec;
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            id = (int)tvItem.lParam;
        }
        return this._getItem(nmcd.dwItemSpec, id);
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.getItemInPixels(Win32DPIUtils.pointToPixelAsLocation(point, this.getZoom()));
    }

    TreeItem getItemInPixels(Point point) {
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = point.x;
        lpht.y = point.y;
        OS.SendMessage(this.handle, 4369, 0L, lpht);
        if (lpht.hItem != 0L) {
            int flags = 70;
            if ((this.style & 0x10000) != 0) {
                flags |= 0x28;
            } else if (this.hooks(41)) {
                lpht.flags &= 0xFFFFFFF9;
                if (this.hitTestSelection(lpht.hItem, lpht.x, lpht.y)) {
                    lpht.flags |= 6;
                }
            }
            if ((lpht.flags & flags) != 0) {
                return this._getItem(lpht.hItem);
            }
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
        if (hItem == 0L) {
            return 0;
        }
        return this.getItemCount(hItem);
    }

    int getItemCount(long hItem) {
        int count = 0;
        long hFirstItem = hItem;
        if (hItem == this.cachedFirstItem) {
            if (this.cachedItemCount != -1) {
                return this.cachedItemCount;
            }
            hFirstItem = this.cachedIndexItem;
            count = this.cachedIndex;
        }
        while (hFirstItem != 0L) {
            hFirstItem = OS.SendMessage(this.handle, 4362, 1L, hFirstItem);
            ++count;
        }
        if (hItem == this.cachedFirstItem) {
            this.cachedItemCount = count;
        }
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.pixelToPoint(this.getItemHeightInPixels(), this.getZoom());
    }

    int getItemHeightInPixels() {
        return (int)OS.SendMessage(this.handle, 4380, 0L, 0L);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
        if (hItem == 0L) {
            return new TreeItem[0];
        }
        return this.getItems(hItem);
    }

    TreeItem[] getItems(long hTreeItem) {
        int count = 0;
        long hItem = hTreeItem;
        while (hItem != 0L) {
            hItem = OS.SendMessage(this.handle, 4362, 1L, hItem);
            ++count;
        }
        int index = 0;
        TreeItem[] result = new TreeItem[count];
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = hTreeItem;
        while (tvItem.hItem != 0L) {
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            TreeItem item = this._getItem(tvItem.hItem, (int)tvItem.lParam);
            if (item != null) {
                result[index++] = item;
            }
            tvItem.hItem = OS.SendMessage(this.handle, 4362, 1L, tvItem.hItem);
        }
        if (index != count) {
            TreeItem[] newResult = new TreeItem[index];
            System.arraycopy(result, 0, newResult, 0, index);
            result = newResult;
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    long getNextSelection(long hItem) {
        while (hItem != 0L) {
            int state = (int)OS.SendMessage(this.handle, 4391, hItem, 2L);
            if ((state & 2) != 0) {
                return hItem;
            }
            long hFirstItem = OS.SendMessage(this.handle, 4362, 4L, hItem);
            long hSelected = this.getNextSelection(hFirstItem);
            if (hSelected != 0L) {
                return hSelected;
            }
            hItem = OS.SendMessage(this.handle, 4362, 1L, hItem);
        }
        return 0L;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    int getSelection(long hItem, TVITEM tvItem, TreeItem[] selection, int index, int count, boolean bigSelection, boolean all) {
        while (hItem != 0L) {
            boolean expanded = true;
            if (bigSelection) {
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, 4414, 0L, tvItem);
                if ((tvItem.state & 2) != 0) {
                    if (selection != null && index < selection.length) {
                        TreeItem item = this._getItem(hItem, (int)tvItem.lParam);
                        if (item != null) {
                            selection[index] = item;
                        } else {
                            --index;
                        }
                    }
                    ++index;
                }
                expanded = (tvItem.state & 0x20) != 0;
            } else {
                int state = (int)OS.SendMessage(this.handle, 4391, hItem, 34L);
                if ((state & 2) != 0) {
                    if (tvItem != null && selection != null && index < selection.length) {
                        tvItem.hItem = hItem;
                        OS.SendMessage(this.handle, 4414, 0L, tvItem);
                        TreeItem item = this._getItem(hItem, (int)tvItem.lParam);
                        if (item != null) {
                            selection[index] = item;
                        } else {
                            --index;
                        }
                    }
                    ++index;
                }
                boolean bl = expanded = (state & 0x20) != 0;
            }
            if (index == count) break;
            if (all) {
                long hFirstItem;
                if (expanded && (index = this.getSelection(hFirstItem = OS.SendMessage(this.handle, 4362, 4L, hItem), tvItem, selection, index, count, bigSelection, all)) == count) break;
                hItem = OS.SendMessage(this.handle, 4362, 1L, hItem);
                continue;
            }
            hItem = OS.SendMessage(this.handle, 4362, 6L, hItem);
        }
        return index;
    }

    public TreeItem[] getSelection() {
        boolean bigSelection;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long hItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
            if (hItem == 0L) {
                return new TreeItem[0];
            }
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 28;
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            if ((tvItem.state & 2) == 0) {
                return new TreeItem[0];
            }
            TreeItem item = this._getItem(tvItem.hItem, (int)tvItem.lParam);
            if (item == null) {
                return new TreeItem[0];
            }
            return new TreeItem[]{item};
        }
        int count = 0;
        TreeItem[] guess = new TreeItem[(this.style & 0x10000000) != 0 ? 8 : 1];
        long oldProc = OS.GetWindowLongPtr(this.handle, -4);
        OS.SetWindowLongPtr(this.handle, -4, TreeProc);
        if ((this.style & 0x10000000) != 0) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 28;
            long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
            count = this.getSelection(hItem, tvItem, guess, 0, -1, false, true);
        } else {
            TreeItem[] treeItemArray = this.items;
            int n = this.items.length;
            int hItem = 0;
            while (hItem < n) {
                long hItem2;
                int state;
                TreeItem item = treeItemArray[hItem];
                if (item != null && ((state = (int)OS.SendMessage(this.handle, 4391, hItem2 = item.handle, 2L)) & 2) != 0) {
                    if (count < guess.length) {
                        guess[count] = item;
                    }
                    ++count;
                }
                ++hItem;
            }
        }
        OS.SetWindowLongPtr(this.handle, -4, oldProc);
        if (count == 0) {
            return new TreeItem[0];
        }
        if (count == guess.length) {
            return guess;
        }
        TreeItem[] result = new TreeItem[count];
        if (count < guess.length) {
            System.arraycopy(guess, 0, result, 0, count);
            return result;
        }
        OS.SetWindowLongPtr(this.handle, -4, TreeProc);
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 28;
        long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
        int itemCount = (int)OS.SendMessage(this.handle, 4357, 0L, 0L);
        boolean bl = bigSelection = result.length > itemCount / 2;
        if (count != this.getSelection(hItem, tvItem, result, 0, count, bigSelection, false)) {
            count = this.getSelection(hItem, tvItem, result, 0, count, bigSelection, true);
        }
        if (count != result.length) {
            TreeItem[] newResult = new TreeItem[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        OS.SetWindowLongPtr(this.handle, -4, oldProc);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            long hItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
            if (hItem == 0L) {
                return 0;
            }
            int state = (int)OS.SendMessage(this.handle, 4391, hItem, 2L);
            return (state & 2) == 0 ? 0 : 1;
        }
        int count = 0;
        long oldProc = OS.GetWindowLongPtr(this.handle, -4);
        OS.SetWindowLongPtr(this.handle, -4, TreeProc);
        if ((this.style & 0x10000000) != 0) {
            long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
            count = this.getSelection(hItem, null, null, 0, -1, false, true);
        } else {
            TreeItem[] treeItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                long hItem;
                int state;
                TreeItem item = treeItemArray[n2];
                if (item != null && ((state = (int)OS.SendMessage(this.handle, 4391, hItem = item.handle, 2L)) & 2) != 0) {
                    ++count;
                }
                ++n2;
            }
        }
        OS.SetWindowLongPtr(this.handle, -4, oldProc);
        return count;
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    int getSortColumnPixel() {
        int pixel = OS.IsWindowEnabled(this.handle) || this.hasCustomBackground() ? this.getBackgroundPixel() : OS.GetSysColor(15);
        return this.getSlightlyDifferentBackgroundColor(pixel);
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        long hItem = OS.SendMessage(this.handle, 4362, 5L, 0L);
        return hItem != 0L ? this._getItem(hItem) : null;
    }

    boolean hitTestSelection(long hItem, int x, int y) {
        int state;
        int detail;
        Event event;
        long hFont;
        if (hItem == 0L) {
            return false;
        }
        TreeItem item = this._getItem(hItem);
        if (item == null) {
            return false;
        }
        if (!this.hooks(41)) {
            return false;
        }
        boolean result = false;
        int[] order = new int[1];
        int[] index = new int[1];
        long hDC = OS.GetDC(this.handle);
        long oldFont = 0L;
        long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (newFont != 0L) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        if ((hFont = item.fontHandle(order[index[0]])) != -1L) {
            hFont = OS.SelectObject(hDC, hFont);
        }
        if (Win32DPIUtils.pointToPixel((event = this.sendMeasureItemEvent(item, order[index[0]], hDC, detail = ((state = (int)OS.SendMessage(this.handle, 4391, hItem, 2L)) & 2) != 0 ? 2 : 0)).getBounds(), this.getZoom()).contains(x, y)) {
            result = true;
        }
        if (newFont != 0L) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(this.handle, hDC);
        return result;
    }

    int imageIndex(Image image, int index) {
        int imageIndex;
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle boundsInPoints = image.getBounds();
            this.imageList = this.display.getImageList(this.style & 0x4000000, boundsInPoints.width, boundsInPoints.height, this.getZoom());
        }
        if ((imageIndex = this.imageList.indexOf(image)) == -1) {
            imageIndex = this.imageList.add(image);
        }
        if (this.hwndHeader == 0L || this.getFirstColumnIndex() == index) {
            long hImageList = this.imageList.getHandle(this.getZoom());
            long hOldImageList = OS.SendMessage(this.handle, 4360, 0L, 0L);
            if (hOldImageList != hImageList) {
                OS.SendMessage(this.handle, 4361, 0L, hImageList);
                this.updateScrollBar();
            }
        }
        return imageIndex;
    }

    int imageIndexHeader(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.headerImageList == null) {
            Rectangle boundsInPoints = image.getBounds();
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, boundsInPoints.width, boundsInPoints.height, this.getZoom());
            int index = this.headerImageList.indexOf(image);
            if (index == -1) {
                index = this.headerImageList.add(image);
            }
            long hImageList = this.headerImageList.getHandle(this.getZoom());
            if (this.hwndHeader != 0L) {
                OS.SendMessage(this.hwndHeader, 4616, 0L, hImageList);
            }
            this.updateScrollBar();
            return index;
        }
        int index = this.headerImageList.indexOf(image);
        if (index != -1) {
            return index;
        }
        return this.headerImageList.add(image);
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TreeItem item) {
        long hItem;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        return (hItem = OS.SendMessage(this.handle, 4362, 0L, 0L)) == 0L ? -1 : this.findIndex(hItem, item.handle);
    }

    boolean isCustomToolTip() {
        return this.hooks(41);
    }

    boolean isItemSelected(NMTVCUSTOMDRAW nmcd) {
        boolean selected = false;
        if (OS.IsWindowEnabled(this.handle)) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 24;
            tvItem.hItem = nmcd.dwItemSpec;
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            if ((tvItem.state & 0xA) != 0) {
                selected = true;
                if (this.handle == OS.GetFocus()) {
                    if (OS.GetTextColor(nmcd.hdc) != OS.GetSysColor(14)) {
                        selected = false;
                    } else if (OS.GetBkColor(nmcd.hdc) != OS.GetSysColor(13)) {
                        selected = false;
                    }
                }
            } else if (nmcd.dwDrawStage == 65538 && OS.GetTextColor(nmcd.hdc) == OS.GetSysColor(14) && OS.GetBkColor(nmcd.hdc) == OS.GetSysColor(13)) {
                selected = true;
            }
        }
        return selected;
    }

    @Override
    boolean isUseWsBorder() {
        return true;
    }

    int itemsGetFreeCapacity() {
        int count = 0;
        TreeItem[] treeItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item == null) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    void itemsGrowArray(int newCapacity) {
        TreeItem[] newItems = new TreeItem[newCapacity];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        this.items = newItems;
    }

    void redrawSelection() {
        if ((this.style & 4) != 0) {
            RECT rect;
            long hItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
            if (hItem != 0L && OS.TreeView_GetItemRect(this.handle, hItem, rect = new RECT(), false)) {
                OS.InvalidateRect(this.handle, rect, true);
            }
        } else {
            long hItem = OS.SendMessage(this.handle, 4362, 5L, 0L);
            if (hItem != 0L) {
                RECT rect = new RECT();
                int index = 0;
                int count = (int)OS.SendMessage(this.handle, 4368, 0L, 0L);
                while (index <= count && hItem != 0L) {
                    int state = (int)OS.SendMessage(this.handle, 4391, hItem, 2L);
                    if ((state & 2) != 0 && OS.TreeView_GetItemRect(this.handle, hItem, rect, false)) {
                        OS.InvalidateRect(this.handle, rect, true);
                    }
                    hItem = OS.SendMessage(this.handle, 4362, 6L, hItem);
                    ++index;
                }
            }
        }
    }

    @Override
    void register() {
        super.register();
        if (this.hwndParent != 0L) {
            this.display.addControl(this.hwndParent, this);
        }
        if (this.hwndHeader != 0L) {
            this.display.addControl(this.hwndHeader, this);
        }
    }

    void releaseItem(long hItem, TVITEM tvItem, boolean release) {
        if (hItem == this.hAnchor) {
            this.hAnchor = 0L;
        }
        if (hItem == this.hInsert) {
            this.hInsert = 0L;
        }
        tvItem.hItem = hItem;
        if (OS.SendMessage(this.handle, 4414, 0L, tvItem) != 0L && tvItem.lParam != -1L) {
            TreeItem item;
            if (tvItem.lParam < (long)this.lastID) {
                this.lastID = (int)tvItem.lParam;
            }
            if (release && (item = this.items[(int)tvItem.lParam]) != null) {
                item.release(false);
            }
            this.items[(int)tvItem.lParam] = null;
        }
    }

    void releaseItems(long hItem, TVITEM tvItem) {
        hItem = OS.SendMessage(this.handle, 4362, 4L, hItem);
        while (hItem != 0L) {
            this.releaseItems(hItem, tvItem);
            this.releaseItem(hItem, tvItem, true);
            hItem = OS.SendMessage(this.handle, 4362, 1L, hItem);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.hwndHeader = 0L;
        this.hwndParent = 0L;
    }

    @Override
    void releaseChildren(boolean destroy) {
        int n;
        int n2;
        Item[] itemArray;
        if (this.items != null) {
            itemArray = this.items;
            n2 = this.items.length;
            n = 0;
            while (n < n2) {
                Item item = itemArray[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        if (this.columns != null) {
            itemArray = this.columns;
            n2 = this.columns.length;
            n = 0;
            while (n < n2) {
                Item column = itemArray[n];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++n;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.customDraw = false;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0L, 0L);
            this.display.releaseImageList(this.imageList);
        }
        if (this.headerImageList != null) {
            if (this.hwndHeader != 0L) {
                OS.SendMessage(this.hwndHeader, 4616, 0L, 0L);
            }
            this.display.releaseImageList(this.headerImageList);
        }
        this.headerImageList = null;
        this.imageList = null;
        long hStateList = OS.SendMessage(this.handle, 4360, 2L, 0L);
        OS.SendMessage(this.handle, 4361, 2L, 0L);
        if (hStateList != 0L) {
            OS.ImageList_Destroy(hStateList);
        }
        if (this.itemToolTipHandle != 0L) {
            OS.DestroyWindow(this.itemToolTipHandle);
        }
        if (this.headerToolTipHandle != 0L) {
            OS.DestroyWindow(this.headerToolTipHandle);
        }
        this.headerToolTipHandle = 0L;
        this.itemToolTipHandle = 0L;
    }

    public void removeAll() {
        boolean redraw;
        this.checkWidget();
        this.cachedIndexItem = 0L;
        this.cachedFirstItem = 0L;
        this.cachedItemCount = -1;
        TreeItem[] treeItemArray = this.items;
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++n2;
        }
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        boolean bl = redraw = this.getDrawing() && OS.IsWindowVisible(this.handle);
        if (redraw) {
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
        }
        this.ignoreShrink = true;
        this.shrink = true;
        long result = OS.SendMessage(this.handle, 4353, 0L, -65536L);
        this.ignoreShrink = false;
        if (redraw) {
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            OS.InvalidateRect(this.handle, null, true);
        }
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (result == 0L) {
            this.error(15);
        }
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0L, 0L);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
        if (!(this.hwndParent != 0L || this.linesVisible || this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            this.customDraw = false;
        }
        this.cachedIndexItem = 0L;
        this.cachedFirstItem = 0L;
        this.hInsert = 0L;
        this.hAnchor = 0L;
        this.cachedItemCount = -1;
        this.items = new TreeItem[4];
        this.scrollWidth = 0;
        this.setScrollWidth();
        this.updateScrollBar();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    @Override
    void reskinChildren(int flags) {
        int n;
        int n2;
        Item[] itemArray;
        if (this.items != null) {
            itemArray = this.items;
            n2 = this.items.length;
            n = 0;
            while (n < n2) {
                Item item = itemArray[n];
                if (item != null) {
                    item.reskinChildren(flags);
                }
                ++n;
            }
        }
        if (this.columns != null) {
            itemArray = this.columns;
            n2 = this.columns.length;
            n = 0;
            while (n < n2) {
                Item column = itemArray[n];
                if (column != null) {
                    column.reskinChildren(flags);
                }
                ++n;
            }
        }
        super.reskinChildren(flags);
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        long hItem = 0L;
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            hItem = item.handle;
        }
        this.hInsert = hItem;
        this.insertAfter = !before;
        OS.SendMessage(this.handle, 4378, (long)(this.insertAfter ? 1 : 0), this.hInsert);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.setItemCount(count, -65536L);
    }

    void setItemCount(int count, long hParent) {
        long itemFirstChild = OS.SendMessage(this.handle, 4362, 4L, hParent);
        long itemInsertAfter = 0L;
        int indexInsertAfter = 0;
        int numInserted = 0;
        long itemDeleteFrom = 0L;
        int itemCount = 0;
        long itemPrev = -65535L;
        long itemNext = itemFirstChild;
        while (itemNext != 0L && itemCount < count) {
            itemPrev = itemNext;
            itemNext = OS.SendMessage(this.handle, 4362, 1L, itemNext);
            ++itemCount;
        }
        if (itemCount == count && itemNext == 0L) {
            return;
        }
        if (itemCount == count) {
            itemDeleteFrom = itemNext;
        } else if (itemNext == 0L) {
            itemInsertAfter = itemPrev;
            indexInsertAfter = itemCount - 1;
            numInserted = count - itemCount;
        }
        boolean redraw = false;
        if (OS.SendMessage(this.handle, 4357, 0L, 0L) == 0L) {
            boolean bl = redraw = this.getDrawing() && OS.IsWindowVisible(this.handle);
            if (redraw) {
                OS.DefWindowProc(this.handle, 11, 0L, 0L);
            }
        }
        boolean expanded = false;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        if (!redraw && (this.style & 0x10000000) != 0) {
            if (hParent == -65536L) {
                expanded = true;
            } else {
                int state = (int)OS.SendMessage(this.handle, 4391, hParent, 32L);
                boolean bl = expanded = (state & 0x20) != 0;
            }
        }
        if (itemDeleteFrom != 0L) {
            while (itemDeleteFrom != 0L) {
                TreeItem item;
                tvItem.hItem = itemDeleteFrom;
                OS.SendMessage(this.handle, 4414, 0L, tvItem);
                itemDeleteFrom = OS.SendMessage(this.handle, 4362, 1L, itemDeleteFrom);
                TreeItem treeItem = item = tvItem.lParam != -1L ? this.items[(int)tvItem.lParam] : null;
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                    continue;
                }
                this.releaseItem(tvItem.hItem, tvItem, false);
                this.destroyItem(null, tvItem.hItem);
            }
        } else {
            int freeCapacity = this.itemsGetFreeCapacity();
            if (numInserted > freeCapacity) {
                this.itemsGrowArray(this.items.length + numInserted - freeCapacity);
            }
            if (itemFirstChild != 0L) {
                this.cachedFirstItem = itemFirstChild;
                this.cachedIndexItem = itemInsertAfter;
                this.cachedIndex = indexInsertAfter;
                this.cachedItemCount = indexInsertAfter + 1;
            } else {
                this.cachedFirstItem = 0L;
                this.cachedIndexItem = 0L;
                this.cachedIndex = 0;
                this.cachedItemCount = 0;
            }
            if ((this.style & 0x10000000) != 0) {
                int i = 0;
                while (i < numInserted) {
                    if (expanded) {
                        this.ignoreShrink = true;
                    }
                    this.createItem(null, hParent, itemInsertAfter, 0L);
                    if (expanded) {
                        this.ignoreShrink = false;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < numInserted) {
                    new TreeItem(this, 0, hParent, itemInsertAfter, 0L);
                    ++i;
                }
            }
        }
        if (redraw) {
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
        if (itemHeight < -1) {
            this.error(5);
        }
        OS.SendMessage(this.handle, 4379, (long)itemHeight, 0L);
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        if (this.linesVisible == show) {
            return;
        }
        this.linesVisible = show;
        if (this.hwndParent == 0L && this.linesVisible) {
            this.customDraw = true;
        }
        OS.InvalidateRect(this.handle, null, true);
        if (this.hwndHeader != 0L) {
            OS.InvalidateRect(this.hwndHeader, null, true);
        }
    }

    @Override
    long scrolledHandle() {
        if (this.hwndHeader == 0L) {
            return this.handle;
        }
        return this.columnCount == 0 && this.scrollWidth == 0 ? this.handle : this.hwndParent;
    }

    void select(long hItem, TVITEM tvItem) {
        while (hItem != 0L) {
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, 4415, 0L, tvItem);
            int state = (int)OS.SendMessage(this.handle, 4391, hItem, 32L);
            if ((state & 0x20) != 0) {
                long hFirstItem = OS.SendMessage(this.handle, 4362, 4L, hItem);
                this.select(hFirstItem, tvItem);
            }
            hItem = OS.SendMessage(this.handle, 4362, 1L, hItem);
        }
    }

    public void select(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            boolean redraw;
            long hItem = item.handle;
            int state = (int)OS.SendMessage(this.handle, 4391, hItem, 2L);
            if ((state & 2) != 0) {
                return;
            }
            SCROLLINFO hInfo = null;
            int bits = OS.GetWindowLong(this.handle, -16);
            if ((bits & 0xA000) == 0) {
                hInfo = new SCROLLINFO();
                hInfo.cbSize = SCROLLINFO.sizeof;
                hInfo.fMask = 23;
                OS.GetScrollInfo(this.handle, 0, hInfo);
            }
            SCROLLINFO vInfo = new SCROLLINFO();
            vInfo.cbSize = SCROLLINFO.sizeof;
            vInfo.fMask = 23;
            OS.GetScrollInfo(this.handle, 1, vInfo);
            boolean bl = redraw = this.getDrawing() && OS.IsWindowVisible(this.handle);
            if (redraw) {
                OS.UpdateWindow(this.handle);
                OS.DefWindowProc(this.handle, 11, 0L, 0L);
            }
            this.setSelection(item);
            if (hInfo != null) {
                long hThumb = OS.MAKELPARAM(4, hInfo.nPos);
                OS.SendMessage(this.handle, 276, hThumb, 0L);
            }
            OS.SetScrollInfo(this.handle, 1, vInfo, true);
            long vThumb = OS.MAKELPARAM(4, vInfo.nPos);
            OS.SendMessage(this.handle, 277, vThumb, 0L);
            if (redraw) {
                OS.DefWindowProc(this.handle, 11, 1L, 0L);
                OS.InvalidateRect(this.handle, null, true);
                if ((this.style & 0x20000000) == 0) {
                    int oldStyle = this.style;
                    this.style |= 0x20000000;
                    OS.UpdateWindow(this.handle);
                    this.style = oldStyle;
                }
            }
            return;
        }
        this.expandToItem(item);
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 2;
        tvItem.state = 2;
        tvItem.hItem = item.handle;
        OS.SendMessage(this.handle, 4415, 0L, tvItem);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.state = 2;
        tvItem.stateMask = 2;
        long oldProc = OS.GetWindowLongPtr(this.handle, -4);
        OS.SetWindowLongPtr(this.handle, -4, TreeProc);
        long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
        this.select(hItem, tvItem);
        OS.SetWindowLongPtr(this.handle, -4, oldProc);
    }

    Event sendEraseItemEvent(TreeItem item, NMTTCUSTOMDRAW nmcd, int column, RECT cellRect) {
        int nSavedDC = OS.SaveDC(nmcd.hdc);
        RECT insetRect = this.toolTipInset(cellRect);
        OS.SetWindowOrgEx(nmcd.hdc, insetRect.left, insetRect.top, null);
        GCData data = new GCData();
        data.device = this.display;
        data.foreground = OS.GetTextColor(nmcd.hdc);
        data.background = OS.GetBkColor(nmcd.hdc);
        data.font = item.getFont(column);
        data.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        GC gc = this.createNewGC(nmcd.hdc, data);
        Event event = new Event();
        event.item = item;
        event.index = column;
        event.gc = gc;
        event.detail |= 0x10;
        event.setBounds(Win32DPIUtils.pixelToPoint(new Rectangle(cellRect.left, cellRect.top, cellRect.right - cellRect.left, cellRect.bottom - cellRect.top), this.getZoom()));
        this.sendEvent(40, event);
        event.gc = null;
        gc.dispose();
        OS.RestoreDC(nmcd.hdc, nSavedDC);
        return event;
    }

    Event sendMeasureItemEvent(TreeItem item, int index, long hDC, int detail) {
        RECT itemRect = item.getBounds(index, true, true, false, false, false, hDC);
        int nSavedDC = OS.SaveDC(hDC);
        GCData data = new GCData();
        data.device = this.display;
        data.font = item.getFont(index);
        GC gc = this.createNewGC(hDC, data);
        Event event = new Event();
        event.item = item;
        event.gc = gc;
        event.index = index;
        event.setBounds(Win32DPIUtils.pixelToPoint(new Rectangle(itemRect.left, itemRect.top, itemRect.right - itemRect.left, itemRect.bottom - itemRect.top), this.getZoom()));
        event.detail = detail;
        this.sendEvent(41, event);
        event.gc = null;
        gc.dispose();
        OS.RestoreDC(hDC, nSavedDC);
        if (this.isDisposed() || item.isDisposed()) {
            return null;
        }
        Rectangle rect = Win32DPIUtils.pointToPixel(event.getBounds(), this.getZoom());
        if (this.hwndHeader != 0L && this.columnCount == 0 && rect.x + rect.width > this.scrollWidth) {
            this.scrollWidth = rect.x + rect.width;
            this.setScrollWidth(this.scrollWidth);
        }
        if (rect.height > this.getItemHeightInPixels()) {
            this.setItemHeight(rect.height);
        }
        return event;
    }

    Event sendPaintItemEvent(TreeItem item, NMTTCUSTOMDRAW nmcd, int column, RECT itemRect) {
        int nSavedDC = OS.SaveDC(nmcd.hdc);
        RECT insetRect = this.toolTipInset(itemRect);
        OS.SetWindowOrgEx(nmcd.hdc, insetRect.left, insetRect.top, null);
        GCData data = new GCData();
        data.device = this.display;
        data.font = item.getFont(column);
        data.foreground = OS.GetTextColor(nmcd.hdc);
        data.background = OS.GetBkColor(nmcd.hdc);
        data.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        GC gc = this.createNewGC(nmcd.hdc, data);
        Event event = new Event();
        event.item = item;
        event.index = column;
        event.gc = gc;
        event.detail |= 0x10;
        event.setBounds(Win32DPIUtils.pixelToPoint(new Rectangle(itemRect.left, itemRect.top, itemRect.right - itemRect.left, itemRect.bottom - itemRect.top), this.getZoom()));
        this.sendEvent(42, event);
        event.gc = null;
        gc.dispose();
        OS.RestoreDC(nmcd.hdc, nSavedDC);
        return event;
    }

    @Override
    void setBackgroundImage(long hBitmap) {
        super.setBackgroundImage(hBitmap);
        if (hBitmap != 0L) {
            if (OS.SendMessage(this.handle, 4383, 0L, 0L) == -1L) {
                OS.SendMessage(this.handle, 4381, 0L, -1L);
            }
            this._setBackgroundPixel(-1);
        } else {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                this.setBackgroundPixel(control.getBackgroundPixel());
            }
        }
        this.updateFullSelection();
    }

    @Override
    void setBackgroundPixel(int pixel) {
        Control control = this.findImageControl();
        if (control != null) {
            this.setBackgroundImage(control.backgroundImage);
            return;
        }
        this._setBackgroundPixel(pixel);
        this.updateFullSelection();
    }

    @Override
    void setCursor() {
        Cursor cursor = this.findCursor();
        long hCursor = cursor == null ? OS.LoadCursor(0L, 32512L) : Cursor.win32_getHandle(cursor, DPIUtil.getZoomForAutoscaleProperty(this.getShellZoom()));
        OS.SetCursor(hCursor);
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length != 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        int[] oldOrder = this.getColumnOrder();
        boolean reorder = false;
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(6);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (index != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (reorder) {
            RECT[] oldRects = new RECT[this.columnCount];
            int i2 = 0;
            while (i2 < this.columnCount) {
                oldRects[i2] = new RECT();
                OS.SendMessage(this.hwndHeader, 4615, (long)i2, oldRects[i2]);
                ++i2;
            }
            OS.SendMessage(this.hwndHeader, 4626, (long)order.length, order);
            this.cachedItemOrder = (int[])order.clone();
            OS.InvalidateRect(this.handle, null, true);
            this.updateImageList();
            TreeColumn[] newColumns = new TreeColumn[this.columnCount];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
            RECT newRect = new RECT();
            int i3 = 0;
            while (i3 < this.columnCount) {
                TreeColumn column = newColumns[i3];
                if (!column.isDisposed()) {
                    OS.SendMessage(this.hwndHeader, 4615, (long)i3, newRect);
                    if (newRect.left != oldRects[i3].left) {
                        column.updateToolTip(i3);
                        column.sendEvent(10);
                    }
                }
                ++i3;
            }
        }
    }

    void setCheckboxImageList() {
        int height;
        if ((this.style & 0x20) == 0) {
            return;
        }
        int count = 5;
        int flags = 32;
        if ((this.style & 0x4000000) != 0) {
            flags |= 0x2000;
        }
        if (!OS.IsAppThemed()) {
            flags |= 1;
        }
        int width = height = (int)OS.SendMessage(this.handle, 4380, 0L, 0L);
        long hStateList = OS.ImageList_Create(width, height, flags, count, count);
        long hDC = OS.GetDC(this.handle);
        long memDC = OS.CreateCompatibleDC(hDC);
        long hBitmap = OS.CreateCompatibleBitmap(hDC, width * count, height);
        long hOldBitmap = OS.SelectObject(memDC, hBitmap);
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, width * count, height);
        int clrBackground = 0;
        if (OS.IsAppThemed()) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            clrBackground = control.getBackgroundPixel();
        } else {
            clrBackground = 0x20000FF;
            if ((clrBackground & 0xFFFFFF) == OS.GetSysColor(5)) {
                clrBackground = 0x200FF00;
            }
        }
        long hBrush = OS.CreateSolidBrush(clrBackground);
        OS.FillRect(memDC, rect, hBrush);
        OS.DeleteObject(hBrush);
        long oldFont = OS.SelectObject(hDC, this.defaultFont());
        TEXTMETRIC tm = new TEXTMETRIC();
        OS.GetTextMetrics(hDC, tm);
        OS.SelectObject(hDC, oldFont);
        int itemWidth = Math.min(tm.tmHeight, width);
        int itemHeight = Math.min(tm.tmHeight, height);
        if (OS.IsAppThemed()) {
            SIZE size = new SIZE();
            OS.GetThemePartSize(this.display.hButtonTheme(this.nativeZoom), memDC, 3, 0, null, 1, size);
            itemWidth = Math.min(size.cx, itemWidth);
            itemHeight = Math.min(size.cy, itemHeight);
        }
        int left = (width - itemWidth) / 2;
        int top = (height - itemHeight) / 2 + 1;
        OS.SetRect(rect, left + width, top, left + width + itemWidth, top + itemHeight);
        if (OS.IsAppThemed()) {
            long hTheme = this.display.hButtonTheme(this.nativeZoom);
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 5, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 9, rect, null);
        } else {
            OS.DrawFrameControl(memDC, rect, 4, 16384);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17408);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 16640);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17664);
        }
        OS.SelectObject(memDC, hOldBitmap);
        OS.DeleteDC(memDC);
        OS.ReleaseDC(this.handle, hDC);
        if (OS.IsAppThemed()) {
            OS.ImageList_Add(hStateList, hBitmap, 0L);
        } else {
            OS.ImageList_AddMasked(hStateList, hBitmap, clrBackground);
        }
        OS.DeleteObject(hBitmap);
        long hOldStateList = OS.SendMessage(this.handle, 4360, 2L, 0L);
        OS.SendMessage(this.handle, 4361, 2L, hStateList);
        if (hOldStateList != 0L) {
            OS.ImageList_Destroy(hOldStateList);
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
    }

    @Override
    void setForegroundPixel(int pixel) {
        if (this.explorerTheme && pixel == -1) {
            pixel = this.defaultForeground();
        }
        OS.SendMessage(this.handle, 4382, 0L, pixel);
    }

    public void setHeaderBackground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
        }
        if (pixel == this.headerBackground) {
            return;
        }
        this.headerBackground = pixel;
        if (this.getHeaderVisible()) {
            OS.InvalidateRect(this.hwndHeader, null, true);
        }
    }

    public void setHeaderForeground(Color color) {
        this.checkWidget();
        int pixel = -1;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            pixel = color.handle;
        }
        if (pixel == this.headerForeground) {
            return;
        }
        this.headerForeground = pixel;
        if (this.getHeaderVisible()) {
            OS.InvalidateRect(this.hwndHeader, null, true);
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        if (this.hwndHeader == 0L) {
            if (!show) {
                return;
            }
            this.createParent();
        }
        int bits = OS.GetWindowLong(this.hwndHeader, -16);
        if (show) {
            if ((bits & 8) == 0) {
                return;
            }
            OS.SetWindowLong(this.hwndHeader, -16, bits &= 0xFFFFFFF7);
            OS.ShowWindow(this.hwndHeader, 5);
        } else {
            if ((bits & 8) != 0) {
                return;
            }
            OS.SetWindowLong(this.hwndHeader, -16, bits |= 8);
            OS.ShowWindow(this.hwndHeader, 0);
        }
        this.setScrollWidth();
        this.updateHeaderToolTips();
        this.updateScrollBar();
    }

    @Override
    public void setRedraw(boolean redraw) {
        boolean haveDisabledDraw;
        boolean willEnableDraw;
        this.checkWidget();
        long hItem = 0L;
        boolean bl = willEnableDraw = redraw && this.drawCount == 1;
        if (willEnableDraw) {
            int count = (int)OS.SendMessage(this.handle, 4357, 0L, 0L);
            if (count == 0) {
                TVINSERTSTRUCT tvInsert = new TVINSERTSTRUCT();
                tvInsert.hInsertAfter = -65535L;
                hItem = OS.SendMessage(this.handle, 4402, 0L, tvInsert);
            }
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            this.updateScrollBar();
        }
        super.setRedraw(redraw);
        boolean bl2 = haveDisabledDraw = !redraw && this.drawCount == 1;
        if (haveDisabledDraw) {
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
        }
        if (hItem != 0L) {
            this.ignoreShrink = true;
            OS.SendMessage(this.handle, 4353, 0L, hItem);
            this.ignoreShrink = false;
        }
    }

    void setScrollWidth() {
        if (this.hwndHeader == 0L || this.hwndParent == 0L) {
            return;
        }
        int width = 0;
        HDITEM hdItem = new HDITEM();
        int i = 0;
        while (i < this.columnCount) {
            hdItem.mask = 1;
            OS.SendMessage(this.hwndHeader, 4619, (long)i, hdItem);
            width += hdItem.cxy;
            ++i;
        }
        this.setScrollWidth(Math.max(this.scrollWidth, width));
    }

    void setScrollWidth(int width) {
        if (this.hwndHeader == 0L || this.hwndParent == 0L) {
            return;
        }
        int left = 0;
        RECT rect = new RECT();
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = SCROLLINFO.sizeof;
        info.fMask = 3;
        if (this.columnCount == 0 && width == 0) {
            OS.GetScrollInfo(this.hwndParent, 0, info);
            info.nPage = info.nMax + 1;
            OS.SetScrollInfo(this.hwndParent, 0, info, true);
            OS.GetScrollInfo(this.hwndParent, 1, info);
            info.nPage = info.nMax + 1;
            OS.SetScrollInfo(this.hwndParent, 1, info, true);
        } else if ((this.style & 0x100) != 0) {
            OS.GetClientRect(this.hwndParent, rect);
            OS.GetScrollInfo(this.hwndParent, 0, info);
            info.nMax = width;
            info.nPage = rect.right - rect.left + 1;
            OS.SetScrollInfo(this.hwndParent, 0, info, true);
            info.fMask = 4;
            OS.GetScrollInfo(this.hwndParent, 0, info);
            left = info.nPos;
        }
        if (this.horizontalBar != null) {
            this.horizontalBar.setIncrement(DPIUtil.pointToPixel(5, this.getZoom()));
            this.horizontalBar.setPageIncrement(info.nPage);
        }
        OS.GetClientRect(this.hwndParent, rect);
        long hHeap = OS.GetProcessHeap();
        HDLAYOUT playout = new HDLAYOUT();
        playout.prc = OS.HeapAlloc(hHeap, 8, RECT.sizeof);
        playout.pwpos = OS.HeapAlloc(hHeap, 8, WINDOWPOS.sizeof);
        OS.MoveMemory(playout.prc, rect, RECT.sizeof);
        OS.SendMessage(this.hwndHeader, 4613, 0L, playout);
        WINDOWPOS pos = new WINDOWPOS();
        OS.MoveMemory(pos, playout.pwpos, WINDOWPOS.sizeof);
        if (playout.prc != 0L) {
            OS.HeapFree(hHeap, 0, playout.prc);
        }
        if (playout.pwpos != 0L) {
            OS.HeapFree(hHeap, 0, playout.pwpos);
        }
        OS.SetWindowPos(this.hwndHeader, 0L, pos.x - left, pos.y, pos.cx + left, pos.cy, 16);
        int w = pos.cx + (this.columnCount == 0 && width == 0 ? 0 : this.getSystemMetrics(2));
        int h = rect.bottom - rect.top - pos.cy;
        boolean oldIgnore = this.ignoreResize;
        this.ignoreResize = true;
        OS.SetWindowPos(this.handle, 0L, pos.x - left, pos.y + pos.cy, w + left, h, 20);
        this.ignoreResize = oldIgnore;
    }

    void setSelection(long hItem, TVITEM tvItem, TreeItem[] selection) {
        while (hItem != 0L) {
            int index = 0;
            while (index < selection.length) {
                TreeItem item = selection[index];
                if (item != null && item.handle == hItem) break;
                ++index;
            }
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            if ((tvItem.state & 2) != 0) {
                if (index == selection.length) {
                    tvItem.state = 0;
                    OS.SendMessage(this.handle, 4415, 0L, tvItem);
                }
            } else if (index != selection.length) {
                this.expandToItem(this._getItem(hItem));
                tvItem.state = 2;
                OS.SendMessage(this.handle, 4415, 0L, tvItem);
            }
            long hFirstItem = OS.SendMessage(this.handle, 4362, 4L, hItem);
            this.setSelection(hFirstItem, tvItem, selection);
            hItem = OS.SendMessage(this.handle, 4362, 1L, hItem);
        }
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{item});
    }

    public void setSelection(TreeItem[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        TreeItem item = items[0];
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            long hOldItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
            this.hAnchor = item.handle;
            long hNewItem = this.hAnchor;
            boolean fixScroll = this.checkScroll(hNewItem);
            if (fixScroll) {
                OS.SendMessage(this.handle, 11, 1L, 0L);
                OS.DefWindowProc(this.handle, 11, 0L, 0L);
            }
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4363, 9L, hNewItem);
            this.ignoreSelect = false;
            if (OS.SendMessage(this.handle, 4368, 0L, 0L) == 0L) {
                OS.SendMessage(this.handle, 4363, 5L, hNewItem);
                long hParent = OS.SendMessage(this.handle, 4362, 3L, hNewItem);
                if (hParent == 0L) {
                    OS.SendMessage(this.handle, 276, 6L, 0L);
                }
            }
            if (fixScroll) {
                OS.DefWindowProc(this.handle, 11, 1L, 0L);
                OS.SendMessage(this.handle, 11, 0L, 0L);
            }
            if (hOldItem == hNewItem) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 24;
                tvItem.state = 2;
                tvItem.stateMask = 2;
                tvItem.hItem = hNewItem;
                OS.SendMessage(this.handle, 4415, 0L, tvItem);
                this.showItem(hNewItem);
            }
        }
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 2;
        long oldProc = OS.GetWindowLongPtr(this.handle, -4);
        OS.SetWindowLongPtr(this.handle, -4, TreeProc);
        if ((this.style & 0x10000000) != 0) {
            long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
            this.setSelection(hItem, tvItem, items);
        } else {
            TreeItem[] treeItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item2 = treeItemArray[n2];
                item = item2;
                if (item != null) {
                    int index = 0;
                    while (index < length) {
                        if (items[index] == item) break;
                        ++index;
                    }
                    tvItem.hItem = item.handle;
                    OS.SendMessage(this.handle, 4414, 0L, tvItem);
                    if ((tvItem.state & 2) != 0) {
                        if (index == length) {
                            tvItem.state = 0;
                            OS.SendMessage(this.handle, 4415, 0L, tvItem);
                        }
                    } else if (index != length) {
                        this.expandToItem(item);
                        tvItem.state = 2;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                    }
                }
                ++n2;
            }
        }
        OS.SetWindowLongPtr(this.handle, -4, oldProc);
    }

    void expandToItem(TreeItem item) {
        TreeItem parentItem = item.getParentItem();
        if (parentItem != null && !parentItem.getExpanded()) {
            this.expandToItem(parentItem);
            parentItem.setExpanded(true);
            Event event = new Event();
            event.item = parentItem;
            this.sendEvent(17, event);
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = column;
        if (this.sortColumn != null && this.sortDirection != 0) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if ((direction & 0x480) == 0 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(direction);
        }
    }

    public void setTopItem(TreeItem item) {
        long hTopItem;
        long hItem;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((hItem = item.handle) == (hTopItem = OS.SendMessage(this.handle, 4362, 5L, 0L))) {
            return;
        }
        boolean fixScroll = this.checkScroll(hItem);
        boolean redraw = false;
        if (fixScroll) {
            OS.SendMessage(this.handle, 11, 1L, 0L);
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
        } else {
            boolean bl = redraw = this.getDrawing() && OS.IsWindowVisible(this.handle);
            if (redraw) {
                OS.DefWindowProc(this.handle, 11, 0L, 0L);
            }
        }
        SCROLLINFO hInfo = null;
        int bits = OS.GetWindowLong(this.handle, -16);
        long hParent = OS.SendMessage(this.handle, 4362, 3L, hItem);
        if (hParent != 0L && (bits & 0xA000) == 0) {
            hInfo = new SCROLLINFO();
            hInfo.cbSize = SCROLLINFO.sizeof;
            hInfo.fMask = 23;
            OS.GetScrollInfo(this.handle, 0, hInfo);
        }
        OS.SendMessage(this.handle, 4363, 5L, hItem);
        if (hParent != 0L) {
            if (hInfo != null) {
                long hThumb = OS.MAKELPARAM(4, hInfo.nPos);
                OS.SendMessage(this.handle, 276, hThumb, 0L);
            }
        } else {
            OS.SendMessage(this.handle, 276, 6L, 0L);
        }
        if (fixScroll) {
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            OS.SendMessage(this.handle, 11, 0L, 0L);
        } else if (redraw) {
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            OS.InvalidateRect(this.handle, null, true);
        }
        this.updateScrollBar();
    }

    private void calculateAndApplyIndentSize() {
        int indent = DPIUtil.pointToPixel(16, this.nativeZoom);
        OS.SendMessage(this.handle, 4359, (long)indent, 0L);
    }

    void showItem(long hItem) {
        if (OS.SendMessage(this.handle, 4368, 0L, 0L) == 0L) {
            boolean fixScroll = this.checkScroll(hItem);
            if (fixScroll) {
                OS.SendMessage(this.handle, 11, 1L, 0L);
                OS.DefWindowProc(this.handle, 11, 0L, 0L);
            }
            OS.SendMessage(this.handle, 4363, 5L, hItem);
            OS.SendMessage(this.handle, 276, 6L, 0L);
            if (fixScroll) {
                OS.DefWindowProc(this.handle, 11, 1L, 0L);
                OS.SendMessage(this.handle, 11, 0L, 0L);
            }
        } else {
            boolean scroll = true;
            RECT itemRect = new RECT();
            if (OS.TreeView_GetItemRect(this.handle, hItem, itemRect, true)) {
                this.forceResize();
                RECT rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                POINT pt = new POINT();
                pt.x = itemRect.left;
                pt.y = itemRect.top;
                if (OS.PtInRect(rect, pt)) {
                    pt.y = itemRect.bottom;
                    if (OS.PtInRect(rect, pt)) {
                        scroll = false;
                    }
                }
            }
            if (scroll) {
                boolean fixScroll = this.checkScroll(hItem);
                if (fixScroll) {
                    OS.SendMessage(this.handle, 11, 1L, 0L);
                    OS.DefWindowProc(this.handle, 11, 0L, 0L);
                }
                OS.SendMessage(this.handle, 4372, 0L, hItem);
                if (fixScroll) {
                    OS.DefWindowProc(this.handle, 11, 1L, 0L);
                    OS.SendMessage(this.handle, 11, 0L, 0L);
                }
            }
        }
        this.updateScrollBar();
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (index == -1) {
            return;
        }
        if (index >= 0 && index < this.columnCount) {
            this.forceResize();
            RECT rect = new RECT();
            OS.GetClientRect(this.hwndParent, rect);
            OS.MapWindowPoints(this.hwndParent, this.handle, rect, 2);
            RECT headerRect = new RECT();
            OS.SendMessage(this.hwndHeader, 4615, (long)index, headerRect);
            boolean scrollBecauseLeft = headerRect.left < rect.left;
            boolean scrollBecauseRight = false;
            if (!scrollBecauseLeft) {
                int width = Math.min(rect.right - rect.left, headerRect.right - headerRect.left);
                boolean bl = scrollBecauseRight = headerRect.left + width > rect.right;
            }
            if (scrollBecauseLeft || headerRect.right - headerRect.left > rect.right - rect.left) {
                SCROLLINFO info = new SCROLLINFO();
                info.cbSize = SCROLLINFO.sizeof;
                info.fMask = 4;
                info.nPos = Math.max(0, headerRect.left - 1);
                OS.SetScrollInfo(this.hwndParent, 0, info, true);
                this.setScrollWidth();
            } else if (scrollBecauseRight) {
                SCROLLINFO info = new SCROLLINFO();
                info.cbSize = SCROLLINFO.sizeof;
                info.fMask = 4;
                int wideRect = rect.right - rect.left;
                int wideHeader = headerRect.right - headerRect.left;
                info.nPos = Math.max(0, wideHeader + headerRect.left - wideRect - 1);
                info.nPos = Math.min(rect.right - 1, info.nPos);
                OS.SetScrollInfo(this.hwndParent, 0, info, true);
                this.setScrollWidth();
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item.handle);
    }

    public void showSelection() {
        this.checkWidget();
        long hItem = 0L;
        if ((this.style & 4) != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
            if (hItem == 0L) {
                return;
            }
            int state = (int)OS.SendMessage(this.handle, 4391, hItem, 2L);
            if ((state & 2) == 0) {
                return;
            }
        } else {
            long oldProc = OS.GetWindowLongPtr(this.handle, -4);
            OS.SetWindowLongPtr(this.handle, -4, TreeProc);
            if ((this.style & 0x10000000) != 0) {
                long hRoot = OS.SendMessage(this.handle, 4362, 0L, 0L);
                hItem = this.getNextSelection(hRoot);
            } else {
                int index = 0;
                while (index < this.items.length) {
                    int state;
                    TreeItem item = this.items[index];
                    if (item != null && ((state = (int)OS.SendMessage(this.handle, 4391, item.handle, 2L)) & 2) != 0) {
                        hItem = item.handle;
                        break;
                    }
                    ++index;
                }
            }
            OS.SetWindowLongPtr(this.handle, -4, oldProc);
        }
        if (hItem != 0L) {
            this.showItem(hItem);
        }
    }

    void sort() {
        this.checkWidget();
        if ((this.style & 0x10000000) != 0) {
            return;
        }
        this.sort(-65536L, false);
    }

    void sort(long hParent, boolean all) {
        int itemCount = (int)OS.SendMessage(this.handle, 4357, 0L, 0L);
        if (itemCount == 0 || itemCount == 1) {
            return;
        }
        this.cachedIndexItem = 0L;
        this.cachedFirstItem = 0L;
        itemCount = -1;
        if (this.sortDirection == 128 || this.sortDirection == 0) {
            OS.SendMessage(this.handle, 4371, (long)(all ? 1 : 0), hParent);
        } else {
            Callback compareCallback = new Callback(this, "CompareFunc", 3);
            long lpfnCompare = compareCallback.getAddress();
            TVSORTCB psort = new TVSORTCB();
            psort.hParent = hParent;
            psort.lpfnCompare = lpfnCompare;
            psort.lParam = this.sortColumn == null ? 0 : this.indexOf(this.sortColumn);
            OS.SendMessage(this.handle, 4373, (long)(all ? 1 : 0), psort);
            compareCallback.dispose();
        }
    }

    @Override
    void subclass() {
        super.subclass();
        if (this.hwndHeader != 0L) {
            OS.SetWindowLongPtr(this.hwndHeader, -4, this.display.windowProc);
        }
    }

    RECT toolTipInset(RECT rect) {
        RECT insetRect = new RECT();
        OS.SetRect(insetRect, rect.left - 1, rect.top - 1, rect.right + 1, rect.bottom + 1);
        return insetRect;
    }

    RECT toolTipRect(RECT rect) {
        RECT toolRect = new RECT();
        OS.SetRect(toolRect, rect.left - 1, rect.top - 1, rect.right + 1, rect.bottom + 1);
        return toolRect;
    }

    @Override
    String toolTipText(NMTTDISPINFO hdr) {
        long hwndToolTip = OS.SendMessage(this.handle, 4377, 0L, 0L);
        if (hwndToolTip == hdr.hwndFrom && this.toolTipText != null) {
            return "";
        }
        if (this.headerToolTipHandle == hdr.hwndFrom) {
            int i = 0;
            while (i < this.columnCount) {
                TreeColumn column = this.columns[i];
                if ((long)column.id == hdr.idFrom) {
                    return column.toolTipText;
                }
                ++i;
            }
            return super.toolTipText(hdr);
        }
        if (this.itemToolTipHandle == hdr.hwndFrom) {
            if (this.toolTipText != null) {
                return "";
            }
            int pos = OS.GetMessagePos();
            POINT pt = new POINT();
            OS.POINTSTOPOINT(pt, pos);
            OS.ScreenToClient(this.handle, pt);
            int[] index = new int[1];
            TreeItem[] item = new TreeItem[1];
            RECT[] cellRect = new RECT[1];
            RECT[] itemRect = new RECT[1];
            if (this.findCell(pt.x, pt.y, item, index, cellRect, itemRect)) {
                String text = null;
                if (index[0] == 0) {
                    text = item[0].text;
                } else {
                    String[] strings = item[0].strings;
                    if (strings != null) {
                        text = strings[index[0]];
                    }
                }
                if (this.isCustomToolTip()) {
                    text = " ";
                }
                if (text != null) {
                    return text;
                }
            }
        }
        return super.toolTipText(hdr);
    }

    @Override
    long topHandle() {
        return this.hwndParent != 0L ? this.hwndParent : this.handle;
    }

    void updateFullSelection() {
        if ((this.style & 0x10000) != 0) {
            int oldBits = OS.GetWindowLong(this.handle, -16);
            int newBits = oldBits;
            if ((newBits & 0x1000) != 0) {
                if (!(OS.IsWindowEnabled(this.handle) && this.findImageControl() == null || this.explorerTheme)) {
                    newBits &= 0xFFFFEFFF;
                }
            } else if (OS.IsWindowEnabled(this.handle) && this.findImageControl() == null && !this.hooks(40) && !this.hooks(42)) {
                newBits |= 0x1000;
            }
            if (newBits != oldBits) {
                OS.SetWindowLong(this.handle, -16, newBits);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
    }

    void updateHeaderToolTips() {
        if (this.headerToolTipHandle == 0L) {
            return;
        }
        RECT rect = new RECT();
        TOOLINFO lpti = new TOOLINFO();
        lpti.cbSize = TOOLINFO.sizeof;
        lpti.uFlags = 16;
        lpti.hwnd = this.hwndHeader;
        lpti.lpszText = -1L;
        int i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this.columns[i];
            if (OS.SendMessage(this.hwndHeader, 4615, (long)i, rect) != 0L) {
                ++this.display.nextToolTipId;
                column.id = column.id;
                lpti.uId = column.id;
                lpti.left = rect.left;
                lpti.top = rect.top;
                lpti.right = rect.right;
                lpti.bottom = rect.bottom;
                OS.SendMessage(this.headerToolTipHandle, 1074, 0L, lpti);
            }
            ++i;
        }
    }

    void updateImageList() {
        if (this.imageList == null) {
            return;
        }
        if (this.hwndHeader == 0L) {
            return;
        }
        int i = 0;
        int index = this.getFirstColumnIndex();
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                Image image = null;
                if (index == 0) {
                    image = item.image;
                } else {
                    Image[] images = item.images;
                    if (images != null) {
                        image = images[index];
                    }
                }
                if (image != null) break;
            }
            ++i;
        }
        long hImageList = i == this.items.length ? 0L : this.imageList.getHandle(this.getZoom());
        long hOldImageList = OS.SendMessage(this.handle, 4360, 0L, 0L);
        if (hImageList != hOldImageList) {
            OS.SendMessage(this.handle, 4361, 0L, hImageList);
        }
    }

    @Override
    void updateMenuLocation(Event event) {
        Rectangle clientArea = this.getClientAreaInPixels();
        int x = clientArea.x;
        int y = clientArea.y;
        TreeItem focusItem = this.getFocusItem();
        if (focusItem != null) {
            Rectangle bounds = focusItem.getBoundsInPixels(0);
            if (focusItem.text != null && focusItem.text.length() != 0) {
                bounds = focusItem.getBoundsInPixels();
            }
            x = Math.max(x, bounds.x + bounds.width / 2);
            x = Math.min(x, clientArea.x + clientArea.width);
            y = Math.max(y, bounds.y + bounds.height);
            y = Math.min(y, clientArea.y + clientArea.height);
        }
        Point pt = this.toDisplayInPixels(x, y);
        int zoom = this.getZoom();
        event.setLocation(DPIUtil.pixelToPoint(pt.x, zoom), DPIUtil.pixelToPoint(pt.y, zoom));
    }

    @Override
    void updateOrientation() {
        int bits;
        super.updateOrientation();
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        OS.SetWindowPos(this.handle, 0L, 0, 0, width - 1, height - 1, 6);
        OS.SetWindowPos(this.handle, 0L, 0, 0, width, height, 6);
        if (this.hwndParent != 0L) {
            bits = OS.GetWindowLong(this.hwndParent, -20);
            bits = (this.style & 0x4000000) != 0 ? (bits |= 0x400000) : (bits &= 0xFFBFFFFF);
            OS.SetWindowLong(this.hwndParent, -20, bits &= 0xFFFFDFFF);
            rect = new RECT();
            OS.GetWindowRect(this.hwndParent, rect);
            width = rect.right - rect.left;
            height = rect.bottom - rect.top;
            OS.SetWindowPos(this.hwndParent, 0L, 0, 0, width - 1, height - 1, 6);
            OS.SetWindowPos(this.hwndParent, 0L, 0, 0, width, height, 6);
        }
        if (this.hwndHeader != 0L) {
            bits = OS.GetWindowLong(this.hwndHeader, -20);
            bits = (this.style & 0x4000000) != 0 ? (bits |= 0x400000) : (bits &= 0xFFBFFFFF);
            OS.SetWindowLong(this.hwndHeader, -20, bits);
            OS.InvalidateRect(this.hwndHeader, null, true);
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        if (this.imageList != null) {
            Point sizeInPoints = this.imageList.getImageSize();
            this.display.releaseImageList(this.imageList);
            this.imageList = this.display.getImageList(this.style & 0x4000000, sizeInPoints.x, sizeInPoints.y, this.getZoom());
            TreeItem[] treeItemArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                int index;
                Image image;
                TreeItem item = treeItemArray[n2];
                if (item != null && (image = item.image) != null && (index = this.imageList.indexOf(image)) == -1) {
                    this.imageList.add(image);
                }
                ++n2;
            }
            long hImageList = this.imageList.getHandle(this.getZoom());
            OS.SendMessage(this.handle, 4361, 0L, hImageList);
        }
        if (this.hwndHeader != 0L && this.headerImageList != null) {
            Point sizeInPoints = this.headerImageList.getImageSize();
            this.display.releaseImageList(this.headerImageList);
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, sizeInPoints.x, sizeInPoints.y, this.getZoom());
            if (this.columns != null) {
                int i = 0;
                while (i < this.columns.length) {
                    Image image;
                    TreeColumn column = this.columns[i];
                    if (column != null && (image = column.image) != null) {
                        HDITEM hdItem = new HDITEM();
                        hdItem.mask = 4;
                        OS.SendMessage(this.hwndHeader, 4619, (long)i, hdItem);
                        if ((hdItem.fmt & 0x800) != 0) {
                            int index = this.headerImageList.indexOf(image);
                            if (index == -1) {
                                index = this.headerImageList.add(image);
                            }
                            hdItem.mask = 32;
                            hdItem.iImage = index;
                            OS.SendMessage(this.hwndHeader, 4620, (long)i, hdItem);
                        }
                    }
                    ++i;
                }
            }
            long hImageListHeader = this.headerImageList.getHandle(this.getZoom());
            OS.SendMessage(this.hwndHeader, 4616, 0L, hImageListHeader);
        }
    }

    void updateScrollBar() {
        if (this.hwndParent != 0L && (this.columnCount != 0 || this.scrollWidth != 0)) {
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = SCROLLINFO.sizeof;
            info.fMask = 23;
            int itemCount = (int)OS.SendMessage(this.handle, 4357, 0L, 0L);
            if (itemCount == 0) {
                OS.GetScrollInfo(this.hwndParent, 1, info);
                info.nPage = info.nMax + 1;
                OS.SetScrollInfo(this.hwndParent, 1, info, true);
            } else {
                OS.GetScrollInfo(this.handle, 1, info);
                if (info.nPage == 0) {
                    SCROLLBARINFO psbi = new SCROLLBARINFO();
                    psbi.cbSize = SCROLLBARINFO.sizeof;
                    OS.GetScrollBarInfo(this.handle, -5, psbi);
                    if ((psbi.rgstate[0] & 0x8000) != 0) {
                        info.nPage = info.nMax + 1;
                    }
                }
                OS.SetScrollInfo(this.hwndParent, 1, info, true);
            }
        }
    }

    @Override
    void unsubclass() {
        super.unsubclass();
        if (this.hwndHeader != 0L) {
            OS.SetWindowLongPtr(this.hwndHeader, -4, HeaderProc);
        }
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle() | 0x20 | 4 | 1 | 0x4000;
        if (OS.IsAppThemed()) {
            bits |= 0x200;
            if ((this.style & 0x10000) != 0) {
                bits |= 0x1000;
            }
        } else {
            bits = (this.style & 0x10000) != 0 ? (bits |= 0x1000) : (bits |= 2);
        }
        if ((this.style & 0x300) == 0) {
            bits &= 0xFFCFFFFF;
            bits |= 0x2000;
        } else if ((this.style & 0x100) == 0) {
            bits &= 0xFFEFFFFF;
            bits |= 0x8000;
        }
        return bits | 0x10;
    }

    @Override
    TCHAR windowClass() {
        return TreeClass;
    }

    @Override
    long windowProc() {
        return TreeProc;
    }

    @Override
    long windowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.hwndHeader != 0L && hwnd == this.hwndHeader) {
            switch (msg) {
                case 123: {
                    LRESULT result = this.wmContextMenu(hwnd, wParam, lParam);
                    if (result == null) break;
                    return result.value;
                }
                case 675: {
                    this.updateHeaderToolTips();
                    this.updateHeaderToolTips();
                    break;
                }
                case 78: {
                    NMHDR hdr = new NMHDR();
                    OS.MoveMemory(hdr, lParam, NMHDR.sizeof);
                    switch (hdr.code) {
                        case -530: 
                        case -522: 
                        case -521: {
                            return OS.SendMessage(this.handle, msg, wParam, lParam);
                        }
                    }
                    break;
                }
                case 32: {
                    short hitTest;
                    if (wParam != hwnd || (hitTest = (short)OS.LOWORD(lParam)) != 1) break;
                    HDHITTESTINFO pinfo = new HDHITTESTINFO();
                    int pos = OS.GetMessagePos();
                    POINT pt = new POINT();
                    OS.POINTSTOPOINT(pt, pos);
                    OS.ScreenToClient(hwnd, pt);
                    pinfo.x = pt.x;
                    pinfo.y = pt.y;
                    int index = (int)OS.SendMessage(this.hwndHeader, 4614, 0L, pinfo);
                    if (index < 0 || index >= this.columnCount || this.columns[index].resizable || (pinfo.flags & 0xC) == 0) break;
                    OS.SetCursor(OS.LoadCursor(0L, 32512L));
                    return 1L;
                }
            }
            return this.callWindowProc(hwnd, msg, wParam, lParam);
        }
        if (this.hwndParent != 0L && hwnd == this.hwndParent) {
            switch (msg) {
                case 3: {
                    this.sendEvent(10);
                    return 0L;
                }
                case 5: {
                    this.setScrollWidth();
                    if (this.ignoreResize) {
                        return 0L;
                    }
                    this.setResizeChildren(false);
                    long code = this.callWindowProc(hwnd, 5, wParam, lParam);
                    this.sendEvent(11);
                    if (this.isDisposed()) {
                        return 0L;
                    }
                    if (this.layout != null) {
                        this.markLayout(false, false);
                        this.updateLayout(false, false);
                    }
                    this.setResizeChildren(true);
                    this.updateScrollBar();
                    return code;
                }
                case 133: {
                    LRESULT result = this.wmNCPaint(hwnd, wParam, lParam);
                    if (result == null) break;
                    return result.value;
                }
                case 791: {
                    LRESULT result = this.wmPrint(hwnd, wParam, lParam);
                    if (result == null) break;
                    return result.value;
                }
                case 21: 
                case 78: 
                case 273: {
                    return OS.SendMessage(this.handle, msg, wParam, lParam);
                }
                case 276: {
                    if (this.horizontalBar != null && (lParam == 0L || lParam == this.hwndParent)) {
                        this.wmScroll(this.horizontalBar, true, this.hwndParent, 276, wParam, lParam);
                    }
                    this.setScrollWidth();
                    break;
                }
                case 277: {
                    SCROLLINFO info = new SCROLLINFO();
                    info.cbSize = SCROLLINFO.sizeof;
                    info.fMask = 23;
                    OS.GetScrollInfo(this.hwndParent, 1, info);
                    if (OS.LOWORD(wParam) == 5) {
                        info.nPos = info.nTrackPos;
                    }
                    OS.SetScrollInfo(this.handle, 1, info, true);
                    long code = OS.SendMessage(this.handle, 277, wParam, lParam);
                    OS.GetScrollInfo(this.handle, 1, info);
                    OS.SetScrollInfo(this.hwndParent, 1, info, true);
                    return code;
                }
            }
            return this.callWindowProc(hwnd, msg, wParam, lParam);
        }
        if (msg == Display.DI_GETDRAGIMAGE && ((this.style & 2) != 0 || this.hooks(40) || this.hooks(42))) {
            long hItem = OS.SendMessage(this.handle, 4362, 5L, 0L);
            TreeItem[] items = new TreeItem[10];
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 28;
            int count = this.getSelection(hItem, tvItem, items, 0, 10, false, true);
            if (count == 0) {
                return 0L;
            }
            POINT mousePos = new POINT();
            OS.POINTSTOPOINT(mousePos, OS.GetMessagePos());
            OS.MapWindowPoints(0L, this.handle, mousePos, 1);
            RECT clientRect = new RECT();
            OS.GetClientRect(this.handle, clientRect);
            RECT rect = items[0].getBounds(0, true, true, false);
            int dragImageSizeInPixels = DPIUtil.pointToPixel(301, this.getZoom());
            if ((this.style & 0x10000) != 0) {
                int width = dragImageSizeInPixels;
                rect.left = Math.max(clientRect.left, mousePos.x - width / 2);
                if (clientRect.right > rect.left + width) {
                    rect.right = rect.left + width;
                } else {
                    rect.right = clientRect.right;
                    rect.left = Math.max(clientRect.left, rect.right - width);
                }
            } else {
                rect.left = Math.max(rect.left, clientRect.left);
                rect.right = Math.min(rect.right, clientRect.right);
            }
            long hRgn = OS.CreateRectRgn(rect.left, rect.top, rect.right, rect.bottom);
            int i = 1;
            while (i < count) {
                if (rect.bottom - rect.top > dragImageSizeInPixels || rect.bottom > clientRect.bottom) break;
                RECT itemRect = items[i].getBounds(0, true, true, false);
                if ((this.style & 0x10000) != 0) {
                    itemRect.left = rect.left;
                    itemRect.right = rect.right;
                } else {
                    itemRect.left = Math.max(itemRect.left, clientRect.left);
                    itemRect.right = Math.min(itemRect.right, clientRect.right);
                }
                long rectRgn = OS.CreateRectRgn(itemRect.left, itemRect.top, itemRect.right, itemRect.bottom);
                OS.CombineRgn(hRgn, hRgn, rectRgn, 2);
                OS.DeleteObject(rectRgn);
                rect.bottom = itemRect.bottom;
                ++i;
            }
            OS.GetRgnBox(hRgn, rect);
            long hdc = OS.GetDC(this.handle);
            long memHdc = OS.CreateCompatibleDC(hdc);
            BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
            bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
            bmiHeader.biWidth = rect.right - rect.left;
            bmiHeader.biHeight = -(rect.bottom - rect.top);
            bmiHeader.biPlanes = 1;
            bmiHeader.biBitCount = (short)32;
            bmiHeader.biCompression = 0;
            byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
            OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
            long[] pBits = new long[1];
            long memDib = OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
            if (memDib == 0L) {
                this.error(2);
            }
            long oldMemBitmap = OS.SelectObject(memHdc, memDib);
            int colorKey = 253;
            POINT pt = new POINT();
            OS.SetWindowOrgEx(memHdc, rect.left, rect.top, pt);
            OS.FillRect(memHdc, rect, this.findBrush(colorKey, 0));
            OS.OffsetRgn(hRgn, -rect.left, -rect.top);
            OS.SelectClipRgn(memHdc, hRgn);
            OS.PrintWindow(this.handle, memHdc, 0);
            OS.SetWindowOrgEx(memHdc, pt.x, pt.y, null);
            OS.SelectObject(memHdc, oldMemBitmap);
            OS.DeleteDC(memHdc);
            OS.ReleaseDC(0L, hdc);
            OS.DeleteObject(hRgn);
            SHDRAGIMAGE shdi = new SHDRAGIMAGE();
            shdi.hbmpDragImage = memDib;
            shdi.crColorKey = colorKey;
            shdi.sizeDragImage.cx = bmiHeader.biWidth;
            shdi.sizeDragImage.cy = -bmiHeader.biHeight;
            shdi.ptOffset.x = mousePos.x - rect.left;
            shdi.ptOffset.y = mousePos.y - rect.top;
            if ((this.style & 0x8000000) != 0) {
                shdi.ptOffset.x = shdi.sizeDragImage.cx - shdi.ptOffset.x;
            }
            OS.MoveMemory(lParam, shdi, SHDRAGIMAGE.sizeof);
            return 1L;
        }
        return super.windowProc(hwnd, msg, wParam, lParam);
    }

    @Override
    LRESULT WM_CHAR(long wParam, long lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch ((int)wParam) {
            case 32: {
                long hItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
                if (hItem != 0L) {
                    this.hAnchor = hItem;
                    OS.SendMessage(this.handle, 4372, 0L, hItem);
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 28;
                    tvItem.hItem = hItem;
                    if ((this.style & 0x20) != 0) {
                        tvItem.stateMask = 61440;
                        OS.SendMessage(this.handle, 4414, 0L, tvItem);
                        int state = tvItem.state >> 12;
                        state = (state & 1) != 0 ? ++state : --state;
                        tvItem.state = state << 12;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                        long id = OS.SendMessage(this.handle, 4395, hItem, 0L);
                        OS.NotifyWinEvent(32773, this.handle, -4, (int)id);
                    }
                    tvItem.stateMask = 2;
                    OS.SendMessage(this.handle, 4414, 0L, tvItem);
                    tvItem.state = (this.style & 2) != 0 && OS.GetKeyState(17) < 0 ? ((tvItem.state & 2) != 0 ? (tvItem.state &= 0xFFFFFFFD) : (tvItem.state |= 2)) : (tvItem.state |= 2);
                    OS.SendMessage(this.handle, 4415, 0L, tvItem);
                    TreeItem item = this._getItem(hItem, (int)tvItem.lParam);
                    Event event = new Event();
                    event.item = item;
                    this.sendSelectionEvent(13, event, false);
                    if ((this.style & 0x20) != 0) {
                        event = new Event();
                        event.item = item;
                        event.detail = 32;
                        this.sendSelectionEvent(13, event, false);
                    }
                }
                return LRESULT.ZERO;
            }
            case 13: {
                Event event = new Event();
                long hItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
                if (hItem != 0L) {
                    event.item = this._getItem(hItem);
                }
                this.sendSelectionEvent(14, event, false);
                return LRESULT.ZERO;
            }
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    @Override
    LRESULT WM_ERASEBKGND(long wParam, long lParam) {
        LRESULT result = super.WM_ERASEBKGND(wParam, lParam);
        if ((this.style & 0x20000000) != 0) {
            return LRESULT.ONE;
        }
        if (this.findImageControl() != null) {
            return LRESULT.ONE;
        }
        return result;
    }

    @Override
    LRESULT WM_GETOBJECT(long wParam, long lParam) {
        if (((this.style & 0x20) != 0 || this.hwndParent != 0L) && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(wParam, lParam);
    }

    @Override
    LRESULT WM_HSCROLL(long wParam, long lParam) {
        boolean fixScroll = false;
        if ((this.style & 0x20000000) != 0) {
            boolean bl = fixScroll = (this.style & 0x10000000) != 0 || this.hooks(40) || this.hooks(42);
        }
        if (fixScroll) {
            this.style &= 0xDFFFFFFF;
            if (this.explorerTheme) {
                OS.SendMessage(this.handle, 4396, 4L, 0L);
            }
        }
        LRESULT result = super.WM_HSCROLL(wParam, lParam);
        if (fixScroll) {
            this.style |= 0x20000000;
            if (this.explorerTheme) {
                OS.SendMessage(this.handle, 4396, 4L, 4L);
            }
        }
        if (result != null) {
            return result;
        }
        return result;
    }

    @Override
    LRESULT WM_KEYDOWN(long wParam, long lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch ((int)wParam) {
            case 37: 
            case 39: {
                boolean isRTL;
                boolean bl = isRTL = (this.style & 0x4000000) != 0;
                if (isRTL == this.createdAsRTL) break;
                long code = this.callWindowProc(this.handle, 256, wParam == 39L ? 37 : 39, lParam);
                return new LRESULT(code);
            }
            case 32: {
                return LRESULT.ZERO;
            }
            case 107: {
                if (OS.GetKeyState(17) >= 0 || this.hwndHeader == 0L) break;
                TreeColumn[] newColumns = new TreeColumn[this.columnCount];
                System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
                int i = 0;
                while (i < this.columnCount) {
                    TreeColumn column = newColumns[i];
                    if (!column.isDisposed() && column.getResizable()) {
                        column.pack();
                    }
                    ++i;
                }
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: {
                long hItem;
                OS.SendMessage(this.handle, 295, 3L, 0L);
                if (this.itemToolTipHandle != 0L) {
                    OS.ShowWindow(this.itemToolTipHandle, 0);
                }
                if ((this.style & 4) != 0) break;
                if (OS.GetKeyState(16) < 0 && (hItem = OS.SendMessage(this.handle, 4362, 9L, 0L)) != 0L) {
                    if (this.hAnchor == 0L) {
                        this.hAnchor = hItem;
                    }
                    this.ignoreDeselect = true;
                    this.ignoreSelect = true;
                    long code = this.callWindowProc(this.handle, 256, wParam, lParam);
                    this.ignoreDeselect = false;
                    this.ignoreSelect = false;
                    long hNewItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 24;
                    tvItem.stateMask = 2;
                    long hDeselectItem = hItem;
                    RECT rect1 = new RECT();
                    if (!OS.TreeView_GetItemRect(this.handle, this.hAnchor, rect1, false)) {
                        this.hAnchor = hItem;
                        OS.TreeView_GetItemRect(this.handle, this.hAnchor, rect1, false);
                    }
                    RECT rect2 = new RECT();
                    OS.TreeView_GetItemRect(this.handle, hDeselectItem, rect2, false);
                    int flags = rect1.top < rect2.top ? 7 : 6;
                    while (hDeselectItem != this.hAnchor) {
                        tvItem.hItem = hDeselectItem;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                        hDeselectItem = OS.SendMessage(this.handle, 4362, (long)flags, hDeselectItem);
                    }
                    long hSelectItem = this.hAnchor;
                    OS.TreeView_GetItemRect(this.handle, hNewItem, rect1, false);
                    OS.TreeView_GetItemRect(this.handle, hSelectItem, rect2, false);
                    tvItem.state = 2;
                    flags = rect1.top < rect2.top ? 7 : 6;
                    while (hSelectItem != hNewItem) {
                        tvItem.hItem = hSelectItem;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                        hSelectItem = OS.SendMessage(this.handle, 4362, (long)flags, hSelectItem);
                    }
                    tvItem.hItem = hNewItem;
                    OS.SendMessage(this.handle, 4415, 0L, tvItem);
                    tvItem.mask = 20;
                    tvItem.hItem = hNewItem;
                    OS.SendMessage(this.handle, 4414, 0L, tvItem);
                    Event event = new Event();
                    event.item = this._getItem(hNewItem, (int)tvItem.lParam);
                    this.sendSelectionEvent(13, event, false);
                    return new LRESULT(code);
                }
                if (OS.GetKeyState(17) < 0 && (hItem = OS.SendMessage(this.handle, 4362, 9L, 0L)) != 0L) {
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 24;
                    tvItem.stateMask = 2;
                    tvItem.hItem = hItem;
                    OS.SendMessage(this.handle, 4414, 0L, tvItem);
                    boolean oldSelected = (tvItem.state & 2) != 0;
                    long hNewItem = 0L;
                    block6 : switch ((int)wParam) {
                        case 38: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 7L, hItem);
                            break;
                        }
                        case 40: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 6L, hItem);
                            break;
                        }
                        case 36: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
                            break;
                        }
                        case 33: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 5L, 0L);
                            if (hNewItem != hItem) break;
                            OS.SendMessage(this.handle, 277, 2L, 0L);
                            hNewItem = OS.SendMessage(this.handle, 4362, 5L, 0L);
                            break;
                        }
                        case 34: {
                            long hVisible;
                            RECT rect = new RECT();
                            RECT clientRect = new RECT();
                            OS.GetClientRect(this.handle, clientRect);
                            hNewItem = OS.SendMessage(this.handle, 4362, 5L, 0L);
                            while ((hVisible = OS.SendMessage(this.handle, 4362, 6L, hNewItem)) != 0L && OS.TreeView_GetItemRect(this.handle, hVisible, rect, false) && rect.bottom <= clientRect.bottom) {
                                hNewItem = hVisible;
                                if (hNewItem == hItem) {
                                    OS.SendMessage(this.handle, 277, 3L, 0L);
                                }
                                if (hNewItem != 0L) continue;
                                break block6;
                            }
                            break;
                        }
                        case 35: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 10L, 0L);
                        }
                    }
                    if (hNewItem != 0L) {
                        boolean redraw;
                        OS.SendMessage(this.handle, 4372, 0L, hNewItem);
                        tvItem.hItem = hNewItem;
                        OS.SendMessage(this.handle, 4414, 0L, tvItem);
                        boolean newSelected = (tvItem.state & 2) != 0;
                        boolean bl = redraw = !newSelected && this.getDrawing() && OS.IsWindowVisible(this.handle);
                        if (redraw) {
                            OS.UpdateWindow(this.handle);
                            OS.DefWindowProc(this.handle, 11, 0L, 0L);
                        }
                        this.hSelect = hNewItem;
                        this.ignoreSelect = true;
                        OS.SendMessage(this.handle, 4363, 9L, hNewItem);
                        this.ignoreSelect = false;
                        this.hSelect = 0L;
                        if (oldSelected) {
                            tvItem.state = 2;
                            tvItem.hItem = hItem;
                            OS.SendMessage(this.handle, 4415, 0L, tvItem);
                        }
                        if (!newSelected) {
                            tvItem.state = 0;
                            tvItem.hItem = hNewItem;
                            OS.SendMessage(this.handle, 4415, 0L, tvItem);
                        }
                        if (redraw) {
                            RECT rect1 = new RECT();
                            RECT rect2 = new RECT();
                            OS.TreeView_GetItemRect(this.handle, hItem, rect1, false);
                            OS.TreeView_GetItemRect(this.handle, hNewItem, rect2, false);
                            OS.DefWindowProc(this.handle, 11, 1L, 0L);
                            OS.InvalidateRect(this.handle, rect1, true);
                            OS.InvalidateRect(this.handle, rect2, true);
                            OS.UpdateWindow(this.handle);
                        }
                        return LRESULT.ZERO;
                    }
                }
                long code = this.callWindowProc(this.handle, 256, wParam, lParam);
                this.hAnchor = OS.SendMessage(this.handle, 4362, 9L, 0L);
                return new LRESULT(code);
            }
        }
        return result;
    }

    @Override
    LRESULT WM_KILLFOCUS(long wParam, long lParam) {
        int bits;
        boolean redraw;
        boolean bl = redraw = (this.style & 2) != 0;
        if (!redraw && this.imageList != null && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) == 0) {
            redraw = true;
        }
        if (redraw) {
            this.redrawSelection();
        }
        return super.WM_KILLFOCUS(wParam, lParam);
    }

    @Override
    LRESULT WM_LBUTTONDBLCLK(long wParam, long lParam) {
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = OS.GET_X_LPARAM(lParam);
        lpht.y = OS.GET_Y_LPARAM(lParam);
        OS.SendMessage(this.handle, 4369, 0L, lpht);
        if (lpht.hItem != 0L && (this.style & 0x20) != 0 && (lpht.flags & 0x40) != 0) {
            Display display = this.display;
            display.captureChanged = false;
            this.sendMouseEvent(3, 1, this.handle, lParam);
            if (!this.sendMouseEvent(8, 1, this.handle, lParam)) {
                if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                    OS.SetCapture(this.handle);
                }
                return LRESULT.ZERO;
            }
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            OS.SetFocus(this.handle);
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = lpht.hItem;
            tvItem.mask = 28;
            tvItem.stateMask = 61440;
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            int state = tvItem.state >> 12;
            state = (state & 1) != 0 ? ++state : --state;
            tvItem.state = state << 12;
            OS.SendMessage(this.handle, 4415, 0L, tvItem);
            long id = OS.SendMessage(this.handle, 4395, tvItem.hItem, 0L);
            OS.NotifyWinEvent(32773, this.handle, -4, (int)id);
            Event event = new Event();
            event.item = this._getItem(tvItem.hItem, (int)tvItem.lParam);
            event.detail = 32;
            this.sendSelectionEvent(13, event, false);
            return LRESULT.ZERO;
        }
        LRESULT result = super.WM_LBUTTONDBLCLK(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        if (lpht.hItem != 0L) {
            int flags = 70;
            if ((this.style & 0x10000) != 0) {
                flags |= 0x28;
            } else if (this.hooks(41)) {
                lpht.flags &= 0xFFFFFFF9;
                if (this.hitTestSelection(lpht.hItem, lpht.x, lpht.y)) {
                    lpht.flags |= 6;
                }
            }
            if ((lpht.flags & flags) != 0) {
                Event event = new Event();
                event.item = this._getItem(lpht.hItem);
                this.sendSelectionEvent(14, event, false);
            }
        }
        return result;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = OS.GET_X_LPARAM(lParam);
        lpht.y = OS.GET_Y_LPARAM(lParam);
        OS.SendMessage(this.handle, 4369, 0L, lpht);
        if (lpht.hItem == 0L || (lpht.flags & 0x10) != 0) {
            RECT rect;
            long hItem;
            int bits;
            long hNewSelection;
            Display display = this.display;
            display.captureChanged = false;
            if (!this.sendMouseEvent(3, 1, this.handle, lParam)) {
                if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                    OS.SetCapture(this.handle);
                }
                return LRESULT.ZERO;
            }
            boolean fixSelection = false;
            boolean deselected = false;
            long hOldSelection = OS.SendMessage(this.handle, 4362, 9L, 0L);
            if (lpht.hItem != 0L && (this.style & 2) != 0 && hOldSelection != 0L) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 24;
                tvItem.hItem = lpht.hItem;
                OS.SendMessage(this.handle, 4414, 0L, tvItem);
                if ((tvItem.state & 0x20) != 0) {
                    fixSelection = true;
                    tvItem.stateMask = 2;
                    long hNext = OS.SendMessage(this.handle, 4362, 6L, lpht.hItem);
                    while (hNext != 0L) {
                        if (hNext == this.hAnchor) {
                            this.hAnchor = 0L;
                        }
                        tvItem.hItem = hNext;
                        OS.SendMessage(this.handle, 4414, 0L, tvItem);
                        if ((tvItem.state & 2) != 0) {
                            deselected = true;
                        }
                        tvItem.state = 0;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                        long hItem2 = hNext = OS.SendMessage(this.handle, 4362, 6L, hNext);
                        while (hItem2 != 0L && hItem2 != lpht.hItem) {
                            hItem2 = OS.SendMessage(this.handle, 4362, 3L, hItem2);
                        }
                        if (hItem2 == 0L) break;
                    }
                }
            }
            this.gestureCompleted = false;
            this.dragStarted = false;
            if (fixSelection) {
                this.hSelect = lpht.hItem;
                this.lockSelection = true;
                this.ignoreSelect = true;
                this.ignoreDeselect = true;
            }
            long code = this.callWindowProc(this.handle, 513, wParam, lParam);
            if (OS.GetFocus() != this.handle) {
                OS.SetFocus(this.handle);
            }
            if (fixSelection) {
                this.hSelect = 0L;
                this.lockSelection = false;
                this.ignoreSelect = false;
                this.ignoreDeselect = false;
            }
            if (hOldSelection != (hNewSelection = OS.SendMessage(this.handle, 4362, 9L, 0L))) {
                this.hAnchor = hNewSelection;
            }
            if (this.dragStarted && !display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            if ((lpht.flags & 0x10) != 0 && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) == 0 && OS.SendMessage(this.handle, 4360, 0L, 0L) == 0L && (hItem = OS.SendMessage(this.handle, 4362, 9L, 0L)) != 0L && OS.TreeView_GetItemRect(this.handle, hItem, rect = new RECT(), false)) {
                OS.InvalidateRect(this.handle, rect, true);
            }
            if (deselected) {
                Event event = new Event();
                event.item = this._getItem(lpht.hItem);
                this.sendSelectionEvent(13, event, false);
            }
            return new LRESULT(code);
        }
        if ((this.style & 0x20) != 0 && (lpht.flags & 0x40) != 0) {
            Display display = this.display;
            display.captureChanged = false;
            if (!this.sendMouseEvent(3, 1, this.handle, lParam)) {
                if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                    OS.SetCapture(this.handle);
                }
                return LRESULT.ZERO;
            }
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            OS.SetFocus(this.handle);
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = lpht.hItem;
            tvItem.mask = 28;
            tvItem.stateMask = 61440;
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            int state = tvItem.state >> 12;
            state = (state & 1) != 0 ? ++state : --state;
            tvItem.state = state << 12;
            OS.SendMessage(this.handle, 4415, 0L, tvItem);
            long id = OS.SendMessage(this.handle, 4395, tvItem.hItem, 0L);
            OS.NotifyWinEvent(32773, this.handle, -4, (int)id);
            Event event = new Event();
            event.item = this._getItem(tvItem.hItem, (int)tvItem.lParam);
            event.detail = 32;
            this.sendSelectionEvent(13, event, false);
            return LRESULT.ZERO;
        }
        boolean selected = false;
        boolean fakeSelection = false;
        if (lpht.hItem != 0L) {
            if ((this.style & 0x10000) != 0) {
                int bits = OS.GetWindowLong(this.handle, -16);
                if ((bits & 0x1000) == 0) {
                    fakeSelection = true;
                }
            } else if (this.hooks(41) && (selected = this.hitTestSelection(lpht.hItem, lpht.x, lpht.y)) && (lpht.flags & 0x46) == 0) {
                fakeSelection = true;
            }
        }
        if (!selected && (this.style & 0x10000) == 0 && (lpht.flags & 0x46) == 0) {
            Display display = this.display;
            display.captureChanged = false;
            if (!this.sendMouseEvent(3, 1, this.handle, lParam)) {
                if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                    OS.SetCapture(this.handle);
                }
                return LRESULT.ZERO;
            }
            long code = this.callWindowProc(this.handle, 513, wParam, lParam);
            if (OS.GetFocus() != this.handle) {
                OS.SetFocus(this.handle);
            }
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return new LRESULT(code);
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 24;
        tvItem.stateMask = 2;
        boolean hittestSelected = false;
        if ((this.style & 2) != 0) {
            tvItem.hItem = lpht.hItem;
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            hittestSelected = (tvItem.state & 2) != 0;
        }
        long hOldItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
        if ((this.style & 2) != 0) {
            tvItem.hItem = hOldItem;
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            if (hittestSelected || (wParam & 8L) != 0L) {
                int uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
                if ((uiState & 1) != 0) {
                    OS.SendMessage(this.handle, 295, 3L, 0L);
                }
                OS.UpdateWindow(this.handle);
                OS.DefWindowProc(this.handle, 11, 0L, 0L);
            } else {
                this.deselectAll();
            }
        }
        Display display = this.display;
        display.captureChanged = false;
        if (!this.sendMouseEvent(3, 1, this.handle, lParam)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        this.hSelect = lpht.hItem;
        this.gestureCompleted = false;
        this.dragStarted = false;
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        long code = this.callWindowProc(this.handle, 513, wParam, lParam);
        if (OS.GetFocus() != this.handle) {
            OS.SetFocus(this.handle);
        }
        long hNewItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
        if (fakeSelection) {
            if (hOldItem == 0L || hNewItem == hOldItem && lpht.hItem != hOldItem) {
                OS.SendMessage(this.handle, 4363, 9L, lpht.hItem);
                hNewItem = OS.SendMessage(this.handle, 4362, 9L, 0L);
            }
            if (!this.dragStarted && (this.state & 0x8000) != 0 && this.hooks(29)) {
                this.dragStarted = this.dragDetect(this.handle, lpht.x, lpht.y, false, null, null);
            }
        }
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        this.hSelect = 0L;
        if (this.dragStarted && !display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if ((this.style & 4) != 0 && hOldItem == hNewItem) {
            tvItem.mask = 24;
            tvItem.state = 2;
            tvItem.stateMask = 2;
            tvItem.hItem = hNewItem;
            OS.SendMessage(this.handle, 4415, 0L, tvItem);
        }
        if ((this.style & 2) != 0) {
            if (hittestSelected || (wParam & 8L) != 0L) {
                if (hOldItem == hNewItem && hOldItem == lpht.hItem) {
                    if ((wParam & 8L) != 0L) {
                        tvItem.state ^= 2;
                        if (this.dragStarted) {
                            tvItem.state = 2;
                        }
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                    }
                } else {
                    if ((tvItem.state & 2) != 0) {
                        tvItem.state = 2;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                    }
                    if ((wParam & 8L) != 0L && !this.dragStarted && hittestSelected) {
                        tvItem.state = 0;
                        tvItem.hItem = lpht.hItem;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                    }
                }
                RECT rect1 = new RECT();
                RECT rect2 = new RECT();
                OS.TreeView_GetItemRect(this.handle, hOldItem, rect1, false);
                OS.TreeView_GetItemRect(this.handle, hNewItem, rect2, false);
                OS.DefWindowProc(this.handle, 11, 1L, 0L);
                OS.InvalidateRect(this.handle, rect1, true);
                OS.InvalidateRect(this.handle, rect2, true);
                OS.UpdateWindow(this.handle);
            }
            if (!((wParam & 8L) != 0L || hittestSelected && this.dragStarted)) {
                tvItem.state = 0;
                long oldProc = OS.GetWindowLongPtr(this.handle, -4);
                OS.SetWindowLongPtr(this.handle, -4, TreeProc);
                if ((this.style & 0x10000000) != 0) {
                    long hItem = OS.SendMessage(this.handle, 4362, 0L, 0L);
                    this.deselect(hItem, tvItem, hNewItem);
                } else {
                    TreeItem[] treeItemArray = this.items;
                    int n = this.items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (item != null && item.handle != hNewItem) {
                            tvItem.hItem = item.handle;
                            OS.SendMessage(this.handle, 4415, 0L, tvItem);
                        }
                        ++n2;
                    }
                }
                tvItem.hItem = hNewItem;
                tvItem.state = 2;
                OS.SendMessage(this.handle, 4415, 0L, tvItem);
                OS.SetWindowLongPtr(this.handle, -4, oldProc);
                if ((wParam & 4L) != 0L) {
                    RECT rect2;
                    RECT rect1 = new RECT();
                    if (this.hAnchor == 0L) {
                        this.hAnchor = hNewItem;
                    }
                    if (OS.TreeView_GetItemRect(this.handle, this.hAnchor, rect1, false) && OS.TreeView_GetItemRect(this.handle, hNewItem, rect2 = new RECT(), false)) {
                        int flags = rect1.top < rect2.top ? 6 : 7;
                        tvItem.state = 2;
                        long hItem = tvItem.hItem = this.hAnchor;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                        while (hItem != hNewItem) {
                            tvItem.hItem = hItem;
                            OS.SendMessage(this.handle, 4415, 0L, tvItem);
                            hItem = OS.SendMessage(this.handle, 4362, (long)flags, hItem);
                        }
                    }
                }
            }
        }
        if ((wParam & 4L) == 0L) {
            this.hAnchor = hNewItem;
        }
        if (!this.gestureCompleted) {
            tvItem.hItem = hNewItem;
            tvItem.mask = 20;
            OS.SendMessage(this.handle, 4414, 0L, tvItem);
            Event event = new Event();
            event.item = this._getItem(tvItem.hItem, (int)tvItem.lParam);
            this.sendSelectionEvent(13, event, false);
        }
        this.gestureCompleted = false;
        if (this.dragStarted) {
            this.sendDragEvent(1, OS.GET_X_LPARAM(lParam), OS.GET_Y_LPARAM(lParam));
        } else {
            int bits = OS.GetWindowLong(this.handle, -16);
            if ((bits & 0x10) == 0) {
                this.sendMouseEvent(4, 1, this.handle, lParam);
            }
        }
        this.dragStarted = false;
        return new LRESULT(code);
    }

    @Override
    LRESULT WM_MOUSEMOVE(long wParam, long lParam) {
        Display display = this.display;
        LRESULT result = super.WM_MOUSEMOVE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.itemToolTipHandle != 0L) {
            RECT[] itemRect;
            RECT[] cellRect;
            int[] index;
            TreeItem[] item;
            int y;
            int x;
            int mask = 19;
            if (display.xMouse) {
                mask |= 0x60;
            }
            if ((wParam & (long)mask) == 0L && this.findCell(x = OS.GET_X_LPARAM(lParam), y = OS.GET_Y_LPARAM(lParam), item = new TreeItem[1], index = new int[1], cellRect = new RECT[1], itemRect = new RECT[1])) {
                if (OS.SendMessage(this.itemToolTipHandle, 1083, 0L, 0L) == 0L && OS.IsWindowVisible(this.itemToolTipHandle)) {
                    OS.ShowWindow(this.itemToolTipHandle, 0);
                }
                TOOLINFO lpti = new TOOLINFO();
                lpti.cbSize = TOOLINFO.sizeof;
                lpti.hwnd = this.handle;
                lpti.uId = this.handle;
                lpti.uFlags = 272;
                lpti.left = cellRect[0].left;
                lpti.top = cellRect[0].top;
                lpti.right = cellRect[0].right;
                lpti.bottom = cellRect[0].bottom;
                OS.SendMessage(this.itemToolTipHandle, 1076, 0L, lpti);
            }
        }
        return result;
    }

    @Override
    LRESULT WM_MOUSEWHEEL(long wParam, long lParam) {
        LRESULT result = super.WM_MOUSEWHEEL(wParam, lParam);
        if (this.itemToolTipHandle != 0L) {
            OS.ShowWindow(this.itemToolTipHandle, 0);
        }
        return result;
    }

    @Override
    LRESULT WM_MOVE(long wParam, long lParam) {
        if (this.itemToolTipHandle != 0L) {
            OS.ShowWindow(this.itemToolTipHandle, 0);
        }
        if (this.ignoreResize) {
            return null;
        }
        return super.WM_MOVE(wParam, lParam);
    }

    @Override
    LRESULT WM_RBUTTONDOWN(long wParam, long lParam) {
        Display display = this.display;
        display.captureChanged = false;
        if (!this.sendMouseEvent(3, 3, this.handle, lParam)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        if (OS.GetFocus() != this.handle) {
            OS.SetFocus(this.handle);
        }
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = OS.GET_X_LPARAM(lParam);
        lpht.y = OS.GET_Y_LPARAM(lParam);
        OS.SendMessage(this.handle, 4369, 0L, lpht);
        if (lpht.hItem != 0L) {
            boolean fakeSelection;
            boolean bl = fakeSelection = (this.style & 0x10000) != 0;
            if (!fakeSelection) {
                if (this.hooks(41)) {
                    fakeSelection = this.hitTestSelection(lpht.hItem, lpht.x, lpht.y);
                } else {
                    int flags = 6;
                    boolean bl2 = fakeSelection = (lpht.flags & flags) != 0;
                }
            }
            if (fakeSelection && (wParam & 0xCL) == 0L) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 24;
                tvItem.stateMask = 2;
                tvItem.hItem = lpht.hItem;
                OS.SendMessage(this.handle, 4414, 0L, tvItem);
                if ((tvItem.state & 2) == 0) {
                    this.ignoreSelect = true;
                    OS.SendMessage(this.handle, 4363, 9L, 0L);
                    this.ignoreSelect = false;
                    OS.SendMessage(this.handle, 4363, 9L, lpht.hItem);
                }
            }
        }
        return LRESULT.ZERO;
    }

    @Override
    LRESULT WM_PAINT(long wParam, long lParam) {
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        if (this.shrink && !this.ignoreShrink && this.items != null) {
            int count = this.items.length - 1;
            while (count >= 0) {
                if (this.items[count] != null) break;
                --count;
            }
            if (this.items.length > 4 && this.items.length - ++count > 3) {
                int length = Math.max(4, (count + 3) / 4 * 4);
                TreeItem[] newItems = new TreeItem[length];
                System.arraycopy(this.items, 0, newItems, 0, count);
                this.items = newItems;
            }
            this.shrink = false;
        }
        if ((this.style & 0x20000000) != 0 || this.findImageControl() != null) {
            int exStyle;
            boolean doubleBuffer = true;
            if (this.explorerTheme && ((exStyle = (int)OS.SendMessage(this.handle, 4397, 0L, 0L)) & 4) != 0) {
                doubleBuffer = false;
            }
            if (doubleBuffer) {
                boolean hooksPaint;
                GC gc = null;
                long paintDC = 0L;
                PAINTSTRUCT ps = new PAINTSTRUCT();
                boolean bl = hooksPaint = this.hooks(9) || this.filters(9);
                if (hooksPaint) {
                    GCData data = new GCData();
                    data.ps = ps;
                    data.hwnd = this.handle;
                    gc = GC.win32_new(this, data);
                    paintDC = gc.handle;
                } else {
                    paintDC = OS.BeginPaint(this.handle, ps);
                }
                int width = ps.right - ps.left;
                int height = ps.bottom - ps.top;
                if (width != 0 && height != 0) {
                    long hDC = OS.CreateCompatibleDC(paintDC);
                    POINT lpPoint1 = new POINT();
                    POINT lpPoint2 = new POINT();
                    OS.SetWindowOrgEx(hDC, ps.left, ps.top, lpPoint1);
                    OS.SetBrushOrgEx(hDC, ps.left, ps.top, lpPoint2);
                    long hBitmap = OS.CreateCompatibleBitmap(paintDC, width, height);
                    long hOldBitmap = OS.SelectObject(hDC, hBitmap);
                    RECT rect = new RECT();
                    OS.SetRect(rect, ps.left, ps.top, ps.right, ps.bottom);
                    this.drawBackground(hDC, rect);
                    this.callWindowProc(this.handle, 15, hDC, 0L);
                    OS.SetWindowOrgEx(hDC, lpPoint1.x, lpPoint1.y, null);
                    OS.SetBrushOrgEx(hDC, lpPoint2.x, lpPoint2.y, null);
                    OS.BitBlt(paintDC, ps.left, ps.top, width, height, hDC, 0, 0, 0xCC0020);
                    OS.SelectObject(hDC, hOldBitmap);
                    OS.DeleteObject(hBitmap);
                    OS.DeleteObject(hDC);
                    if (hooksPaint) {
                        Event event = new Event();
                        event.gc = gc;
                        event.setBounds(Win32DPIUtils.pixelToPoint(new Rectangle(ps.left, ps.top, ps.right - ps.left, ps.bottom - ps.top), this.getZoom()));
                        this.sendEvent(9, event);
                        event.gc = null;
                    }
                }
                if (hooksPaint) {
                    gc.dispose();
                } else {
                    OS.EndPaint(this.handle, ps);
                }
                return LRESULT.ZERO;
            }
        }
        return super.WM_PAINT(wParam, lParam);
    }

    @Override
    LRESULT WM_SETCURSOR(long wParam, long lParam) {
        short hitTest;
        LRESULT result = super.WM_SETCURSOR(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (wParam == this.handle && (hitTest = (short)OS.LOWORD(lParam)) == 1) {
            OS.SetCursor(OS.LoadCursor(0L, 32512L));
            return LRESULT.ONE;
        }
        return null;
    }

    @Override
    LRESULT WM_SETFOCUS(long wParam, long lParam) {
        int bits;
        boolean redraw;
        boolean bl = redraw = (this.style & 2) != 0;
        if (!redraw && this.imageList != null && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) == 0) {
            redraw = true;
        }
        if (redraw) {
            this.redrawSelection();
        }
        return super.WM_SETFOCUS(wParam, lParam);
    }

    @Override
    LRESULT WM_SETFONT(long wParam, long lParam) {
        LRESULT result = super.WM_SETFONT(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.hwndHeader != 0L) {
            OS.SendMessage(this.hwndHeader, 48, 0L, lParam);
            OS.SendMessage(this.hwndHeader, 48, wParam, lParam);
        }
        if (this.itemToolTipHandle != 0L) {
            OS.ShowWindow(this.itemToolTipHandle, 0);
            OS.SendMessage(this.itemToolTipHandle, 48, wParam, lParam);
        }
        if (this.headerToolTipHandle != 0L) {
            OS.SendMessage(this.headerToolTipHandle, 48, wParam, lParam);
            this.updateHeaderToolTips();
        }
        return result;
    }

    @Override
    LRESULT WM_SETREDRAW(long wParam, long lParam) {
        long code;
        LRESULT result = super.WM_SETREDRAW(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.itemToolTipHandle != 0L) {
            OS.ShowWindow(this.itemToolTipHandle, 0);
        }
        return (code = OS.DefWindowProc(this.handle, 11, wParam, lParam)) == 0L ? LRESULT.ZERO : new LRESULT(code);
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        int bits;
        if (this.itemToolTipHandle != 0L) {
            OS.ShowWindow(this.itemToolTipHandle, 0);
        }
        if (((bits = OS.GetWindowLong(this.handle, -16)) & 0x8000) != 0) {
            OS.ShowScrollBar(this.handle, 0, false);
        }
        if (this.explorerTheme && (this.style & 0x10000) != 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
        if (this.ignoreResize) {
            return null;
        }
        return super.WM_SIZE(wParam, lParam);
    }

    @Override
    LRESULT WM_SYSCOLORCHANGE(long wParam, long lParam) {
        LRESULT result = super.WM_SYSCOLORCHANGE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.explorerTheme && this.foreground == -1) {
            this.setForegroundPixel(-1);
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        return result;
    }

    @Override
    LRESULT WM_VSCROLL(long wParam, long lParam) {
        boolean fixScroll = false;
        if ((this.style & 0x20000000) != 0) {
            int code = OS.LOWORD(wParam);
            switch (code) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    boolean bl = fixScroll = (this.style & 0x10000000) != 0 || this.hooks(40) || this.hooks(42);
                }
            }
        }
        if (fixScroll) {
            this.style &= 0xDFFFFFFF;
            if (this.explorerTheme) {
                OS.SendMessage(this.handle, 4396, 4L, 0L);
            }
        }
        LRESULT result = super.WM_VSCROLL(wParam, lParam);
        if (fixScroll) {
            this.style |= 0x20000000;
            if (this.explorerTheme) {
                OS.SendMessage(this.handle, 4396, 4L, 4L);
            }
        }
        if (result != null) {
            return result;
        }
        return result;
    }

    @Override
    LRESULT WM_TIMER(long wParam, long lParam) {
        LRESULT result = super.WM_TIMER(wParam, lParam);
        if (result != null) {
            return result;
        }
        long bits = OS.SendMessage(this.handle, 4397, 0L, 0L);
        if ((bits & 0x40L) != 0L) {
            if (!OS.IsWindowVisible(this.handle)) {
                this.lastTimerCount = this.lastTimerID == wParam ? ++this.lastTimerCount : 0;
                this.lastTimerID = wParam;
                if (this.lastTimerCount >= 8) {
                    OS.CallWindowProc(TreeProc, this.handle, 512, 0L, 0L);
                    this.lastTimerID = -1L;
                    this.lastTimerCount = 0;
                }
            } else {
                this.lastTimerID = -1L;
                this.lastTimerCount = 0;
            }
        }
        return result;
    }

    @Override
    LRESULT wmColorChild(long wParam, long lParam) {
        if (this.findImageControl() != null) {
            return new LRESULT(OS.GetStockObject(5));
        }
        return null;
    }

    @Override
    LRESULT wmNotify(NMHDR hdr, long wParam, long lParam) {
        LRESULT result;
        if (hdr.hwndFrom == this.itemToolTipHandle && this.itemToolTipHandle != 0L) {
            result = this.wmNotifyToolTip(hdr, wParam, lParam);
            if (result != null) {
                return result;
            }
        } else if (hdr.code == -521) {
            return this.positionTooltip(hdr, wParam, lParam, false);
        }
        if (hdr.hwndFrom == this.hwndHeader && this.hwndHeader != 0L && (result = this.wmNotifyHeader(hdr, wParam, lParam)) != null) {
            return result;
        }
        return super.wmNotify(hdr, wParam, lParam);
    }

    @Override
    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -452: {
                TreeItem item;
                NMTVDISPINFO lptvdi = new NMTVDISPINFO();
                OS.MoveMemory(lptvdi, lParam, NMTVDISPINFO.sizeof);
                if ((this.style & 0x10000000) != 0) {
                    boolean checkVisible = true;
                    if (!this.ignoreShrink && this.items != null && lptvdi.lParam != -1L && this.items[(int)lptvdi.lParam] != null && this.items[(int)lptvdi.lParam].cached) {
                        checkVisible = false;
                    }
                    if (checkVisible) {
                        RECT itemRect;
                        if (!this.getDrawing() || !OS.IsWindowVisible(this.handle) || !OS.TreeView_GetItemRect(this.handle, lptvdi.hItem, itemRect = new RECT(), false)) break;
                        RECT rect = new RECT();
                        OS.GetClientRect(this.handle, rect);
                        if (!OS.IntersectRect(rect, rect, itemRect)) break;
                        if (this.ignoreShrink) {
                            OS.InvalidateRect(this.handle, rect, true);
                            break;
                        }
                    }
                }
                if (this.items == null) break;
                int id = (int)lptvdi.lParam;
                if ((this.style & 0x10000000) != 0 && id == -1) {
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 20;
                    tvItem.hItem = lptvdi.hItem;
                    OS.SendMessage(this.handle, 4414, 0L, tvItem);
                    id = (int)tvItem.lParam;
                }
                if ((item = this._getItem(lptvdi.hItem, id)) == null || item.isDisposed()) break;
                if (!item.cached) {
                    if ((this.style & 0x10000000) != 0 && !this.checkData(item, false)) break;
                    if (this.painted) {
                        item.cached = true;
                    }
                }
                int index = 0;
                if (this.hwndHeader != 0L) {
                    index = this.getFirstColumnIndex();
                }
                if ((lptvdi.mask & 1) != 0) {
                    String string = null;
                    if (index == 0) {
                        string = item.text;
                    } else {
                        String[] strings = item.strings;
                        if (strings != null) {
                            string = strings[index];
                        }
                    }
                    if (string != null) {
                        int length = Math.min(string.length() + 1, lptvdi.cchTextMax);
                        char[] buffer = new char[length];
                        string.getChars(0, length - 1, buffer, 0);
                        OS.MoveMemory(lptvdi.pszText, buffer, length * 2);
                        lptvdi.cchTextMax = length;
                    }
                }
                if ((lptvdi.mask & 0x22) != 0) {
                    Image image = null;
                    if (index == 0) {
                        image = item.image;
                    } else {
                        Image[] images = item.images;
                        if (images != null) {
                            image = images[index];
                        }
                    }
                    lptvdi.iSelectedImage = -2;
                    lptvdi.iImage = -2;
                    if (image != null) {
                        lptvdi.iImage = lptvdi.iSelectedImage = this.imageIndex(image, index);
                    }
                    if (this.explorerTheme && OS.IsWindowEnabled(this.handle) && this.findImageControl() != null) {
                        lptvdi.iSelectedImage = -2;
                        lptvdi.iImage = -2;
                    }
                }
                OS.MoveMemory(lParam, lptvdi, NMTVDISPINFO.sizeof);
                break;
            }
            case -12: {
                if (hdr.hwndFrom == this.hwndHeader) break;
                if (this.hooks(41) && this.hwndHeader == 0L) {
                    this.createParent();
                }
                if (!this.customDraw && this.findImageControl() == null && OS.IsAppThemed() && (this.sortColumn == null || this.sortDirection == 0)) break;
                NMTVCUSTOMDRAW nmcd = new NMTVCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMTVCUSTOMDRAW.sizeof);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        return this.CDDS_PREPAINT(nmcd, wParam, lParam);
                    }
                    case 65537: {
                        return this.CDDS_ITEMPREPAINT(nmcd, wParam, lParam);
                    }
                    case 65538: {
                        return this.CDDS_ITEMPOSTPAINT(nmcd, wParam, lParam);
                    }
                    case 2: {
                        return this.CDDS_POSTPAINT(nmcd, wParam, lParam);
                    }
                }
                break;
            }
            case -3: {
                if (this.hooks(41)) {
                    return LRESULT.ONE;
                }
                if (!this.hooks(14)) break;
                POINT pt = new POINT();
                int pos = OS.GetMessagePos();
                OS.POINTSTOPOINT(pt, pos);
                OS.ScreenToClient(this.handle, pt);
                TVHITTESTINFO lpht = new TVHITTESTINFO();
                lpht.x = pt.x;
                lpht.y = pt.y;
                OS.SendMessage(this.handle, 4369, 0L, lpht);
                if (lpht.hItem == 0L || (lpht.flags & 0x46) == 0) break;
                return LRESULT.ONE;
            }
            case -417: {
                if ((this.style & 2) == 0 || this.hSelect == 0L) break;
                NMTVITEMCHANGE pnm = new NMTVITEMCHANGE();
                OS.MoveMemory(pnm, lParam, NMTVITEMCHANGE.sizeof);
                if (this.hSelect == pnm.hItem) break;
                return LRESULT.ONE;
            }
            case -450: {
                if ((this.style & 2) != 0 && this.lockSelection) {
                    NMTREEVIEW treeView = new NMTREEVIEW();
                    OS.MoveMemory(treeView, lParam, NMTREEVIEW.sizeof);
                    TVITEM tvItem = treeView.itemOld;
                    this.oldSelected = (tvItem.state & 2) != 0;
                    tvItem = treeView.itemNew;
                    boolean bl = this.newSelected = (tvItem.state & 2) != 0;
                }
                if (this.ignoreSelect || this.ignoreDeselect) break;
                this.hAnchor = 0L;
                if ((this.style & 2) == 0) break;
                this.deselectAll();
                break;
            }
            case -451: {
                TVITEM tvItem;
                NMTREEVIEW treeView = null;
                if ((this.style & 2) != 0 && this.lockSelection) {
                    if (this.oldSelected) {
                        if (treeView == null) {
                            treeView = new NMTREEVIEW();
                            OS.MoveMemory(treeView, lParam, NMTREEVIEW.sizeof);
                        }
                        tvItem = treeView.itemOld;
                        tvItem.mask = 8;
                        tvItem.stateMask = 2;
                        tvItem.state = 2;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                    }
                    if (!this.newSelected && this.ignoreSelect) {
                        if (treeView == null) {
                            treeView = new NMTREEVIEW();
                            OS.MoveMemory(treeView, lParam, NMTREEVIEW.sizeof);
                        }
                        tvItem = treeView.itemNew;
                        tvItem.mask = 8;
                        tvItem.stateMask = 2;
                        tvItem.state = 0;
                        OS.SendMessage(this.handle, 4415, 0L, tvItem);
                    }
                }
                if (!this.ignoreSelect) {
                    if (treeView == null) {
                        treeView = new NMTREEVIEW();
                        OS.MoveMemory(treeView, lParam, NMTREEVIEW.sizeof);
                    }
                    tvItem = treeView.itemNew;
                    this.hAnchor = tvItem.hItem;
                    Event event = new Event();
                    event.item = this._getItem(tvItem.hItem, (int)tvItem.lParam);
                    this.sendSelectionEvent(13, event, false);
                }
                this.updateScrollBar();
                break;
            }
            case -454: {
                if (this.itemToolTipHandle != 0L) {
                    OS.ShowWindow(this.itemToolTipHandle, 0);
                }
                boolean runExpanded = false;
                if ((this.style & 0x10000000) != 0) {
                    this.style &= 0xDFFFFFFF;
                }
                if (this.hooks(40) || this.hooks(42)) {
                    this.style &= 0xDFFFFFFF;
                }
                if (this.findImageControl() != null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                    OS.DefWindowProc(this.handle, 11, 0L, 0L);
                }
                if (this.hInsert != 0L) {
                    OS.SendMessage(this.handle, 4378, 0L, 0L);
                }
                if (!this.ignoreExpand) {
                    TreeItem item;
                    NMTREEVIEW treeView = new NMTREEVIEW();
                    OS.MoveMemory(treeView, lParam, NMTREEVIEW.sizeof);
                    TVITEM tvItem = treeView.itemNew;
                    if (this.items == null || (item = this._getItem(tvItem.hItem, (int)tvItem.lParam)) == null) break;
                    Event event = new Event();
                    event.item = item;
                    switch (treeView.action) {
                        case 2: {
                            if ((tvItem.state & 0x20) != 0) break;
                            this.sendEvent(17, event);
                            if (!this.isDisposed()) break;
                            return LRESULT.ZERO;
                        }
                        case 1: {
                            this.sendEvent(18, event);
                            if (!this.isDisposed()) break;
                            return LRESULT.ZERO;
                        }
                    }
                    long hFirstItem = OS.SendMessage(this.handle, 4362, 4L, tvItem.hItem);
                    boolean bl = runExpanded = hFirstItem == 0L;
                }
                if (!runExpanded) break;
            }
            case -455: {
                if ((this.style & 0x10000000) != 0) {
                    this.style |= 0x20000000;
                }
                if (this.hooks(40) || this.hooks(42)) {
                    this.style |= 0x20000000;
                }
                if (this.findImageControl() != null && this.getDrawing()) {
                    OS.DefWindowProc(this.handle, 11, 1L, 0L);
                    OS.InvalidateRect(this.handle, null, true);
                }
                if (this.hInsert != 0L) {
                    OS.SendMessage(this.handle, 4378, (long)(this.insertAfter ? 1 : 0), this.hInsert);
                }
                if (this.imageList != null) {
                    RECT rect;
                    int bits;
                    NMTREEVIEW treeView = new NMTREEVIEW();
                    OS.MoveMemory(treeView, lParam, NMTREEVIEW.sizeof);
                    TVITEM tvItem = treeView.itemNew;
                    if (tvItem.hItem != 0L && ((bits = OS.GetWindowLong(this.handle, -16)) & 0x1000) == 0 && OS.TreeView_GetItemRect(this.handle, tvItem.hItem, rect = new RECT(), false)) {
                        OS.InvalidateRect(this.handle, rect, true);
                    }
                }
                this.updateScrollBar();
                break;
            }
            case -456: {
                if (OS.GetKeyState(1) >= 0) break;
            }
            case -457: {
                this.dragStarted = true;
                NMTREEVIEW treeView = new NMTREEVIEW();
                OS.MoveMemory(treeView, lParam, NMTREEVIEW.sizeof);
                TVITEM tvItem = treeView.itemNew;
                if (tvItem.hItem == 0L || (tvItem.state & 2) != 0) break;
                this.hSelect = tvItem.hItem;
                this.ignoreDeselect = true;
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4363, 9L, tvItem.hItem);
                this.ignoreDeselect = false;
                this.ignoreSelect = false;
                this.hSelect = 0L;
            }
        }
        return super.wmNotifyChild(hdr, wParam, lParam);
    }

    LRESULT wmNotifyHeader(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -326: 
            case -325: {
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                TreeColumn column = this.columns[phdn.iItem];
                if (column != null && !column.getResizable()) {
                    return LRESULT.ONE;
                }
                this.ignoreColumnMove = true;
                if (hdr.code != -325 || column == null) break;
                column.pack();
                break;
            }
            case -12: {
                NMCUSTOMDRAW nmcd = new NMCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMCUSTOMDRAW.sizeof);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        return new LRESULT(this.customHeaderDrawing() ? 48 : 0);
                    }
                    case 65537: {
                        RECT rect = new RECT();
                        OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                        int pixel = this.getHeaderBackgroundPixel();
                        if ((nmcd.uItemState & 1) != 0) {
                            pixel = this.getDifferentColor(pixel);
                        }
                        long brush = OS.CreateSolidBrush(pixel);
                        OS.FillRect(nmcd.hdc, rect, brush);
                        OS.DeleteObject(brush);
                        return new LRESULT(4L);
                    }
                    case 2: {
                        POINT cursorPos = new POINT();
                        OS.GetCursorPos(cursorPos);
                        OS.MapWindowPoints(0L, this.hwndHeader, cursorPos, 1);
                        int highlightedHeaderDividerX = -1;
                        int lastColumnRight = -1;
                        RECT[] rects = new RECT[this.columnCount];
                        int i = 0;
                        while (i < this.columnCount) {
                            long oldPen;
                            long pen;
                            rects[i] = new RECT();
                            OS.SendMessage(this.hwndHeader, 4615, (long)i, rects[i]);
                            if (rects[i].right > lastColumnRight) {
                                lastColumnRight = rects[i].right;
                            }
                            if (this.columns[i] == this.sortColumn && this.sortDirection != 0) {
                                pen = OS.CreatePen(0, 1, this.getHeaderForegroundPixel());
                                oldPen = OS.SelectObject(nmcd.hdc, pen);
                                int center = rects[i].left + (rects[i].right - rects[i].left) / 2;
                                int leg = DPIUtil.pointToPixel(3, this.nativeZoom);
                                if (this.sortDirection == 128) {
                                    int[] nArray = new int[4];
                                    nArray[0] = center - leg;
                                    nArray[1] = 1 + leg;
                                    nArray[2] = center + 1;
                                    OS.Polyline(nmcd.hdc, nArray, 2);
                                    int[] nArray2 = new int[4];
                                    nArray2[0] = center + leg;
                                    nArray2[1] = 1 + leg;
                                    nArray2[2] = center - 1;
                                    OS.Polyline(nmcd.hdc, nArray2, 2);
                                } else if (this.sortDirection == 1024) {
                                    OS.Polyline(nmcd.hdc, new int[]{center - leg, 1, center + 1, 1 + leg + 1}, 2);
                                    OS.Polyline(nmcd.hdc, new int[]{center + leg, 1, center - 1, 1 + leg + 1}, 2);
                                }
                                OS.SelectObject(nmcd.hdc, oldPen);
                                OS.DeleteObject(pen);
                            }
                            pen = OS.CreatePen(0, this.getGridLineWidthInPixels(), this.getSlightlyDifferentColor(this.getHeaderBackgroundPixel()));
                            oldPen = OS.SelectObject(nmcd.hdc, pen);
                            OS.Polyline(nmcd.hdc, new int[]{rects[i].right - 1, rects[i].top, rects[i].right - 1, rects[i].bottom}, 2);
                            OS.SelectObject(nmcd.hdc, oldPen);
                            OS.DeleteObject(pen);
                            pen = OS.CreatePen(0, this.getGridLineWidthInPixels(), OS.GetSysColor(15));
                            oldPen = OS.SelectObject(nmcd.hdc, pen);
                            OS.Polyline(nmcd.hdc, new int[]{rects[i].right - 1, rects[i].top, rects[i].right - 1, rects[i].bottom}, 2);
                            if (i == 0) {
                                OS.Polyline(nmcd.hdc, new int[]{nmcd.left, nmcd.bottom - 1, nmcd.right, nmcd.bottom - 1}, 2);
                            }
                            OS.SelectObject(nmcd.hdc, oldPen);
                            OS.DeleteObject(pen);
                            if (this.headerItemDragging && highlightedHeaderDividerX == -1) {
                                int distanceToLeftBorder = cursorPos.x - rects[i].left;
                                int distanceToRightBorder = rects[i].right - cursorPos.x;
                                if (distanceToLeftBorder >= 0 && distanceToRightBorder >= 0) {
                                    highlightedHeaderDividerX = distanceToLeftBorder <= distanceToRightBorder ? rects[i].left - 1 : rects[i].right;
                                }
                            }
                            int x = rects[i].left + 3 + 2;
                            if (this.columns[i].image != null) {
                                GCData data = new GCData();
                                data.device = this.display;
                                GC gc = this.createNewGC(nmcd.hdc, data);
                                int zoom = this.getZoom();
                                Rectangle imageBounds = Win32DPIUtils.scaleBounds(this.columns[i].image.getBounds(), zoom, 100);
                                int y = Math.max(0, (nmcd.bottom - imageBounds.height) / 2);
                                gc.drawImage(this.columns[i].image, DPIUtil.pixelToPoint(x, zoom), DPIUtil.pixelToPoint(y, zoom));
                                x += imageBounds.width + 12;
                                gc.dispose();
                            }
                            if (this.columns[i].text != null) {
                                int flags = 2084;
                                if ((this.columns[i].style & 0x1000000) != 0) {
                                    flags |= 1;
                                }
                                if ((this.columns[i].style & 0x20000) != 0) {
                                    flags |= 2;
                                }
                                char[] buffer = this.columns[i].text.toCharArray();
                                OS.SetBkMode(nmcd.hdc, 1);
                                OS.SetTextColor(nmcd.hdc, this.getHeaderForegroundPixel());
                                RECT textRect = new RECT();
                                textRect.left = x;
                                textRect.top = rects[i].top;
                                textRect.right = rects[i].right;
                                textRect.bottom = rects[i].bottom;
                                OS.DrawText(nmcd.hdc, buffer, buffer.length, textRect, flags);
                            }
                            ++i;
                        }
                        if (lastColumnRight < nmcd.right) {
                            RECT rect = new RECT();
                            OS.SetRect(rect, lastColumnRight, nmcd.top, nmcd.right, nmcd.bottom - 1);
                            long brush = OS.CreateSolidBrush(this.getHeaderBackgroundPixel());
                            OS.FillRect(nmcd.hdc, rect, brush);
                            OS.DeleteObject(brush);
                        }
                        if (highlightedHeaderDividerX != -1) {
                            long pen = OS.CreatePen(0, 4, OS.GetSysColor(13));
                            long oldPen = OS.SelectObject(nmcd.hdc, pen);
                            OS.Polyline(nmcd.hdc, new int[]{highlightedHeaderDividerX, nmcd.top, highlightedHeaderDividerX, nmcd.bottom}, 2);
                            OS.SelectObject(nmcd.hdc, oldPen);
                            OS.DeleteObject(pen);
                        }
                        return new LRESULT(0L);
                    }
                }
                break;
            }
            case -16: {
                if (!this.ignoreColumnMove) {
                    int i = 0;
                    while (i < this.columnCount) {
                        TreeColumn column = this.columns[i];
                        column.updateToolTip(i);
                        ++i;
                    }
                    this.updateImageList();
                }
                this.ignoreColumnMove = false;
                break;
            }
            case -310: {
                if (this.ignoreColumnMove) {
                    return LRESULT.ONE;
                }
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                if (phdn.iItem == -1) break;
                TreeColumn column = this.columns[phdn.iItem];
                if (column != null && !column.getMoveable()) {
                    this.ignoreColumnMove = true;
                    return LRESULT.ONE;
                }
                this.headerItemDragging = true;
                break;
            }
            case -311: {
                this.headerItemDragging = false;
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                if (phdn.iItem == -1 || phdn.pitem == 0L) break;
                HDITEM pitem = new HDITEM();
                OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                if ((pitem.mask & 0x80) == 0 || pitem.iOrder == -1) break;
                int[] oldOrder = this.getColumnOrder();
                this.cachedItemOrder = null;
                int index = 0;
                while (index < oldOrder.length) {
                    if (oldOrder[index] == phdn.iItem) break;
                    ++index;
                }
                if (index == oldOrder.length) {
                    index = 0;
                }
                if (index == pitem.iOrder) break;
                int start = Math.min(index, pitem.iOrder);
                int end = Math.max(index, pitem.iOrder);
                RECT rect = new RECT();
                RECT headerRect = new RECT();
                OS.GetClientRect(this.handle, rect);
                OS.SendMessage(this.hwndHeader, 4615, (long)oldOrder[start], headerRect);
                rect.left = Math.max(rect.left, headerRect.left);
                OS.SendMessage(this.hwndHeader, 4615, (long)oldOrder[end], headerRect);
                rect.right = Math.min(rect.right, headerRect.right);
                OS.InvalidateRect(this.handle, rect, true);
                this.ignoreColumnMove = false;
                int i = start;
                while (i <= end) {
                    TreeColumn column = this.columns[oldOrder[i]];
                    if (!column.isDisposed()) {
                        column.postEvent(10);
                    }
                    ++i;
                }
                break;
            }
            case -320: {
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                if (phdn.pitem == 0L) break;
                HDITEM newItem = new HDITEM();
                OS.MoveMemory(newItem, phdn.pitem, HDITEM.sizeof);
                if ((newItem.mask & 1) == 0) break;
                RECT rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                HDITEM oldItem = new HDITEM();
                oldItem.mask = 1;
                OS.SendMessage(this.hwndHeader, 4619, (long)phdn.iItem, oldItem);
                int deltaX = newItem.cxy - oldItem.cxy;
                RECT headerRect = new RECT();
                OS.SendMessage(this.hwndHeader, 4615, (long)phdn.iItem, headerRect);
                int gridWidth = this.linesVisible ? this.getGridLineWidthInPixels() : 0;
                rect.left = headerRect.right - gridWidth;
                int newX = rect.left + deltaX;
                rect.right = Math.max(rect.right, rect.left + Math.abs(deltaX));
                if (this.explorerTheme || this.findImageControl() != null || this.hooks(41) || this.hooks(40) || this.hooks(42)) {
                    rect.left -= this.getSystemMetrics(83);
                    OS.InvalidateRect(this.handle, rect, true);
                    OS.OffsetRect(rect, deltaX, 0);
                    OS.InvalidateRect(this.handle, rect, true);
                } else {
                    int flags = 6;
                    OS.ScrollWindowEx(this.handle, deltaX, 0, rect, null, 0L, null, flags);
                }
                if (this.getFirstColumnIndex() != phdn.iItem) {
                    rect.left = headerRect.left;
                    rect.right = newX;
                    OS.InvalidateRect(this.handle, rect, true);
                }
                this.setScrollWidth();
                break;
            }
            case -321: {
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                if (phdn.pitem == 0L) break;
                HDITEM pitem = new HDITEM();
                OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                if ((pitem.mask & 0x80) != 0) {
                    this.cachedItemOrder = null;
                }
                if ((pitem.mask & 1) != 0) {
                    TreeColumn column;
                    if (this.ignoreColumnMove) {
                        int flags = 384;
                        OS.RedrawWindow(this.handle, null, 0L, flags);
                    }
                    if (!this.ignoreColumnResize && (column = this.columns[phdn.iItem]) != null) {
                        column.updateToolTip(phdn.iItem);
                        column.sendEvent(11);
                        if (this.isDisposed()) {
                            return LRESULT.ZERO;
                        }
                        TreeColumn[] newColumns = new TreeColumn[this.columnCount];
                        System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
                        int[] order = this.getColumnOrder();
                        boolean moved = false;
                        int i = 0;
                        while (i < this.columnCount) {
                            TreeColumn nextColumn = newColumns[order[i]];
                            if (moved && !nextColumn.isDisposed()) {
                                nextColumn.updateToolTip(order[i]);
                                nextColumn.sendEvent(10);
                            }
                            if (nextColumn == column) {
                                moved = true;
                            }
                            ++i;
                        }
                    }
                }
                this.setScrollWidth();
                break;
            }
            case -322: {
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                TreeColumn column = this.columns[phdn.iItem];
                if (column == null) break;
                column.sendSelectionEvent(13);
                break;
            }
            case -323: {
                NMHEADER phdn = new NMHEADER();
                OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                TreeColumn column = this.columns[phdn.iItem];
                if (column == null) break;
                column.sendSelectionEvent(14);
            }
        }
        return null;
    }

    LRESULT wmNotifyToolTip(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -12: {
                NMTTCUSTOMDRAW nmcd = new NMTTCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMTTCUSTOMDRAW.sizeof);
                return this.wmNotifyToolTip(nmcd, lParam);
            }
            case -521: {
                return this.positionTooltip(hdr, wParam, lParam, true);
            }
        }
        return null;
    }

    private LRESULT positionTooltip(NMHDR hdr, long wParam, long lParam, boolean managedTooltip) {
        LRESULT result = super.wmNotify(hdr, wParam, lParam);
        if (result != null) {
            return result;
        }
        int flags = 21;
        if (this.isCustomToolTip() || !managedTooltip) {
            flags &= 0xFFFFFFFE;
        }
        int pos = OS.GetMessagePos();
        POINT pt = new POINT();
        OS.POINTSTOPOINT(pt, pos);
        OS.ScreenToClient(this.handle, pt);
        int[] index = new int[1];
        TreeItem[] item = new TreeItem[1];
        RECT[] cellRect = new RECT[1];
        RECT[] itemRect = new RECT[1];
        if (this.findCell(pt.x, pt.y, item, index, cellRect, itemRect)) {
            RECT toolRect = managedTooltip ? this.toolTipRect(itemRect[0]) : itemRect[0];
            OS.MapWindowPoints(this.handle, 0L, toolRect, 2);
            Rectangle adjustedTooltipBounds = this.getDisplay().fitRectangleBoundsIntoMonitorWithCursor(toolRect);
            if (adjustedTooltipBounds != null) {
                OS.SetWindowPos(hdr.hwndFrom, 0L, adjustedTooltipBounds.x, adjustedTooltipBounds.y, adjustedTooltipBounds.width, adjustedTooltipBounds.height, flags);
                result = LRESULT.ONE;
            }
        } else if (!managedTooltip) {
            OS.SetWindowPos(hdr.hwndFrom, 0L, 0, 0, 0, 0, flags |= 2);
            result = LRESULT.ONE;
        }
        return result;
    }

    LRESULT wmNotifyToolTip(NMTTCUSTOMDRAW nmcd, long lParam) {
        switch (nmcd.dwDrawStage) {
            case 1: {
                if (!this.isCustomToolTip()) break;
                return new LRESULT(18L);
            }
            case 2: {
                if (OS.SendMessage(this.itemToolTipHandle, 1083, 0L, 0L) == 0L) break;
                TOOLINFO lpti = new TOOLINFO();
                lpti.cbSize = TOOLINFO.sizeof;
                if (OS.SendMessage(this.itemToolTipHandle, 1083, 0L, lpti) == 0L) break;
                int[] index = new int[1];
                TreeItem[] item = new TreeItem[1];
                RECT[] cellRect = new RECT[1];
                RECT[] itemRect = new RECT[1];
                int pos = OS.GetMessagePos();
                POINT pt = new POINT();
                OS.POINTSTOPOINT(pt, pos);
                OS.ScreenToClient(this.handle, pt);
                if (!this.findCell(pt.x, pt.y, item, index, cellRect, itemRect)) break;
                long hDC = OS.GetDC(this.handle);
                long hFont = item[0].fontHandle(index[0]);
                if (hFont == -1L) {
                    hFont = OS.SendMessage(this.handle, 49, 0L, 0L);
                }
                long oldFont = OS.SelectObject(hDC, hFont);
                boolean drawForeground = true;
                cellRect[0] = item[0].getBounds(index[0], true, true, false, false, false, hDC);
                if (this.hooks(40)) {
                    Event event = this.sendEraseItemEvent(item[0], nmcd, index[0], cellRect[0]);
                    if (this.isDisposed() || item[0].isDisposed()) break;
                    drawForeground = event.doit ? (event.detail & 0x10) != 0 : false;
                }
                if (drawForeground) {
                    Image image;
                    int nSavedDC = OS.SaveDC(nmcd.hdc);
                    int gridWidth = this.getLinesVisible() ? this.getGridLineWidthInPixels() : 0;
                    RECT insetRect = this.toolTipInset(cellRect[0]);
                    OS.SetWindowOrgEx(nmcd.hdc, insetRect.left, insetRect.top, null);
                    GCData data = new GCData();
                    data.device = this.display;
                    data.foreground = OS.GetTextColor(nmcd.hdc);
                    data.background = OS.GetBkColor(nmcd.hdc);
                    data.font = Font.win32_new(this.display, hFont);
                    GC gc = this.createNewGC(nmcd.hdc, data);
                    int x = cellRect[0].left + 3;
                    if (index[0] != 0) {
                        x -= gridWidth;
                    }
                    if ((image = item[0].getImage(index[0])) != null || index[0] == 0) {
                        Point size = this.getImageSize();
                        RECT imageRect = item[0].getBounds(index[0], false, true, false, false, false, hDC);
                        if (this.imageList == null) {
                            size.x = imageRect.right - imageRect.left;
                        }
                        if (image != null) {
                            int zoom = this.getZoom();
                            gc.drawImage(image, DPIUtil.pixelToPoint(x, zoom), DPIUtil.pixelToPoint(imageRect.top, zoom), DPIUtil.pixelToPoint(size.x, zoom), DPIUtil.pixelToPoint(size.y, zoom));
                            x += 3 + (index[0] == 0 ? 1 : 0);
                        }
                        x += size.x;
                    } else {
                        x += 3;
                    }
                    String string = item[0].getText(index[0]);
                    if (string != null) {
                        TreeColumn column;
                        int flags = 2084;
                        TreeColumn treeColumn = column = this.columns != null ? this.columns[index[0]] : null;
                        if (column != null) {
                            if ((column.style & 0x1000000) != 0) {
                                flags |= 1;
                            }
                            if ((column.style & 0x20000) != 0) {
                                flags |= 2;
                            }
                        }
                        char[] buffer = string.toCharArray();
                        RECT textRect = new RECT();
                        OS.SetRect(textRect, x, cellRect[0].top, cellRect[0].right, cellRect[0].bottom);
                        OS.DrawText(nmcd.hdc, buffer, buffer.length, textRect, flags);
                    }
                    gc.dispose();
                    OS.RestoreDC(nmcd.hdc, nSavedDC);
                }
                if (this.hooks(42)) {
                    itemRect[0] = item[0].getBounds(index[0], true, true, false, false, false, hDC);
                    this.sendPaintItemEvent(item[0], nmcd, index[0], itemRect[0]);
                }
                OS.SelectObject(hDC, oldFont);
                OS.ReleaseDC(this.handle, hDC);
            }
        }
        return null;
    }

    @Override
    void handleDPIChange(Event event, float scalingFactor) {
        super.handleDPIChange(event, scalingFactor);
        Display display = this.getDisplay();
        if (this.headerImageList != null) {
            display.releaseImageList(this.headerImageList);
            this.headerImageList = null;
        }
        if (this.imageList != null) {
            display.releaseImageList(this.imageList);
            OS.SendMessage(this.handle, 4361, 0L, 0L);
            this.imageList = null;
        }
        this.setItemHeight(-1);
        Item[] itemArray = this.getColumns();
        int n = itemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = itemArray[n2];
            treeColumn.notifyListeners(55, event);
            ++n2;
        }
        itemArray = this.getItems();
        n = itemArray.length;
        n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            item.notifyListeners(55, event);
            ++n2;
        }
        this.calculateAndApplyIndentSize();
        this.updateOrientation();
        this.setScrollWidth();
        this.setCheckboxImageList();
    }
}

