/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.bag;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.lazy.parallel.bag.AbstractParallelUnsortedBag;
import org.eclipse.collections.impl.lazy.parallel.bag.UnsortedBagBatch;

@Beta
public class ParallelCollectUnsortedBag<T, V>
extends AbstractParallelUnsortedBag<V, UnsortedBagBatch<V>> {
    private final AbstractParallelUnsortedBag<T, ? extends UnsortedBagBatch<T>> parallelIterable;
    private final Function<? super T, ? extends V> function;

    public ParallelCollectUnsortedBag(AbstractParallelUnsortedBag<T, ? extends UnsortedBagBatch<T>> parallelIterable, Function<? super T, ? extends V> function) {
        this.parallelIterable = parallelIterable;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<UnsortedBagBatch<V>> split() {
        return this.parallelIterable.split().collect((Function & Serializable)eachBatch -> eachBatch.collect(this.function));
    }

    public void forEach(Procedure<? super V> procedure) {
        this.parallelIterable.forEach(Functions.bind(procedure, this.function));
    }

    public void forEachWithOccurrences(ObjectIntProcedure<? super V> procedure) {
        this.parallelIterable.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, parameter) -> procedure.value(this.function.valueOf(each), parameter));
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.anySatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.allSatisfy(Predicates.attributePredicate(this.function, predicate));
    }

    public V detect(Predicate<? super V> predicate) {
        Object resultItem = this.parallelIterable.detect(Predicates.attributePredicate(this.function, predicate));
        return (V)(resultItem == null ? null : this.function.valueOf(resultItem));
    }
}

