/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.shaded.com.google.common.cache.CacheBuilder;
import com.github.jsonldjava.shaded.com.google.common.cache.CacheLoader;
import com.github.jsonldjava.shaded.com.google.common.cache.LoadingCache;
import com.github.jsonldjava.shaded.com.google.common.collect.MapMaker;
import com.github.jsonldjava.utils.JarCacheResource;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.apache.http.client.cache.Resource;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicStatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarCacheStorage
implements HttpCacheStorage {
    private static final String JARCACHE_JSON = "jarcache.json";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CacheConfig cacheConfig;
    private ClassLoader classLoader = null;
    private static final Object NULL_CLASS_LOADER = new Object();
    private final HttpCacheStorage delegate;
    private final ObjectMapper mapper = new ObjectMapper();
    private final LoadingCache<URL, JsonNode> jarCaches = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(100L).softValues().build(new CacheLoader<URL, JsonNode>(){

        @Override
        public JsonNode load(URL url) throws IOException {
            return JarCacheStorage.this.mapper.readTree(url);
        }
    });
    private static final ConcurrentMap<Object, List<URL>> cachedResourceList = new MapMaker().concurrencyLevel(4).weakKeys().makeMap();

    public JarCacheStorage(ClassLoader classLoader, CacheConfig cacheConfig) {
        this(classLoader, cacheConfig, (HttpCacheStorage)new BasicHttpCacheStorage(cacheConfig));
    }

    public JarCacheStorage(ClassLoader classLoader, CacheConfig cacheConfig, HttpCacheStorage delegate) {
        this.setClassLoader(classLoader);
        this.cacheConfig = Objects.requireNonNull(cacheConfig, "Cache config cannot be null");
        this.delegate = Objects.requireNonNull(delegate, "Delegate cannot be null");
    }

    public ClassLoader getClassLoader() {
        ClassLoader nextClassLoader = this.classLoader;
        if (nextClassLoader != null) {
            return nextClassLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void putEntry(String key, HttpCacheEntry entry) throws IOException {
        this.delegate.putEntry(key, entry);
    }

    public HttpCacheEntry getEntry(String key) throws IOException {
        this.log.trace("Requesting {}", (Object)key);
        Optional<Object> parsedUri = Optional.empty();
        try {
            parsedUri = Optional.of(new URI(key));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (parsedUri.isPresent()) {
            URI requestedUri;
            block8: {
                requestedUri = (URI)parsedUri.get();
                if (requestedUri.getScheme().equals("http") && requestedUri.getPort() == 80 || requestedUri.getScheme().equals("https") && requestedUri.getPort() == 443) {
                    try {
                        requestedUri = new URI(requestedUri.getScheme(), requestedUri.getHost(), requestedUri.getPath(), requestedUri.getFragment());
                    }
                    catch (URISyntaxException e) {
                        if (!this.log.isTraceEnabled()) break block8;
                        this.log.trace("Failed to normalise URI port before looking in cache: " + requestedUri, (Throwable)e);
                    }
                }
            }
            for (URL url : this.getResources()) {
                JsonNode tree = this.getJarCache(url);
                for (JsonNode node : tree) {
                    URI uri = URI.create(node.get("Content-Location").asText());
                    if (!uri.equals(requestedUri)) continue;
                    return this.cacheEntry(requestedUri, url, node);
                }
            }
        }
        return this.delegate.getEntry(key);
    }

    private List<URL> getResources() throws IOException {
        ClassLoader cl = this.getClassLoader();
        Object key = cl == null ? NULL_CLASS_LOADER : cl;
        List<URL> newValue = (List<URL>)cachedResourceList.get(key);
        if (newValue != null) {
            return newValue;
        }
        newValue = cl != null ? Collections.unmodifiableList(Collections.list(cl.getResources(JARCACHE_JSON))) : Collections.unmodifiableList(Collections.list(ClassLoader.getSystemResources(JARCACHE_JSON)));
        List<URL> oldValue = cachedResourceList.putIfAbsent(key, newValue);
        return oldValue != null ? oldValue : newValue;
    }

    protected JsonNode getJarCache(URL url) throws IOException {
        try {
            return this.jarCaches.get(url);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to retrieve jar cache for URL: " + url, e);
        }
    }

    protected HttpCacheEntry cacheEntry(URI requestedUri, URL baseURL, JsonNode cacheNode) throws MalformedURLException, IOException {
        URL classpath = new URL(baseURL, cacheNode.get("X-Classpath").asText());
        this.log.debug("Cache hit for: {}", (Object)requestedUri);
        this.log.trace("Parsed cache entry: {}", (Object)cacheNode);
        ArrayList<BasicHeader> responseHeaders = new ArrayList<BasicHeader>();
        if (!cacheNode.has("Date")) {
            responseHeaders.add(new BasicHeader("Date", DateUtils.formatDate((Date)new Date())));
        }
        if (!cacheNode.has("Cache-Control")) {
            responseHeaders.add(new BasicHeader("Cache-Control", "max-age=2147483647"));
        }
        JarCacheResource resource = new JarCacheResource(classpath);
        Iterator fieldNames = cacheNode.fieldNames();
        while (fieldNames.hasNext()) {
            String headerName = (String)fieldNames.next();
            JsonNode header = cacheNode.get(headerName);
            if (header == null) continue;
            responseHeaders.add(new BasicHeader(headerName, header.asText()));
        }
        return new HttpCacheEntry(new Date(), new Date(), (StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"), responseHeaders.toArray(new Header[0]), (Resource)resource);
    }

    public void removeEntry(String key) throws IOException {
        this.delegate.removeEntry(key);
    }

    public void updateEntry(String key, HttpCacheUpdateCallback callback) throws IOException, HttpCacheUpdateException {
        this.delegate.updateEntry(key, callback);
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }
}

