/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingleCloseablePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;

class ShapeValidationContainer {
    private final Shape shape;
    private final boolean logValidationViolations;
    private final PlanNode planNode;
    private final ValidationExecutionLogger validationExecutionLogger;
    private final long effectiveValidationResultsLimitPerConstraint;
    private final boolean performanceLogging;
    private final Logger logger;

    public ShapeValidationContainer(Shape shape, Supplier<PlanNode> planNodeSupplier, boolean logValidationExecution, boolean logValidationViolations, long effectiveValidationResultsLimitPerConstraint, boolean performanceLogging, boolean logValidationPlans, Logger logger, ConnectionsGroup connectionsGroup) {
        this.shape = shape;
        this.logValidationViolations = logValidationViolations;
        this.effectiveValidationResultsLimitPerConstraint = effectiveValidationResultsLimitPerConstraint;
        this.performanceLogging = performanceLogging;
        this.logger = logger;
        try {
            PlanNode planNode = planNodeSupplier.get();
            if (logValidationPlans) {
                StringBuilder planAsGraphvizDot = new StringBuilder();
                planAsGraphvizDot.append("rank1 [style=invisible];\nrank2 [style=invisible];\n\nrank1 -> rank2 [color=white];\n");
                planAsGraphvizDot.append("{\n").append("\trank = same;\n").append("\trank2 -> ").append(System.identityHashCode(connectionsGroup.getBaseConnection())).append(" -> ").append(System.identityHashCode(connectionsGroup.getAddedStatements())).append(" -> ").append(System.identityHashCode(connectionsGroup.getRemovedStatements())).append(" [ style=invis ];\n").append("\trankdir = LR;\n").append("}\n");
                planAsGraphvizDot.append(System.identityHashCode(connectionsGroup.getBaseConnection())).append(" [label=\"").append("BaseConnection").append("\" fillcolor=\"#CACADB\", style=filled];").append("\n");
                planAsGraphvizDot.append(System.identityHashCode(connectionsGroup.getAddedStatements())).append(" [label=\"").append("AddedStatements").append("\" fillcolor=\"#CEDBCA\", style=filled];").append("\n");
                planAsGraphvizDot.append(System.identityHashCode(connectionsGroup.getRemovedStatements())).append(" [label=\"").append("RemovedStatements").append("\" fillcolor=\"#DBCFC9r\", style=filled];").append("\n");
                planNode.getPlanAsGraphvizDot(planAsGraphvizDot);
                String[] split = planAsGraphvizDot.toString().split("\n");
                planAsGraphvizDot = new StringBuilder();
                Arrays.stream(split).map(s -> "\t" + s + "\n").forEach(planAsGraphvizDot::append);
                logger.info("Plan as Graphviz dot:\ndigraph G {\n{}}", (Object)planAsGraphvizDot);
            }
            this.validationExecutionLogger = ValidationExecutionLogger.getInstance(logValidationExecution);
            if (!planNode.isGuaranteedEmpty()) {
                assert (planNode instanceof SingleCloseablePlanNode);
                planNode.receiveLogger(this.validationExecutionLogger);
                this.planNode = planNode;
            } else {
                this.planNode = planNode;
            }
        }
        catch (Throwable e) {
            logger.warn("Error processing SHACL Shape {}", (Object)shape.getId(), (Object)e);
            logger.warn("Error processing SHACL Shape\n{}", (Object)shape, (Object)e);
            if (e instanceof Error) {
                throw e;
            }
            throw new SailException("Error processing SHACL Shape " + shape.getId() + "\n" + shape, e);
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean hasPlanNode() {
        return !this.planNode.isGuaranteedEmpty();
    }

    public ValidationResultIterator performValidation() {
        ValidationResultIterator validationResultIterator;
        ValidationResultIterator validationResults;
        long before;
        block11: {
            before = this.getTimeStamp();
            this.handlePreLogging();
            validationResults = null;
            CloseableIteration<? extends ValidationTuple> iterator = this.planNode.iterator();
            try {
                validationResultIterator = validationResults = new ValidationResultIterator(iterator, this.effectiveValidationResultsLimitPerConstraint);
                if (iterator == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (iterator != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        this.logger.warn("Internal error while trying to validate SHACL Shape {}", (Object)this.shape.getId(), (Object)e);
                        this.logger.warn("Internal error while trying to validate SHACL Shape\n{}", (Object)this.shape, (Object)e);
                        if (e instanceof Error) {
                            throw e;
                        }
                        throw new SailException("Internal error while trying to validate SHACL Shape " + this.shape.getId() + "\n" + this.shape, e);
                    }
                }
                catch (Throwable throwable3) {
                    this.handlePostLogging(before, validationResults);
                    throw throwable3;
                }
            }
            iterator.close();
        }
        this.handlePostLogging(before, validationResults);
        return validationResultIterator;
    }

    private long getTimeStamp() {
        if (this.performanceLogging) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    private void handlePreLogging() {
        if (this.validationExecutionLogger.isEnabled()) {
            this.logger.info("Start execution of plan:\n{}\n", (Object)this.getShape().toString());
        }
    }

    private void handlePostLogging(long before, ValidationResultIterator validationResults) {
        if (this.validationExecutionLogger.isEnabled()) {
            this.validationExecutionLogger.flush();
        }
        if (validationResults != null) {
            if (this.performanceLogging) {
                long after = System.currentTimeMillis();
                this.logger.info("Execution of plan took {} ms for:\n{}\n", (Object)(after - before), (Object)this.getShape().toString());
            }
            if (this.validationExecutionLogger.isEnabled()) {
                this.logger.info("Finished execution of plan:\n{}\n", (Object)this.getShape().toString());
            }
            if (this.logValidationViolations && !validationResults.conforms()) {
                List<ValidationTuple> tuples = validationResults.getTuples();
                this.logger.info("SHACL not valid. The following experimental debug results were produced:\n\t\t{}\n\n{}\n", (Object)tuples.stream().map(ValidationTuple::toString).collect(Collectors.joining("\n\t\t")), (Object)this.getShape().toString());
            }
        }
    }
}

