/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

public class PatternIterator<S extends Statement>
implements Iterator<S> {
    private final Iterator<S> filteredIter;
    private final Value subj;
    private final Value pred;
    private final Value obj;
    private final Value[] contexts;
    private S nextElement;
    private boolean nextCalled;

    public PatternIterator(Iterator<S> iter, Value subj, Value pred, Value obj, Value ... contexts) {
        this.filteredIter = iter;
        this.subj = subj;
        this.pred = pred;
        this.obj = obj;
        this.contexts = this.notNull(contexts);
    }

    @Override
    public boolean hasNext() {
        this.findNextElement();
        return this.nextElement != null;
    }

    @Override
    public S next() {
        this.findNextElement();
        S result = this.nextElement;
        if (result != null) {
            this.nextElement = null;
            this.nextCalled = true;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNextElement() {
        while (this.nextElement == null && this.filteredIter.hasNext()) {
            Statement candidate = (Statement)this.filteredIter.next();
            if (!this.accept(candidate)) continue;
            this.nextElement = candidate;
        }
    }

    @Override
    public void remove() {
        if (!this.nextCalled) {
            throw new IllegalStateException();
        }
        this.filteredIter.remove();
    }

    protected boolean accept(S st) {
        if (this.subj != null && !this.subj.equals(st.getSubject())) {
            return false;
        }
        if (this.pred != null && !this.pred.equals(st.getPredicate())) {
            return false;
        }
        if (this.obj != null && !this.obj.equals(st.getObject())) {
            return false;
        }
        Resource stContext = st.getContext();
        if (this.contexts != null && this.contexts.length == 0) {
            return true;
        }
        for (Value context : this.notNull(this.contexts)) {
            if (context == null && stContext == null) {
                return true;
            }
            if (context == null || !context.equals(stContext)) continue;
            return true;
        }
        return false;
    }

    private Value[] notNull(Value[] contexts) {
        if (contexts == null) {
            return new Resource[]{null};
        }
        return contexts;
    }
}

