/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.factory.map.primitive.ImmutableCharObjectMapFactory;
import org.eclipse.collections.api.map.primitive.CharObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.impl.factory.primitive.CharObjectMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharObjectSingletonMap;

public enum ImmutableCharObjectMapFactoryImpl implements ImmutableCharObjectMapFactory
{
    INSTANCE;


    public <V> ImmutableCharObjectMap<V> empty() {
        return ImmutableCharObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableCharObjectMap<V> of() {
        return this.empty();
    }

    public <V> ImmutableCharObjectMap<V> with() {
        return this.empty();
    }

    public <V> ImmutableCharObjectMap<V> of(char key, V value) {
        return this.with(key, value);
    }

    public <V> ImmutableCharObjectMap<V> with(char key, V value) {
        return new ImmutableCharObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableCharObjectMap<V> ofAll(CharObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    public <V> ImmutableCharObjectMap<V> withAll(CharObjectMap<? extends V> map) {
        if (map instanceof ImmutableCharObjectMap) {
            return (ImmutableCharObjectMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            char[] array = new char[1];
            map.forEachKey((CharProcedure & Serializable)each -> {
                array[0] = each;
            });
            return new ImmutableCharObjectSingletonMap<Object>(array[0], map.get(array[0]));
        }
        return new ImmutableCharObjectHashMap<V>(map);
    }

    public <T, V> ImmutableCharObjectMap<V> from(Iterable<T> iterable, CharFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableCharObjectMap map = CharObjectMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map.toImmutable();
    }
}

