/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.tuple.primitive;

import org.eclipse.collections.api.tuple.primitive.FloatDoublePair;

public class FloatDoublePairImpl
implements FloatDoublePair {
    private static final long serialVersionUID = 1L;
    private final float one;
    private final double two;

    FloatDoublePairImpl(float newOne, double newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    public float getOne() {
        return this.one;
    }

    public double getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatDoublePair)) {
            return false;
        }
        FloatDoublePair that = (FloatDoublePair)o;
        return Float.compare(this.one, that.getOne()) == 0 && Double.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        return 29 * Float.floatToIntBits(this.one) + (int)(Double.doubleToLongBits(this.two) ^ Double.doubleToLongBits(this.two) >>> 32);
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    public int compareTo(FloatDoublePair that) {
        int i = Float.compare(this.one, that.getOne());
        if (i != 0) {
            return i;
        }
        return Double.compare(this.two, that.getTwo());
    }
}

