/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternFilter
extends FilterPlanNode {
    private static final Logger logger = LoggerFactory.getLogger(PatternFilter.class);
    private final Pattern pattern;

    public PatternFilter(PlanNode parent, Pattern pattern, ConnectionsGroup connectionsGroup) {
        super(parent, connectionsGroup);
        this.pattern = pattern;
    }

    private static Literal str(Value argValue, ValueFactory valueFactory) {
        if (argValue instanceof IRI || argValue instanceof Triple) {
            return valueFactory.createLiteral(argValue.toString());
        }
        if (argValue instanceof Literal) {
            Literal literal = (Literal)argValue;
            if (QueryEvaluationUtility.isSimpleLiteral((Literal)literal)) {
                return literal;
            }
            return valueFactory.createLiteral(literal.getLabel());
        }
        return null;
    }

    @Override
    boolean checkTuple(FilterPlanNode.Reference t) {
        Value literal = t.get().getValue();
        if ((literal = PatternFilter.str(literal, (ValueFactory)SimpleValueFactory.getInstance())) == null) {
            return false;
        }
        if (QueryEvaluationUtility.isStringLiteral((Value)literal)) {
            boolean result = this.pattern.matcher(((Literal)literal).getLabel()).find();
            if (logger.isTraceEnabled()) {
                logger.trace("PatternFilter value: \"{}\" with pattern: \"{}\" and result: {}", new Object[]{((Literal)literal).getLabel().replace("\n", "\\n").replace("\"", "\\\""), this.pattern.toString().replace("\n", "\\n").replace("\"", "\\\""), result});
            }
            return result;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("PatternFilter did not match value because value is not a string literal: {}", (Object)literal);
        }
        return false;
    }

    @Override
    public String toString() {
        return "PatternFilter{pattern=" + this.pattern + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatternFilter that = (PatternFilter)o;
        return this.pattern.equals(that.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pattern);
    }
}

