/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryLockedException;
import org.eclipse.rdf4j.sail.LockManager;
import org.eclipse.rdf4j.sail.SailLockedException;
import org.eclipse.rdf4j.sail.helpers.DirectoryLockManager;

public class LockRemover {
    public static boolean tryToRemoveLock(Repository repo, ConsoleIO consoleIO) throws RepositoryException {
        boolean lockRemoved = false;
        DirectoryLockManager lockManager = new DirectoryLockManager(repo.getDataDir());
        if (lockManager.isLocked() && consoleIO.askProceed("WARNING: The lock from another process on this repository needs to be removed", true)) {
            repo.shutDown();
            lockRemoved = lockManager.revokeLock();
            repo.init();
        }
        return lockRemoved;
    }

    public static boolean tryToRemoveLock(RepositoryLockedException rle, ConsoleIO consoleIO) {
        SailLockedException sle;
        LockManager lockManager;
        boolean lockRemoved = false;
        if (rle.getCause() instanceof SailLockedException && (lockManager = (sle = (SailLockedException)rle.getCause()).getLockManager()) != null && lockManager.isLocked() && consoleIO.askProceed("WARNING: The lock from process '" + sle.getLockedBy() + "' on this repository needs to be removed", true)) {
            lockRemoved = lockManager.revokeLock();
        }
        return lockRemoved;
    }
}

