/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.util.stream.LongStream;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableLongBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableLongEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableLongHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableLongSingletonBag;
import org.eclipse.collections.impl.factory.primitive.LongBags;

public enum ImmutableLongBagFactoryImpl implements ImmutableLongBagFactory
{
    INSTANCE;


    public ImmutableLongBag empty() {
        return ImmutableLongEmptyBag.INSTANCE;
    }

    public ImmutableLongBag of() {
        return this.empty();
    }

    public ImmutableLongBag with() {
        return this.empty();
    }

    public ImmutableLongBag of(long one) {
        return this.with(one);
    }

    public ImmutableLongBag with(long one) {
        return new ImmutableLongSingletonBag(one);
    }

    public ImmutableLongBag of(long ... items) {
        return this.with(items);
    }

    public ImmutableLongBag with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableLongHashBag.newBagWith(items);
    }

    public ImmutableLongBag ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public ImmutableLongBag withAll(LongIterable items) {
        if (items instanceof ImmutableLongBag) {
            return (ImmutableLongBag)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableLongBag ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableLongBag withAll(Iterable<Long> iterable) {
        return LongBags.mutable.withAll(iterable).toImmutable();
    }

    public ImmutableLongBag ofAll(LongStream items) {
        return this.withAll(items);
    }

    public ImmutableLongBag withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

