/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.PeekMarkIterator;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.AbstractBulkJoinPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTupleHelper;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class BulkedExternalInnerJoin
extends AbstractBulkJoinPlanNode {
    private static final Resource[] allContext = new Resource[0];
    private static final Function<BindingSet, ValidationTuple> propertyShapeScopeAllContextMapper = b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), ConstraintComponent.Scope.propertyShape, true, allContext);
    private static final Function<BindingSet, ValidationTuple> nodeShapeScopeAllContextMapper = b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), ConstraintComponent.Scope.nodeShape, true, allContext);
    private final SailConnection connection;
    private final PlanNode leftNode;
    private final Dataset dataset;
    private final Resource[] dataGraph;
    private TupleExpr parsedQuery = null;
    private final boolean skipBasedOnPreviousConnection;
    private final SailConnection previousStateConnection;
    private final String query;
    private boolean printed = false;

    public BulkedExternalInnerJoin(PlanNode leftNode, SailConnection connection, Resource[] dataGraph, SparqlFragment query, boolean skipBasedOnPreviousConnection, SailConnection previousStateConnection, Function<BindingSet, ValidationTuple> mapper, ConnectionsGroup connectionsGroup, List<StatementMatcher.Variable> vars) {
        super(vars);
        assert (!skipBasedOnPreviousConnection || previousStateConnection != null);
        this.leftNode = PlanNodeHelper.handleSorting(this, leftNode, connectionsGroup);
        this.query = query.getNamespacesForSparql() + StatementMatcher.StableRandomVariableProvider.normalize(query.getFragment(), List.of(), List.of());
        this.connection = connection;
        assert (this.connection != null);
        this.skipBasedOnPreviousConnection = skipBasedOnPreviousConnection;
        this.mapper = mapper;
        this.previousStateConnection = previousStateConnection;
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
        this.dataGraph = dataGraph;
    }

    public static Function<BindingSet, ValidationTuple> getMapper(String a, String c, ConstraintComponent.Scope scope, Resource[] dataGraph) {
        assert (a.equals("a"));
        assert (c.equals("c"));
        if (scope == ConstraintComponent.Scope.nodeShape && dataGraph.length == 0) {
            return nodeShapeScopeAllContextMapper;
        }
        if (scope == ConstraintComponent.Scope.propertyShape && dataGraph.length == 0) {
            return propertyShapeScopeAllContextMapper;
        }
        return b -> new ValidationTuple(b.getValue(a), b.getValue(c), scope, true, dataGraph);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            LinkedHashMap<Value, ValidationTuple> left;
            ArrayDeque<ValidationTuple> right;
            ArrayDeque<ValidationTuple> joined;
            private PeekMarkIterator<? extends ValidationTuple> leftNodeIterator;

            @Override
            protected void init() {
                this.left = new LinkedHashMap(3000);
                this.right = new ArrayDeque(1000);
                this.joined = new ArrayDeque(1000);
                this.leftNodeIterator = new PeekMarkIterator(BulkedExternalInnerJoin.this.leftNode.iterator());
            }

            private void calculateNext() {
                if (!this.joined.isEmpty()) {
                    return;
                }
                while (this.joined.isEmpty() && this.leftNodeIterator.hasNext()) {
                    while (this.left.size() < 1000 && this.leftNodeIterator.hasNext()) {
                        ValidationTuple next = (ValidationTuple)this.leftNodeIterator.next();
                        ValidationTuple previousValue = this.left.put(next.getActiveTarget(), next);
                        assert (previousValue == null) : "We dont support duplicates on the left side of the join";
                    }
                    if (BulkedExternalInnerJoin.this.parsedQuery == null) {
                        BulkedExternalInnerJoin.this.parsedQuery = BulkedExternalInnerJoin.this.parseQuery(BulkedExternalInnerJoin.this.query);
                    }
                    if (this.isClosed()) {
                        return;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        this.close();
                    }
                    BulkedExternalInnerJoin.this.runQuery(this.left.values(), this.right, BulkedExternalInnerJoin.this.connection, BulkedExternalInnerJoin.this.parsedQuery, BulkedExternalInnerJoin.this.dataset, BulkedExternalInnerJoin.this.dataGraph, BulkedExternalInnerJoin.this.skipBasedOnPreviousConnection, BulkedExternalInnerJoin.this.previousStateConnection);
                    while (!this.right.isEmpty()) {
                        ValidationTuple rightPeek = this.right.getLast();
                        ValidationTuple leftPeek = this.left.get(rightPeek.getActiveTarget());
                        if (leftPeek != null) {
                            this.joined.addLast(ValidationTupleHelper.join(leftPeek, rightPeek));
                            this.right.removeLast();
                            continue;
                        }
                        this.right.removeLast();
                    }
                    this.left.clear();
                }
            }

            @Override
            public void localClose() {
                if (this.leftNodeIterator != null) {
                    this.leftNodeIterator.close();
                }
            }

            @Override
            protected boolean localHasNext() {
                if (this.isClosed()) {
                    return false;
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.close();
                    return false;
                }
                this.calculateNext();
                return !this.joined.isEmpty();
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calculateNext();
                return this.joined.removeFirst();
            }
        };
    }

    @Override
    public int depth() {
        return this.leftNode.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.leftNode.getId() + " -> " + this.getId() + " [label=\"left\"]").append("\n");
        stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"right\"]").append("\n");
        if (this.skipBasedOnPreviousConnection) {
            stringBuilder.append(System.identityHashCode(this.previousStateConnection) + " -> " + this.getId() + " [label=\"skip if not present\"]").append("\n");
        }
        this.leftNode.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "BulkedExternalInnerJoin{query=" + this.query.replace("\n", "") + "}";
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.leftNode.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BulkedExternalInnerJoin that = (BulkedExternalInnerJoin)o;
        return this.skipBasedOnPreviousConnection == that.skipBasedOnPreviousConnection && Objects.equals(this.connection, that.connection) && this.leftNode.equals(that.leftNode) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.previousStateConnection, that.previousStateConnection) && this.query.equals(that.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.connection, this.dataset, this.leftNode, this.skipBasedOnPreviousConnection, this.previousStateConnection, this.query);
    }

    @Override
    public boolean producesSorted() {
        return this.leftNode.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

