/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class DecodeURL
implements Function {
    public String getURI() {
        return SPIF.DECODE_URL_FUNCTION.toString();
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length < 1 || args.length > 2) {
            throw new ValueExprEvaluationException("Incorrect number of arguments");
        }
        if (!(args[0] instanceof Literal)) {
            throw new ValueExprEvaluationException("First argument must be a string");
        }
        if (args.length == 2 && !(args[1] instanceof Literal)) {
            throw new ValueExprEvaluationException("Second argument must be a string");
        }
        Literal s = (Literal)args[0];
        try {
            Charset encoding = args.length == 2 ? Charset.forName(((Literal)args[1]).getLabel()) : StandardCharsets.UTF_8;
            return valueFactory.createLiteral(URLDecoder.decode(s.getLabel(), encoding));
        }
        catch (UnsupportedCharsetException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
    }
}

