/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerByteArray;

public class SerializerByteArrayDelta
extends SerializerByteArray {
    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        byte[][] chars;
        for (byte[] b : chars = (byte[][])vals) {
            out.packInt(b.length);
        }
        int prefixLen = SerializerByteArrayDelta.commonPrefixLen(chars);
        out.packInt(prefixLen);
        out.write(chars[0], 0, prefixLen);
        for (byte[] b : chars) {
            out.write(b, prefixLen, b.length - prefixLen);
        }
    }

    @Override
    public byte[][] valueArrayDeserialize(DataInput2 in, int size) throws IOException {
        byte[][] ret = new byte[size][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new byte[in.unpackInt()];
        }
        int prefixLen = in.unpackInt();
        in.readFully(ret[0], 0, prefixLen);
        for (int i = 1; i < ret.length; ++i) {
            System.arraycopy(ret[0], 0, ret[i], 0, prefixLen);
        }
        for (byte[] aRet : ret) {
            in.readFully(aRet, prefixLen, aRet.length - prefixLen);
        }
        return ret;
    }

    protected static int commonPrefixLen(byte[][] bytes) {
        int ret = 0;
        while (bytes[0].length != ret) {
            byte byt = bytes[0][ret];
            for (int i = 1; i < bytes.length; ++i) {
                if (bytes[i].length != ret && byt == bytes[i][ret]) continue;
                return ret;
            }
            ++ret;
        }
        return ret;
    }
}

