"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createServerBase = void 0;
const language_service_1 = require("@volar/language-service");
const snapshot_document_1 = require("@volar/snapshot-document");
const l10n = require("@vscode/l10n");
const request_light_1 = require("request-light");
const vscode = require("vscode-languageserver");
const vscode_uri_1 = require("vscode-uri");
const registerEditorFeatures_js_1 = require("./register/registerEditorFeatures.js");
const registerLanguageFeatures_js_1 = require("./register/registerLanguageFeatures.js");
const serverCapabilities_js_1 = require("./serverCapabilities.js");
const uri_js_1 = require("./uri.js");
const uriMap_js_1 = require("./utils/uriMap.js");
__exportStar(require("@volar/snapshot-document"), exports);
function createServerBase(connection, getFs) {
    let semanticTokensReq = 0;
    let documentUpdatedReq = 0;
    const didChangeWatchedFilesCallbacks = new Set();
    const didChangeConfigurationCallbacks = new Set();
    const configurations = new Map();
    const documents = new vscode.TextDocuments({
        create(uri, languageId, version, text) {
            return new snapshot_document_1.SnapshotDocument(uri, languageId, version, text);
        },
        update(snapshot, contentChanges, version) {
            snapshot.update(contentChanges, version);
            return snapshot;
        },
    });
    const uriConverter = (0, uri_js_1.createUriConverter)(documents);
    const workspaceFolders = (0, uriMap_js_1.createUriMap)();
    documents.listen(connection);
    const status = {
        connection,
        initializeParams: undefined,
        languageServicePlugins: [],
        projects: undefined,
        fs: undefined,
        semanticTokensLegend: undefined,
        pullModelDiagnostics: false,
        documents,
        uriConverter,
        workspaceFolders,
        initialize,
        initialized,
        shutdown,
        watchFiles,
        getConfiguration,
        onDidChangeConfiguration,
        onDidChangeWatchedFiles,
        clearPushDiagnostics,
        refresh,
    };
    return status;
    function initialize(initializeParams, languageServicePlugins, projects, options) {
        status.initializeParams = initializeParams;
        status.languageServicePlugins = languageServicePlugins;
        status.projects = projects;
        status.semanticTokensLegend = options?.semanticTokensLegend ?? language_service_1.standardSemanticTokensLegend;
        status.pullModelDiagnostics = options?.pullModelDiagnostics ?? false;
        status.fs = createFsWithCache(getFs(initializeParams.initializationOptions ?? {}, status.uriConverter));
        if (initializeParams.initializationOptions?.l10n) {
            l10n.config({ uri: initializeParams.initializationOptions.l10n.location });
        }
        if (initializeParams.workspaceFolders?.length) {
            for (const folder of initializeParams.workspaceFolders) {
                workspaceFolders.set(vscode_uri_1.URI.parse(folder.uri), true);
            }
        }
        else if (initializeParams.rootUri) {
            workspaceFolders.set(vscode_uri_1.URI.parse(initializeParams.rootUri), true);
        }
        else if (initializeParams.rootPath) {
            workspaceFolders.set(vscode_uri_1.URI.file(initializeParams.rootPath), true);
        }
        const result = {
            capabilities: (0, serverCapabilities_js_1.getServerCapabilities)(status),
        };
        if (!status.pullModelDiagnostics) {
            result.capabilities.diagnosticProvider = undefined;
            activateServerPushDiagnostics(projects);
        }
        (0, registerEditorFeatures_js_1.registerEditorFeatures)(status);
        (0, registerLanguageFeatures_js_1.registerLanguageFeatures)(status);
        return result;
    }
    function initialized() {
        registerWorkspaceFolderWatcher();
        registerConfigurationWatcher();
        updateHttpSettings();
        onDidChangeConfiguration(updateHttpSettings);
    }
    async function shutdown() {
        for (const project of await status.projects.all.call(status)) {
            project.dispose();
        }
    }
    async function updateHttpSettings() {
        const httpSettings = await getConfiguration('http');
        (0, request_light_1.configure)(httpSettings?.proxy, httpSettings?.proxyStrictSSL ?? false);
    }
    function getConfiguration(section, scopeUri) {
        if (!status.initializeParams?.capabilities.workspace?.configuration) {
            return Promise.resolve(undefined);
        }
        if (!scopeUri && status.initializeParams.capabilities.workspace?.didChangeConfiguration) {
            if (!configurations.has(section)) {
                configurations.set(section, getConfigurationWorker(section, scopeUri));
            }
            return configurations.get(section);
        }
        return getConfigurationWorker(section, scopeUri);
    }
    async function getConfigurationWorker(section, scopeUri) {
        return (await connection.workspace.getConfiguration({ scopeUri, section })) ?? undefined /* replace null to undefined */;
    }
    function onDidChangeConfiguration(cb) {
        didChangeConfigurationCallbacks.add(cb);
        return {
            dispose() {
                didChangeConfigurationCallbacks.delete(cb);
            },
        };
    }
    function onDidChangeWatchedFiles(cb) {
        didChangeWatchedFilesCallbacks.add(cb);
        return {
            dispose: () => {
                didChangeWatchedFilesCallbacks.delete(cb);
            },
        };
    }
    function createFsWithCache(fs) {
        const readFileCache = new Map();
        const statCache = new Map();
        const readDirectoryCache = new Map();
        onDidChangeWatchedFiles(({ changes }) => {
            for (const change of changes) {
                if (change.type === vscode.FileChangeType.Deleted) {
                    readFileCache.set(change.uri, undefined);
                    statCache.set(change.uri, undefined);
                    const dir = change.uri.substring(0, change.uri.lastIndexOf('/'));
                    readDirectoryCache.delete(dir);
                }
                else if (change.type === vscode.FileChangeType.Changed) {
                    readFileCache.delete(change.uri);
                    statCache.delete(change.uri);
                }
                else if (change.type === vscode.FileChangeType.Created) {
                    readFileCache.delete(change.uri);
                    statCache.delete(change.uri);
                    const dir = change.uri.substring(0, change.uri.lastIndexOf('/'));
                    readDirectoryCache.delete(dir);
                }
            }
        });
        return {
            readFile: uri => {
                if (!readFileCache.has(uri)) {
                    readFileCache.set(uri, fs.readFile(uri));
                }
                return readFileCache.get(uri);
            },
            stat: uri => {
                if (!statCache.has(uri)) {
                    statCache.set(uri, fs.stat(uri));
                }
                return statCache.get(uri);
            },
            readDirectory: uri => {
                if (!readDirectoryCache.has(uri)) {
                    readDirectoryCache.set(uri, fs.readDirectory(uri));
                }
                return readDirectoryCache.get(uri);
            },
        };
    }
    function registerConfigurationWatcher() {
        const didChangeConfiguration = status.initializeParams?.capabilities.workspace?.didChangeConfiguration;
        if (didChangeConfiguration) {
            connection.onDidChangeConfiguration(params => {
                configurations.clear();
                for (const cb of didChangeConfigurationCallbacks) {
                    cb(params);
                }
            });
            if (didChangeConfiguration.dynamicRegistration) {
                connection.client.register(vscode.DidChangeConfigurationNotification.type);
            }
        }
    }
    function watchFiles(patterns) {
        const didChangeWatchedFiles = status.initializeParams?.capabilities.workspace?.didChangeWatchedFiles;
        const fileOperations = status.initializeParams?.capabilities.workspace?.fileOperations;
        if (didChangeWatchedFiles) {
            connection.onDidChangeWatchedFiles(e => {
                for (const cb of didChangeWatchedFilesCallbacks) {
                    cb(e);
                }
            });
            if (didChangeWatchedFiles.dynamicRegistration) {
                connection.client.register(vscode.DidChangeWatchedFilesNotification.type, {
                    watchers: patterns.map(pattern => ({ globPattern: pattern })),
                });
            }
        }
        if (fileOperations?.dynamicRegistration && fileOperations.willRename) {
            connection.client.register(vscode.WillRenameFilesRequest.type, {
                filters: patterns.map(pattern => ({ pattern: { glob: pattern } })),
            });
        }
    }
    function registerWorkspaceFolderWatcher() {
        if (status.initializeParams?.capabilities.workspace?.workspaceFolders) {
            connection.workspace.onDidChangeWorkspaceFolders(e => {
                for (const folder of e.added) {
                    workspaceFolders.set(vscode_uri_1.URI.parse(folder.uri), true);
                }
                for (const folder of e.removed) {
                    workspaceFolders.delete(vscode_uri_1.URI.parse(folder.uri));
                }
                status.projects.reload.call(status);
            });
        }
    }
    function activateServerPushDiagnostics(projects) {
        documents.onDidChangeContent(({ document }) => {
            pushAllDiagnostics(projects, document.uri);
        });
        documents.onDidClose(({ document }) => {
            connection.sendDiagnostics({ uri: document.uri, diagnostics: [] });
        });
        onDidChangeConfiguration(() => refresh(projects));
    }
    function clearPushDiagnostics() {
        if (!status.pullModelDiagnostics) {
            for (const document of documents.all()) {
                connection.sendDiagnostics({ uri: document.uri, diagnostics: [] });
            }
        }
    }
    async function refresh(projects) {
        const req = ++semanticTokensReq;
        if (!status.pullModelDiagnostics) {
            await pushAllDiagnostics(projects);
        }
        const delay = 250;
        await sleep(delay);
        if (req === semanticTokensReq) {
            if (status.initializeParams?.capabilities.workspace?.semanticTokens?.refreshSupport) {
                connection.languages.semanticTokens.refresh();
            }
            if (status.initializeParams?.capabilities.workspace?.inlayHint?.refreshSupport) {
                connection.languages.inlayHint.refresh();
            }
            if (status.pullModelDiagnostics && status.initializeParams?.capabilities.workspace?.diagnostics?.refreshSupport) {
                connection.languages.diagnostics.refresh();
            }
        }
    }
    async function pushAllDiagnostics(projects, docUri) {
        const req = ++documentUpdatedReq;
        const delay = 250;
        const token = {
            get isCancellationRequested() {
                return req !== documentUpdatedReq;
            },
            onCancellationRequested: vscode.Event.None,
        };
        const changeDoc = docUri ? documents.get(docUri) : undefined;
        const otherDocs = [...documents.all()].filter(doc => doc !== changeDoc);
        if (changeDoc) {
            await sleep(delay);
            if (token.isCancellationRequested) {
                return;
            }
            await pushDiagnostics(projects, changeDoc.uri, changeDoc.version, token);
        }
        for (const doc of otherDocs) {
            await sleep(delay);
            if (token.isCancellationRequested) {
                break;
            }
            await pushDiagnostics(projects, doc.uri, doc.version, token);
        }
    }
    async function pushDiagnostics(projects, uri, version, cancel) {
        const languageService = (await projects.get.call(status, uri)).getLanguageService();
        const errors = await languageService.doValidation(uri, cancel, result => {
            connection.sendDiagnostics({ uri: uri, diagnostics: result, version });
        });
        connection.sendDiagnostics({ uri: uri, diagnostics: errors, version });
    }
}
exports.createServerBase = createServerBase;
function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
//# sourceMappingURL=server.js.map