import type * as html from 'vscode-html-languageservice';
export { PugDocument } from './pugDocument';
export * from './baseParse';
export interface LanguageService extends ReturnType<typeof getLanguageService> {
}
export declare function getLanguageService(htmlLs: html.LanguageService): {
    parsePugDocument: (pugCode: string) => {
        htmlTextDocument: html.TextDocument;
        htmlDocument: html.HTMLDocument;
        map: import("@volar/language-service").SourceMapWithDocuments<any>;
        htmlCode: string;
        mappings: import("@volar/language-service").Mapping<any>[];
        pugTextDocument: html.TextDocument;
        error: {
            code: string;
            msg: string;
            line: number;
            column: number;
            filename: string;
        } | undefined;
        ast: import("./baseParse").Node | undefined;
        emptyLineEnds: number[];
    };
    doComplete: (pugDoc: import("./pugDocument").PugDocument, pos: html.Position, serviceContext: import("@volar/language-service").ServiceContext, documentContext: html.DocumentContext | undefined, options?: html.CompletionConfiguration | undefined) => Promise<html.CompletionList | undefined>;
    findDocumentHighlights: (pugDoc: import("./pugDocument").PugDocument, pos: html.Position) => html.DocumentHighlight[] | undefined;
    findDocumentLinks: (pugDoc: import("./pugDocument").PugDocument, docContext: html.DocumentContext) => html.DocumentLink[];
    doHover: (pugDoc: import("./pugDocument").PugDocument, pos: html.Position, options?: html.HoverSettings | undefined) => html.Hover | undefined;
    createScanner: (pugDoc: import("./pugDocument").PugDocument, initialOffset?: number) => html.Scanner | undefined;
    getSelectionRanges: (pugDoc: import("./pugDocument").PugDocument, posArr: html.Position[]) => html.SelectionRange[];
    doQuoteComplete: (pugDoc: import("./pugDocument").PugDocument, pos: html.Position, options?: html.CompletionConfiguration | undefined) => string | null | undefined;
    getFoldingRanges: (pugDoc: import("./pugDocument").PugDocument) => html.FoldingRange[];
};
//# sourceMappingURL=languageService.d.ts.map