/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.consumer.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxy;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;

public class RemoteServiceHolder<T> {
    private Class<T> rsClass;
    private T serviceInstance;

    public boolean equals(Object o) {
        if (!(o instanceof RemoteServiceHolder)) {
            return false;
        }
        RemoteServiceHolder other = (RemoteServiceHolder)o;
        return this.rsClass.equals(other.rsClass) && this.serviceInstance.equals(other.serviceInstance);
    }

    public int hashCode() {
        return this.serviceInstance.hashCode() ^ this.getClass().hashCode();
    }

    public RemoteServiceHolder(Class<T> clazz, T service) {
        this.rsClass = clazz;
        Assert.isTrue((boolean)RemoteServiceHolder.isRemoteServiceProxy(service));
        this.serviceInstance = service;
    }

    public static boolean isRemoteServiceProxy(Object service) {
        return service instanceof IRemoteServiceProxy;
    }

    public Class<T> getServiceClass() {
        return this.rsClass;
    }

    public T getRemoteService() {
        return this.serviceInstance;
    }

    public IRemoteServiceReference getRemoteServiceReference() {
        return ((IRemoteServiceProxy)this.getRemoteService()).getRemoteServiceReference();
    }

    public boolean isActive() {
        return this.getRemoteServiceReference().isActive();
    }

    public ID getLocalContainerID() {
        return this.getRemoteServiceReference().getContainerID();
    }

    public IRemoteServiceID getRemoteServiceID() {
        return this.getRemoteServiceReference().getID();
    }

    public ID getRemoteContainerID() {
        return this.getRemoteServiceID().getContainerID();
    }

    public long getRemoteServiceId() {
        return this.getRemoteServiceID().getContainerRelativeID();
    }
}

