/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.consumer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.mgmt.consumer.util.IRemoteServiceListener;
import org.eclipse.ecf.mgmt.consumer.util.IRemoteServiceNotifier;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceEvent;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceHolder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true)
public class RemoteServiceNotifier
implements IRemoteServiceNotifier {
    private Map<ID, List<RemoteServiceHolder<?>>> map;
    private Map<IRemoteServiceListener, Class<?>> listeners;
    private Object lock = new Object();

    @Activate
    protected void activate() throws Exception {
        this.map = new HashMap();
        this.listeners = new HashMap();
    }

    @Deactivate
    protected void deactivate() {
        if (this.map != null) {
            this.map.clear();
            this.map = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void addServiceHolder(RemoteServiceHolder<T> holder) {
        HashMap lcopy = null;
        ID remoteID = holder.getRemoteContainerID();
        Object object = this.lock;
        synchronized (object) {
            List<RemoteServiceHolder<Object>> holderList = null;
            for (ID id : this.map.keySet()) {
                if (!remoteID.equals((Object)id)) continue;
                holderList = this.map.get(id);
                break;
            }
            if (holderList == null) {
                holderList = new ArrayList<RemoteServiceHolder<T>>();
            }
            holderList.add(holder);
            this.map.put(remoteID, holderList);
            lcopy = new HashMap(this.listeners);
        }
        this.fireRemoteServicesEvent(lcopy, 1, holder);
    }

    @Override
    public <T> boolean addServiceHolder(Class<T> clazz, T service) {
        if (RemoteServiceHolder.isRemoteServiceProxy(service)) {
            this.addServiceHolder(new RemoteServiceHolder<T>(clazz, service));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean removeServiceHolder(RemoteServiceHolder<T> holder) {
        HashMap lcopy = null;
        ID remoteID = holder.getRemoteContainerID();
        boolean removed = false;
        Object object = this.lock;
        synchronized (object) {
            List<RemoteServiceHolder<?>> holderList = null;
            Iterator<ID> i = this.map.keySet().iterator();
            while (i.hasNext()) {
                ID next = i.next();
                if (remoteID.equals((Object)next)) {
                    holderList = this.map.get(next);
                }
                if (holderList != null) {
                    holderList.remove(holder);
                    removed = true;
                }
                if (holderList.size() == 0) {
                    i.remove();
                }
                holderList = new ArrayList();
                lcopy = new HashMap(this.listeners);
            }
        }
        if (removed) {
            this.fireRemoteServicesEvent(lcopy, 2, holder);
        }
        return removed;
    }

    @Override
    public <T> boolean removeServiceHolder(Class<T> clazz, T service) {
        if (RemoteServiceHolder.isRemoteServiceProxy(service)) {
            return this.removeServiceHolder(new RemoteServiceHolder<T>(clazz, service));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Collection<RemoteServiceHolder<T>> addListener(IRemoteServiceListener l, Class<T> clazz) {
        ArrayList<RemoteServiceHolder<T>> results = new ArrayList<RemoteServiceHolder<T>>();
        Object object = this.lock;
        synchronized (object) {
            this.listeners.put(l, clazz);
            for (List<RemoteServiceHolder<?>> hl : this.map.values()) {
                for (RemoteServiceHolder<?> rsh : hl) {
                    if (!rsh.getServiceClass().equals(clazz)) continue;
                    results.add(rsh);
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IRemoteServiceListener l) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(l);
        }
    }

    protected void logException(String message, Throwable t) {
        if (message != null) {
            System.out.println(message);
        }
        if (t != null) {
            t.printStackTrace();
        }
    }

    protected <T> void fireRemoteServicesEvent(Map<IRemoteServiceListener, Class<?>> lcopy, final int type, final RemoteServiceHolder<T> holder) {
        Class<T> clazz = holder.getServiceClass();
        for (final IRemoteServiceListener l : lcopy.keySet()) {
            if (!clazz.equals(lcopy.get(l))) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    RemoteServiceNotifier.this.logException("Exception in IRemoteServiceListener", exception);
                }

                public void run() throws Exception {
                    l.handleEvent(new RemoteServiceEvent(type, holder));
                }
            });
        }
    }
}

