/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EcfTcpConnectDialog
extends Dialog {
    private static final int RESET_ID = 22;
    private Text hostnameField;
    private Text portField;
    private String hostnameDefault;
    private String portDefault;
    private String title;
    private String hostname;
    private String port;

    public EcfTcpConnectDialog(Shell parentShell, String title, String hostnameDefault, String portDefault) {
        super(parentShell);
        this.hostnameDefault = hostnameDefault == null ? "" : hostnameDefault;
        this.portDefault = portDefault == null ? "" : portDefault;
        this.title = title;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 2;
        Label hostnameLabel = new Label(comp, 131072);
        hostnameLabel.setText("Hostname: ");
        this.hostnameField = new Text(comp, 4);
        this.hostnameField.setText(this.hostnameDefault);
        Label portLabel = new Label(comp, 131072);
        portLabel.setText("Port: ");
        this.portField = new Text(comp, 4);
        GridData data = new GridData(768);
        this.portField.setLayoutData((Object)data);
        this.portField.setText(this.portDefault);
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 22, "Reset All", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 22) {
            this.hostnameField.setText(this.hostnameDefault);
            this.portField.setText(this.portDefault);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.hostname = this.hostnameField.getText();
        this.port = this.portField.getText();
        super.okPressed();
    }

    public String getHostname() {
        if (this.hostname == null || "".equals(this.hostname)) {
            return null;
        }
        return this.hostname;
    }

    public String getPort() {
        if (this.port == null || "".equals(this.port)) {
            return null;
        }
        return this.port;
    }
}

