/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui;

import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.mgmt.consumer.util.IRemoteServiceNotifier;
import org.eclipse.ecf.mgmt.framework.IBundleEventHandler;
import org.eclipse.ecf.mgmt.framework.IBundleManagerAsync;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.BundleEventHandler;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.ICallbackRegistrar;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.IImportableServiceCallbackAssociator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
public class RemoteBundleManagerComponent {
    private static RemoteBundleManagerComponent instance;
    private IImportableServiceCallbackAssociator importer;
    private IRemoteServiceNotifier notifier;

    public static RemoteBundleManagerComponent getInstance() {
        return instance;
    }

    public RemoteBundleManagerComponent() {
        instance = this;
    }

    @Reference
    void bindCallbackAssociator(IImportableServiceCallbackAssociator ca) {
        this.importer = ca;
    }

    void unbindCallbackAssociator(IImportableServiceCallbackAssociator ca) {
        this.importer = null;
    }

    @Reference
    void bindNotifier(IRemoteServiceNotifier n) {
        this.notifier = n;
    }

    void unbindNotifier(IRemoteServiceNotifier n) {
        this.notifier = null;
    }

    public IRemoteServiceNotifier getNotifier() {
        return this.notifier;
    }

    @Activate
    public void activate(final BundleContext context) throws Exception {
        this.importer.associateCallbackRegistrar(IBundleManagerAsync.class, new ICallbackRegistrar(){

            public ServiceRegistration<?> registerCallback(RemoteServiceAdmin.ImportReference importReference) throws Exception {
                return context.registerService(IBundleEventHandler.class, (Object)new BundleEventHandler(importReference), null);
            }
        });
    }

    @Deactivate
    public void deactivate() {
        this.importer.unassociateCallbackRegistrar(IBundleManagerAsync.class);
        this.importer = null;
        this.notifier = null;
        instance = null;
    }

    public IContainer getContainerForID(ID id) {
        return this.importer == null ? null : this.importer.getContainerConnectedToID(id);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    void bindBundleManagerAsync(IBundleManagerAsync bm) {
        this.notifier.addServiceHolder(IBundleManagerAsync.class, (Object)bm);
    }

    void unbindBundleManagerAsync(IBundleManagerAsync bm) {
        this.notifier.removeServiceHolder(IBundleManagerAsync.class, (Object)bm);
    }
}

