/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui;

import org.eclipse.ecf.mgmt.consumer.util.IRemoteServiceNotifier;
import org.eclipse.ecf.mgmt.framework.IServiceEventHandler;
import org.eclipse.ecf.mgmt.framework.IServiceManagerAsync;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.ServiceEventHandler;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.ICallbackRegistrar;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.callback.IImportableServiceCallbackAssociator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
public class RemoteServiceManagerComponent {
    private static RemoteServiceManagerComponent instance;
    private IImportableServiceCallbackAssociator importer;
    private IRemoteServiceNotifier notifier;

    public static RemoteServiceManagerComponent getInstance() {
        return instance;
    }

    public RemoteServiceManagerComponent() {
        instance = this;
    }

    @Reference
    void bindCallbackAssociator(IImportableServiceCallbackAssociator ca) {
        this.importer = ca;
    }

    void unbindCallbackAssociator(IImportableServiceCallbackAssociator ca) {
        this.importer = null;
    }

    @Reference
    void bindNotifier(IRemoteServiceNotifier n) {
        this.notifier = n;
    }

    void unbindNotifier(IRemoteServiceNotifier n) {
        this.notifier = null;
    }

    public IRemoteServiceNotifier getNotifier() {
        return this.notifier;
    }

    @Activate
    public void activate(final BundleContext context) throws Exception {
        this.importer.associateCallbackRegistrar(IServiceManagerAsync.class, new ICallbackRegistrar(){

            public ServiceRegistration<?> registerCallback(RemoteServiceAdmin.ImportReference importReference) throws Exception {
                return context.registerService(IServiceEventHandler.class, (Object)new ServiceEventHandler(importReference), null);
            }
        });
    }

    @Deactivate
    public void deactivate() {
        this.importer.unassociateCallbackRegistrar(IServiceManagerAsync.class);
        this.importer = null;
        this.notifier = null;
        instance = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    void bindServicesManagerAsync(IServiceManagerAsync sm) {
        this.notifier.addServiceHolder(IServiceManagerAsync.class, (Object)sm);
    }

    void unbindServicesManagerAsync(IServiceManagerAsync sm) {
        this.notifier.removeServiceHolder(IServiceManagerAsync.class, (Object)sm);
    }
}

