/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.mgmt.framework.IServiceEventHandler;
import org.eclipse.ecf.mgmt.framework.ServiceEventMTO;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.IServiceEventHandlerDelegate;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;

public class ServiceEventHandler
implements IServiceEventHandler {
    private static Map<IRemoteServiceID, IServiceEventHandlerDelegate> sehs = new HashMap<IRemoteServiceID, IServiceEventHandlerDelegate>();
    private ID containerID;
    private long rsid;

    public ServiceEventHandler(RemoteServiceAdmin.ImportReference importReference) {
        this.containerID = importReference.getContainerID();
        this.rsid = importReference.getRemoteServiceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDelegate(IRemoteServiceID rsID, IServiceEventHandlerDelegate delegate) {
        Map<IRemoteServiceID, IServiceEventHandlerDelegate> map = sehs;
        synchronized (map) {
            sehs.put(rsID, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDelegate(IRemoteServiceID rsID) {
        Map<IRemoteServiceID, IServiceEventHandlerDelegate> map = sehs;
        synchronized (map) {
            sehs.remove(rsID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDelegates() {
        Map<IRemoteServiceID, IServiceEventHandlerDelegate> map = sehs;
        synchronized (map) {
            sehs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleServiceEvent(ServiceEventMTO serviceEvent) {
        IRemoteServiceID rsID = null;
        IServiceEventHandlerDelegate seh = null;
        Map<IRemoteServiceID, IServiceEventHandlerDelegate> map = sehs;
        synchronized (map) {
            for (IRemoteServiceID rsid : sehs.keySet()) {
                if (!rsid.getContainerID().equals((Object)this.containerID) || rsid.getContainerRelativeID() != this.rsid) continue;
                rsID = rsid;
                seh = sehs.get(rsID);
                break;
            }
        }
        if (seh != null) {
            seh.handleServiceEvent(rsID, serviceEvent);
        } else {
            System.out.println("RECEIVED serviceEvent=" + serviceEvent);
        }
    }
}

