/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui.services;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.mgmt.consumer.util.IRemoteServiceListener;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceEvent;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceHolder;
import org.eclipse.ecf.mgmt.framework.BundleEventMTO;
import org.eclipse.ecf.mgmt.framework.BundleMTO;
import org.eclipse.ecf.mgmt.framework.IBundleManagerAsync;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.Activator;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.BundleEventHandler;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.EcfTcpConnectDialog;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.IBundleEventHandlerDelegate;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.MqttConnectDialog;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.RemoteBundleManagerComponent;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.RemoteServiceManagerComponent;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.services.model.RemoteBundleManagerContentProvider;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.services.model.RemoteBundleManagerNode;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.services.model.RemoteBundleManagerRootNode;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.ui.bundleview.AbstractBundlesView;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.AbstractBundlesNode;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.BundleNode;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.BundlesContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;

public class RemoteBundlesView
extends AbstractBundlesView {
    public static final String VIEW_ID = "org.eclipse.ecf.mgmt.framework.eclipse.ui.RemoteBundlesView";
    private Action refreshAction;
    private Action mqttConnectAction;
    private Action ecftcpConnectAction;
    private Action disconnectAction;
    private List<RemoteServiceAdmin.ImportRegistration> regs = Collections.synchronizedList(new ArrayList());
    private IRemoteServiceListener rsListener = new IRemoteServiceListener(){

        public void handleEvent(RemoteServiceEvent e) {
            TreeViewer v = RemoteBundlesView.this.getTreeViewer();
            if (v != null && !v.getControl().isDisposed()) {
                int type = e.getType();
                RemoteServiceHolder h = e.getRemoteServiceHolder(IBundleManagerAsync.class);
                if (type == 1) {
                    RemoteBundlesView.this.addRemoteBundleManager((IBundleManagerAsync)h.getRemoteService(), h.getRemoteServiceReference());
                } else if (type == 2) {
                    RemoteBundlesView.this.removeRemoteBundleManager(h.getRemoteServiceReference());
                }
            }
        }
    };

    void showException(final String title, final String message, final Throwable e) {
        Shell s;
        IViewSite vs = this.getViewSite();
        if (vs != null && (s = vs.getShell()) != null) {
            s.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (e instanceof CompletionException) {
                        Throwable t = e.getCause().getCause();
                        StringWriter sw = new StringWriter();
                        t.printStackTrace(new PrintWriter(sw));
                        String trace = sw.toString();
                        ArrayList<Status> childStatuses = new ArrayList<Status>();
                        String[] stringArray = trace.split(System.getProperty("line.separator"));
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            childStatuses.add(new Status(4, "org.eclipse.ecf.mgmt.framework.eclipse.ui", line));
                            ++n2;
                        }
                        ErrorDialog.openError((Shell)s, (String)title, (String)message, (IStatus)new MultiStatus("org.eclipse.ecf.mgmt.framework.eclipse.ui", 4, (IStatus[])childStatuses.toArray(new Status[0]), t.getLocalizedMessage(), t));
                    } else {
                        ErrorDialog.openError((Shell)s, (String)title, (String)message, (IStatus)new Status(4, "org.eclipse.ecf.mgmt.framework.eclipse.ui", e.getLocalizedMessage()));
                    }
                }
            });
        }
    }

    protected void makeActions() {
        super.makeActions();
        this.refreshAction = new Action(){

            public void run() {
                RemoteBundleManagerNode node = RemoteBundlesView.this.getSelectedRSManagerNode();
                if (node != null) {
                    RemoteBundlesView.this.refresh(node);
                }
            }
        };
        this.refreshAction.setText("Refresh");
        this.mqttConnectAction = new Action(){

            public void run() {
                MqttConnectDialog d = new MqttConnectDialog(RemoteBundlesView.this.getViewSite().getShell(), "Connect to MQTT Broker", "tcp://iot.eclipse.org:1883/kura/remoteservices");
                if (d.open() == 0) {
                    final String brokerUrl = d.getBrokerUrl();
                    final String username = d.getUsername();
                    final String password = d.getPassword();
                    CompletableFuture.supplyAsync(new Supplier<Collection<RemoteServiceAdmin.ImportRegistration>>(){

                        @Override
                        public Collection<RemoteServiceAdmin.ImportRegistration> get() {
                            ArrayList<RemoteServiceAdmin.ImportRegistration> results = new ArrayList<RemoteServiceAdmin.ImportRegistration>();
                            EndpointDescription[] eds = null;
                            try {
                                EndpointDescription[] endpointDescriptionArray = eds = Activator.getDefault().getEndpointDescriptions("/edef/bundlemanager.mqtt.xml");
                                int n = eds.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    RemoteServiceAdmin.ImportRegistration reg;
                                    Throwable t;
                                    EndpointDescription ed = endpointDescriptionArray[n2];
                                    HashMap<String, String> props = new HashMap<String, String>(ed.getProperties());
                                    props.put("ecf.endpoint.id", brokerUrl);
                                    if (username != null && password != null) {
                                        props.put("ecf.jms.mqtt.client.username", username);
                                        props.put("ecf.jms.mqtt.client.password", password);
                                    }
                                    if ((t = (reg = (RemoteServiceAdmin.ImportRegistration)RemoteBundlesView.this.getRSA().importService((org.osgi.service.remoteserviceadmin.EndpointDescription)new EndpointDescription(props))).getException()) != null) {
                                        results.forEach(r -> r.close());
                                        throw t;
                                    }
                                    results.add(reg);
                                    ++n2;
                                }
                            }
                            catch (Throwable t) {
                                throw new RuntimeException("Exception importing BundleManager", t);
                            }
                            return results;
                        }
                    }).whenComplete((irs, e) -> {
                        if (e != null) {
                            RemoteBundlesView.this.showException("MQTT BundleManager Import Error", "MQTT BundleManager Import Error", (Throwable)e);
                        } else {
                            RemoteBundlesView.this.regs.addAll(irs);
                        }
                    });
                }
            }
        };
        this.mqttConnectAction.setText("Add Remote BundleManager via MQTT");
        this.mqttConnectAction.setToolTipText("Add Remote BundleManager via MQTT");
        this.mqttConnectAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.ecftcpConnectAction = new Action(){

            public void run() {
                EcfTcpConnectDialog d = new EcfTcpConnectDialog(RemoteBundlesView.this.getViewSite().getShell(), "Connect via ECFTCP", "localhost", "3289");
                if (d.open() == 0) {
                    final String hostname = d.getHostname();
                    final String port = d.getPort();
                    CompletableFuture.supplyAsync(new Supplier<Collection<RemoteServiceAdmin.ImportRegistration>>(){

                        @Override
                        public Collection<RemoteServiceAdmin.ImportRegistration> get() {
                            ArrayList<RemoteServiceAdmin.ImportRegistration> results = new ArrayList<RemoteServiceAdmin.ImportRegistration>();
                            EndpointDescription[] eds = null;
                            try {
                                EndpointDescription[] endpointDescriptionArray = eds = Activator.getDefault().getEndpointDescriptions("/edef/bundlemanager.xml");
                                int n = eds.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    EndpointDescription ed = endpointDescriptionArray[n2];
                                    HashMap<String, String> props = new HashMap<String, String>(ed.getProperties());
                                    props.put("ecf.endpoint.id", "ecftcp://" + hostname + ":" + port + "/server");
                                    RemoteServiceAdmin.ImportRegistration reg = (RemoteServiceAdmin.ImportRegistration)RemoteBundlesView.this.getRSA().importService((org.osgi.service.remoteserviceadmin.EndpointDescription)new EndpointDescription(props));
                                    if (reg == null) {
                                        throw new NullPointerException("Import registration returned is null");
                                    }
                                    Throwable t = reg.getException();
                                    if (t != null) {
                                        results.forEach(r -> r.close());
                                        throw t;
                                    }
                                    results.add(reg);
                                    ++n2;
                                }
                            }
                            catch (Throwable t) {
                                throw new RuntimeException("Exception importing BundleManager", t);
                            }
                            return results;
                        }
                    }).whenComplete((irs, e) -> {
                        if (e != null) {
                            RemoteBundlesView.this.showException("Import Error", "ECFTCP BundleManager Import Error", (Throwable)e);
                        } else {
                            RemoteBundlesView.this.regs.addAll(irs);
                        }
                    });
                }
            }
        };
        this.ecftcpConnectAction.setText("Add Remote BundleManager via ECFTCP");
        this.ecftcpConnectAction.setToolTipText("Add RemoteBundle Manager via ECFTCP");
        this.ecftcpConnectAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().add((IAction)this.mqttConnectAction);
        bars.getToolBarManager().add((IAction)this.mqttConnectAction);
        bars.getMenuManager().add((IAction)this.ecftcpConnectAction);
        bars.getToolBarManager().add((IAction)this.ecftcpConnectAction);
        this.disconnectAction = new Action(){

            public void run() {
                RemoteBundleManagerNode node = RemoteBundlesView.this.getSelectedRSManagerNode();
                if (node != null) {
                    RemoteBundlesView.this.disconnect(node);
                }
            }
        };
        this.disconnectAction.setText("Disconnect");
    }

    private RemoteServiceAdmin getRSA() {
        return Activator.getDefault().getRSA();
    }

    protected void fillContextMenu(IMenuManager manager) {
        Object e;
        super.fillContextMenu(manager);
        ITreeSelection selection = (ITreeSelection)this.getTreeViewer().getSelection();
        if (selection != null && (e = selection.getFirstElement()) instanceof RemoteBundleManagerNode) {
            manager.add((IAction)this.refreshAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.disconnectAction);
        }
    }

    private RemoteBundleManagerNode getSelectedRSManagerNode() {
        AbstractBundlesNode aNode = this.getSelectedNode();
        return aNode == null ? null : (aNode instanceof RemoteBundleManagerNode ? (RemoteBundleManagerNode)aNode : null);
    }

    protected BundlesContentProvider createContentProvider(IViewSite viewSite) {
        return new RemoteBundleManagerContentProvider(viewSite);
    }

    public void dispose() {
        this.regs.forEach(reg -> reg.close());
        BundleEventHandler.removeDelegates();
        RemoteServiceManagerComponent.getInstance().getNotifier().removeListener(this.rsListener);
        super.dispose();
    }

    RemoteBundleManagerRootNode getRootNode() {
        return (RemoteBundleManagerRootNode)this.getContentProvider().getBundlesRoot();
    }

    protected void removeRemoteBundleManager(final IRemoteServiceReference rsRef) {
        BundleEventHandler.removeDelegate(rsRef.getID());
        final TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RemoteBundlesView.this.getRootNode().removeBundleManagerNode(rsRef);
                viewer.refresh();
            }
        });
    }

    void addRemoteBundleManager(IBundleManagerAsync s, IRemoteServiceReference rsRef) {
        BundleEventHandler.addDelegate(rsRef.getID(), new BundleEventHandlerDelegate());
        this.updateRemoteBundleManager(s, rsRef, null);
    }

    private void updateRemoteBundleManager(IBundleManagerAsync s, IRemoteServiceReference rsRef, RemoteBundleManagerNode node) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        s.getBundlesAsync().whenComplete((result, exception) -> viewer.getControl().getDisplay().asyncExec(new Runnable((Throwable)exception, rsRef, node, s, (BundleMTO[])result, viewer){
            private final /* synthetic */ Throwable val$exception;
            private final /* synthetic */ IRemoteServiceReference val$rsRef;
            private final /* synthetic */ RemoteBundleManagerNode val$node;
            private final /* synthetic */ IBundleManagerAsync val$s;
            private final /* synthetic */ BundleMTO[] val$result;
            private final /* synthetic */ TreeViewer val$viewer;
            {
                this.val$exception = throwable;
                this.val$rsRef = iRemoteServiceReference;
                this.val$node = remoteBundleManagerNode;
                this.val$s = iBundleManagerAsync;
                this.val$result = bundleMTOArray;
                this.val$viewer = treeViewer;
            }

            @Override
            public void run() {
                if (this.val$exception != null) {
                    RemoteBundlesView.this.logAndShowError("Exception using remote service reference=" + this.val$rsRef, this.val$exception);
                } else {
                    RemoteBundleManagerNode managerNode = this.val$node == null ? RemoteBundlesView.this.getRootNode().getBundleManagerNode(this.val$rsRef, this.val$s) : this.val$node;
                    managerNode.clearChildren();
                    BundleMTO[] bundleMTOArray = this.val$result;
                    int n = this.val$result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BundleMTO bMTO = bundleMTOArray[n2];
                        managerNode.addChild((AbstractBundlesNode)RemoteBundlesView.this.createBundleNode(bMTO.getId(), bMTO.getLastModified(), bMTO.getState(), bMTO.getSymbolicName(), bMTO.getVersion(), bMTO.getManifest(), bMTO.getLocation()));
                        ++n2;
                    }
                    this.val$viewer.expandToLevel(2);
                    this.val$viewer.refresh();
                }
            }
        }));
    }

    void refresh(RemoteBundleManagerNode managerNode) {
        this.updateRemoteBundleManager(managerNode.getBundleManager(), managerNode.getBundleManagerRef(), managerNode);
    }

    void disconnect(RemoteBundleManagerNode managerNode) {
        IRemoteServiceReference rsRef = managerNode.getBundleManagerRef();
        IRemoteServiceID rsID = rsRef.getID();
        RemoteServiceAdmin.ImportRegistration importReg = null;
        Iterator<RemoteServiceAdmin.ImportRegistration> i = this.regs.iterator();
        while (i.hasNext()) {
            ID remoteContainerID;
            EndpointDescription ed;
            RemoteServiceAdmin.ImportReference imRef;
            RemoteServiceAdmin.ImportRegistration reg = i.next();
            if (reg.getException() != null || (imRef = (RemoteServiceAdmin.ImportReference)reg.getImportReference()) == null || (ed = (EndpointDescription)imRef.getImportedEndpoint()) == null || (remoteContainerID = ed.getContainerID()) == null || !remoteContainerID.equals((Object)rsID.getContainerID())) continue;
            importReg = reg;
            i.remove();
        }
        if (importReg != null) {
            try {
                importReg.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IContainer c = RemoteBundleManagerComponent.getInstance().getContainerForID(rsID.getContainerID());
            if (c != null) {
                try {
                    c.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void initializeBundles() {
        Collection existing = RemoteBundleManagerComponent.getInstance().getNotifier().addListener(this.rsListener, IBundleManagerAsync.class);
        for (RemoteServiceHolder rh : existing) {
            this.addRemoteBundleManager((IBundleManagerAsync)rh.getRemoteService(), rh.getRemoteServiceReference());
        }
    }

    private RemoteBundleManagerNode findRemoteBundleManagerForBundleNode(BundleNode bn) {
        AbstractBundlesNode abn = bn.getParent();
        return abn instanceof RemoteBundleManagerNode ? (RemoteBundleManagerNode)abn : null;
    }

    protected void stopBundlesAction(BundleNode[] bns) {
        if (bns.length > 0) {
            int i = 0;
            while (i < bns.length) {
                boolean last = i == bns.length - 1;
                RemoteBundleManagerNode rbn = this.findRemoteBundleManagerForBundleNode(bns[0]);
                if (rbn != null) {
                    rbn.getBundleManager().stopAsync(bns[i].getId()).whenComplete((status, exception) -> {
                        if (exception != null) {
                            System.out.println("Remote transport error: " + exception.getMessage());
                            exception.printStackTrace();
                        } else if (!status.isOK()) {
                            System.out.println("Remote error: " + status.getMessage());
                            Throwable t = status.getException();
                            if (t != null) {
                                t.printStackTrace();
                            }
                        } else if (last) {
                            this.refresh(rbn);
                        }
                    });
                }
                ++i;
            }
        }
    }

    protected void startBundlesAction(BundleNode[] bns) {
        if (bns.length > 0) {
            int i = 0;
            while (i < bns.length) {
                boolean last = i == bns.length - 1;
                RemoteBundleManagerNode rbn = this.findRemoteBundleManagerForBundleNode(bns[0]);
                if (rbn != null) {
                    rbn.getBundleManager().startAsync(bns[i].getId()).whenComplete((status, exception) -> {
                        if (exception != null) {
                            System.out.println("Remote error");
                            exception.printStackTrace();
                        } else if (!status.isOK()) {
                            System.out.println("Remote status error: " + status.getMessage());
                        } else if (last) {
                            this.refresh(rbn);
                        }
                    });
                }
                ++i;
            }
        }
    }

    protected void uninstallBundlesAction(BundleNode[] bns) {
        if (bns.length > 0) {
            int i = 0;
            while (i < bns.length) {
                boolean last = i == bns.length - 1;
                RemoteBundleManagerNode rbn = this.findRemoteBundleManagerForBundleNode(bns[0]);
                if (rbn != null) {
                    rbn.getBundleManager().uninstallBundleAsync(bns[i].getId()).whenComplete((status, exception) -> {
                        if (exception != null) {
                            System.out.println("Remote error");
                            exception.printStackTrace();
                        } else if (!status.isOK()) {
                            System.out.println("Remote status error: " + status.getMessage());
                        } else if (last) {
                            this.refresh(rbn);
                        }
                    });
                }
                ++i;
            }
        }
    }

    class BundleEventHandlerDelegate
    implements IBundleEventHandlerDelegate {
        BundleEventHandlerDelegate() {
        }

        @Override
        public void handleBundleEvent(final IRemoteServiceID rsID, final BundleEventMTO bundleEvent) {
            final TreeViewer v = RemoteBundlesView.this.getTreeViewer();
            if (v != null && !v.getControl().isDisposed()) {
                v.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RemoteBundleManagerNode managerNode = RemoteBundlesView.this.getRootNode().getBundleManagerNode(rsID);
                        if (managerNode != null) {
                            long bundleId = bundleEvent.getBundleId();
                            BundleNode bundleNode = managerNode.getBundleNode(bundleId);
                            BundleMTO bMTO = bundleEvent.getBundleMTO();
                            if (bundleNode != null) {
                                managerNode.removeChild((AbstractBundlesNode)bundleNode);
                            }
                            if (bMTO.getState() != 1) {
                                managerNode.addChild((AbstractBundlesNode)RemoteBundlesView.this.createBundleNode(bMTO.getId(), bMTO.getLastModified(), bMTO.getState(), bMTO.getSymbolicName(), bMTO.getVersion(), bMTO.getManifest(), bMTO.getLocation()));
                            }
                            v.expandToLevel(2);
                            v.refresh();
                        }
                    }
                });
            }
        }
    }
}

