/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.eclipse.ui.services;

import java.util.Collection;
import org.eclipse.ecf.mgmt.consumer.util.IRemoteServiceListener;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceEvent;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceHolder;
import org.eclipse.ecf.mgmt.framework.IServiceManagerAsync;
import org.eclipse.ecf.mgmt.framework.ServiceEventMTO;
import org.eclipse.ecf.mgmt.framework.ServiceReferenceMTO;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.IServiceEventHandlerDelegate;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.RemoteServiceManagerComponent;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.ServiceEventHandler;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.services.model.RemoteServiceManagerContentProvider;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.services.model.RemoteServiceManagerNode;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.services.model.RemoteServiceManagerRootNode;
import org.eclipse.ecf.mgmt.framework.eclipse.ui.services.model.RemoteServiceNode;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.ui.serviceview.AbstractServicesView;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.AbstractServicesContentProvider;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.AbstractServicesNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.RegisteringBundleIdNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.ServiceNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.ServicesContentProvider;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.UsingBundleIdsNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewSite;

public class RemoteServicesView
extends AbstractServicesView {
    public static final String VIEW_ID = "org.eclipse.ecf.mgmt.framework.eclipse.ui.RemoteServicesView";
    private Action refreshAction;
    private IRemoteServiceListener rsListener = new IRemoteServiceListener(){

        public void handleEvent(RemoteServiceEvent e) {
            int type = e.getType();
            RemoteServiceHolder h = e.getRemoteServiceHolder(IServiceManagerAsync.class);
            if (type == 1) {
                RemoteServicesView.this.addRemoteServiceManager((IServiceManagerAsync)h.getRemoteService(), h.getRemoteServiceReference());
            } else if (type == 2) {
                RemoteServicesView.this.removeRemoteServiceManager(h.getRemoteServiceReference());
            }
        }
    };

    protected void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                RemoteServiceManagerNode node = RemoteServicesView.this.getSelectedRSManagerNode();
                if (node != null) {
                    RemoteServicesView.this.refresh(node);
                }
            }
        };
        this.refreshAction.setText("Refresh remote OSGi services");
    }

    protected void fillContextMenu(IMenuManager manager) {
        Object e;
        ITreeSelection selection = (ITreeSelection)this.getTreeViewer().getSelection();
        if (selection != null && (e = selection.getFirstElement()) instanceof RemoteServiceManagerNode) {
            manager.add((IAction)this.refreshAction);
        }
    }

    private RemoteServiceManagerNode getSelectedRSManagerNode() {
        AbstractServicesNode aNode = this.getSelectedNode();
        return aNode == null ? null : (aNode instanceof RemoteServiceManagerNode ? (RemoteServiceManagerNode)aNode : null);
    }

    protected ServicesContentProvider createContentProvider(IViewSite viewSite) {
        return new RemoteServiceManagerContentProvider(viewSite);
    }

    public void dispose() {
        ServiceEventHandler.removeDelegates();
        RemoteServiceManagerComponent.getInstance().getNotifier().removeListener(this.rsListener);
        super.dispose();
    }

    RemoteServiceManagerRootNode getRootNode() {
        AbstractServicesContentProvider c = this.getContentProvider();
        return c == null ? null : (RemoteServiceManagerRootNode)c.getServicesRoot();
    }

    protected void removeRemoteServiceManager(final IRemoteServiceReference rsRef) {
        ServiceEventHandler.removeDelegate(rsRef.getID());
        final TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RemoteServicesView.this.getRootNode().removeServiceManagerNode(rsRef);
                viewer.refresh();
            }
        });
    }

    void addRemoteServiceManager(IServiceManagerAsync s, IRemoteServiceReference rsRef) {
        ServiceEventHandler.addDelegate(rsRef.getID(), new ServiceEventHandlerDelegate());
        this.updateRemoteServiceManager(s, rsRef, null);
    }

    private void updateRemoteServiceManager(IServiceManagerAsync s, IRemoteServiceReference rsRef, RemoteServiceManagerNode node) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        s.getServiceReferencesAsync().whenComplete((result, exception) -> viewer.getControl().getDisplay().asyncExec(new Runnable((Throwable)exception, rsRef, node, s, (ServiceReferenceMTO[])result, viewer){
            private final /* synthetic */ Throwable val$exception;
            private final /* synthetic */ IRemoteServiceReference val$rsRef;
            private final /* synthetic */ RemoteServiceManagerNode val$node;
            private final /* synthetic */ IServiceManagerAsync val$s;
            private final /* synthetic */ ServiceReferenceMTO[] val$result;
            private final /* synthetic */ TreeViewer val$viewer;
            {
                this.val$exception = throwable;
                this.val$rsRef = iRemoteServiceReference;
                this.val$node = remoteServiceManagerNode;
                this.val$s = iServiceManagerAsync;
                this.val$result = serviceReferenceMTOArray;
                this.val$viewer = treeViewer;
            }

            @Override
            public void run() {
                if (this.val$exception != null) {
                    RemoteServicesView.this.logAndShowError("Exception using remote service reference=" + this.val$rsRef, this.val$exception);
                } else {
                    RemoteServiceManagerNode managerNode = this.val$node == null ? RemoteServicesView.this.getRootNode().getServiceManagerNode(this.val$rsRef, this.val$s) : this.val$node;
                    managerNode.clearChildren();
                    ServiceReferenceMTO[] serviceReferenceMTOArray = this.val$result;
                    int n = this.val$result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ServiceReferenceMTO srMTO = serviceReferenceMTOArray[n2];
                        managerNode.addChild((AbstractServicesNode)RemoteServicesView.this.createServiceNode(srMTO));
                        ++n2;
                    }
                    this.val$viewer.expandToLevel(2);
                    this.val$viewer.refresh();
                }
            }
        }));
    }

    ServiceNode createServiceNode(ServiceReferenceMTO srMTO) {
        long bundleId = srMTO.getBundle();
        long[] usingBundleIds = srMTO.getUsingBundles();
        RemoteServiceNode sn = new RemoteServiceNode(bundleId, usingBundleIds, srMTO.getProperties(), srMTO.getExportImportMode());
        sn.addChild((AbstractServicesNode)new RegisteringBundleIdNode(bundleId));
        sn.addChild((AbstractServicesNode)new UsingBundleIdsNode("Using Bundles", usingBundleIds));
        return sn;
    }

    void refresh(RemoteServiceManagerNode rsManagerNode) {
        this.updateRemoteServiceManager(rsManagerNode.getRemoteServiceManager(), rsManagerNode.getRemoteServiceReference(), rsManagerNode);
    }

    protected void initializeServices() {
        Collection existing = RemoteServiceManagerComponent.getInstance().getNotifier().addListener(this.rsListener, IServiceManagerAsync.class);
        for (RemoteServiceHolder rh : existing) {
            this.addRemoteServiceManager((IServiceManagerAsync)rh.getRemoteService(), rh.getRemoteServiceReference());
        }
    }

    class ServiceEventHandlerDelegate
    implements IServiceEventHandlerDelegate {
        ServiceEventHandlerDelegate() {
        }

        @Override
        public void handleServiceEvent(final IRemoteServiceID rsID, final ServiceEventMTO serviceEvent) {
            final TreeViewer v = RemoteServicesView.this.getTreeViewer();
            if (v != null && !v.getControl().isDisposed()) {
                v.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RemoteServiceManagerRootNode rootNode = RemoteServicesView.this.getRootNode();
                        if (rootNode == null) {
                            return;
                        }
                        RemoteServiceManagerNode managerNode = rootNode.getServiceManagerNode(rsID);
                        if (managerNode != null) {
                            ServiceReferenceMTO srMTO = serviceEvent.getServiceReferenceMTO();
                            ServiceNode serviceNode = managerNode.getServiceNode(srMTO.getId());
                            if (serviceNode != null) {
                                managerNode.removeChild((AbstractServicesNode)serviceNode);
                            }
                            if (serviceEvent.getType() != 4) {
                                managerNode.addChild((AbstractServicesNode)RemoteServicesView.this.createServiceNode(srMTO));
                            }
                            v.expandToLevel(2);
                            v.refresh();
                        }
                    }
                });
            }
        }
    }
}

