/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.karaf.features.eclipse.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.mgmt.karaf.features.FeatureEventMTO;
import org.eclipse.ecf.mgmt.karaf.features.FeatureInstallEventHandler;
import org.eclipse.ecf.mgmt.karaf.features.RepositoryEventMTO;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.FeaturesInstallerHandler;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;

public class KarafFeaturesListener
implements FeatureInstallEventHandler {
    private static Map<IRemoteServiceID, FeaturesInstallerHandler> behs = new HashMap<IRemoteServiceID, FeaturesInstallerHandler>();
    private ID containerID;
    private long rsid;

    public KarafFeaturesListener(RemoteServiceAdmin.ImportReference importReference) {
        this.containerID = importReference.getContainerID();
        this.rsid = importReference.getRemoteServiceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDelegate(IRemoteServiceID rsID, FeaturesInstallerHandler delegate) {
        Map<IRemoteServiceID, FeaturesInstallerHandler> map = behs;
        synchronized (map) {
            behs.put(rsID, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDelegate(IRemoteServiceID rsID) {
        Map<IRemoteServiceID, FeaturesInstallerHandler> map = behs;
        synchronized (map) {
            behs.remove(rsID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDelegates() {
        Map<IRemoteServiceID, FeaturesInstallerHandler> map = behs;
        synchronized (map) {
            behs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFeatureEvent(FeatureEventMTO event) {
        IRemoteServiceID rsID = null;
        FeaturesInstallerHandler beh = null;
        Map<IRemoteServiceID, FeaturesInstallerHandler> map = behs;
        synchronized (map) {
            for (IRemoteServiceID rsid : behs.keySet()) {
                if (!rsid.getContainerID().equals((Object)this.containerID) || rsid.getContainerRelativeID() != this.rsid) continue;
                rsID = rsid;
                beh = behs.get(rsID);
                break;
            }
        }
        if (beh != null) {
            beh.handleFeatureEvent(rsID, event);
        } else {
            System.out.println("RECEIVED featureEvent=" + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRepoEvent(RepositoryEventMTO event) {
        IRemoteServiceID rsID = null;
        FeaturesInstallerHandler beh = null;
        Map<IRemoteServiceID, FeaturesInstallerHandler> map = behs;
        synchronized (map) {
            for (IRemoteServiceID rsid : behs.keySet()) {
                if (!rsid.getContainerID().equals((Object)this.containerID) || rsid.getContainerRelativeID() != this.rsid) continue;
                rsID = rsid;
                beh = behs.get(rsID);
                break;
            }
        }
        if (beh != null) {
            beh.handleRepoEvent(rsID, event);
        } else {
            System.out.println("RECEIVED repoEvent=" + event);
        }
    }
}

