/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.mgmt.consumer.util.IRemoteServiceListener;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceEvent;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceHolder;
import org.eclipse.ecf.mgmt.karaf.features.FeatureEventMTO;
import org.eclipse.ecf.mgmt.karaf.features.FeatureInstallManagerAsync;
import org.eclipse.ecf.mgmt.karaf.features.FeatureMTO;
import org.eclipse.ecf.mgmt.karaf.features.RepositoryEventMTO;
import org.eclipse.ecf.mgmt.karaf.features.RepositoryMTO;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.Activator;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.FeaturesFilteredTree;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.FeaturesInstallerHandler;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.KarafFeaturesListener;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.RemoteKarafFeaturesInstaller;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.AbstractFeaturesNode;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.FeatureNode;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.FeaturesContentProvider;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.FeaturesNode;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.FeaturesRootNode;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.RepositoryNode;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public class FeaturesInstallerView
extends ViewPart {
    public static final String ID_VIEW = "org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.FeaturesInstallerView";
    private TreeViewer viewer;
    private FeaturesContentProvider contentProvider;
    private FeaturesFilteredTree filteredTree;
    private Action refreshAction;
    private Action disconnectAction;
    private Action addRepoAction;
    private Action removeRepoAction;
    private Action installFeatureAction;
    private Action uninstallFeatureAction;
    private IRemoteServiceListener rsListener = new IRemoteServiceListener(){

        public void handleEvent(RemoteServiceEvent e) {
            int type = e.getType();
            RemoteServiceHolder h = e.getRemoteServiceHolder(FeatureInstallManagerAsync.class);
            if (type == 1) {
                FeaturesInstallerView.this.addRemoteKarafFeaturesInstaller((FeatureInstallManagerAsync)h.getRemoteService(), h.getRemoteServiceReference());
            } else if (type == 2) {
                FeaturesInstallerView.this.removeRemoteKarafFeaturesInstaller(h.getRemoteServiceReference());
            }
        }
    };
    private static final String REPOSITORY_URLS = "REPOSITORY_URLS";
    List<String> repos = new ArrayList<String>();

    protected void fillContextMenu(IMenuManager manager) {
        ITreeSelection selection = (ITreeSelection)this.getTreeViewer().getSelection();
        if (selection != null) {
            Object e = selection.getFirstElement();
            if (e instanceof FeaturesNode) {
                manager.add((IAction)this.addRepoAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.refreshAction);
                manager.add((IAction)this.disconnectAction);
            } else if (e instanceof RepositoryNode) {
                manager.add((IAction)this.removeRepoAction);
            } else if (e instanceof FeatureNode) {
                FeatureNode fn = (FeatureNode)e;
                if (!fn.isInstalled()) {
                    manager.add((IAction)this.installFeatureAction);
                } else {
                    manager.add((IAction)this.uninstallFeatureAction);
                }
            }
        }
    }

    protected void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                FeaturesNode node = FeaturesInstallerView.this.getSelectedFeaturesNode();
                if (node != null) {
                    FeaturesInstallerView.this.refresh(node);
                }
            }
        };
        this.refreshAction.setText("Refresh");
        this.disconnectAction = new Action(){

            public void run() {
                FeaturesNode node = FeaturesInstallerView.this.getSelectedFeaturesNode();
                if (node != null) {
                    FeaturesInstallerView.this.disconnect(node);
                }
            }
        };
        this.disconnectAction.setText("Disconnect");
        this.addRepoAction = new Action(){

            public void run() {
                FeaturesNode node = FeaturesInstallerView.this.getSelectedFeaturesNode();
                if (node != null) {
                    FeaturesInstallerView.this.addRepo(node);
                }
            }
        };
        this.addRepoAction.setText("Add Repo...");
        this.removeRepoAction = new Action(){

            public void run() {
                RepositoryNode node = FeaturesInstallerView.this.getSelectedRepositoryNode();
                if (node != null) {
                    FeaturesInstallerView.this.removeRepo(node);
                }
            }
        };
        this.removeRepoAction.setText("Remove Repo...");
        this.installFeatureAction = new Action(){

            public void run() {
                FeatureNode node = FeaturesInstallerView.this.getSelectedFeatureNode();
                if (node != null) {
                    FeaturesInstallerView.this.installFeature(node);
                }
            }
        };
        this.installFeatureAction.setText("Install...");
        this.uninstallFeatureAction = new Action(){

            public void run() {
                FeatureNode node = FeaturesInstallerView.this.getSelectedFeatureNode();
                if (node != null) {
                    FeaturesInstallerView.this.uninstallFeature(node);
                }
            }
        };
        this.uninstallFeatureAction.setText("Uninstall...");
    }

    void installFeature(FeatureNode node) {
        FeaturesNode managerNode = (FeaturesNode)node.getParent().getParent();
        if (MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)"Install Feature", (String)("Install feature '" + node.getId() + "'?"))) {
            managerNode.getKarafFeaturesInstaller().installFeatureAsync(node.getName(), node.getVersion()).whenComplete((v, exception) -> {
                if (exception != null) {
                    this.logAndShowError("Remote Karaf Feature Installer could not install feature " + node.getId(), (Throwable)exception);
                }
            });
        }
    }

    void uninstallFeature(FeatureNode node) {
        FeaturesNode managerNode = (FeaturesNode)node.getParent().getParent();
        if (MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)"Uninstall Feature", (String)("Uninstall feature '" + node.getId() + "'?"))) {
            managerNode.getKarafFeaturesInstaller().uninstallFeatureAsync(node.getName(), node.getVersion()).whenComplete((v, exception) -> {
                if (exception != null) {
                    this.logAndShowError("Remote Karaf Feature Installer could not uninstall feature " + node.getId(), (Throwable)exception);
                }
            });
        }
    }

    void removeRepo(RepositoryNode repoNode) {
        FeaturesNode managerNode = (FeaturesNode)repoNode.getParent();
        if (MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)"Remove Repository", (String)("Remove repository named '" + repoNode.getName() + "'?"))) {
            managerNode.getKarafFeaturesInstaller().removeRepositoryAsync(repoNode.getUri(), false).whenComplete((v, exception) -> {
                if (exception != null) {
                    this.logAndShowError("Remote Karaf Feature Installer could not remove repo " + repoNode.getUri(), (Throwable)exception);
                }
            });
        }
    }

    void addRepo(FeaturesNode managerNode) {
        String value;
        InputDialog id = new InputDialog(this.viewer.getControl().getShell(), "Add Repository", "Enter repository URL", "", new IInputValidator(){

            public String isValid(String newText) {
                if ("".equals(newText)) {
                    return null;
                }
                try {
                    URI.create(newText);
                }
                catch (Exception e) {
                    return "Malformed URI: " + e.getMessage();
                }
                return null;
            }
        });
        int i = id.open();
        if (i == 0 && !"".equals(value = id.getValue())) {
            if (!value.endsWith(".xml")) {
                value = String.valueOf(value) + ".xml";
            }
            String uriString = value;
            URI u = null;
            try {
                u = URI.create(uriString);
            }
            catch (Exception exception2) {}
            URI uri = u;
            managerNode.getKarafFeaturesInstaller().addRepositoryAsync(uri).whenComplete((v, exception) -> {
                if (exception != null) {
                    this.logAndShowError("Remote Karaf Feature Installer could not add repo " + uri, (Throwable)exception);
                }
            });
        }
    }

    void disconnect(FeaturesNode managerNode) {
        IRemoteServiceReference rsRef = managerNode.getKarafFeaturesInstallerRef();
        IRemoteServiceID rsID = rsRef.getID();
        IContainer c = RemoteKarafFeaturesInstaller.getInstance().getContainerForID(rsID.getContainerID());
        if (c != null) {
            try {
                c.disconnect();
            }
            catch (Exception e) {
                this.logAndShowError("Remote Karaf Feature Install could not connect using reference " + rsRef, e);
            }
        }
    }

    private FeaturesNode getSelectedFeaturesNode() {
        AbstractFeaturesNode aNode = this.getSelectedNode();
        return aNode == null ? null : (aNode instanceof FeaturesNode ? (FeaturesNode)aNode : null);
    }

    private RepositoryNode getSelectedRepositoryNode() {
        AbstractFeaturesNode aNode = this.getSelectedNode();
        return aNode == null ? null : (aNode instanceof RepositoryNode ? (RepositoryNode)aNode : null);
    }

    private FeatureNode getSelectedFeatureNode() {
        AbstractFeaturesNode aNode = this.getSelectedNode();
        return aNode == null ? null : (aNode instanceof FeatureNode ? (FeatureNode)aNode : null);
    }

    protected void log(int level, String message, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(level, "org.eclipse.ecf.mgmt.karaf.features.eclipse.ui", message, e));
    }

    protected void logWarning(String message, Throwable e) {
        this.log(2, message, e);
    }

    protected void logError(String message, Throwable e) {
        this.log(4, message, e);
    }

    protected void logAndShowError(final String message, Throwable exception) {
        Throwable t;
        Throwable throwable = t = exception instanceof InvocationTargetException ? exception.getCause() : exception;
        if (t != null) {
            this.logError(message, t);
            if (this.viewer != null) {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FeaturesInstallerView.this.viewer != null) {
                            MessageDialog.openInformation((Shell)FeaturesInstallerView.this.viewer.getControl().getShell(), (String)"Remote Karaf Feature Install Error", (String)(String.valueOf(message) + "\n\nSee Error Log for details and stack trace"));
                            try {
                                FeaturesInstallerView.this.getSite().getWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
                            }
                            catch (Exception exception) {}
                        }
                    }
                });
            }
        }
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FeaturesInstallerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.contentProvider = this.createContentProvider(this.getViewSite());
        this.viewer = this.createTreeViewer(composite);
        this.makeActions();
        this.hookContextMenu();
        Collection existing = RemoteKarafFeaturesInstaller.getInstance().getNotifier().addListener(this.rsListener, FeatureInstallManagerAsync.class);
        for (RemoteServiceHolder rh : existing) {
            this.addRemoteKarafFeaturesInstaller((FeatureInstallManagerAsync)rh.getRemoteService(), rh.getRemoteServiceReference());
        }
    }

    public void setFocus() {
        Text filterText;
        FilteredTree filteredTree = this.getFilteredTree();
        if (filteredTree != null && (filterText = filteredTree.getFilterControl()) != null) {
            filterText.setFocus();
        }
    }

    void addRemoteKarafFeaturesInstaller(FeatureInstallManagerAsync s, IRemoteServiceReference rsRef) {
        KarafFeaturesListener.addDelegate(rsRef.getID(), new FeaturesInstallerHandlerDelegate());
        this.update(s, rsRef, null);
    }

    protected void removeRemoteKarafFeaturesInstaller(final IRemoteServiceReference rsRef) {
        KarafFeaturesListener.removeDelegate(rsRef.getID());
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer v = FeaturesInstallerView.this.getTreeViewer();
                if (v == null) {
                    return;
                }
                FeaturesRootNode frn = FeaturesInstallerView.this.getKarafFeaturesInstallerRoot();
                if (frn != null) {
                    frn.removeFeaturesInstallerNode(rsRef);
                    v.refresh();
                }
            }
        });
    }

    private void update(FeatureInstallManagerAsync s, IRemoteServiceReference rsRef, FeaturesNode node) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        s.listRepositoriesAsync().whenComplete((result, exception) -> viewer.getControl().getDisplay().asyncExec(new Runnable((Throwable)exception, rsRef, node, s, (RepositoryMTO[])result, viewer){
            private final /* synthetic */ Throwable val$exception;
            private final /* synthetic */ IRemoteServiceReference val$rsRef;
            private final /* synthetic */ FeaturesNode val$node;
            private final /* synthetic */ FeatureInstallManagerAsync val$s;
            private final /* synthetic */ RepositoryMTO[] val$result;
            private final /* synthetic */ TreeViewer val$viewer;
            {
                this.val$exception = throwable;
                this.val$rsRef = iRemoteServiceReference;
                this.val$node = featuresNode;
                this.val$s = featureInstallManagerAsync;
                this.val$result = repositoryMTOArray;
                this.val$viewer = treeViewer;
            }

            @Override
            public void run() {
                if (this.val$exception != null) {
                    FeaturesInstallerView.this.logAndShowError("Exception using remote service reference=" + this.val$rsRef, this.val$exception);
                } else {
                    FeaturesNode managerNode = this.val$node == null ? FeaturesInstallerView.this.getKarafFeaturesInstallerRoot().getFeaturesNode(this.val$rsRef, this.val$s) : this.val$node;
                    managerNode.clearChildren();
                    RepositoryMTO[] repositoryMTOArray = this.val$result;
                    int n = this.val$result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RepositoryMTO srMTO = repositoryMTOArray[n2];
                        managerNode.addChild(new RepositoryNode(srMTO));
                        ++n2;
                    }
                    this.val$viewer.expandToLevel(2);
                    this.val$viewer.refresh();
                }
            }
        }));
    }

    void refresh(FeaturesNode rsManagerNode) {
        this.update(rsManagerNode.getKarafFeaturesInstaller(), rsManagerNode.getKarafFeaturesInstallerRef(), rsManagerNode);
    }

    public void dispose() {
        super.dispose();
        RemoteKarafFeaturesInstaller.getInstance().getNotifier().removeListener(this.rsListener);
        KarafFeaturesListener.removeDelegates();
        this.viewer = null;
        this.contentProvider = null;
    }

    protected TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected FilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.filteredTree = this.createFilteredTree(composite, 768, new PatternFilter());
        TreeViewer viewer = this.filteredTree.getViewer();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.setUseHashlookup(true);
        viewer.setInput((Object)this.getViewSite());
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof FeatureNode && e2 instanceof FeatureNode) {
                    return ((FeatureNode)e1).getName().compareTo(((FeatureNode)e2).getName());
                }
                if (e1 instanceof RepositoryNode && e2 instanceof RepositoryNode) {
                    return ((RepositoryNode)e1).getUri().compareTo(((RepositoryNode)e2).getUri());
                }
                return 0;
            }
        });
        this.getViewSite().setSelectionProvider((ISelectionProvider)viewer);
        return viewer;
    }

    FeaturesFilteredTree createFilteredTree(Composite parent, int options, PatternFilter filter) {
        FeaturesFilteredTree result = new FeaturesFilteredTree(this, parent, options, filter);
        result.setBackground(parent.getDisplay().getSystemColor(25));
        GridData gd = new GridData(1808);
        result.setLayoutData(gd);
        return result;
    }

    protected FeaturesContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected FeaturesContentProvider createContentProvider(IViewSite viewSite) {
        return new FeaturesContentProvider(viewSite);
    }

    protected FeatureNode findFeatureNode(String featureId) {
        AbstractFeaturesNode[] features;
        FeaturesRootNode frn = this.getKarafFeaturesInstallerRoot();
        if (frn == null) {
            return null;
        }
        AbstractFeaturesNode[] abstractFeaturesNodeArray = features = frn.getChildren();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureNode sn;
            AbstractFeaturesNode afn = abstractFeaturesNodeArray[n2];
            if (afn instanceof FeatureNode && featureId.equals((sn = (FeatureNode)afn).getId())) {
                return sn;
            }
            ++n2;
        }
        return null;
    }

    protected FeaturesRootNode getKarafFeaturesInstallerRoot() {
        FeaturesContentProvider fcp = this.getContentProvider();
        if (fcp == null) {
            return null;
        }
        return fcp.getKarafFeaturesInstallerRoot();
    }

    protected Tree getUndisposedTree() {
        if (this.viewer == null || this.viewer.getTree() == null || this.viewer.getTree().isDisposed()) {
            return null;
        }
        return this.viewer.getTree();
    }

    protected AbstractFeaturesNode getSelectedNode() {
        return (AbstractFeaturesNode)((ITreeSelection)this.viewer.getSelection()).getFirstElement();
    }

    public void selectFeature(String remoteId, final String featureId) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer tv = FeaturesInstallerView.this.getTreeViewer();
                if (tv == null) {
                    return;
                }
                FeatureNode sn = FeaturesInstallerView.this.findFeatureNode(featureId);
                if (sn != null) {
                    tv.setSelection((ISelection)new StructuredSelection((Object)sn));
                }
            }
        });
    }

    protected void addServiceNodes(final Collection<FeatureNode> sns) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer tv = FeaturesInstallerView.this.getTreeViewer();
                if (tv == null) {
                    return;
                }
                FeaturesRootNode srn = FeaturesInstallerView.this.getKarafFeaturesInstallerRoot();
                if (srn != null) {
                    for (FeatureNode sn : sns) {
                        srn.addChild(sn);
                    }
                    tv.setExpandedState((Object)FeaturesInstallerView.this.getKarafFeaturesInstallerRoot(), true);
                    tv.refresh();
                }
            }
        });
    }

    public void updateTitle() {
        this.setContentDescription(this.getTitleSummary());
    }

    protected String getTitleSummary() {
        Tree tree = this.getUndisposedTree();
        String type = "services";
        FeaturesRootNode frn = this.getKarafFeaturesInstallerRoot();
        if (frn != null) {
            int total = frn.getChildren().length;
            if (tree == null) {
                return NLS.bind((String)"Filter matched {0} of {1} {2}.", (Object[])new String[]{"0", "0", type});
            }
            return NLS.bind((String)"Filter matched {0} of {1} {2}.", (Object[])new String[]{Integer.toString(tree.getItemCount()), Integer.toString(total), type});
        }
        return "";
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String s;
        super.init(site, memento);
        if (memento != null && (s = memento.getString(REPOSITORY_URLS)) != null && !"".equals(s)) {
            String[] strs;
            String[] stringArray = strs = s.split(",");
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                this.repos.add(str);
                ++n2;
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        StringBuffer buf = new StringBuffer();
        Iterator<String> i = this.repos.iterator();
        while (i.hasNext()) {
            String s = i.next();
            buf.append(s);
            if (!i.hasNext()) continue;
            buf.append(",");
        }
        memento.putString(REPOSITORY_URLS, buf.toString());
    }

    class FeaturesInstallerHandlerDelegate
    implements FeaturesInstallerHandler {
        FeaturesInstallerHandlerDelegate() {
        }

        @Override
        public void handleFeatureEvent(final IRemoteServiceID rsID, final FeatureEventMTO featureEvent) {
            this.runUi(new Runnable(){

                @Override
                public void run() {
                    FeatureNode featureNode;
                    FeatureMTO fMTO;
                    TreeViewer v = FeaturesInstallerView.this.getTreeViewer();
                    if (v == null) {
                        return;
                    }
                    FeaturesNode managerNode = FeaturesInstallerView.this.getKarafFeaturesInstallerRoot().getFeaturesNode(rsID);
                    if (managerNode != null && (fMTO = featureEvent.getFeatureMTO()) != null && (featureNode = managerNode.getFeatureNode(fMTO.getId())) != null) {
                        RepositoryNode rn = (RepositoryNode)featureNode.getParent();
                        if (rn != null) {
                            rn.removeChild(featureNode);
                        }
                        rn.addChild(new FeatureNode(fMTO));
                    }
                    v.refresh();
                }
            });
        }

        private void runUi(Runnable r) {
            TreeViewer v = FeaturesInstallerView.this.getTreeViewer();
            if (v != null && !v.getControl().isDisposed()) {
                v.getControl().getDisplay().asyncExec(r);
            }
        }

        @Override
        public void handleRepoEvent(final IRemoteServiceID rsID, final RepositoryEventMTO repoEvent) {
            this.runUi(new Runnable(){

                @Override
                public void run() {
                    TreeViewer v = FeaturesInstallerView.this.getTreeViewer();
                    if (v == null) {
                        return;
                    }
                    FeaturesNode managerNode = FeaturesInstallerView.this.getKarafFeaturesInstallerRoot().getFeaturesNode(rsID);
                    if (managerNode != null) {
                        RepositoryMTO rMTO = repoEvent.getRepositoryMTO();
                        if (rMTO != null) {
                            RepositoryNode repoNode = managerNode.getRepositoryNode(rMTO.getUri());
                            if (repoNode != null) {
                                managerNode.removeChild(repoNode);
                            }
                            if (repoEvent.getType() != 2) {
                                managerNode.addChild(new RepositoryNode(rMTO));
                            }
                        }
                        v.refresh();
                    }
                }
            });
        }
    }
}

