/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model;

import java.net.URI;
import org.eclipse.ecf.mgmt.karaf.features.FeatureInstallManagerAsync;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.AbstractFeaturesNode;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.FeatureNode;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.RepositoryNode;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;

public class FeaturesNode
extends AbstractFeaturesNode {
    private final IRemoteServiceReference managerRef;
    private final FeatureInstallManagerAsync rsaManager;

    public FeaturesNode(IRemoteServiceReference managerRef, FeatureInstallManagerAsync rsaManager) {
        this.managerRef = managerRef;
        this.rsaManager = rsaManager;
    }

    public FeatureInstallManagerAsync getKarafFeaturesInstaller() {
        return this.rsaManager;
    }

    public IRemoteServiceReference getKarafFeaturesInstallerRef() {
        return this.managerRef;
    }

    public String getManagerContainer() {
        return this.managerRef.getID().getContainerID().getName();
    }

    public String getName() {
        return String.valueOf(this.getManagerContainer()) + ":" + this.managerRef.getID().getContainerRelativeID();
    }

    public RepositoryNode getRepositoryNode(URI repoURI) {
        AbstractFeaturesNode[] abstractFeaturesNodeArray = this.getChildren();
        int n = abstractFeaturesNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RepositoryNode repoNode;
            AbstractFeaturesNode bn = abstractFeaturesNodeArray[n2];
            if (bn instanceof RepositoryNode && (repoNode = (RepositoryNode)bn).getUri().equals(repoURI)) {
                return repoNode;
            }
            ++n2;
        }
        return null;
    }

    public FeatureNode getFeatureNode(String fId) {
        AbstractFeaturesNode[] abstractFeaturesNodeArray = this.getChildren();
        int n = abstractFeaturesNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFeaturesNode bn = abstractFeaturesNodeArray[n2];
            if (bn instanceof RepositoryNode) {
                RepositoryNode repoNode = (RepositoryNode)bn;
                AbstractFeaturesNode[] abstractFeaturesNodeArray2 = repoNode.getChildren();
                int n3 = abstractFeaturesNodeArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    FeatureNode fn;
                    AbstractFeaturesNode rn = abstractFeaturesNodeArray2[n4];
                    if (rn instanceof FeatureNode && (fn = (FeatureNode)rn).getId().equals(fId)) {
                        return fn;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }
}

