/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.mgmt.karaf.features.FeatureMTO;
import org.eclipse.ecf.mgmt.karaf.features.RepositoryMTO;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.AbstractFeaturesNode;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.FeatureNode;
import org.eclipse.ecf.mgmt.karaf.features.eclipse.ui.view.model.FeaturePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class RepositoryNode
extends AbstractFeaturesNode {
    private RepositoryMTO repositoryMTO;

    public URI getUri() {
        return this.repositoryMTO.getUri();
    }

    public String getName() {
        return this.repositoryMTO.getName();
    }

    public RepositoryNode(RepositoryMTO mto) {
        this.repositoryMTO = mto;
        FeatureMTO[] features = mto.getFeatures();
        int i = 0;
        while (i < features.length) {
            this.addChild(new FeatureNode(features[i]));
            ++i;
        }
    }

    private Map<String, String> getRepositoryProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("URI", this.getUri().toString());
        result.put("Name", this.getName());
        result.put("Repositories", Arrays.asList(this.repositoryMTO.getRepositories()).toString());
        result.put("Resource Repositories", Arrays.asList(this.repositoryMTO.getResourceRepositories()).toString());
        return result;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new FeaturePropertySource(this.getRepositoryProperties());
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

