/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.rsa.eclipse.ui;

import java.util.Collection;
import org.eclipse.ecf.mgmt.consumer.util.IRemoteServiceListener;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceEvent;
import org.eclipse.ecf.mgmt.consumer.util.RemoteServiceHolder;
import org.eclipse.ecf.mgmt.rsa.ExportReferenceMTO;
import org.eclipse.ecf.mgmt.rsa.ExportRegistrationMTO;
import org.eclipse.ecf.mgmt.rsa.IRemoteServiceAdminManagerAsync;
import org.eclipse.ecf.mgmt.rsa.ImportReferenceMTO;
import org.eclipse.ecf.mgmt.rsa.ImportRegistrationMTO;
import org.eclipse.ecf.mgmt.rsa.eclipse.ui.model.ExportReferenceMTONode;
import org.eclipse.ecf.mgmt.rsa.eclipse.ui.model.ImportReferenceMTONode;
import org.eclipse.ecf.mgmt.rsa.eclipse.ui.model.RSAManagerContentProvider;
import org.eclipse.ecf.mgmt.rsa.eclipse.ui.model.RSAManagerNode;
import org.eclipse.ecf.mgmt.rsa.eclipse.ui.model.RemoteRSAManagersRootNode;
import org.eclipse.ecf.mgmt.rsa.internal.eclipse.ui.RSAManagerComponent;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.AbstractRemoteServiceAdminView;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.AbstractRSAContentProvider;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.AbstractRSANode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ExportedServicesRootNode;
import org.eclipse.ecf.remoteserviceadmin.ui.rsa.model.ImportedEndpointsRootNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IViewSite;

public class RemoteRSAView
extends AbstractRemoteServiceAdminView {
    public static final String ID_VIEW = "org.eclipse.ecf.mgmt.eclipse.ui.RemoteRSAView";
    private Action refreshExportedAction;
    private Action refreshImportedAction;
    private Action refreshBothAction;
    private IRemoteServiceListener rsListener = new IRemoteServiceListener(){

        public void handleEvent(RemoteServiceEvent e) {
            int type = e.getType();
            final RemoteServiceHolder h = e.getRemoteServiceHolder(IRemoteServiceAdminManagerAsync.class);
            if (type == 1) {
                RemoteRSAView.this.refreshBoth((IRemoteServiceAdminManagerAsync)h.getRemoteService(), h.getRemoteServiceReference());
            } else if (type == 2) {
                if (RemoteRSAView.this.viewer == null) {
                    return;
                }
                RemoteRSAView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (RemoteRSAView.this.viewer == null) {
                            return;
                        }
                        RemoteRSAView.this.getRootNode().removeRSAManagerNode(h.getRemoteServiceReference());
                        RemoteRSAView.this.viewer.refresh();
                    }
                });
            }
        }
    };
    private Collection<RemoteServiceHolder<IRemoteServiceAdminManagerAsync>> initialRemoteServiceHolders;

    protected void makeActions() {
        super.makeActions();
        this.refreshExportedAction = new Action(){

            public void run() {
                AbstractRSANode rsaNode = RemoteRSAView.this.getSelectedNode();
                RSAManagerNode managerNode = null;
                if (rsaNode instanceof ExportedServicesRootNode) {
                    managerNode = (RSAManagerNode)rsaNode.getParent();
                }
                if (managerNode != null) {
                    RemoteRSAView.this.refreshExports(managerNode.getRemoteServiceAdminManager(), managerNode.getRemoteServiceAdminManagerRef());
                }
            }
        };
        this.refreshExportedAction.setText("Refresh remote exported services");
        this.refreshImportedAction = new Action(){

            public void run() {
                AbstractRSANode rsaNode = RemoteRSAView.this.getSelectedNode();
                RSAManagerNode managerNode = null;
                if (rsaNode instanceof ImportedEndpointsRootNode) {
                    managerNode = (RSAManagerNode)rsaNode.getParent();
                }
                if (managerNode != null) {
                    RemoteRSAView.this.refreshImports(managerNode.getRemoteServiceAdminManager(), managerNode.getRemoteServiceAdminManagerRef());
                }
            }
        };
        this.refreshImportedAction.setText("Refresh remote imported endpoints");
        this.refreshBothAction = new Action(){

            public void run() {
                RSAManagerNode managerNode = RemoteRSAView.this.getSelectedManagerNode();
                if (managerNode != null) {
                    RemoteRSAView.this.refreshBoth(managerNode.getRemoteServiceAdminManager(), managerNode.getRemoteServiceAdminManagerRef());
                }
            }
        };
        this.refreshBothAction.setText("Refresh remote exports and imports");
    }

    protected void fillContextMenu(IMenuManager manager) {
        ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
        if (selection != null) {
            Object e = selection.getFirstElement();
            if (e instanceof RSAManagerNode) {
                manager.add((IAction)this.refreshBothAction);
            } else if (e instanceof ExportReferenceMTONode || e instanceof ExportedServicesRootNode) {
                manager.add((IAction)this.refreshExportedAction);
            } else if (e instanceof ImportReferenceMTONode || e instanceof ImportedEndpointsRootNode) {
                manager.add((IAction)this.refreshImportedAction);
            }
        }
    }

    private RSAManagerNode getSelectedManagerNode() {
        AbstractRSANode aNode = this.getSelectedNode();
        return aNode == null ? null : (aNode instanceof RSAManagerNode ? (RSAManagerNode)aNode : null);
    }

    protected AbstractRSAContentProvider createContentProvider(IViewSite viewSite) {
        return new RSAManagerContentProvider(viewSite);
    }

    public void dispose() {
        RSAManagerComponent.getInstance().removeListener(this.rsListener);
        super.dispose();
    }

    protected void setupListeners() {
        this.initialRemoteServiceHolders = RSAManagerComponent.getInstance().addListener(this.rsListener, IRemoteServiceAdminManagerAsync.class);
    }

    protected void updateModel() {
        if (this.initialRemoteServiceHolders != null) {
            for (RemoteServiceHolder<IRemoteServiceAdminManagerAsync> h : this.initialRemoteServiceHolders) {
                this.refreshBoth((IRemoteServiceAdminManagerAsync)h.getRemoteService(), h.getRemoteServiceReference());
            }
            this.initialRemoteServiceHolders = null;
        }
        super.updateModel();
    }

    private void refreshExports(IRemoteServiceAdminManagerAsync rsaManagerAsync, IRemoteServiceReference rsRef) {
        if (this.viewer == null) {
            return;
        }
        if (rsRef != null) {
            rsaManagerAsync.getExportedServicesAsync().whenComplete((result, exception) -> {
                if (this.viewer == null) {
                    return;
                }
                this.viewer.getControl().getDisplay().asyncExec(new Runnable((Throwable)exception, rsRef, rsaManagerAsync, (ExportRegistrationMTO[])result){
                    private final /* synthetic */ Throwable val$exception;
                    private final /* synthetic */ IRemoteServiceReference val$rsRef;
                    private final /* synthetic */ IRemoteServiceAdminManagerAsync val$rsaManagerAsync;
                    private final /* synthetic */ ExportRegistrationMTO[] val$result;
                    {
                        this.val$exception = throwable;
                        this.val$rsRef = iRemoteServiceReference;
                        this.val$rsaManagerAsync = iRemoteServiceAdminManagerAsync;
                        this.val$result = exportRegistrationMTOArray;
                    }

                    @Override
                    public void run() {
                        if (RemoteRSAView.this.viewer == null) {
                            return;
                        }
                        if (this.val$exception != null) {
                            RemoteRSAView.this.handleExportException(this.val$rsRef, this.val$exception);
                        } else {
                            RSAManagerNode managerNode = RemoteRSAView.this.getRootNode().getRSAManagerNode(this.val$rsRef, this.val$rsaManagerAsync);
                            ExportedServicesRootNode exportedRoot = managerNode.getExportedServicesRootNode();
                            exportedRoot.clearChildren();
                            ExportRegistrationMTO[] exportRegistrationMTOArray = this.val$result;
                            int n = this.val$result.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ExportReferenceMTO eref;
                                ExportRegistrationMTO ereg = exportRegistrationMTOArray[n2];
                                Throwable t = ereg.getException();
                                if (t == null && (eref = ereg.getExportReference()) != null) {
                                    exportedRoot.addChild((AbstractRSANode)new ExportReferenceMTONode(eref));
                                }
                                ++n2;
                            }
                            RemoteRSAView.this.viewer.expandToLevel(3);
                            RemoteRSAView.this.viewer.refresh();
                        }
                    }
                });
            });
        }
    }

    private void refreshImports(IRemoteServiceAdminManagerAsync rsaManagerAsync, IRemoteServiceReference rsRef) {
        rsaManagerAsync.getImportedEndpointsAsync().whenComplete((result, exception) -> {
            if (this.viewer == null) {
                return;
            }
            this.viewer.getControl().getDisplay().asyncExec(new Runnable((Throwable)exception, rsRef, rsaManagerAsync, (ImportRegistrationMTO[])result){
                private final /* synthetic */ Throwable val$exception;
                private final /* synthetic */ IRemoteServiceReference val$rsRef;
                private final /* synthetic */ IRemoteServiceAdminManagerAsync val$rsaManagerAsync;
                private final /* synthetic */ ImportRegistrationMTO[] val$result;
                {
                    this.val$exception = throwable;
                    this.val$rsRef = iRemoteServiceReference;
                    this.val$rsaManagerAsync = iRemoteServiceAdminManagerAsync;
                    this.val$result = importRegistrationMTOArray;
                }

                @Override
                public void run() {
                    if (RemoteRSAView.this.viewer == null) {
                        return;
                    }
                    if (this.val$exception != null) {
                        RemoteRSAView.this.handleImportException(this.val$rsRef, this.val$exception);
                    } else {
                        RSAManagerNode managerNode = RemoteRSAView.this.getRootNode().getRSAManagerNode(this.val$rsRef, this.val$rsaManagerAsync);
                        ImportedEndpointsRootNode importedRoot = managerNode.getImportedEndpointsRootNode();
                        importedRoot.clearChildren();
                        ImportRegistrationMTO[] importRegistrationMTOArray = this.val$result;
                        int n = this.val$result.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ImportReferenceMTO iref;
                            ImportRegistrationMTO ireg = importRegistrationMTOArray[n2];
                            Throwable t = ireg.getException();
                            if (t == null && (iref = ireg.getImportReference()) != null) {
                                importedRoot.addChild((AbstractRSANode)new ImportReferenceMTONode(iref));
                            }
                            ++n2;
                        }
                        RemoteRSAView.this.viewer.expandToLevel(4);
                        RemoteRSAView.this.viewer.refresh();
                    }
                }
            });
        });
    }

    protected void handleImportException(IRemoteServiceReference rsRef, Throwable exception) {
        System.out.println("handleImportException. rsRef=" + rsRef + ";exception=" + exception);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    RemoteRSAManagersRootNode getRootNode() {
        return ((RSAManagerContentProvider)this.contentProvider).getRoot();
    }

    private void handleExportException(IRemoteServiceReference rsRef, Throwable exception) {
        System.out.println("handleExportException. rsRef=" + rsRef + ";exception=" + exception);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    private void refreshBoth(IRemoteServiceAdminManagerAsync rsaManager, IRemoteServiceReference rsRef) {
        this.refreshImports(rsaManager, rsRef);
        this.refreshExports(rsaManager, rsRef);
    }
}

