/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.scr;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.eclipse.ecf.mgmt.PropertiesUtil;
import org.eclipse.ecf.mgmt.framework.ServiceReferenceMTO;
import org.eclipse.ecf.mgmt.scr.ComponentReferenceMTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.component.ComponentInstance;

public class ComponentMTO
implements Serializable {
    private static final long serialVersionUID = -5159960239280902025L;
    private static long curID = 1L;
    private long id;
    private long componentId;
    private String name;
    private int state;
    private long bundleId;
    private String factory;
    private boolean serviceFactory;
    private String className;
    private boolean defaultEnabled;
    private boolean immediate;
    private String[] services;
    private Map properties;
    private ComponentReferenceMTO[] componentReferenceMTOs;
    private boolean activated;
    private String activate;
    private boolean activateDeclared;
    private String deactivate;
    private boolean deactivateDeclared;
    private String modified;
    private String configurationPolicy;
    private ServiceReferenceMTO serviceInstance;

    private static synchronized long generateID() {
        return curID++;
    }

    private static ServiceReferenceMTO findServiceForComponent(Component comp) {
        if (comp.getState() != 16) {
            return null;
        }
        String[] compServices = comp.getServices();
        if (compServices == null || compServices.length < 1) {
            return null;
        }
        ComponentInstance compInstance = comp.getComponentInstance();
        if (compInstance == null) {
            return null;
        }
        Object compInstanceService = compInstance.getInstance();
        if (compInstanceService == null) {
            return null;
        }
        Bundle b = comp.getBundle();
        ServiceReference[] serviceRefs = b.getRegisteredServices();
        if (serviceRefs == null) {
            return null;
        }
        ServiceReferenceDTO[] dtos = (ServiceReferenceDTO[])b.adapt(ServiceReferenceDTO[].class);
        ServiceReference[] serviceReferenceArray = serviceRefs;
        int n = serviceRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference sr = serviceReferenceArray[n2];
            Long serviceId = (Long)sr.getProperty("service.id");
            if (serviceId != null) {
                ServiceReferenceDTO[] serviceReferenceDTOArray = dtos;
                int n3 = dtos.length;
                int n4 = 0;
                while (n4 < n3) {
                    ServiceReferenceDTO dto = serviceReferenceDTOArray[n4];
                    if (serviceId == dto.id) {
                        return ServiceReferenceMTO.createMTO((ServiceReferenceDTO)dto);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public static ComponentMTO createMTO(CompRef cRef, Component comp) {
        return new ComponentMTO(cRef.id, comp.getName(), comp.getState(), comp.getBundle().getBundleId(), comp.getFactory(), comp.isServiceFactory(), comp.getClassName(), comp.isDefaultEnabled(), comp.isImmediate(), comp.getServices(), PropertiesUtil.convertDictionaryToMap((Dictionary)comp.getProperties()), ComponentReferenceMTO.createMTOs(comp.getReferences()), comp.getComponentInstance() != null, comp.getActivate(), comp.isActivateDeclared(), comp.getDeactivate(), comp.isDeactivateDeclared(), comp.getModified(), comp.getConfigurationPolicy(), ComponentMTO.findServiceForComponent(comp));
    }

    ComponentMTO(long id, String name, int state, long bundleId, String factory, boolean serviceFactory, String className, boolean defaultEnabled, boolean immediate, String[] services, Map properties, ComponentReferenceMTO[] referenceInfo, boolean activated, String activate, boolean activateDeclared, String deactivate, boolean deactivateDeclared, String modified, String configurationPolicy, ServiceReferenceMTO serviceInstance) {
        this.id = id;
        Long cId = (Long)properties.get("component.id");
        if (cId != null) {
            this.componentId = cId;
        }
        this.name = name;
        this.state = state;
        this.bundleId = bundleId;
        this.factory = factory;
        this.serviceFactory = serviceFactory;
        this.className = className;
        this.defaultEnabled = defaultEnabled;
        this.immediate = immediate;
        this.services = services;
        this.properties = properties;
        this.componentReferenceMTOs = referenceInfo;
        this.activated = activated;
        this.activate = activate;
        this.activateDeclared = activateDeclared;
        this.deactivate = deactivate;
        this.deactivateDeclared = deactivateDeclared;
        this.modified = modified;
        this.configurationPolicy = configurationPolicy;
        this.serviceInstance = serviceInstance;
    }

    public long getId() {
        return this.id;
    }

    public long getComponentId() {
        return this.componentId;
    }

    public String getName() {
        return this.name;
    }

    public int getState() {
        return this.state;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String getFactory() {
        return this.factory;
    }

    public boolean isServiceFactory() {
        return this.serviceFactory;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public String[] getServices() {
        return this.services;
    }

    public Map getProperties() {
        return this.properties;
    }

    public ComponentReferenceMTO[] getReferences() {
        return this.componentReferenceMTOs;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public String getActivate() {
        return this.activate;
    }

    public boolean isActivateDeclared() {
        return this.activateDeclared;
    }

    public String getDeactivate() {
        return this.deactivate;
    }

    public boolean isDeactivateDeclared() {
        return this.deactivateDeclared;
    }

    public String getModified() {
        return this.modified;
    }

    public String getConfigurationPolicy() {
        return this.configurationPolicy;
    }

    public ServiceReferenceMTO getActiveService() {
        return this.serviceInstance;
    }

    public String toString() {
        return "ComponentMTO [id=" + this.id + ", componentId=" + this.componentId + ", name=" + this.name + ", state=" + this.state + ", bundleId=" + this.bundleId + ", factory=" + this.factory + ", serviceFactory=" + this.serviceFactory + ", className=" + this.className + ", defaultEnabled=" + this.defaultEnabled + ", immediate=" + this.immediate + ", services=" + Arrays.toString(this.services) + ", properties=" + this.properties + ", componentReferenceMTOs=" + Arrays.toString(this.componentReferenceMTOs) + ", activated=" + this.activated + ", activate=" + this.activate + ", activateDeclared=" + this.activateDeclared + ", deactivate=" + this.deactivate + ", deactivateDeclared=" + this.deactivateDeclared + ", modified=" + this.modified + ", configurationPolicy=" + this.configurationPolicy + ", serviceInstance=" + this.serviceInstance + "]";
    }

    public static class CompRef {
        private long bid;
        private String name;
        private long id = -1L;
        private Long componentId;

        public CompRef(long bundleId, String name, Long componentId) {
            this.bid = bundleId;
            this.name = name;
            this.componentId = componentId;
        }

        public void setId() {
            if (this.id < 0L) {
                this.id = ComponentMTO.generateID();
            }
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public long getBundleId() {
            return this.bid;
        }

        public boolean equals(Object other) {
            if (other instanceof CompRef) {
                CompRef oRef = (CompRef)other;
                return oRef.bid == this.bid && this.name.equals(oRef.name) && this.componentId.equals(oRef.componentId);
            }
            return false;
        }

        public int hashCode() {
            return this.componentId.hashCode();
        }
    }
}

