/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.scr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.felix.scr.Reference;
import org.osgi.framework.ServiceReference;

public class ComponentReferenceMTO
implements Serializable {
    private static final long serialVersionUID = 4461270131669598394L;
    private final String name;
    private final String serviceName;
    private final long[] serviceReferenceIds;
    private final boolean satisfied;
    private final boolean optional;
    private final boolean multiple;
    private final boolean isStatic;
    private final String target;
    private final String bindMethodName;
    private final String unbindMethodName;

    public static ComponentReferenceMTO createMTO(Reference reference) {
        ServiceReference[] srefs = reference.getServiceReferences();
        if (srefs == null) {
            return null;
        }
        long[] serviceReferenceIds = new long[srefs.length];
        int i = 0;
        while (i < srefs.length) {
            serviceReferenceIds[i] = (Long)srefs[i].getProperty("service.id");
            ++i;
        }
        return new ComponentReferenceMTO(reference.getName(), reference.getServiceName(), serviceReferenceIds, reference.isSatisfied(), reference.isOptional(), reference.isMultiple(), reference.isStatic(), reference.getTarget(), reference.getBindMethodName(), reference.getUnbindMethodName());
    }

    public static ComponentReferenceMTO[] createMTOs(Reference[] references) {
        ArrayList<ComponentReferenceMTO> results = new ArrayList<ComponentReferenceMTO>();
        if (references != null) {
            Reference[] referenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                Reference r = referenceArray[n2];
                results.add(ComponentReferenceMTO.createMTO(r));
                ++n2;
            }
        }
        return results.toArray(new ComponentReferenceMTO[results.size()]);
    }

    ComponentReferenceMTO(String name, String serviceName, long[] serviceReferenceIds, boolean satisfied, boolean optional, boolean multiple, boolean isstatic, String target, String bindMethodName, String unbindMethodName) {
        this.name = name;
        this.serviceName = serviceName;
        this.serviceReferenceIds = serviceReferenceIds;
        this.satisfied = satisfied;
        this.optional = optional;
        this.multiple = multiple;
        this.isStatic = isstatic;
        this.target = target;
        this.bindMethodName = bindMethodName;
        this.unbindMethodName = unbindMethodName;
    }

    public String getName() {
        return this.name;
    }

    public String getService() {
        return this.serviceName;
    }

    public long[] getIds() {
        return this.serviceReferenceIds;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getTarget() {
        return this.target;
    }

    public String getBindMethodName() {
        return this.bindMethodName;
    }

    public String getUnbindMethodName() {
        return this.unbindMethodName;
    }

    public String toString() {
        return "ComponentReferenceMTO [name=" + this.name + ", serviceName=" + this.serviceName + ", serviceReferenceIds=" + Arrays.toString(this.serviceReferenceIds) + ", satisfied=" + this.satisfied + ", optional=" + this.optional + ", multiple=" + this.multiple + ", isStatic=" + this.isStatic + ", target=" + this.target + ", bindMethodName=" + this.bindMethodName + ", unbindMethodName=" + this.unbindMethodName + "]";
    }

    public ComponentReferenceMTO[] getComponentReferences() {
        return null;
    }
}

