/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.ui.bundleview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.remoteservice.ui.bundleview.BundlesFilteredTree;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.AbstractBundlesContentProvider;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.AbstractBundlesNode;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.BundleNode;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.BundlesContentProvider;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.BundlesRootNode;
import org.eclipse.ecf.remoteservice.ui.internal.bundleview.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractBundlesView
extends ViewPart {
    private TreeViewer viewer;
    private AbstractBundlesContentProvider contentProvider;
    private BundlesFilteredTree filteredTree;
    private Action stopBundleAction;
    private Action startBundleAction;
    private Action uninstallBundleAction;

    protected void fillContextMenu(IMenuManager manager) {
        Object first = this.getSelection().getFirstElement();
        if (first instanceof BundleNode) {
            BundleNode bn = (BundleNode)first;
            int bState = bn.getState();
            switch (bState) {
                case 32: {
                    manager.add((IAction)this.stopBundleAction);
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)this.uninstallBundleAction);
                    break;
                }
                case 4: 
                case 8: {
                    manager.add((IAction)this.startBundleAction);
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)this.uninstallBundleAction);
                }
            }
        }
    }

    protected ITreeSelection getSelection() {
        return this.getTreeViewer().getStructuredSelection();
    }

    protected abstract void stopBundlesAction(BundleNode[] var1);

    protected abstract void startBundlesAction(BundleNode[] var1);

    protected abstract void uninstallBundlesAction(BundleNode[] var1);

    protected void makeActions() {
        this.stopBundleAction = new Action(){

            public void run() {
                ITreeSelection selection = AbstractBundlesView.this.getSelection();
                if (selection.getFirstElement() instanceof BundleNode) {
                    Iterator i = selection.iterator();
                    ArrayList<BundleNode> bns = new ArrayList<BundleNode>();
                    while (i.hasNext()) {
                        bns.add((BundleNode)i.next());
                    }
                    AbstractBundlesView.this.stopBundlesAction(bns.toArray(new BundleNode[bns.size()]));
                }
            }
        };
        this.stopBundleAction.setText("Stop Bundle");
        this.startBundleAction = new Action(){

            public void run() {
                ITreeSelection selection = AbstractBundlesView.this.getSelection();
                if (selection.getFirstElement() instanceof BundleNode) {
                    Iterator i = selection.iterator();
                    ArrayList<BundleNode> bns = new ArrayList<BundleNode>();
                    while (i.hasNext()) {
                        bns.add((BundleNode)i.next());
                    }
                    AbstractBundlesView.this.startBundlesAction(bns.toArray(new BundleNode[bns.size()]));
                }
            }
        };
        this.startBundleAction.setText("Start Bundle");
        this.uninstallBundleAction = new Action(){

            public void run() {
                ITreeSelection selection = AbstractBundlesView.this.getSelection();
                if (selection.getFirstElement() instanceof BundleNode) {
                    Iterator i = selection.iterator();
                    ArrayList<BundleNode> bns = new ArrayList<BundleNode>();
                    while (i.hasNext()) {
                        bns.add((BundleNode)i.next());
                    }
                    AbstractBundlesView.this.uninstallBundlesAction(bns.toArray(new BundleNode[bns.size()]));
                }
            }
        };
        this.uninstallBundleAction.setText("Uninstall Bundle");
    }

    protected void log(int level, String message, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(level, "org.eclipse.ecf.remoteservice.ui.bundleview", message, e));
    }

    protected void logWarning(String message, Throwable e) {
        this.log(2, message, e);
    }

    protected void logError(String message, Throwable e) {
        this.log(4, message, e);
    }

    protected void logAndShowError(String message, Throwable exception) {
        this.logError(message, exception);
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Error", (String)(String.valueOf(message) + (exception != null ? "\nException: " + exception.getMessage() + "\nSee Error Log for stack" : "")));
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractBundlesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.contentProvider = this.createContentProvider(this.getViewSite());
        this.viewer = this.createTreeViewer(composite);
        this.makeActions();
        this.hookContextMenu();
        this.initializeBundles();
    }

    public void setFocus() {
        Text filterText;
        FilteredTree filteredTree = this.getFilteredTree();
        if (filteredTree != null && (filterText = filteredTree.getFilterControl()) != null) {
            filterText.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.viewer = null;
        this.contentProvider = null;
    }

    protected TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected FilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.filteredTree = this.createFilteredTree(composite, 770, new PatternFilter());
        TreeViewer viewer = this.filteredTree.getViewer();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.setUseHashlookup(true);
        viewer.setInput((Object)this.getViewSite());
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof BundleNode && e2 instanceof BundleNode) {
                    return new Long(((BundleNode)e1).getId() - ((BundleNode)e2).getId()).intValue();
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.getViewSite().setSelectionProvider((ISelectionProvider)viewer);
        return viewer;
    }

    protected BundlesFilteredTree createFilteredTree(Composite parent, int options, PatternFilter filter) {
        BundlesFilteredTree result = new BundlesFilteredTree(this, parent, options, filter);
        result.setBackground(parent.getDisplay().getSystemColor(25));
        GridData gd = new GridData(1808);
        result.setLayoutData(gd);
        return result;
    }

    protected AbstractBundlesContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected BundlesContentProvider createContentProvider(IViewSite viewSite) {
        return new BundlesContentProvider(viewSite);
    }

    protected void initializeBundles() {
    }

    protected BundleNode findBundleNode(long bundleId) {
        AbstractBundlesNode[] bundles;
        AbstractBundlesNode[] abstractBundlesNodeArray = bundles = this.getBundlesRoot().getChildren();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleNode sn;
            AbstractBundlesNode abn = abstractBundlesNodeArray[n2];
            if (abn instanceof BundleNode && bundleId == (sn = (BundleNode)abn).getId()) {
                return sn;
            }
            ++n2;
        }
        return null;
    }

    protected BundlesRootNode getBundlesRoot() {
        return this.getContentProvider().getBundlesRoot();
    }

    protected Tree getUndisposedTree() {
        if (this.viewer == null || this.viewer.getTree() == null || this.viewer.getTree().isDisposed()) {
            return null;
        }
        return this.viewer.getTree();
    }

    protected String getTitleSummary() {
        Tree tree = this.getUndisposedTree();
        String type = "bundles";
        int total = this.getBundlesRoot().getChildren().length;
        if (tree == null) {
            return NLS.bind((String)"Filter matched {0} of {1} {2}.", (Object[])new String[]{"0", "0", type});
        }
        return NLS.bind((String)"Filter matched {0} of {1} {2}.", (Object[])new String[]{Integer.toString(tree.getItemCount()), Integer.toString(total), type});
    }

    protected void updateTitle() {
        this.setContentDescription(this.getTitleSummary());
    }

    protected AbstractBundlesNode getSelectedNode() {
        return (AbstractBundlesNode)((ITreeSelection)this.viewer.getSelection()).getFirstElement();
    }

    protected BundleNode createBundleNode(long id, long lastModified, int state, String symbolicName, String version, Map<String, String> manifest, String location) {
        return new BundleNode(id, lastModified, state, symbolicName, version, manifest, location);
    }

    protected void addBundleNodes(final Collection<BundleNode> bns) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer tv = AbstractBundlesView.this.getTreeViewer();
                if (tv == null) {
                    return;
                }
                BundlesRootNode brn = AbstractBundlesView.this.getBundlesRoot();
                for (BundleNode bn : bns) {
                    brn.addChild(bn);
                }
                tv.setExpandedState((Object)brn, true);
                tv.refresh();
            }
        });
    }
}

