/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.ui.bundleview;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.remoteservice.ui.bundleview.AbstractBundlesView;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.BundleNode;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.BundlesRootNode;
import org.eclipse.ecf.remoteservice.ui.internal.bundleview.Activator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.dto.BundleDTO;
import org.osgi.framework.dto.FrameworkDTO;

public class LocalBundlesView
extends AbstractBundlesView {
    public static final String ID_VIEW = "org.eclipse.ecf.remoteservice.ui.bundleview.BundleView";
    private BundleListener bundleListener = new BundleListener(){

        public void bundleChanged(final BundleEvent event) {
            TreeViewer v = LocalBundlesView.this.getTreeViewer();
            if (v == null) {
                return;
            }
            v.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeViewer tv = LocalBundlesView.this.getTreeViewer();
                    if (tv == null) {
                        return;
                    }
                    BundleContext ctxt = LocalBundlesView.this.getLocalBundleContext();
                    if (ctxt == null) {
                        return;
                    }
                    Bundle bundle = event.getBundle();
                    BundleDTO bDTO = LocalBundlesView.this.getBundleDTO(ctxt, bundle);
                    switch (event.getType()) {
                        case 1: {
                            if (bDTO == null) break;
                            LocalBundlesView.this.getBundlesRoot().addChild(LocalBundlesView.this.createBundleNode(bDTO, bundle));
                            break;
                        }
                        case 16: {
                            BundleNode bn = LocalBundlesView.this.findBundleNode(bundle.getBundleId());
                            if (bn == null) break;
                            LocalBundlesView.this.getBundlesRoot().removeChild(bn);
                            break;
                        }
                        default: {
                            BundleNode node = LocalBundlesView.this.findBundleNode(bundle.getBundleId());
                            if (node == null) break;
                            BundlesRootNode brn = LocalBundlesView.this.getBundlesRoot();
                            brn.removeChild(node);
                            if (bDTO == null) break;
                            brn.addChild(LocalBundlesView.this.createBundleNode(bDTO, bundle));
                        }
                    }
                    tv.setExpandedState((Object)LocalBundlesView.this.getBundlesRoot(), true);
                    tv.refresh();
                }
            });
        }
    };

    private BundleContext getLocalBundleContext() {
        return Activator.getDefault().getBundle().getBundleContext();
    }

    @Override
    public void dispose() {
        BundleContext ctxt = this.getLocalBundleContext();
        if (ctxt != null) {
            ctxt.removeBundleListener(this.bundleListener);
        }
        super.dispose();
    }

    private List<BundleDTO> getBundleDTOs(BundleContext ctxt) {
        return ((FrameworkDTO)ctxt.getBundle((long)0L).adapt(FrameworkDTO.class)).bundles;
    }

    private BundleDTO getBundleDTO(BundleContext ctxt, Bundle b) {
        long bId = b.getBundleId();
        for (BundleDTO bdto : this.getBundleDTOs(ctxt)) {
            if (bId != bdto.id) continue;
            return bdto;
        }
        return null;
    }

    static Map<String, String> convertHeadersToMap(Dictionary<String, String> headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<String> e = headers.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String value = headers.get(key);
            result.put(key, value);
        }
        return result;
    }

    private Bundle getBundle(long bId) {
        BundleContext localContext = this.getLocalBundleContext();
        if (localContext != null) {
            Bundle[] bundleArray = localContext.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                if (b.getBundleId() == bId) {
                    return b;
                }
                ++n2;
            }
        }
        return null;
    }

    private BundleNode createBundleNode(BundleDTO bDTO, Bundle b) {
        return this.createBundleNode(bDTO.id, bDTO.lastModified, bDTO.state, bDTO.symbolicName, bDTO.version, LocalBundlesView.convertHeadersToMap(b.getHeaders()), b.getLocation());
    }

    @Override
    protected void initializeBundles() {
        final BundleContext ctxt = this.getLocalBundleContext();
        ctxt.addBundleListener(this.bundleListener);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<BundleNode> bnds = new ArrayList<BundleNode>();
                for (BundleDTO bDTO : LocalBundlesView.this.getBundleDTOs(ctxt)) {
                    bnds.add(LocalBundlesView.this.createBundleNode(bDTO, LocalBundlesView.this.getBundle(bDTO.id)));
                }
                LocalBundlesView.this.addBundleNodes(bnds);
            }
        }).start();
    }

    private void startOrStopBundles(BundleNode[] bns, boolean start) {
        BundleNode[] bundleNodeArray = bns;
        int n = bns.length;
        int n2 = 0;
        while (n2 < n) {
            BundleNode bn = bundleNodeArray[n2];
            Bundle b = this.getBundle(bn.getId());
            if (b != null) {
                try {
                    if (start) {
                        b.start();
                    } else {
                        b.stop();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private String createStringFromBundles(BundleNode[] bnodes) {
        ArrayList<String> names = new ArrayList<String>();
        BundleNode[] bundleNodeArray = bnodes;
        int n = bnodes.length;
        int n2 = 0;
        while (n2 < n) {
            BundleNode bn = bundleNodeArray[n2];
            names.add(bn.getSymbolicName());
            ++n2;
        }
        StringBuffer result = new StringBuffer();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            result.append((String)i.next());
            if (!i.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    @Override
    protected void uninstallBundlesAction(BundleNode[] bns) {
        if (MessageDialog.openConfirm((Shell)this.getTreeViewer().getControl().getShell(), (String)"Uninstall Bundles", (String)("Uninstall Bundles: '" + this.createStringFromBundles(bns) + "'?"))) {
            BundleNode[] bundleNodeArray = bns;
            int n = bns.length;
            int n2 = 0;
            while (n2 < n) {
                BundleNode bn = bundleNodeArray[n2];
                Bundle b = this.getBundle(bn.getId());
                if (b != null) {
                    try {
                        b.uninstall();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    protected void stopBundlesAction(BundleNode[] bns) {
        this.startOrStopBundles(bns, false);
    }

    @Override
    protected void startBundlesAction(BundleNode[] bns) {
        this.startOrStopBundles(bns, true);
    }
}

