/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.ui.bundleview.model;

import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.AbstractBundlesNode;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.FeaturePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class BundleNode
extends AbstractBundlesNode {
    private final long id;
    private final long lastModified;
    private final int state;
    private final String symbolicName;
    private final String version;
    private final Map<String, String> manifest;
    private final String location;

    public BundleNode(long id, long lastModified, int state, String symbolicName, String version, Map<String, String> manifest, String location) {
        this.id = id;
        this.lastModified = lastModified;
        this.state = state;
        this.symbolicName = symbolicName;
        this.version = version;
        this.manifest = manifest;
        this.location = location;
    }

    public long getId() {
        return this.id;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int getState() {
        return this.state;
    }

    public String getStateLabel() {
        int s = this.getState();
        switch (s) {
            case 32: {
                return "Active";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninstalled";
            }
        }
        return "Unknown";
    }

    public boolean isFragment() {
        return this.getManifest().containsKey("Fragment-Host");
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getManifest() {
        return this.manifest;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new FeaturePropertySource(this.getManifest());
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

