/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.ui.bundleview.model;

import org.eclipse.ecf.remoteservice.ui.bundleview.model.AbstractBundlesWorkbenchAdapter;
import org.eclipse.ecf.remoteservice.ui.bundleview.model.BundleNode;
import org.eclipse.ecf.remoteservice.ui.internal.bundleview.Activator;
import org.eclipse.jface.resource.ImageDescriptor;

public class BundleNodeWorkbenchAdapter
extends AbstractBundlesWorkbenchAdapter {
    private static final String ICON_ACTIVE = "/icons/bundle_active.png";
    private static final String ICON_RESOLVED = "/icons/bundle_resolved.png";
    private static final String ICON_INSTALLED = "/icons/bundle_installed.png";

    public String getLabel(Object object) {
        BundleNode bn = (BundleNode)object;
        StringBuffer buf = new StringBuffer(String.valueOf(bn.getId()));
        buf.append(" - ").append(bn.getSymbolicName());
        buf.append(" - ").append(bn.getVersion());
        return buf.toString();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        BundleNode bn = (BundleNode)object;
        int bstate = bn.getState();
        String icon = null;
        if (bstate == 2) {
            icon = ICON_INSTALLED;
        } else {
            boolean active = bn.isFragment() ? bstate == 32 || bstate == 4 : bstate == 32;
            String string = icon = active ? ICON_ACTIVE : ICON_RESOLVED;
        }
        if (icon == null) {
            return null;
        }
        return Activator.getImageDescriptor(icon);
    }
}

