/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.ui.serviceview;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.remoteservice.ui.internal.serviceview.Activator;
import org.eclipse.ecf.remoteservice.ui.services.IServicesView;
import org.eclipse.ecf.remoteservice.ui.serviceview.ServicesFilteredTree;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.AbstractServicesContentProvider;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.AbstractServicesNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.RegisteringBundleIdNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.ServiceNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.ServicesContentProvider;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.ServicesRootNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.UsingBundleIdsNode;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractServicesView
extends ViewPart
implements IServicesView {
    private TreeViewer viewer;
    private AbstractServicesContentProvider contentProvider;
    private ServicesFilteredTree filteredTree;

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void makeActions() {
    }

    protected void log(int level, String message, Throwable e) {
        Activator.getDefault().getLog().log((IStatus)new Status(level, "org.eclipse.ecf.remoteservice.ui.internal.serviceview", message, e));
    }

    protected void logWarning(String message, Throwable e) {
        this.log(2, message, e);
    }

    protected void logError(String message, Throwable e) {
        this.log(4, message, e);
    }

    protected void logAndShowError(String message, Throwable exception) {
        this.logError(message, exception);
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Error", (String)(String.valueOf(message) + (exception != null ? "\nException: " + exception.getMessage() + "\nSee Error Log for stack" : "")));
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractServicesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.contentProvider = this.createContentProvider(this.getViewSite());
        this.viewer = this.createTreeViewer(composite);
        this.makeActions();
        this.hookContextMenu();
        this.initializeServices();
    }

    public void setFocus() {
        Text filterText;
        FilteredTree filteredTree = this.getFilteredTree();
        if (filteredTree != null && (filterText = filteredTree.getFilterControl()) != null) {
            filterText.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.viewer = null;
        this.contentProvider = null;
    }

    protected TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected FilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.filteredTree = this.createFilteredTree(composite, 768, new PatternFilter());
        TreeViewer viewer = this.filteredTree.getViewer();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.setUseHashlookup(true);
        viewer.setInput((Object)this.getViewSite());
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ServiceNode && e2 instanceof ServiceNode) {
                    return new Long(((ServiceNode)e2).getServiceId() - ((ServiceNode)e1).getServiceId()).intValue();
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.getViewSite().setSelectionProvider((ISelectionProvider)viewer);
        return viewer;
    }

    protected ServicesFilteredTree createFilteredTree(Composite parent, int options, PatternFilter filter) {
        ServicesFilteredTree result = new ServicesFilteredTree(this, parent, options, filter);
        result.setBackground(parent.getDisplay().getSystemColor(25));
        GridData gd = new GridData(1808);
        result.setLayoutData(gd);
        return result;
    }

    protected AbstractServicesContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected ServicesContentProvider createContentProvider(IViewSite viewSite) {
        return new ServicesContentProvider(viewSite);
    }

    protected void initializeServices() {
    }

    protected ServiceNode findServiceNode(long serviceId) {
        AbstractServicesNode[] services;
        AbstractServicesNode[] abstractServicesNodeArray = services = this.getServicesRoot().getChildren();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceNode sn;
            AbstractServicesNode asn = abstractServicesNodeArray[n2];
            if (asn instanceof ServiceNode && serviceId == (sn = (ServiceNode)asn).getServiceId()) {
                return sn;
            }
            ++n2;
        }
        return null;
    }

    protected ServicesRootNode getServicesRoot() {
        return this.getContentProvider().getServicesRoot();
    }

    protected Tree getUndisposedTree() {
        if (this.viewer == null || this.viewer.getTree() == null || this.viewer.getTree().isDisposed()) {
            return null;
        }
        return this.viewer.getTree();
    }

    protected String getTitleSummary() {
        Tree tree = this.getUndisposedTree();
        String type = "services";
        int total = this.getServicesRoot().getChildren().length;
        if (tree == null) {
            return NLS.bind((String)"Filter matched {0} of {1} {2}.", (Object[])new String[]{"0", "0", type});
        }
        return NLS.bind((String)"Filter matched {0} of {1} {2}.", (Object[])new String[]{Integer.toString(tree.getItemCount()), Integer.toString(total), type});
    }

    protected void updateTitle() {
        this.setContentDescription(this.getTitleSummary());
    }

    protected AbstractServicesNode getSelectedNode() {
        return (AbstractServicesNode)((ITreeSelection)this.viewer.getSelection()).getFirstElement();
    }

    public void selectService(String remoteId, final long serviceId) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer tv = AbstractServicesView.this.getTreeViewer();
                if (tv == null) {
                    return;
                }
                ServiceNode sn = AbstractServicesView.this.findServiceNode(serviceId);
                if (sn != null) {
                    tv.setSelection((ISelection)new StructuredSelection((Object)sn));
                }
            }
        });
    }

    public String getRemoteId() {
        return null;
    }

    protected ServiceNode createServiceNode(long serviceId, long bundleId, long[] usingBundleIds, Map<String, Object> properties) {
        ServiceNode result = new ServiceNode(bundleId, usingBundleIds, properties);
        result.addChild(new RegisteringBundleIdNode(bundleId));
        result.addChild(new UsingBundleIdsNode("Using Bundles", usingBundleIds));
        return result;
    }

    protected void addServiceNodes(final Collection<ServiceNode> sns) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer tv = AbstractServicesView.this.getTreeViewer();
                if (tv == null) {
                    return;
                }
                ServicesRootNode srn = AbstractServicesView.this.getServicesRoot();
                for (ServiceNode sn : sns) {
                    srn.addChild(sn);
                }
                tv.setExpandedState((Object)AbstractServicesView.this.getServicesRoot(), true);
                tv.refresh();
            }
        });
    }
}

