/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.ui.serviceview;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.eclipse.ecf.remoteservice.ui.internal.serviceview.Activator;
import org.eclipse.ecf.remoteservice.ui.internal.serviceview.DiscoveryComponent;
import org.eclipse.ecf.remoteservice.ui.serviceview.AbstractServicesView;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.AbstractServicesNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.RegisteringBundleIdNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.ServiceNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.UsingBundleIdsNode;
import org.eclipse.ecf.remoteservices.ui.RSAImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Menu;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.FrameworkDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;

public class ServicesView
extends AbstractServicesView {
    public static final String ID_VIEW = "org.eclipse.ecf.remoteservice.ui.serviceview.ServiceView";
    private Action exportServiceNodeAction;
    private Action unexportServiceNodeAction;
    private ServiceListener serviceListener = new ServiceListener(){

        public void serviceChanged(final ServiceEvent event) {
            TreeViewer v = ServicesView.this.getTreeViewer();
            if (v == null) {
                return;
            }
            v.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TreeViewer tv = ServicesView.this.getTreeViewer();
                    if (tv == null) {
                        return;
                    }
                    BundleContext ctxt = DiscoveryComponent.getDefault().getContext();
                    if (ctxt == null) {
                        return;
                    }
                    ServiceReference sr = event.getServiceReference();
                    ServiceReferenceDTO srDTO = null;
                    switch (event.getType()) {
                        case 1: {
                            srDTO = ServicesView.this.getServiceDTO(ctxt, sr);
                            if (srDTO == null) break;
                            ServicesView.this.getServicesRoot().addChild(ServicesView.this.createServiceNode(srDTO.id, srDTO.bundle, srDTO.usingBundles, srDTO.properties));
                            break;
                        }
                        case 2: {
                            ServiceNode sn;
                            srDTO = ServicesView.this.getServiceDTO(ctxt, sr);
                            if (srDTO == null || (sn = ServicesView.this.findServiceNode(srDTO.id)) == null) break;
                            sn.setProperties(srDTO.properties);
                            break;
                        }
                        case 4: {
                            ServiceNode sn = ServicesView.this.findServiceNode(ServicesView.this.getServiceId(sr));
                            if (sn == null) break;
                            ServicesView.this.getServicesRoot().removeChild(sn);
                        }
                    }
                    tv.setExpandedState((Object)ServicesView.this.getServicesRoot(), true);
                    tv.refresh();
                }
            });
        }
    };

    @Override
    public void dispose() {
        DiscoveryComponent discovery = DiscoveryComponent.getDefault();
        BundleContext ctxt = discovery.getContext();
        if (ctxt != null) {
            ctxt.removeServiceListener(this.serviceListener);
        }
        discovery.setServicesView(null);
        super.dispose();
    }

    private List<ServiceReferenceDTO> getServiceDTOs(BundleContext ctxt) {
        return ((FrameworkDTO)ctxt.getBundle((long)0L).adapt(FrameworkDTO.class)).services;
    }

    private ServiceReferenceDTO getServiceDTO(BundleContext ctxt, ServiceReference<?> sr) {
        long serviceId = (Long)sr.getProperty("service.id");
        for (ServiceReferenceDTO ref : this.getServiceDTOs(ctxt)) {
            if (serviceId != ref.id) continue;
            return ref;
        }
        return null;
    }

    private void logRSAException(String message, Exception e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.remoteservice.ui.internal.serviceview", message, (Throwable)e));
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.exportServiceNodeAction = new Action(){

            public void run() {
                ServiceNode sn;
                int state;
                Object o = ((ITreeSelection)ServicesView.this.getTreeViewer().getSelection()).getFirstElement();
                if (o instanceof ServiceNode && (state = (sn = (ServiceNode)o).getExportedImportedState()) == 0) {
                    long serviceId = sn.getServiceId();
                    ServicesView.this.exportServiceReference(Activator.getDefault().getServiceReference(serviceId), serviceId);
                }
            }
        };
        this.exportServiceNodeAction.setText("Export Service");
        this.exportServiceNodeAction.setImageDescriptor(RSAImageRegistry.RS_OBJ);
        this.unexportServiceNodeAction = new Action(){

            public void run() {
                org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin rsa;
                ServiceNode sn;
                ExportReference er;
                Object o = ((ITreeSelection)ServicesView.this.getTreeViewer().getSelection()).getFirstElement();
                if (o instanceof ServiceNode && (er = (sn = (ServiceNode)o).getExportRef()) != null && (rsa = (org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin)DiscoveryComponent.getDefault().getRSA()) != null) {
                    RemoteServiceAdmin.ExportRegistration eReg = null;
                    for (RemoteServiceAdmin.ExportRegistration reg : rsa.getExportedRegistrations()) {
                        ExportReference exportReference = reg.getExportReference();
                        if (exportReference == null || !er.equals(exportReference)) continue;
                        eReg = reg;
                    }
                    ServicesView.this.closeExportRegistration(eReg, sn.getServiceId());
                }
            }
        };
        this.unexportServiceNodeAction.setText("Unexport Service");
    }

    private void exportServiceReference(final ServiceReference<?> sr, final long serviceId) {
        RemoteServiceAdmin rsa;
        if (sr != null && (rsa = DiscoveryComponent.getDefault().getRSA()) != null) {
            String exportingProvider;
            InputDialog id = new InputDialog(this.getViewSite().getShell(), "Distribution Provider", "Distribution Provider Config", "ecf.generic.server", null);
            id.setBlockOnOpen(true);
            int result = id.open();
            if (result == 0 && (exportingProvider = id.getValue()) != null) {
                final Hashtable<String, String> overridingProperties = new Hashtable<String, String>();
                overridingProperties.put("service.exported.interfaces", "*");
                overridingProperties.put("service.exported.configs", exportingProvider);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            rsa.exportService(sr, (Map)overridingProperties);
                        }
                        catch (Exception e) {
                            ServicesView.this.logRSAException("Exception on exportService for service id=" + serviceId, e);
                        }
                    }
                }).start();
            }
        }
    }

    private void closeExportRegistration(final RemoteServiceAdmin.ExportRegistration exportRegistration, final long serviceId) {
        if (exportRegistration != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (exportRegistration != null) {
                        try {
                            exportRegistration.close();
                        }
                        catch (Exception e) {
                            ServicesView.this.logRSAException("Exception on export registration close for service id=" + serviceId, e);
                        }
                    }
                }
            }).start();
        }
    }

    @Override
    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ServicesView.this.fillContextMenu(manager);
            }
        });
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null) {
            Menu menu = menuMgr.createContextMenu(viewer.getControl());
            viewer.getControl().setMenu(menu);
            this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        Object e;
        ITreeSelection selection = (ITreeSelection)this.getTreeViewer().getSelection();
        if (selection != null && (e = selection.getFirstElement()) instanceof ServiceNode) {
            ServiceNode sn = (ServiceNode)e;
            if (sn.getExportRef() == null) {
                manager.add((IAction)this.exportServiceNodeAction);
            } else {
                manager.add((IAction)this.unexportServiceNodeAction);
            }
        }
    }

    @Override
    protected void initializeServices() {
        DiscoveryComponent d = DiscoveryComponent.getDefault();
        d.setServicesView(this);
        final BundleContext ctxt = d.getContext();
        ctxt.addServiceListener(this.serviceListener);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<ServiceNode> snds = new ArrayList<ServiceNode>();
                for (ServiceReferenceDTO sr : ServicesView.this.getServiceDTOs(ctxt)) {
                    snds.add(ServicesView.this.createServiceNode(sr.id, sr.bundle, sr.usingBundles, sr.properties));
                }
                ServicesView.this.addServiceNodes(snds);
            }
        }).start();
    }

    @Override
    protected ServiceNode createServiceNode(long serviceId, long bundleId, long[] usingBundleIds, Map<String, Object> properties) {
        RemoteServiceAdmin rsa = DiscoveryComponent.getDefault().getRSA();
        ExportReference eRef = null;
        ImportReference iRef = null;
        if (rsa != null) {
            for (ExportReference er : rsa.getExportedServices()) {
                long exServiceId = this.getServiceId(er.getExportedService());
                if (exServiceId != serviceId) continue;
                eRef = er;
            }
            if (eRef == null) {
                for (ImportReference ir : rsa.getImportedEndpoints()) {
                    long imServiceId = this.getServiceId(ir.getImportedService());
                    if (imServiceId != serviceId) continue;
                    iRef = ir;
                }
            }
        }
        ServiceNode result = new ServiceNode(bundleId, usingBundleIds, properties, eRef, iRef);
        result.addChild(new RegisteringBundleIdNode(bundleId));
        result.addChild(new UsingBundleIdsNode("Using Bundles", usingBundleIds));
        return result;
    }

    private ServiceNode findServiceNode(ExportReference eRef) {
        AbstractServicesNode[] services;
        AbstractServicesNode[] abstractServicesNodeArray = services = this.getServicesRoot().getChildren();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceNode sn;
            AbstractServicesNode asn = abstractServicesNodeArray[n2];
            if (asn instanceof ServiceNode && eRef == (sn = (ServiceNode)asn).getExportRef()) {
                return sn;
            }
            ++n2;
        }
        return null;
    }

    private ServiceNode findServiceNode(ImportReference iRef) {
        AbstractServicesNode[] services;
        AbstractServicesNode[] abstractServicesNodeArray = services = this.getServicesRoot().getChildren();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceNode sn;
            AbstractServicesNode asn = abstractServicesNodeArray[n2];
            if (asn instanceof ServiceNode && iRef == (sn = (ServiceNode)asn).getImportRef()) {
                return sn;
            }
            ++n2;
        }
        return null;
    }

    private long getServiceId(ServiceReference<?> ref) {
        return (Long)ref.getProperty("service.id");
    }

    public void handleRSAEvent(final RemoteServiceAdminEvent event) {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer tv = ServicesView.this.getTreeViewer();
                if (tv == null) {
                    return;
                }
                Throwable t = event.getException();
                if (t == null) {
                    switch (event.getType()) {
                        case 2: {
                            ExportReference eRef = event.getExportReference();
                            ServiceNode sn = ServicesView.this.findServiceNode(ServicesView.this.getServiceId(eRef.getExportedService()));
                            if (sn == null) break;
                            sn.setExportRef(eRef);
                            break;
                        }
                        case 3: 
                        case 6: 
                        case 7: 
                        case 10: {
                            ServiceNode sn1 = ServicesView.this.findServiceNode(event.getExportReference());
                            if (sn1 == null) break;
                            sn1.setExportRef(null);
                            break;
                        }
                        case 1: {
                            ImportReference iRef = event.getImportReference();
                            ServiceNode sn2 = ServicesView.this.findServiceNode(ServicesView.this.getServiceId(iRef.getImportedService()));
                            if (sn2 == null) break;
                            sn2.setImportRef(iRef);
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: {
                            ServiceNode sn3 = ServicesView.this.findServiceNode(event.getImportReference());
                            if (sn3 == null) break;
                            sn3.setImportRef(null);
                        }
                    }
                    tv.setExpandedState((Object)ServicesView.this.getServicesRoot(), true);
                    tv.refresh();
                }
            }
        });
    }
}

