/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.ui.serviceview.model;

import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.AbstractServicesNode;
import org.eclipse.ecf.remoteservice.ui.serviceview.model.ServicePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ImportReference;

public class ServiceNode
extends AbstractServicesNode {
    public static final byte EXPORTED = 1;
    public static final byte IMPORTED = 2;
    public static final byte LOCAL = 0;
    private final long bundleId;
    private final long[] usingBundleIds;
    private Map<String, Object> properties;
    private ExportReference exportRef;
    private ImportReference importRef;

    public ServiceNode(long bundleId, long[] usingBundles, Map<String, Object> props, ExportReference eRef, ImportReference iRef) {
        this.bundleId = bundleId;
        this.usingBundleIds = usingBundles;
        this.properties = props;
        this.exportRef = eRef;
        this.importRef = iRef;
    }

    public ServiceNode(long bundleId, long[] usingBundles, Map<String, Object> props) {
        this(bundleId, usingBundles, props, null, null);
    }

    public void setProperties(Map<String, Object> updatedProperties) {
        this.properties = updatedProperties;
    }

    public long getServiceId() {
        return (Long)this.getProperties().get("service.id");
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public long[] getUsingBundleIds() {
        return this.usingBundleIds;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String[] getServiceInterfaces() {
        return (String[])this.properties.get("objectClass");
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return new ServicePropertySource(this.getProperties());
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setExportRef(ExportReference ref) {
        this.exportRef = ref;
        this.importRef = null;
    }

    public void setImportRef(ImportReference ref) {
        this.importRef = ref;
        this.exportRef = null;
    }

    public int getExportedImportedState() {
        if (this.exportRef == null) {
            if (this.importRef == null) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public ExportReference getExportRef() {
        return this.exportRef;
    }

    public ImportReference getImportRef() {
        return this.importRef;
    }
}

