/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.ui.internal.workbench.IDelegateInitializer;
import org.eclipse.e4.ui.model.application.MApplicationElement;

public class ExtensionPointProxy {
    private IConfigurationElement element;
    private String propertyName;
    private IDelegateInitializer delegateInitializer;
    private boolean failed = false;
    private Object delegate;

    public ExtensionPointProxy(IConfigurationElement element, String propertyName) {
        this(element, propertyName, null);
    }

    public ExtensionPointProxy(IConfigurationElement element, String propertyName, IDelegateInitializer delegateInitializer) {
        this.element = element;
        this.propertyName = propertyName;
        this.delegateInitializer = delegateInitializer;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public Object createDelegate(MApplicationElement model) {
        if (this.delegate == null && !this.failed) {
            try {
                this.delegate = this.element.createExecutableExtension(this.propertyName);
                if (this.delegateInitializer != null) {
                    this.delegateInitializer.initialize(model, this.delegate);
                }
            }
            catch (CoreException coreException) {
                this.failed = true;
            }
        }
        return this.delegate;
    }

    public boolean setField(String name, Object value) {
        Field field;
        if (this.delegate != null && (field = this.getField(this.delegate.getClass(), name)) != null) {
            boolean accessible = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(this.delegate, value);
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            finally {
                field.setAccessible(accessible);
            }
        }
        return false;
    }

    private Field getField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return this.getField(cls.getSuperclass(), name);
        }
    }
}

