/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConnection.class);
    private final List<Connection.Listener> _listeners = new CopyOnWriteArrayList<Connection.Listener>();
    private final Callback _fillableCallback = new FillableCallback();
    private final long _created = System.currentTimeMillis();
    private final EndPoint _endPoint;
    private final Executor _executor;
    private int _inputBufferSize = 2048;

    protected AbstractConnection(EndPoint endPoint, Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("Executor must not be null!");
        }
        this._endPoint = endPoint;
        this._executor = executor;
    }

    @Override
    public void addEventListener(EventListener listener) {
        if (listener instanceof Connection.Listener) {
            this._listeners.add((Connection.Listener)listener);
        }
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        if (eventListener instanceof Connection.Listener) {
            Connection.Listener listener = (Connection.Listener)eventListener;
            this._listeners.remove(listener);
        }
    }

    public int getInputBufferSize() {
        return this._inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this._inputBufferSize = inputBufferSize;
    }

    protected Executor getExecutor() {
        return this._executor;
    }

    public void fillInterested() {
        this.fillInterested(this._fillableCallback);
    }

    public void fillInterested(Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fillInterested {} {}", (Object)callback, (Object)this);
        }
        this.getEndPoint().fillInterested(callback);
    }

    public void tryFillInterested(Callback callback) {
        this.getEndPoint().tryFillInterested(callback);
    }

    public boolean isFillInterested() {
        return this.getEndPoint().isFillInterested();
    }

    public abstract void onFillable();

    public void onFillInterestedFailed(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFillInterestedFailed {}", (Object)this, (Object)cause);
        }
        if (this._endPoint.isOpen()) {
            boolean close = true;
            if (cause instanceof TimeoutException) {
                TimeoutException timeout = (TimeoutException)cause;
                close = this.onReadTimeout(timeout);
            }
            if (close) {
                if (this._endPoint.isOutputShutdown()) {
                    this._endPoint.close();
                } else {
                    this._endPoint.shutdownOutput();
                    this.fillInterested();
                }
            }
        }
    }

    protected boolean onReadTimeout(TimeoutException timeout) {
        return true;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", (Object)this);
        }
        for (Connection.Listener listener : this._listeners) {
            this.onOpened(listener);
        }
    }

    private void onOpened(Connection.Listener listener) {
        try {
            listener.onOpened(this);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    @Override
    public void onClose(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            if (cause == null) {
                LOG.debug("onClose {}", (Object)this);
            } else {
                LOG.debug("onClose {}", (Object)this, (Object)cause);
            }
        }
        for (Connection.Listener listener : this._listeners) {
            this.onClosed(listener);
        }
    }

    private void onClosed(Connection.Listener listener) {
        try {
            listener.onClosed(this);
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
            }
            LOG.info("Failure while notifying listener {} {}", (Object)listener, (Object)x.toString());
        }
    }

    @Override
    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    @Override
    public void close() {
        this.getEndPoint().close();
    }

    @Override
    public boolean onIdleExpired(TimeoutException timeoutException) {
        return true;
    }

    @Override
    public long getMessagesIn() {
        return -1L;
    }

    @Override
    public long getMessagesOut() {
        return -1L;
    }

    @Override
    public long getBytesIn() {
        return -1L;
    }

    @Override
    public long getBytesOut() {
        return -1L;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    public final String toString() {
        return String.format("%s@%x::%s", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getEndPoint());
    }

    public String toConnectionString() {
        return String.format("%s@%x", TypeUtil.toShortName(this.getClass()), this.hashCode());
    }

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        public void succeeded() {
            AbstractConnection.this.onFillable();
        }

        public void failed(Throwable x) {
            AbstractConnection.this.onFillInterestedFailed(x);
        }

        public String toString() {
            return String.format("%s@%x{%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), AbstractConnection.this);
        }
    }

    public static abstract class NonBlocking
    extends AbstractConnection {
        private final Callback _nonBlockingFillableCallback = new NonBlockingFillableCallback();

        public NonBlocking(EndPoint endPoint, Executor executor) {
            super(endPoint, executor);
        }

        @Override
        public void fillInterested() {
            this.fillInterested(this._nonBlockingFillableCallback);
        }

        private class NonBlockingFillableCallback
        extends FillableCallback {
            private NonBlockingFillableCallback() {
            }

            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }
        }
    }
}

