/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.Promise;

public class ContentSourceRetainableByteBuffer
implements Runnable {
    private final RetainableByteBuffer.Mutable _mutable;
    private final Content.Source _source;
    private final Promise<RetainableByteBuffer> _promise;

    public ContentSourceRetainableByteBuffer(Content.Source source, ByteBufferPool pool, boolean direct, int maxSize, Promise<RetainableByteBuffer> promise) {
        this._source = source;
        this._mutable = new RetainableByteBuffer.DynamicCapacity(pool, direct, (long)maxSize);
        this._promise = promise;
    }

    @Override
    public void run() {
        Content.Chunk chunk;
        do {
            if ((chunk = this._source.read()) == null) {
                this._source.demand(this);
                return;
            }
            if (Content.Chunk.isFailure(chunk)) {
                this._promise.failed(chunk.getFailure());
                if (!chunk.isLast()) {
                    this._source.fail(chunk.getFailure());
                }
                return;
            }
            boolean appended = this._mutable.append(chunk);
            chunk.release();
            if (appended) continue;
            IllegalStateException ise = new IllegalStateException("Max size (" + this._mutable.capacity() + ") exceeded");
            this._promise.failed((Throwable)ise);
            this._mutable.release();
            this._source.fail(ise);
            return;
        } while (!chunk.isLast());
        this._promise.succeeded((Object)this._mutable);
        this._mutable.release();
    }
}

