/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core;

import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.services.TaskingLog;

@Creatable
public class TaskingEngine {
    private final IEclipseContext context;
    private final TaskingLog log;

    @Inject
    public TaskingEngine(IEclipseContext context, TaskingLog log) {
        this.context = context;
        this.log = log;
    }

    public static TaskingEngine withConfiguration(TaskingConfigurationStore config) {
        return TaskingInjectionHelper.createNewEngine(config);
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public IStatus runTaskChain(TaskExecutionContext chain) {
        if (chain.isEmpty()) {
            return Status.OK_STATUS;
        }
        int retries = chain.getRetries();
        MultiStatus status = new MultiStatus("org.eclipse.tea.core", 0, "", null);
        int i = 0;
        while (i < retries) {
            ContextInjectionFactory.invoke((Object)chain, Execute.class, (IEclipseContext)chain.getContext());
            status = (MultiStatus)chain.getContext().get(MultiStatus.class);
            if (status.getSeverity() >= 4) {
                if (retries - 1 == i) {
                    this.log.error("cannot execute '" + String.valueOf(chain) + "'");
                } else {
                    this.log.info("Inhibiting failure on '" + String.valueOf(chain) + "', retrying...");
                }
            } else {
                return status;
            }
            ++i;
        }
        return status;
    }
}

