/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;
import org.eclipse.actf.model.internal.flash.proxy.BitBuffer;

class SwfStageResizer {
    private static final Logger LOGGER = Logger.getLogger(SwfStageResizer.class.getName());
    private static final int COMPRESSED_FLAG = 67;
    private int bitBuf = 0;
    private int bitPos = 0;
    private int byteCount = 0;
    private byte[] buf2 = new byte[17];
    private ByteArrayOutputStream bo;
    private InputStream bi;

    SwfStageResizer() {
    }

    public static byte[] resize(byte[] byArray, int n, int n2) {
        return new SwfStageResizer().doResize(byArray, n, n2);
    }

    public byte[] doResize(byte[] byArray, int n, int n2) {
        try {
            LOGGER.info("Resizing SWF to " + n / 20 + "x" + n2 / 20 + " pixels...");
            this.bo = new ByteArrayOutputStream();
            this.bi = new ByteArrayInputStream(byArray);
            int n3 = this.bi.read();
            this.bo.write(70);
            boolean bl = n3 == 67;
            LOGGER.fine("compressed? = " + bl);
            this.bo.write(this.bi.read());
            this.bo.write(this.bi.read());
            n3 = this.bi.read();
            this.bo.write(n3);
            int n4 = n3 & 0xFF;
            LOGGER.fine("SWF version = " + n4);
            byte[] byArray2 = new byte[4];
            this.bi.read(byArray2);
            int n5 = byArray2[0] & 0xFF | (byArray2[1] & 0xFF) << 8 | (byArray2[2] & 0xFF) << 16 | byArray2[3] << 24;
            LOGGER.fine("length = " + n5);
            this.bo.write(byArray2);
            if (bl) {
                this.bi = new InflaterInputStream(this.bi);
            }
            int[] nArray = this.readFrameSize();
            LOGGER.fine("original frame size (in twips) = " + nArray[0] + "x" + nArray[1]);
            this.writeFrameSize(n, n2);
            n3 = this.bi.read();
            int n6 = (n3 & 0xFF) << 8;
            this.bo.write(n3);
            n3 = this.bi.read();
            this.bo.write(n3);
            LOGGER.fine("framerate = " + (n6 |= n3 & 0xFF));
            n3 = this.bi.read();
            int n7 = n3 & 0xFF;
            this.bo.write(n3);
            n3 = this.bi.read();
            this.bo.write(n3);
            LOGGER.fine("framecount = " + (n7 |= (n3 & 0xFF) << 8));
            while ((n3 = this.bi.read()) >= 0) {
                this.bo.write(n3);
            }
            byte[] byArray3 = this.bo.toByteArray();
            int n8 = byArray3.length;
            LOGGER.info("Modifying file size field from " + n5 + " to " + n8);
            int n9 = 4;
            while (n9 <= 7) {
                byArray3[n9] = (byte)(n8 & 0xFF);
                n8 >>= 8;
                ++n9;
            }
            LOGGER.fine("done");
            return byArray3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return new byte[0];
        }
    }

    private int[] readFrameSize() throws IOException {
        int[] nArray = new int[2];
        int n = this.readUBits(5);
        LOGGER.fine("frame size X min = " + Integer.toString(this.readSBits(n)));
        nArray[0] = this.readSBits(n);
        LOGGER.fine("frame size X max (twips) = " + Integer.toString(nArray[0]));
        LOGGER.fine("frame size Y min = " + Integer.toString(this.readSBits(n)));
        nArray[1] = this.readSBits(n);
        LOGGER.fine("frame size Y max (twips) = " + Integer.toString(nArray[1]));
        return nArray;
    }

    private int readSBits(int n) throws IOException {
        if (n > 32) {
            throw new IOException("Number of bits > 32");
        }
        int n2 = this.readUBits(n);
        int n3 = 32 - n;
        n2 = n2 << n3 >> n3;
        return n2;
    }

    private int readUBits(int n) throws IOException {
        int n2;
        byte[] byArray;
        if (n == 0) {
            return 0;
        }
        int n3 = n;
        int n4 = 0;
        if (this.bitPos == 0) {
            byArray = new byte[1];
            this.bi.read(byArray);
            this.buf2[this.byteCount] = byArray[0];
            ++this.byteCount;
            this.bitBuf = byArray[0] & 0xFF;
            this.bitPos = 8;
        }
        while ((n2 = n3 - this.bitPos) > 0) {
            n4 |= this.bitBuf << n2;
            n3 -= this.bitPos;
            byArray = new byte[1];
            this.bi.read(byArray);
            this.buf2[this.byteCount] = byArray[0];
            ++this.byteCount;
            this.bitBuf = byArray[0] & 0xFF;
            this.bitPos = 8;
        }
        this.bitPos -= n3;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return n4 |= this.bitBuf >> -n2;
    }

    private void writeFrameSize(int n, int n2) throws IOException {
        int n3 = this.numDigit(n) + 1;
        int n4 = this.numDigit(n2) + 1;
        LOGGER.fine("required number of digits = " + n3 + ", " + n4);
        int n5 = Math.max(n3, n4);
        BitBuffer bitBuffer = new BitBuffer();
        bitBuffer.append(n5, 5);
        bitBuffer.append(0, n5);
        bitBuffer.append(n, n5);
        bitBuffer.append(0, n5);
        bitBuffer.append(n2, n5);
        this.bo.write(bitBuffer.toByteArray());
    }

    private int numDigit(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }
}

