/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleRelation;
import org.eclipse.actf.visualization.gui.msaa.properties.AccessibleObjectPropertySource;
import org.eclipse.actf.visualization.gui.msaa.properties.AccessibleRelationPropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ObjectArrayPropertySource
implements IPropertySource {
    private Object[] objArray;
    private String editableText;

    public ObjectArrayPropertySource(Object[] objectArray) {
        this.objArray = objectArray;
    }

    public ObjectArrayPropertySource(Object[] objectArray, String string) {
        this(objectArray);
        this.editableText = string;
    }

    public ObjectArrayPropertySource(int[] nArray) {
        this.objArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            this.objArray[n] = new Integer(nArray[n]);
            ++n;
        }
    }

    public ObjectArrayPropertySource(int[] nArray, String string) {
        this(nArray);
        this.editableText = string;
    }

    public Object getEditableValue() {
        if (this.editableText != null) {
            return this.editableText;
        }
        return ObjectArrayPropertySource.objectArrayToString(this.objArray);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] iPropertyDescriptorArray = new IPropertyDescriptor[this.objArray.length];
        int n = 0;
        while (n < this.objArray.length) {
            iPropertyDescriptorArray[n] = new PropertyDescriptor((Object)new Integer(n), "[" + n + "]");
            ++n;
        }
        return iPropertyDescriptorArray;
    }

    public Object getPropertyValue(Object object) {
        if (object instanceof Integer) {
            Object object2 = this.objArray[(Integer)object];
            if (object2 instanceof AccessibleObject) {
                return new AccessibleObjectPropertySource((AccessibleObject)object2);
            }
            if (object2 instanceof AccessibleRelation) {
                return new AccessibleRelationPropertySource((AccessibleRelation)object2);
            }
            return object2.toString();
        }
        return null;
    }

    public boolean isPropertySet(Object object) {
        return false;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
    }

    private static String objectArrayToString(Object[] objectArray) {
        String string = null;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                string = n == 0 ? "" : String.valueOf(string) + "; ";
                string = String.valueOf(string) + objectArray[n];
                ++n;
            }
        }
        return string;
    }
}

