/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.text.impl;

import java.util.Iterator;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.ODFStylableElementImpl;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.text.ListElement;
import org.eclipse.actf.model.dom.odf.text.ListItemElement;
import org.eclipse.actf.model.dom.odf.text.ListLevelStyleBulletElement;
import org.eclipse.actf.model.dom.odf.text.ListLevelStyleNumberElement;
import org.eclipse.actf.model.dom.odf.text.ListStyleElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListElementImpl
extends ODFStylableElementImpl
implements ListElement {
    private static final long serialVersionUID = -1816073361921569606L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='list-item']");

    protected ListElementImpl(ODFDocument oDFDocument, Element element) {
        super(oDFDocument, element);
    }

    @Override
    public long getSize() {
        return xpathService.evalForNodeList(EXP1, (Node)this).getLength();
    }

    @Override
    public ListItemElement getItem(long l) {
        NodeList nodeList = xpathService.evalPathForNodeList("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='list-item'][" + (l + 1L) + "]", (Node)this);
        if (nodeList != null && nodeList.getLength() == 1 && nodeList.item(0) instanceof ListItemElement) {
            return (ListItemElement)nodeList.item(0);
        }
        return null;
    }

    @Override
    public StyleElement getStyle() {
        ListElement listElement = this.getTopLevelListElement();
        String string = listElement.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name");
        ODFElement oDFElement = this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "list-style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", string);
        if (oDFElement != null && oDFElement instanceof ListStyleElement) {
            return (StyleElement)oDFElement;
        }
        return null;
    }

    @Override
    public void appendItem(ListItemElement listItemElement) {
    }

    @Override
    public void insertBefore(ListItemElement listItemElement, long l) {
    }

    @Override
    public long getContentSize() {
        return 0L;
    }

    @Override
    public Iterator<ITextElementContainer> getChildIterator() {
        return null;
    }

    @Override
    public long getListLevel() {
        long l = 1L;
        ListElement listElement = this;
        while (true) {
            Node node = listElement.getParentNode();
            Node node2 = null;
            if (node != null) {
                node2 = node.getParentNode();
            }
            if (node == null || !(node instanceof ListItemElement) || node2 == null || !(node2 instanceof ListElement)) break;
            listElement = (ListElement)node2;
            ++l;
        }
        return l;
    }

    @Override
    public ListElement getTopLevelListElement() {
        ListElement listElement = this;
        while (true) {
            Node node = listElement.getParentNode();
            Node node2 = null;
            if (node != null) {
                node2 = node.getParentNode();
            }
            if (node == null || !(node instanceof ListItemElement) || node2 == null || !(node2 instanceof ListElement)) break;
            listElement = (ListElement)node2;
        }
        return listElement;
    }

    @Override
    public StyleElement getListLevelStyleElement() {
        long l = this.getListLevel();
        StyleElement styleElement = this.getStyle();
        if (styleElement == null) {
            return null;
        }
        NodeList nodeList = styleElement.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof StyleElement) {
                if (node instanceof ListLevelStyleBulletElement && ((ListLevelStyleBulletElement)node).getAttrLevel() == l) {
                    return (StyleElement)node;
                }
                if (node instanceof ListLevelStyleNumberElement && ((ListLevelStyleNumberElement)node).getAttrLevel() == l) {
                    return (StyleElement)node;
                }
            }
            ++n;
        }
        return null;
    }
}

