/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval.problem;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetSourceInfo;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightTargetNodeInfo {
    private static final int SINGLE = 0;
    private static final int RANGE = 1;
    private static final int MULTI = 2;
    private int mode;
    private Node targetNode;
    private Node startTarget;
    private Node endTarget;
    private Node[] targets;

    public HighlightTargetNodeInfo(Node node) {
        this.mode = 0;
        this.targetNode = node;
    }

    public HighlightTargetNodeInfo(Node node, Node node2) {
        this.mode = 1;
        this.startTarget = node;
        this.endTarget = node2;
    }

    public HighlightTargetNodeInfo(List<Node> list) {
        this.mode = 2;
        this.targets = new Node[0];
        if (list != null) {
            this.targets = new Node[list.size()];
            try {
                list.toArray(this.targets);
            }
            catch (Exception exception) {
                this.targets = new Node[0];
            }
        }
    }

    public HighlightTargetId[] getHighlightTargetIds(Map<Node, Integer> map) {
        HighlightTargetId[] highlightTargetIdArray = new HighlightTargetId[]{};
        switch (this.mode) {
            case 0: {
                if (map == null || !map.containsKey(this.targetNode)) break;
                try {
                    int n = map.get(this.targetNode);
                    highlightTargetIdArray = new HighlightTargetId[]{new HighlightTargetId(n, n)};
                }
                catch (Exception exception) {}
                break;
            }
            case 1: {
                if (map == null || !map.containsKey(this.startTarget) && !map.containsKey(this.endTarget)) break;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                try {
                    n2 = map.get(this.startTarget);
                    ++n;
                }
                catch (Exception exception) {}
                try {
                    n3 = map.get(this.endTarget);
                    n += 2;
                }
                catch (Exception exception) {}
                switch (n) {
                    case 0: {
                        highlightTargetIdArray = new HighlightTargetId[]{};
                        break;
                    }
                    case 1: {
                        highlightTargetIdArray = new HighlightTargetId[]{new HighlightTargetId(n2, n2)};
                        break;
                    }
                    case 2: {
                        highlightTargetIdArray = new HighlightTargetId[]{new HighlightTargetId(n3, n3)};
                        break;
                    }
                    case 3: {
                        highlightTargetIdArray = new HighlightTargetId[]{new HighlightTargetId(n2, n3)};
                    }
                }
                break;
            }
            case 2: {
                Vector<HighlightTargetId> vector = new Vector<HighlightTargetId>();
                int n = 0;
                while (n < this.targets.length) {
                    if (map != null && map.containsKey(this.targets[n])) {
                        try {
                            int n4 = map.get(this.targets[n]);
                            vector.add(new HighlightTargetId(n4, n4));
                        }
                        catch (Exception exception) {}
                    }
                    ++n;
                }
                highlightTargetIdArray = new HighlightTargetId[vector.size()];
                vector.toArray(highlightTargetIdArray);
            }
        }
        return highlightTargetIdArray;
    }

    public HighlightTargetSourceInfo[] getHighlightTargetSourceInfo(Vector<Html2ViewMapData> vector) {
        HighlightTargetSourceInfo[] highlightTargetSourceInfoArray = new HighlightTargetSourceInfo[]{};
        switch (this.mode) {
            case 0: {
                Html2ViewMapData html2ViewMapData = this.getViewMapData(this.targetNode, vector);
                if (html2ViewMapData == null) break;
                highlightTargetSourceInfoArray = new HighlightTargetSourceInfo[]{new HighlightTargetSourceInfo(html2ViewMapData, html2ViewMapData)};
                break;
            }
            case 1: {
                Html2ViewMapData html2ViewMapData = this.getViewMapData(this.startTarget, vector);
                Html2ViewMapData html2ViewMapData2 = this.getViewMapData(this.endTarget, vector);
                if (html2ViewMapData != null && html2ViewMapData2 != null) {
                    highlightTargetSourceInfoArray = new HighlightTargetSourceInfo[]{new HighlightTargetSourceInfo(html2ViewMapData, html2ViewMapData2)};
                    break;
                }
                if (html2ViewMapData == null) {
                    highlightTargetSourceInfoArray = new HighlightTargetSourceInfo[]{new HighlightTargetSourceInfo(html2ViewMapData2, html2ViewMapData2)};
                    break;
                }
                highlightTargetSourceInfoArray = new HighlightTargetSourceInfo[]{new HighlightTargetSourceInfo(html2ViewMapData, html2ViewMapData)};
                break;
            }
            case 2: {
                ArrayList<HighlightTargetSourceInfo> arrayList = new ArrayList<HighlightTargetSourceInfo>();
                int n = 0;
                while (n < this.targets.length) {
                    Html2ViewMapData html2ViewMapData = this.getViewMapData(this.targets[n], vector);
                    if (html2ViewMapData != null) {
                        arrayList.add(new HighlightTargetSourceInfo(html2ViewMapData, html2ViewMapData));
                    }
                    ++n;
                }
                highlightTargetSourceInfoArray = new HighlightTargetSourceInfo[arrayList.size()];
                arrayList.toArray(highlightTargetSourceInfoArray);
            }
        }
        return highlightTargetSourceInfoArray;
    }

    private Html2ViewMapData getViewMapData(Node node, Vector<Html2ViewMapData> vector) {
        if (node != null && vector != null) {
            try {
                int n;
                String string = ((Element)node).getAttribute("eclipse-actf-id");
                if (!string.equals("") && (n = Integer.parseInt(string)) > -1 && n < vector.size()) {
                    Html2ViewMapData html2ViewMapData = vector.get(n);
                    return html2ViewMapData;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

