/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ooo.util;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCell;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextEmbeddedObjectsSupplier;
import com.sun.star.text.XTextGraphicObjectsSupplier;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.draw.ControlElement;
import org.eclipse.actf.model.dom.odf.draw.FrameElement;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.ODFException;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.ODFUtils;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.OOoUIControls;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OOoNavigation {
    private static final String COLON = ":";
    private String _targetContentID = null;
    private ODFDocument _contentXML = null;
    private ODFConstants.ContentType _fileType = null;
    private XMultiServiceFactory _xMSF = null;
    private XComponent _xComp = null;

    public OOoNavigation(XMultiServiceFactory xMultiServiceFactory, XComponent xComponent) {
        this._xMSF = xMultiServiceFactory;
        this._xComp = xComponent;
    }

    public void setContentXML(ODFDocument oDFDocument) {
        this._contentXML = oDFDocument;
    }

    public ODFDocument getContentXML() {
        return this._contentXML;
    }

    public void jumpToProblemPosition(Node node) throws ODFException {
        this._targetContentID = ((Element)node).getAttribute("actf-odf-content-id");
        if (this._targetContentID == null) {
            return;
        }
        if (this._fileType == null) {
            this._fileType = ODFUtils.getODFFileType((Document)this._contentXML);
        }
        if (this._fileType == ODFConstants.ContentType.NONE) {
            return;
        }
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this._xComp);
        XController xController = xModel.getCurrentController();
        if (this._fileType == ODFConstants.ContentType.PRESENTATION) {
            OOoUIControls.setDrawingMode(this._xMSF, xController);
        }
        String string = this._contentXML.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        String string2 = this._contentXML.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        String string3 = node.getNodeName();
        String string4 = ((Element)node).getAttribute("odf-tagname");
        if (string3.equalsIgnoreCase("img")) {
            this.jumpToProblemImage(node);
        } else if (string4.equals(String.valueOf(string) + COLON + "object")) {
            this.jumpToProblemObject(node);
        } else if (string3.equalsIgnoreCase("table")) {
            this.jumpToProblemTable(node);
        } else if (string4.equals(String.valueOf(string) + COLON + "caption") || string4.equals(String.valueOf(string) + COLON + "circle") || string4.equals(String.valueOf(string) + COLON + "custom-shape") || string4.equals(String.valueOf(string) + COLON + "ellipse") || string4.equals(String.valueOf(string) + COLON + "g") || string4.equals(String.valueOf(string) + COLON + "line") || string4.equals(String.valueOf(string) + COLON + "connector") || string4.equals(String.valueOf(string) + COLON + "polygon") || string4.equals(String.valueOf(string) + COLON + "polyline") || string4.equals(String.valueOf(string) + COLON + "rect") || string4.equals(String.valueOf(string) + COLON + "regular-polygon") || string4.equals(String.valueOf(string2) + COLON + "scene")) {
            this.jumpToProblemDrawingShape(node);
        } else if (string4.equals(String.valueOf(string) + COLON + "page")) {
            this.jumpToProblemDrawingPage(node);
        } else if (string4.equals(String.valueOf(string) + COLON + "control")) {
            this.jumpToProblemFormControl(node);
        }
        try {
            XFrame xFrame = xController.getFrame();
            OOoUIControls.hideUIElements(xFrame, this._xMSF);
        }
        catch (ODFException oDFException) {
            oDFException.printStackTrace();
        }
    }

    private void jumpToProblemTable(Node node) throws ODFException {
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this._xComp);
        XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xModel.getCurrentController());
        if (ODFConstants.ContentType.WRITE.equals((Object)this._fileType)) {
            XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this._xComp);
            XTextTablesSupplier xTextTablesSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)xTextDocument);
            XNameAccess xNameAccess = xTextTablesSupplier.getTextTables();
            try {
                if (!(node instanceof Element)) {
                    return;
                }
                String string = ((Element)node).getAttribute("actf-odf-content-id");
                NodeList nodeList = XPathServiceFactory.newService().evalPathForNodeList("//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table'][@actf-odf-content-id='" + string + "']", (Node)this._contentXML.getDocumentElement());
                if (nodeList == null || nodeList.getLength() != 1) {
                    return;
                }
                TableElement tableElement = (TableElement)nodeList.item(0);
                String string2 = tableElement.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "name");
                Object object = xNameAccess.getByName(string2);
                XTextTable xTextTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)object);
                xSelectionSupplier.select((Object)xTextTable);
                XController xController = xModel.getCurrentController();
                XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
                XTextViewCursor xTextViewCursor = xTextViewCursorSupplier.getViewCursor();
                xTextViewCursor.collapseToStart();
                XCell xCell = xTextTable.getCellByName(xTextTable.getCellNames()[xTextTable.getCellNames().length - 1]);
                xSelectionSupplier.select((Object)xCell);
                xTextViewCursor.gotoStart(true);
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
                throw new ODFException(noSuchElementException.getMessage());
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace();
                throw new ODFException(wrappedTargetException.getMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw new ODFException(illegalArgumentException.getMessage());
            }
        }
    }

    private void jumpToProblemImage(Node node) throws ODFException {
        XTextGraphicObjectsSupplier xTextGraphicObjectsSupplier;
        Object object;
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this._xComp);
        XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xModel.getCurrentController());
        if (!(node instanceof Element)) {
            return;
        }
        String string = ((Element)node).getAttribute("actf-odf-content-id");
        NodeList nodeList = XPathServiceFactory.newService().evalPathForNodeList("//*[@actf-odf-content-id='" + string + "']", (Node)this._contentXML.getDocumentElement());
        if (nodeList == null || nodeList.getLength() != 1) {
            return;
        }
        if (!(nodeList.item(0) instanceof ODFElement)) {
            return;
        }
        Node node2 = nodeList.item(0).getParentNode();
        if (!(node2 instanceof FrameElement)) {
            return;
        }
        FrameElement frameElement = (FrameElement)node2;
        String string2 = frameElement.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name");
        if (string2 == null) {
            return;
        }
        Object object2 = UnoRuntime.queryInterface(XTextDocument.class, (Object)this._xComp);
        if (object2 != null && object2 instanceof XTextDocument) {
            object = (XTextDocument)object2;
            xTextGraphicObjectsSupplier = (XTextGraphicObjectsSupplier)UnoRuntime.queryInterface(XTextGraphicObjectsSupplier.class, (Object)object);
            XNameAccess xNameAccess = xTextGraphicObjectsSupplier.getGraphicObjects();
            try {
                Object object3 = xNameAccess.getByName(string2);
                xSelectionSupplier.select(object3);
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        if ((object = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this._xComp)) != null && object instanceof XDrawPagesSupplier) {
            xTextGraphicObjectsSupplier = (XDrawPagesSupplier)object;
            int n = (int)frameElement.getZIndex();
            int n2 = (int)frameElement.getPageIndex();
            if (n != -1 && n2 != -1) {
                XDrawPages xDrawPages = xTextGraphicObjectsSupplier.getDrawPages();
                try {
                    Object object4 = UnoRuntime.queryInterface(XDrawPage.class, (Object)xDrawPages.getByIndex(n2));
                    if (object4 != null && object4 instanceof XDrawPage) {
                        XDrawPage xDrawPage = (XDrawPage)object4;
                        Object object5 = xDrawPage.getByIndex(n);
                        xSelectionSupplier.select(object5);
                        return;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    indexOutOfBoundsException.printStackTrace();
                }
                catch (WrappedTargetException wrappedTargetException) {
                    wrappedTargetException.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
            }
        }
    }

    private void jumpToProblemObject(Node node) throws ODFException {
        XTextEmbeddedObjectsSupplier xTextEmbeddedObjectsSupplier;
        Object object;
        XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this._xComp);
        XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xModel.getCurrentController());
        if (!(node instanceof Element)) {
            return;
        }
        String string = ((Element)node).getAttribute("actf-odf-content-id");
        NodeList nodeList = XPathServiceFactory.newService().evalPathForNodeList("//*[@actf-odf-content-id='" + string + "']", (Node)this._contentXML.getDocumentElement());
        if (nodeList == null || nodeList.getLength() != 1) {
            return;
        }
        if (!(nodeList.item(0) instanceof ODFElement)) {
            return;
        }
        Node node2 = nodeList.item(0).getParentNode();
        if (!(node2 instanceof FrameElement)) {
            return;
        }
        FrameElement frameElement = (FrameElement)node2;
        String string2 = frameElement.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name");
        if (string2 == null) {
            return;
        }
        Object object2 = UnoRuntime.queryInterface(XTextDocument.class, (Object)this._xComp);
        if (object2 != null && object2 instanceof XTextDocument) {
            object = (XTextDocument)object2;
            xTextEmbeddedObjectsSupplier = (XTextEmbeddedObjectsSupplier)UnoRuntime.queryInterface(XTextEmbeddedObjectsSupplier.class, (Object)object);
            XNameAccess xNameAccess = xTextEmbeddedObjectsSupplier.getEmbeddedObjects();
            try {
                Object object3 = xNameAccess.getByName(string2);
                xSelectionSupplier.select(object3);
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace();
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        if ((object = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this._xComp)) != null && object instanceof XDrawPagesSupplier) {
            xTextEmbeddedObjectsSupplier = (XDrawPagesSupplier)object;
            int n = (int)frameElement.getZIndex();
            int n2 = (int)frameElement.getPageIndex();
            if (n != -1 && n2 != -1) {
                XDrawPages xDrawPages = xTextEmbeddedObjectsSupplier.getDrawPages();
                try {
                    Object object4 = UnoRuntime.queryInterface(XDrawPage.class, (Object)xDrawPages.getByIndex(n2));
                    if (object4 != null && object4 instanceof XDrawPage) {
                        XDrawPage xDrawPage = (XDrawPage)object4;
                        Object object5 = xDrawPage.getByIndex(n);
                        xSelectionSupplier.select(object5);
                        return;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    indexOutOfBoundsException.printStackTrace();
                }
                catch (WrappedTargetException wrappedTargetException) {
                    wrappedTargetException.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
            }
        }
    }

    private void jumpToProblemDrawingShape(Node node) throws ODFException {
        block13: {
            try {
                Object object;
                XDrawPage xDrawPage;
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this._xComp);
                XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xModel.getCurrentController());
                if (!(node instanceof Element)) {
                    return;
                }
                String string = ((Element)node).getAttribute("actf-odf-content-id");
                NodeList nodeList = XPathServiceFactory.newService().evalPathForNodeList("//*[@actf-odf-content-id='" + string + "']", (Node)this._contentXML.getDocumentElement());
                if (nodeList == null || nodeList.getLength() != 1) {
                    return;
                }
                if (!(nodeList.item(0) instanceof DrawingObjectElement)) {
                    return;
                }
                DrawingObjectElement drawingObjectElement = (DrawingObjectElement)nodeList.item(0);
                int n = (int)drawingObjectElement.getZIndex();
                if (n < 0) break block13;
                Object object2 = UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this._xComp);
                if (object2 instanceof XDrawPageSupplier && (xDrawPage = (object = (XDrawPageSupplier)object2).getDrawPage()) != null) {
                    try {
                        Object object3 = xDrawPage.getByIndex(n);
                        xSelectionSupplier.select(object3);
                        return;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        indexOutOfBoundsException.printStackTrace();
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                        wrappedTargetException.printStackTrace();
                    }
                }
                if ((object = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this._xComp)) == null || !(object instanceof XDrawPagesSupplier)) break block13;
                xDrawPage = (XDrawPagesSupplier)object;
                int n2 = (int)drawingObjectElement.getPageIndex();
                if (n == -1 || n2 == -1) break block13;
                XDrawPages xDrawPages = xDrawPage.getDrawPages();
                try {
                    Object object4 = UnoRuntime.queryInterface(XDrawPage.class, (Object)xDrawPages.getByIndex(n2));
                    if (object4 != null && object4 instanceof XDrawPage) {
                        XDrawPage xDrawPage2 = (XDrawPage)object4;
                        Object object5 = xDrawPage2.getByIndex(n);
                        xSelectionSupplier.select(object5);
                        return;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    indexOutOfBoundsException.printStackTrace();
                }
                catch (WrappedTargetException wrappedTargetException) {
                    wrappedTargetException.printStackTrace();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw new ODFException(illegalArgumentException.getMessage());
            }
        }
    }

    private void jumpToProblemDrawingPage(Node node) throws ODFException {
        try {
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this._xComp);
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xModel.getCurrentController());
            if (ODFConstants.ContentType.PRESENTATION.equals((Object)this._fileType)) {
                if (!(node instanceof Element)) {
                    return;
                }
                String string = ((Element)node).getAttribute("actf-odf-content-id");
                NodeList nodeList = XPathServiceFactory.newService().evalPathForNodeList("//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='page'][@actf-odf-content-id='" + string + "']", (Node)this._contentXML.getDocumentElement());
                if (nodeList == null || nodeList.getLength() != 1) {
                    return;
                }
                if (nodeList.item(0) instanceof PageElement) {
                    PageElement pageElement = (PageElement)nodeList.item(0);
                    int n = pageElement.getPageIndex();
                    XDrawPage xDrawPage = ODFUtils.getDrawPageByIndex(this._xComp, n);
                    xSelectionSupplier.select((Object)xDrawPage);
                    return;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            throw new ODFException(illegalArgumentException.getMessage());
        }
    }

    private void jumpToProblemFormControl(Node node) throws ODFException {
        block13: {
            try {
                Object object;
                XDrawPage xDrawPage;
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this._xComp);
                XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)xModel.getCurrentController());
                if (!(node instanceof Element)) {
                    return;
                }
                String string = ((Element)node).getAttribute("actf-odf-content-id");
                NodeList nodeList = XPathServiceFactory.newService().evalPathForNodeList("//*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='control'][@actf-odf-content-id='" + string + "']", (Node)this._contentXML.getDocumentElement());
                if (nodeList == null || nodeList.getLength() != 1) {
                    return;
                }
                if (!(nodeList.item(0) instanceof ControlElement)) {
                    return;
                }
                ControlElement controlElement = (ControlElement)nodeList.item(0);
                int n = (int)controlElement.getZIndex();
                if (n < 0) break block13;
                Object object2 = UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this._xComp);
                if (object2 instanceof XDrawPageSupplier && (xDrawPage = (object = (XDrawPageSupplier)object2).getDrawPage()) != null) {
                    try {
                        Object object3 = xDrawPage.getByIndex(n);
                        xSelectionSupplier.select(object3);
                        return;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        indexOutOfBoundsException.printStackTrace();
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                        wrappedTargetException.printStackTrace();
                    }
                }
                if ((object = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this._xComp)) == null || !(object instanceof XDrawPagesSupplier)) break block13;
                xDrawPage = (XDrawPagesSupplier)object;
                int n2 = (int)controlElement.getPageIndex();
                if (n == -1 || n2 == -1) break block13;
                XDrawPages xDrawPages = xDrawPage.getDrawPages();
                try {
                    Object object4 = UnoRuntime.queryInterface(XDrawPage.class, (Object)xDrawPages.getByIndex(n2));
                    if (object4 != null && object4 instanceof XDrawPage) {
                        XDrawPage xDrawPage2 = (XDrawPage)object4;
                        Object object5 = xDrawPage2.getByIndex(n);
                        xSelectionSupplier.select(object5);
                        return;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    indexOutOfBoundsException.printStackTrace();
                }
                catch (WrappedTargetException wrappedTargetException) {
                    wrappedTargetException.printStackTrace();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw new ODFException(illegalArgumentException.getMessage());
            }
        }
    }
}

