/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.eclipse.actf.visualization.engines.blind.eval.PageEvaluation;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VisualizeReportUtil {
    public static void createReport(File file, PageEvaluation pageEvaluation) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            Document document = dOMImplementation.createDocument("", "html", null);
            Element element = document.getDocumentElement();
            Element element2 = document.createElement("head");
            Element element3 = document.createElement("meta");
            element3.setAttribute("http-equiv", "Content-type");
            element3.setAttribute("content", "text/html; charset=UTF-8");
            element2.appendChild(element3);
            Element element4 = document.createElement("title");
            element4.appendChild(document.createTextNode("Overall rating"));
            element2.appendChild(element4);
            element.appendChild(element2);
            Element element5 = document.createElement("body");
            element.appendChild(element5);
            Element element6 = document.createElement("div");
            Element element7 = document.createElement("img");
            element7.setAttribute("src", "img/" + pageEvaluation.getRatingIcon());
            element7.setAttribute("alt", "");
            element6.appendChild(element7);
            Element element8 = document.createElement("b");
            element8.appendChild(document.createTextNode(" " + pageEvaluation.getOverallRating()));
            element6.appendChild(element8);
            element5.appendChild(element6);
            int n = 0;
            boolean[] blArray = GuidelineHolder.getInstance().getMatchedMetrics();
            int n2 = 0;
            while (n2 < blArray.length) {
                if (blArray[n2]) {
                    ++n;
                }
                ++n2;
            }
            if (n > 2) {
                Element element9 = document.createElement("img");
                element9.setAttribute("src", "./pagerating.png");
                element9.setAttribute("alt", "");
                element5.appendChild(element9);
            }
            element5.appendChild(document.createElement("hr"));
            VisualizeReportUtil.appendRatingTable(pageEvaluation.getAllResult(), document, element5);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            StreamResult streamResult = new StreamResult(outputStreamWriter);
            transformer.transform(dOMSource, streamResult);
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void appendRatingTableAndTitle(PageEvaluation pageEvaluation, String string, Document document, Node node) {
        String[] stringArray = pageEvaluation.getAllResult();
        Element element = document.createElement("div");
        Element element2 = document.createElement("img");
        element2.setAttribute("src", String.valueOf(string) + pageEvaluation.getRatingIcon());
        element2.setAttribute("alt", "");
        element.appendChild(element2);
        Element element3 = document.createElement("b");
        element3.appendChild(document.createTextNode(String.valueOf(stringArray[0]) + ": " + stringArray[1]));
        element.appendChild(element3);
        node.appendChild(element);
        VisualizeReportUtil.appendRatingTable(stringArray, document, node);
    }

    private static void appendRatingTable(String[] stringArray, Document document, Node node) {
        Element element = document.createElement("table");
        element.setAttribute("border", "1");
        Element element2 = document.createElement("tr");
        Element element3 = document.createElement("th");
        element3.appendChild(document.createTextNode("evaluation"));
        element2.appendChild(element3);
        element3 = document.createElement("th");
        element3.appendChild(document.createTextNode("score"));
        element2.appendChild(element3);
        element.appendChild(element2);
        int n = stringArray.length / 2;
        int n2 = 1;
        while (n2 < n) {
            element2 = document.createElement("tr");
            Element element4 = document.createElement("td");
            element4.appendChild(document.createTextNode(stringArray[n2 * 2]));
            element2.appendChild(element4);
            element4 = document.createElement("td");
            element4.appendChild(document.createTextNode(stringArray[n2 * 2 + 1]));
            element2.appendChild(element4);
            element.appendChild(element2);
            ++n2;
        }
        node.appendChild(element);
    }

    public static void visualizeError(Document document, IProblemItem iProblemItem) {
        Element element;
        String string;
        Element element2 = (Element)iProblemItem.getTargetNode();
        if (element2 != null && (string = (element = (Element)element2.getParentNode()).getAttribute("eclipse-actf-id")).length() > 0) {
            Integer n = new Integer(string);
            NodeList nodeList = XPathServiceFactory.newService().evalPathForNodeList("//*[@eclipse-actf-id='" + n + "']/span", (Node)document.getDocumentElement());
            if (nodeList != null && nodeList.getLength() == 1) {
                Element element3 = (Element)nodeList.item(0);
                Element element4 = VisualizeReportUtil.createErrorImageElement(element3, iProblemItem, n);
                element3.appendChild(element4);
            }
        }
    }

    private static Element createErrorImageElement(Node node, IProblemItem iProblemItem, Integer n) {
        Element element = node.getOwnerDocument().createElement("img");
        element.setAttribute("alt", "error");
        element.setAttribute("title", iProblemItem.getDescription());
        element.setAttribute("onmouseover", "updateBaloon('id" + n + "');");
        element.setAttribute("src", "img/" + VisualizeEngine.ERROR_ICON_NAME);
        return element;
    }
}

